/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.Singletons;
import forge.gui.FThreads;
import forge.gui.GuiUtils;
import forge.gui.framework.ILocalRepaint;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.localinstance.skin.ISkinImage;
import forge.model.FModel;
import forge.toolbox.FComboBoxPanel;
import forge.toolbox.FComboBoxWrapper;
import forge.util.Localizer;
import forge.util.OperatingSystem;
import forge.util.WordUtil;
import forge.view.FView;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;

public class FSkin {
    public static final int SYMBOL_WIDTH = 13;
    public static final int SYMBOL_HEIGHT = 13;
    private static Map<Integer, SkinImage> avatars;
    private static Map<Integer, SkinImage> sleeves;
    private static Map<Integer, Font> fixedFonts;
    private static List<String> allSkins;
    private static int currentSkinIndex;
    private static String preferredDir;
    private static String preferredName;
    private static BufferedImage bimDefaultSprite;
    private static BufferedImage bimFavIcon;
    private static BufferedImage bimPreferredSprite;
    private static BufferedImage bimFoils;
    private static BufferedImage bimQuestDraftDeck;
    private static BufferedImage bimOldFoils;
    private static BufferedImage bimDefaultAvatars;
    private static BufferedImage bimPreferredAvatars;
    private static BufferedImage bimTrophies;
    private static BufferedImage bimAbilities;
    private static BufferedImage bimManaIcons;
    private static BufferedImage bimPhyrexian;
    private static BufferedImage bimColorlessHybrid;
    private static BufferedImage bimDefaultSleeve;
    private static BufferedImage bimDefaultSleeve2;
    private static BufferedImage bimDefaultDeckbox;
    private static BufferedImage bimPrefferedSetLogo;
    private static BufferedImage bimDefaultWatermark;
    private static BufferedImage bimDefaultDraftRank;
    private static BufferedImage bimAttractionLights;
    private static int x0;
    private static int y0;
    private static int w0;
    private static int h0;
    private static int newW;
    private static int newH;
    private static int preferredW;
    private static int preferredH;
    private static int defaultFontSize;
    private static boolean loaded;

    public static SkinColor getColor(Colors c0) {
        return (SkinColor)SkinColor.baseColors.get((Object)c0);
    }

    public static Color stepColor(Color clr0, int step) {
        int r = clr0.getRed();
        int g2 = clr0.getGreen();
        int b = clr0.getBlue();
        if (step < 0) {
            r = r + step > 0 ? r + step : 0;
            g2 = g2 + step > 0 ? g2 + step : 0;
            b = b + step > 0 ? b + step : 0;
        } else {
            r = r + step < 255 ? r + step : 255;
            g2 = g2 + step < 255 ? g2 + step : 255;
            b = b + step < 255 ? b + step : 255;
        }
        return new Color(r, g2, b);
    }

    public static Color alphaColor(Color clr0, int alpha) {
        return new Color(clr0.getRed(), clr0.getGreen(), clr0.getBlue(), alpha);
    }

    public static boolean isColorBright(Color c) {
        int v = (int)Math.sqrt((double)(c.getRed() * c.getRed()) * 0.241 + (double)(c.getGreen() * c.getGreen()) * 0.691 + (double)(c.getBlue() * c.getBlue()) * 0.068);
        return v >= 130;
    }

    public static Color getHighContrastColor(Color c) {
        return FSkin.isColorBright(c) ? Color.BLACK : Color.WHITE;
    }

    public static void setGraphicsColor(Graphics g2, SkinColor skinColor) {
        g2.setColor(skinColor.color);
    }

    public static void setGraphicsGradientPaint(Graphics2D g2d, float x1, float y1, SkinColor skinColor1, float x2, float y2, SkinColor skinColor2) {
        g2d.setPaint(new GradientPaint(x1, y1, skinColor1.color, x2, y2, skinColor2.color));
    }

    public static void setGraphicsGradientPaint(Graphics2D g2d, float x1, float y1, Color color1, float x2, float y2, SkinColor skinColor2) {
        g2d.setPaint(new GradientPaint(x1, y1, color1, x2, y2, skinColor2.color));
    }

    public static void setGraphicsGradientPaint(Graphics2D g2d, float x1, float y1, SkinColor skinColor1, float x2, float y2, Color color2) {
        g2d.setPaint(new GradientPaint(x1, y1, skinColor1.color, x2, y2, color2));
    }

    public static void setTempBackground(Component comp, SkinColor skinColor) {
        comp.setBackground(skinColor.color);
    }

    public static void setTempBorder(JComponent comp, SkinBorder skinBorder) {
        comp.setBorder(skinBorder.createBorder());
    }

    public static void drawImage(Graphics g2, SkinImage skinImage, int x, int y) {
        if (skinImage != null) {
            skinImage.draw(g2, x, y);
        }
    }

    public static void drawImage(Graphics g2, SkinImage skinImage, int x, int y, int w, int h2) {
        if (skinImage != null) {
            skinImage.draw(g2, x, y, w, h2);
        }
    }

    public static void drawImage(Graphics g2, SkinImage skinImage, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        if (skinImage != null) {
            skinImage.draw(g2, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2);
        }
    }

    public static SkinImage getImage(FSkinProp s0) {
        SkinImage image = (SkinImage)SkinImage.images.get((Object)s0);
        if (image == null && (image = (SkinImage)SkinIcon.icons.get((Object)s0)) == null) {
            throw new NullPointerException("Can't find an image for FSkinProp " + (Object)((Object)s0));
        }
        return image;
    }

    public static SkinImage getImage(FSkinProp s0, int w0, int h0) {
        w0 = w0 < 1 ? 1 : w0;
        h0 = h0 < 1 ? 1 : h0;
        return FSkin.getImage(s0).resize(w0, h0);
    }

    public static SkinCursor getCursor(FSkinProp s0, int hotSpotX, int hotSpotY, String name) {
        return FSkin.getImage(s0).toCursor(hotSpotX, hotSpotY, name);
    }

    public static SkinIcon getIcon(FSkinProp s0) {
        SkinIcon icon = (SkinIcon)SkinIcon.icons.get((Object)s0);
        if (icon == null) {
            throw new NullPointerException("Can't find an icon for FSkinProp " + (Object)((Object)s0));
        }
        return icon;
    }

    public static Font getFixedFont() {
        return FSkin.getFixedFont(defaultFontSize);
    }

    private static Font getFixedFont(int size) {
        Font fixedFont = fixedFonts.computeIfAbsent(size, s2 -> new Font("Monospaced", 0, (int)s2));
        return fixedFont;
    }

    public static Font getRelativeFixedFont(int relative) {
        return FSkin.getFixedFont(FSkin.getRelativeFontSize(relative));
    }

    private static double getMultiplier(int relative) {
        return (double)relative / 12.0;
    }

    public static Integer getRelativeFontSize(int relative) {
        double multiplier = FSkin.getMultiplier(relative);
        return (int)((double)defaultFontSize * multiplier);
    }

    public static SkinFont getFont() {
        return FSkin.getFont(defaultFontSize);
    }

    public static SkinFont getFont(int size) {
        return SkinFont.get(0, size);
    }

    public static SkinFont getRelativeFont(int relative) {
        return SkinFont.get(0, FSkin.getRelativeFontSize(relative));
    }

    public static SkinFont getBoldFont() {
        return FSkin.getBoldFont(defaultFontSize);
    }

    public static SkinFont getBoldFont(int size) {
        return SkinFont.get(1, size);
    }

    public static SkinFont getRelativeBoldFont(int relative) {
        return SkinFont.get(1, FSkin.getRelativeFontSize(relative));
    }

    public static SkinFont getItalicFont() {
        return FSkin.getItalicFont(defaultFontSize);
    }

    public static SkinFont getItalicFont(int size) {
        return SkinFont.get(2, size);
    }

    public static SkinFont getRelativeItalicFont(int relative) {
        return SkinFont.get(2, FSkin.getRelativeFontSize(relative));
    }

    public static void setGraphicsFont(Graphics g2, SkinFont skinFont) {
        g2.setFont(skinFont.font);
    }

    private static void addEncodingSymbol(String key, FSkinProp skinProp) {
        String path = ForgeConstants.CACHE_SYMBOLS_DIR + "/" + key.replace("/", "") + ".png";
        FSkin.getImage(skinProp).save(path, 13, 13);
    }

    public static String encodeSymbols(String str, boolean formatReminderText) {
        String replacement;
        String pattern;
        if (formatReminderText) {
            pattern = " \\((.+?)\\)";
            replacement = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_HIDE_REMINDER_TEXT) ? "" : " <i>\\($1\\)</i>";
            str = str.replaceAll(pattern, replacement);
        }
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_SR_OPTIMIZE)) {
            return str;
        }
        pattern = "\\{([A-Z0-9]+)\\}|\\{([A-Z0-9]+)/([A-Z0-9]+)\\}|(A-)|\\{([A-Z0-9]+)/([A-Z0-9]+)/([A-Z0-9]+)\\}";
        try {
            replacement = "<img src=\"" + new File(ForgeConstants.CACHE_SYMBOLS_DIR + "/$1$2$3$4$5$6$7.png").toURI().toURL().toString() + "\" width=" + 13 + " height=" + 13 + ">";
            str = str.replaceAll(pattern, replacement);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        str = str.replaceAll("\r?\n", "<br>");
        return "<html>" + str + "</html>";
    }

    public static void changeSkin(String skinName) {
        ForgePreferences prefs = FModel.getPreferences();
        if (skinName.equals(prefs.getPref(ForgePreferences.FPref.UI_SKIN))) {
            return;
        }
        prefs.setPref(ForgePreferences.FPref.UI_SKIN, skinName);
        prefs.save();
        loaded = false;
        FSkin.loadLight(skinName, false);
        FSkin.loadFull(false);
        Singletons.getControl().getForgeMenu().refresh();
        FComboBoxWrapper.refreshAllSkins();
        FComboBoxPanel.refreshAllSkins();
        Singletons.getView().getFrame().repaint();
    }

    public static void loadLight(String skinName, boolean onInit) {
        if (onInit) {
            FThreads.assertExecutedByEdt(false);
            if (allSkins == null) {
                allSkins = new ArrayList<String>();
                allSkins.add("Default");
                List<String> skinDirectoryNames = FSkin.getSkinDirectoryNames();
                for (String skinDirectoryName : skinDirectoryNames) {
                    allSkins.add(WordUtil.capitalize(skinDirectoryName.replace('_', ' ')));
                }
                Collections.sort(allSkins);
            }
        }
        currentSkinIndex = allSkins.indexOf(skinName);
        preferredName = skinName.toLowerCase().replace(' ', '_');
        String string = preferredDir = preferredName.equalsIgnoreCase("default") || preferredName.isEmpty() ? ForgeConstants.DEFAULT_SKINS_DIR : ForgeConstants.CACHE_SKINS_DIR + preferredName + "/";
        if (onInit) {
            File f = new File(preferredDir + "bg_splash.png");
            if (!f.exists()) {
                if (skinName.equals("default")) {
                    throw new RuntimeException(String.format("Cannot find default skin at %s", f.getAbsolutePath()));
                }
                FSkin.loadLight("default", true);
                return;
            }
            try {
                BufferedImage img = ImageIO.read(f);
                int h2 = img.getHeight();
                int w = img.getWidth();
                SkinIcon.setIcon(FSkinProp.BG_SPLASH, img.getSubimage(0, 0, w, h2 - 100));
                UIManager.put("ProgressBar.background", FSkin.getColorFromPixel(img.getRGB(25, h2 - 75)));
                UIManager.put("ProgressBar.selectionBackground", FSkin.getColorFromPixel(img.getRGB(75, h2 - 75)));
                UIManager.put("ProgressBar.foreground", FSkin.getColorFromPixel(img.getRGB(25, h2 - 25)));
                UIManager.put("ProgressBar.selectionForeground", FSkin.getColorFromPixel(img.getRGB(75, h2 - 25)));
                UIManager.put("ProgressBar.border", new LineBorder(Color.BLACK, 0));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            loaded = true;
        }
    }

    public static void loadFull(boolean onInit) {
        if (onInit) {
            FThreads.assertExecutedByEdt(false);
            if (preferredName.isEmpty()) {
                FSkin.loadLight("default", true);
            }
        }
        Localizer localizer = Localizer.getInstance();
        FView.SINGLETON_INSTANCE.setSplashProgessBarMessage(localizer.getMessage("splash.loading.processingimagesprites", new Object[0]) + ": ", 20);
        String defaultDir = ForgeConstants.DEFAULT_SKINS_DIR;
        File f1 = new File(defaultDir + "sprite_icons.png");
        File f2 = new File(preferredDir + "sprite_icons.png");
        File f3 = new File(defaultDir + "sprite_foils.png");
        File f4 = new File(defaultDir + "sprite_avatars.png");
        File f5 = new File(preferredDir + "sprite_avatars.png");
        File f6 = new File(defaultDir + "sprite_old_foils.png");
        File f7 = new File(defaultDir + "sprite_trophies.png");
        File f8 = new File(defaultDir + "bg_draft_deck.png");
        File f9 = new File(defaultDir + "sprite_favicons.png");
        File f10 = new File(defaultDir + "sprite_ability.png");
        File f11 = new File(defaultDir + "sprite_manaicons.png");
        File f12 = new File(defaultDir + "sprite_sleeves.png");
        File f13 = new File(defaultDir + "sprite_sleeves2.png");
        File f14 = new File(defaultDir + "sprite_deckbox.png");
        File f15 = new File(defaultDir + "sprite_setlogo.png");
        File f16 = new File(preferredDir + "sprite_setlogo.png");
        File f17 = new File(defaultDir + "sprite_watermark.png");
        File f18 = new File(defaultDir + "sprite_phyrexian.png");
        File f19 = new File(defaultDir + "sprite_hybrid_colorless.png");
        File f20 = new File(defaultDir + "sprite_draftranks.png");
        File f21 = new File(defaultDir + "sprite_attraction_lights.png");
        try {
            int p = 0;
            bimDefaultSprite = ImageIO.read(f1);
            FView.SINGLETON_INSTANCE.incrementSplashProgessBar(++p);
            bimAbilities = ImageIO.read(f10);
            FView.SINGLETON_INSTANCE.incrementSplashProgessBar(++p);
            bimManaIcons = ImageIO.read(f11);
            FView.SINGLETON_INSTANCE.incrementSplashProgessBar(++p);
            bimPhyrexian = ImageIO.read(f18);
            FView.SINGLETON_INSTANCE.incrementSplashProgessBar(++p);
            bimColorlessHybrid = ImageIO.read(f19);
            FView.SINGLETON_INSTANCE.incrementSplashProgessBar(++p);
            bimAttractionLights = ImageIO.read(f21);
            FView.SINGLETON_INSTANCE.incrementSplashProgessBar(++p);
            bimPreferredSprite = ImageIO.read(f2);
            FView.SINGLETON_INSTANCE.incrementSplashProgessBar(++p);
            bimFoils = ImageIO.read(f3);
            FView.SINGLETON_INSTANCE.incrementSplashProgessBar(++p);
            bimOldFoils = f6.exists() ? ImageIO.read(f6) : ImageIO.read(f3);
            FView.SINGLETON_INSTANCE.incrementSplashProgessBar(++p);
            bimDefaultAvatars = ImageIO.read(f4);
            FView.SINGLETON_INSTANCE.incrementSplashProgessBar(++p);
            bimDefaultSleeve = ImageIO.read(f12);
            FView.SINGLETON_INSTANCE.incrementSplashProgessBar(++p);
            bimDefaultSleeve2 = ImageIO.read(f13);
            FView.SINGLETON_INSTANCE.incrementSplashProgessBar(++p);
            bimDefaultDeckbox = ImageIO.read(f14);
            FView.SINGLETON_INSTANCE.incrementSplashProgessBar(++p);
            bimDefaultDraftRank = ImageIO.read(f20);
            FView.SINGLETON_INSTANCE.incrementSplashProgessBar(++p);
            bimPrefferedSetLogo = f16.exists() ? ImageIO.read(f16) : ImageIO.read(f15);
            FView.SINGLETON_INSTANCE.incrementSplashProgessBar(++p);
            bimDefaultWatermark = ImageIO.read(f17);
            FView.SINGLETON_INSTANCE.incrementSplashProgessBar(++p);
            bimTrophies = ImageIO.read(f7);
            FView.SINGLETON_INSTANCE.incrementSplashProgessBar(++p);
            bimQuestDraftDeck = ImageIO.read(f8);
            FView.SINGLETON_INSTANCE.incrementSplashProgessBar(++p);
            bimFavIcon = ImageIO.read(f9);
            FView.SINGLETON_INSTANCE.incrementSplashProgessBar(++p);
            if (f5.exists()) {
                bimPreferredAvatars = ImageIO.read(f5);
            }
            FView.SINGLETON_INSTANCE.incrementSplashProgessBar(++p);
            preferredH = bimPreferredSprite.getHeight();
            preferredW = bimPreferredSprite.getWidth();
        }
        catch (Exception e) {
            System.err.println("FSkin$loadFull: Missing a sprite (default icons, preferred icons, or foils.");
            e.printStackTrace();
        }
        if (onInit) {
            defaultFontSize = FModel.getPreferences().getPrefInt(ForgePreferences.FPref.UI_DEFAULT_FONT_SIZE);
        }
        SkinFont.setBaseFont(GuiUtils.newFont(FSkin.preferredDir + "font1.ttf"));
        SkinIcon.setIcon(FSkinProp.BG_TEXTURE, FSkin.preferredDir + "bg_texture.jpg");
        SkinIcon.setIcon(FSkinProp.BG_MATCH, FSkin.preferredDir + "bg_match.jpg");
        SkinIcon.setIcon(FSkinProp.BG_DAY, defaultDir + "bg_day.jpg");
        SkinIcon.setIcon(FSkinProp.BG_NIGHT, defaultDir + "bg_night.jpg");
        Colors.updateAll();
        block19: for (FSkinProp prop : FSkinProp.values()) {
            switch (prop.getType()) {
                case IMAGE: {
                    SkinImage.setImage(prop);
                    continue block19;
                }
                case ICON: {
                    SkinIcon.setIcon(prop);
                    continue block19;
                }
                case FOIL: {
                    FSkin.setImage(prop, bimFoils);
                    continue block19;
                }
                case OLD_FOIL: {
                    FSkin.setImage(prop, bimOldFoils);
                    continue block19;
                }
                case TROPHY: {
                    FSkin.setImage(prop, bimTrophies);
                    continue block19;
                }
                case FAVICON: {
                    FSkin.setImage(prop, bimFavIcon);
                    continue block19;
                }
                case ABILITY: {
                    FSkin.setImage(prop, bimAbilities);
                    continue block19;
                }
                case MANAICONS: {
                    FSkin.setImage(prop, bimManaIcons);
                    continue block19;
                }
                case PHYREXIAN: {
                    FSkin.setImage(prop, bimPhyrexian);
                    continue block19;
                }
                case COLORLESS_HYBRID: {
                    FSkin.setImage(prop, bimColorlessHybrid);
                    continue block19;
                }
                case ATTRACTION_LIGHTS: {
                    FSkin.setImage(prop, bimAttractionLights);
                    continue block19;
                }
                case DECKBOX: {
                    FSkin.setImage(prop, bimDefaultDeckbox);
                    continue block19;
                }
                case DRAFTRANKS: {
                    FSkin.setImage(prop, bimDefaultDraftRank);
                    continue block19;
                }
                case SETLOGO: {
                    FSkin.setImage(prop, bimPrefferedSetLogo);
                    continue block19;
                }
                case WATERMARKS: {
                    FSkin.setImage(prop, bimDefaultWatermark);
                    continue block19;
                }
            }
        }
        FSkin.assembleAvatars();
        FSkin.assembleSleeves();
        FView.SINGLETON_INSTANCE.setSplashProgessBarMessage("Creating display components.");
        loaded = true;
        bimDefaultSprite.flush();
        bimFoils.flush();
        bimOldFoils.flush();
        bimPreferredSprite.flush();
        bimDefaultAvatars.flush();
        bimDefaultSleeve.flush();
        bimDefaultSleeve2.flush();
        bimDefaultDeckbox.flush();
        bimDefaultDraftRank.flush();
        bimPrefferedSetLogo.flush();
        bimDefaultWatermark.flush();
        bimQuestDraftDeck.flush();
        bimTrophies.flush();
        bimAbilities.flush();
        bimPhyrexian.flush();
        bimColorlessHybrid.flush();
        bimManaIcons.flush();
        bimAttractionLights.flush();
        if (bimPreferredAvatars != null) {
            bimPreferredAvatars.flush();
        }
        bimDefaultSprite = null;
        bimFoils = null;
        bimOldFoils = null;
        bimPreferredSprite = null;
        bimDefaultAvatars = null;
        bimDefaultSleeve = null;
        bimDefaultSleeve2 = null;
        bimDefaultDeckbox = null;
        bimDefaultDraftRank = null;
        bimPrefferedSetLogo = null;
        bimDefaultWatermark = null;
        bimPreferredAvatars = null;
        bimQuestDraftDeck = null;
        bimTrophies = null;
        bimAbilities = null;
        bimPhyrexian = null;
        bimColorlessHybrid = null;
        bimManaIcons = null;
        bimAttractionLights = null;
        File dir = new File(ForgeConstants.CACHE_SYMBOLS_DIR);
        if (!dir.mkdir()) {
            File[] files = dir.listFiles();
            assert (files != null);
            for (File file : files) {
                file.delete();
            }
        }
        for (Map.Entry<String, FSkinProp> e : FSkinProp.MANA_IMG.entrySet()) {
            FSkin.addEncodingSymbol(e.getKey(), e.getValue());
        }
        FSkin.addEncodingSymbol("E", FSkinProp.IMG_ENERGY);
        FSkin.addEncodingSymbol("TK", FSkinProp.IMG_TICKET);
        FSkin.addEncodingSymbol("EXPERIENCE", FSkinProp.IMG_EXPERIENCE);
        FSkin.addEncodingSymbol("A-", FSkinProp.IMG_ALCHEMY);
        FView.SINGLETON_INSTANCE.setSplashProgessBarMessage("Setting look and feel...");
        ForgeLookAndFeel laf = new ForgeLookAndFeel();
        laf.setForgeLookAndFeel(Singletons.getView().getFrame());
    }

    public static List<String> getSkinDirectoryNames() {
        ArrayList<String> mySkins = new ArrayList<String>();
        File dir = new File(ForgeConstants.CACHE_SKINS_DIR);
        String[] children = dir.list();
        if (children == null) {
            System.err.println("FSkin > can't find skins directory!");
        } else {
            for (String aChildren : children) {
                if (aChildren.equalsIgnoreCase(".svn") || aChildren.equalsIgnoreCase(".DS_Store")) continue;
                mySkins.add(aChildren);
            }
        }
        return mySkins;
    }

    public static Iterable<String> getAllSkins() {
        return allSkins;
    }

    public static Map<Integer, SkinImage> getAvatars() {
        return avatars;
    }

    public static Map<Integer, SkinImage> getSleeves() {
        return sleeves;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static Color getColorFromPixel(int pixel) {
        int a = pixel >> 24 & 0xFF;
        int r = pixel >> 16 & 0xFF;
        int g2 = pixel >> 8 & 0xFF;
        int b = pixel & 0xFF;
        return new Color(r, g2, b, a);
    }

    private static BufferedImage testPreferredSprite(FSkinProp s0) {
        int[] tempCoords = s0.getCoords();
        x0 = tempCoords[0];
        y0 = tempCoords[1];
        w0 = tempCoords[2];
        h0 = tempCoords[3];
        if (s0.equals((Object)FSkinProp.IMG_QUEST_DRAFT_DECK)) {
            if (bimQuestDraftDeck != null) {
                Color c = FSkin.getColorFromPixel(bimQuestDraftDeck.getRGB(x0 + w0 / 2, y0 + h0 / 2));
                if (c.getAlpha() != 0) {
                    return bimQuestDraftDeck;
                }
            } else {
                return null;
            }
        }
        if (x0 > preferredW || x0 + w0 > preferredW || y0 > preferredH || y0 + h0 > preferredH) {
            return bimDefaultSprite;
        }
        if (bimPreferredSprite != null) {
            int x = x0 + w0 / 2;
            int y = y0 + h0 / 2;
            Color c = FSkin.getColorFromPixel(bimPreferredSprite.getRGB(x, y));
            if (c.getAlpha() != 0) {
                return bimPreferredSprite;
            }
            c = FSkin.getColorFromPixel(bimPreferredSprite.getRGB(x += 2, y += 2));
            if (c.getAlpha() != 0) {
                return bimPreferredSprite;
            }
            c = FSkin.getColorFromPixel(bimPreferredSprite.getRGB(x -= 4, y));
            if (c.getAlpha() != 0) {
                return bimPreferredSprite;
            }
            c = FSkin.getColorFromPixel(bimPreferredSprite.getRGB(x, y -= 4));
            if (c.getAlpha() != 0) {
                return bimPreferredSprite;
            }
            c = FSkin.getColorFromPixel(bimPreferredSprite.getRGB(x += 4, y));
            if (c.getAlpha() != 0) {
                return bimPreferredSprite;
            }
        }
        return bimDefaultSprite;
    }

    private static void assembleAvatars() {
        avatars = new HashMap<Integer, SkinImage>();
        int counter = 0;
        if (bimPreferredAvatars != null) {
            int pw = bimPreferredAvatars.getWidth();
            int ph = bimPreferredAvatars.getHeight();
            for (int j = 0; j < ph; j += 100) {
                for (int i = 0; i < pw; i += 100) {
                    Color pxTest;
                    if (i == 0 && j == 0 || (pxTest = FSkin.getColorFromPixel(bimPreferredAvatars.getRGB(i + 50, j + 50))).getAlpha() == 0) continue;
                    avatars.put(counter++, new SkinImage(bimPreferredAvatars.getSubimage(i, j, 100, 100)));
                }
            }
        } else {
            int aw = bimDefaultAvatars.getWidth();
            int ah = bimDefaultAvatars.getHeight();
            for (int j = 0; j < ah; j += 100) {
                for (int i = 0; i < aw; i += 100) {
                    Color pxTest;
                    if (i == 0 && j == 0 || (pxTest = FSkin.getColorFromPixel(bimDefaultAvatars.getRGB(i + 50, j + 50))).getAlpha() == 0) continue;
                    try {
                        avatars.put(counter++, new SkinImage(bimDefaultAvatars.getSubimage(i, j, 100, 100)));
                        continue;
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                    }
                }
            }
        }
    }

    private static void assembleSleeves() {
        Color pxTest;
        int i;
        int j;
        sleeves = new HashMap<Integer, SkinImage>();
        int counter = 0;
        if (bimDefaultSleeve != null) {
            int pw = bimDefaultSleeve.getWidth();
            int ph = bimDefaultSleeve.getHeight();
            for (j = 0; j < ph; j += 500) {
                for (i = 0; i < pw; i += 360) {
                    pxTest = FSkin.getColorFromPixel(bimDefaultSleeve.getRGB(i + 180, j + 250));
                    if (pxTest.getAlpha() == 0) continue;
                    sleeves.put(counter++, new SkinImage(bimDefaultSleeve.getSubimage(i, j, 360, 500)));
                }
            }
        }
        if (bimDefaultSleeve2 != null) {
            int aw = bimDefaultSleeve2.getWidth();
            int ah = bimDefaultSleeve2.getHeight();
            for (j = 0; j < ah; j += 500) {
                for (i = 0; i < aw; i += 360) {
                    pxTest = FSkin.getColorFromPixel(bimDefaultSleeve2.getRGB(i + 180, j + 250));
                    if (pxTest.getAlpha() == 0) continue;
                    sleeves.put(counter++, new SkinImage(bimDefaultSleeve2.getSubimage(i, j, 360, 500)));
                }
            }
        }
    }

    private static void setImage(FSkinProp s0, BufferedImage bim) {
        int[] tempCoords = s0.getCoords();
        x0 = tempCoords[0];
        y0 = tempCoords[1];
        w0 = tempCoords[2];
        h0 = tempCoords[3];
        if (bim != null) {
            SkinImage.setImage(s0, bim.getSubimage(FSkin.x0, FSkin.y0, FSkin.w0, FSkin.h0));
        }
    }

    static {
        fixedFonts = new HashMap<Integer, Font>();
        defaultFontSize = 12;
        loaded = false;
    }

    public static class SkinnedTableHeader
    extends JTableHeader
    implements ISkinnedComponent<JTableHeader> {
        private static final long serialVersionUID = -1842620489613307379L;
        private JComponentSkin<JTableHeader> skin;

        @Override
        public JComponentSkin<JTableHeader> getSkin() {
            if (this.skin == null) {
                this.skin = new JComponentSkin();
            }
            return this.skin;
        }

        public SkinnedTableHeader() {
        }

        public SkinnedTableHeader(TableColumnModel columnModel0) {
            super(columnModel0);
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            this.getSkin().resetForeground();
            super.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            this.getSkin().resetBackground();
            super.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this, skinFont);
        }

        @Override
        public void setFont(Font font) {
            this.getSkin().resetFont();
            super.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        public void setBorder(SkinBorder skinBorder) {
            ((JComponentSkin)this.getSkin()).setBorder(this, skinBorder);
        }

        @Override
        public void setBorder(Border border) {
            ((JComponentSkin)this.getSkin()).resetBorder();
            super.setBorder(border);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedTable
    extends JTable
    implements ISkinnedComponent<JTable> {
        private static final long serialVersionUID = -4194423897092773473L;
        private JTableSkin<JTable> skin;

        @Override
        public JTableSkin<JTable> getSkin() {
            if (this.skin == null) {
                this.skin = new JTableSkin();
            }
            return this.skin;
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            this.getSkin().resetForeground();
            super.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            this.getSkin().resetBackground();
            super.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this, skinFont);
        }

        @Override
        public void setFont(Font font) {
            this.getSkin().resetFont();
            super.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        public void setBorder(SkinBorder skinBorder) {
            ((JComponentSkin)this.getSkin()).setBorder(this, skinBorder);
        }

        @Override
        public void setBorder(Border border) {
            ((JComponentSkin)this.getSkin()).resetBorder();
            super.setBorder(border);
        }

        public void setSelectionForeground(SkinColor skinColor) {
            ((JTableSkin)this.getSkin()).setSelectionForeground(this, skinColor);
        }

        @Override
        public void setSelectionForeground(Color color) {
            ((JTableSkin)this.getSkin()).resetSelectionForeground();
            super.setSelectionForeground(color);
        }

        public void setSelectionBackground(SkinColor skinColor) {
            ((JTableSkin)this.getSkin()).setSelectionBackground(this, skinColor);
        }

        @Override
        public void setSelectionBackground(Color color) {
            ((JTableSkin)this.getSkin()).resetSelectionBackground();
            super.setSelectionBackground(color);
        }

        public void setGridColor(SkinColor skinColor) {
            ((JTableSkin)this.getSkin()).setGridColor(this, skinColor);
        }

        @Override
        public void setGridColor(Color color) {
            ((JTableSkin)this.getSkin()).resetGridColor();
            super.setGridColor(color);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedSlider
    extends JSlider
    implements ISkinnedComponent<JSlider> {
        private static final long serialVersionUID = -7846549500200072420L;
        private JComponentSkin<JSlider> skin;

        @Override
        public JComponentSkin<JSlider> getSkin() {
            if (this.skin == null) {
                this.skin = new JComponentSkin();
            }
            return this.skin;
        }

        public SkinnedSlider() {
        }

        public SkinnedSlider(int orientation) {
            super(orientation);
        }

        public SkinnedSlider(int min2, int max) {
            super(min2, max);
        }

        public SkinnedSlider(int min2, int max, int value) {
            super(min2, max, value);
        }

        public SkinnedSlider(int orientation, int min2, int max, int value) {
            super(orientation, min2, max, value);
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            this.getSkin().resetForeground();
            super.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            this.getSkin().resetBackground();
            super.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this, skinFont);
        }

        @Override
        public void setFont(Font font) {
            this.getSkin().resetFont();
            super.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        public void setBorder(SkinBorder skinBorder) {
            ((JComponentSkin)this.getSkin()).setBorder(this, skinBorder);
        }

        @Override
        public void setBorder(Border border) {
            ((JComponentSkin)this.getSkin()).resetBorder();
            super.setBorder(border);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedSpinner
    extends JSpinner
    implements ISkinnedComponent<JFormattedTextField> {
        private static final long serialVersionUID = -7379547491760852368L;
        private JTextComponentSkin<JFormattedTextField> skin;
        private JFormattedTextField textField;

        @Override
        public JTextComponentSkin<JFormattedTextField> getSkin() {
            if (this.skin == null) {
                this.skin = new JTextComponentSkin();
            }
            return this.skin;
        }

        public JFormattedTextField getTextField() {
            return this.textField;
        }

        public SkinnedSpinner() {
            this.updateTextField();
        }

        @Override
        public void setEditor(JComponent editor) {
            super.setEditor(editor);
            this.updateTextField();
        }

        private void updateTextField() {
            try {
                this.textField = ((JSpinner.NumberEditor)this.getEditor()).getTextField();
            }
            catch (Exception ex) {
                this.textField = null;
            }
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this.textField, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            if (this.textField == null) {
                super.setForeground(color);
                return;
            }
            this.getSkin().resetForeground();
            this.textField.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this.textField, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            if (this.textField == null) {
                super.setBackground(color);
                return;
            }
            this.getSkin().resetBackground();
            this.textField.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this.textField, skinFont);
        }

        @Override
        public void setFont(Font font) {
            if (this.textField == null) {
                super.setFont(font);
                return;
            }
            this.getSkin().resetFont();
            this.textField.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this.textField, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            if (this.textField == null) {
                super.setCursor(cursor);
                return;
            }
            this.getSkin().resetCursor();
            this.textField.setCursor(cursor);
        }

        public void setCaretColor(SkinColor skinColor) {
            ((JTextComponentSkin)this.getSkin()).setCaretColor(this.textField, skinColor);
        }

        public void setCaretColor(Color color) {
            if (this.textField == null) {
                return;
            }
            ((JTextComponentSkin)this.getSkin()).resetCaretColor();
            this.textField.setCaretColor(color);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this.textField);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedEditorPane
    extends JEditorPane
    implements ISkinnedComponent<JEditorPane> {
        private static final long serialVersionUID = 88434642461539322L;
        private JTextComponentSkin<JEditorPane> skin;

        @Override
        public JTextComponentSkin<JEditorPane> getSkin() {
            if (this.skin == null) {
                this.skin = new JTextComponentSkin();
            }
            return this.skin;
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            this.getSkin().resetForeground();
            super.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            this.getSkin().resetBackground();
            super.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this, skinFont);
        }

        @Override
        public void setFont(Font font) {
            this.getSkin().resetFont();
            super.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        public void setBorder(SkinBorder skinBorder) {
            ((JComponentSkin)this.getSkin()).setBorder(this, skinBorder);
        }

        @Override
        public void setBorder(Border border) {
            ((JComponentSkin)this.getSkin()).resetBorder();
            super.setBorder(border);
        }

        public void setCaretColor(SkinColor skinColor) {
            ((JTextComponentSkin)this.getSkin()).setCaretColor(this, skinColor);
        }

        @Override
        public void setCaretColor(Color color) {
            ((JTextComponentSkin)this.getSkin()).resetCaretColor();
            super.setCaretColor(color);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedTextPane
    extends JTextPane
    implements ISkinnedComponent<JTextPane> {
        private static final long serialVersionUID = -209191600467610844L;
        private JTextComponentSkin<JTextPane> skin;

        @Override
        public JTextComponentSkin<JTextPane> getSkin() {
            if (this.skin == null) {
                this.skin = new JTextComponentSkin();
            }
            return this.skin;
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            this.getSkin().resetForeground();
            super.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            this.getSkin().resetBackground();
            super.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this, skinFont);
        }

        @Override
        public void setFont(Font font) {
            this.getSkin().resetFont();
            super.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        public void setBorder(SkinBorder skinBorder) {
            ((JComponentSkin)this.getSkin()).setBorder(this, skinBorder);
        }

        @Override
        public void setBorder(Border border) {
            ((JComponentSkin)this.getSkin()).resetBorder();
            super.setBorder(border);
        }

        public void setCaretColor(SkinColor skinColor) {
            ((JTextComponentSkin)this.getSkin()).setCaretColor(this, skinColor);
        }

        @Override
        public void setCaretColor(Color color) {
            ((JTextComponentSkin)this.getSkin()).resetCaretColor();
            super.setCaretColor(color);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedTextArea
    extends JTextArea
    implements ISkinnedComponent<JTextArea> {
        private static final long serialVersionUID = 4191648156716570907L;
        private JTextComponentSkin<JTextArea> skin;

        @Override
        public JTextComponentSkin<JTextArea> getSkin() {
            if (this.skin == null) {
                this.skin = new JTextComponentSkin();
            }
            return this.skin;
        }

        public SkinnedTextArea() {
        }

        public SkinnedTextArea(String text) {
            super(text);
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            this.getSkin().resetForeground();
            super.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            this.getSkin().resetBackground();
            super.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this, skinFont);
        }

        @Override
        public void setFont(Font font) {
            this.getSkin().resetFont();
            super.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        public void setBorder(SkinBorder skinBorder) {
            ((JComponentSkin)this.getSkin()).setBorder(this, skinBorder);
        }

        @Override
        public void setBorder(Border border) {
            ((JComponentSkin)this.getSkin()).resetBorder();
            super.setBorder(border);
        }

        public void setCaretColor(SkinColor skinColor) {
            ((JTextComponentSkin)this.getSkin()).setCaretColor(this, skinColor);
        }

        @Override
        public void setCaretColor(Color color) {
            ((JTextComponentSkin)this.getSkin()).resetCaretColor();
            super.setCaretColor(color);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedPasswordField
    extends JPasswordField
    implements ISkinnedComponent<JTextField> {
        private static final long serialVersionUID = 1557674285031452868L;
        private JTextComponentSkin<JTextField> skin;

        @Override
        public JTextComponentSkin<JTextField> getSkin() {
            if (this.skin == null) {
                this.skin = new JTextComponentSkin();
            }
            return this.skin;
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            this.getSkin().resetForeground();
            super.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            this.getSkin().resetBackground();
            super.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this, skinFont);
        }

        @Override
        public void setFont(Font font) {
            this.getSkin().resetFont();
            super.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        public void setBorder(SkinBorder skinBorder) {
            ((JComponentSkin)this.getSkin()).setBorder(this, skinBorder);
        }

        @Override
        public void setBorder(Border border) {
            ((JComponentSkin)this.getSkin()).resetBorder();
            super.setBorder(border);
        }

        public void setCaretColor(SkinColor skinColor) {
            ((JTextComponentSkin)this.getSkin()).setCaretColor(this, skinColor);
        }

        @Override
        public void setCaretColor(Color color) {
            ((JTextComponentSkin)this.getSkin()).resetCaretColor();
            super.setCaretColor(color);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedTextField
    extends JTextField
    implements ISkinnedComponent<JTextField> {
        private static final long serialVersionUID = 5133370343400427635L;
        private JTextComponentSkin<JTextField> skin;

        @Override
        public JTextComponentSkin<JTextField> getSkin() {
            if (this.skin == null) {
                this.skin = new JTextComponentSkin();
            }
            return this.skin;
        }

        public SkinnedTextField() {
        }

        public SkinnedTextField(String text) {
            super(text);
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            this.getSkin().resetForeground();
            super.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            this.getSkin().resetBackground();
            super.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this, skinFont);
        }

        @Override
        public void setFont(Font font) {
            this.getSkin().resetFont();
            super.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        public void setBorder(SkinBorder skinBorder) {
            ((JComponentSkin)this.getSkin()).setBorder(this, skinBorder);
        }

        @Override
        public void setBorder(Border border) {
            ((JComponentSkin)this.getSkin()).resetBorder();
            super.setBorder(border);
        }

        public void setCaretColor(SkinColor skinColor) {
            ((JTextComponentSkin)this.getSkin()).setCaretColor(this, skinColor);
        }

        @Override
        public void setCaretColor(Color color) {
            ((JTextComponentSkin)this.getSkin()).resetCaretColor();
            super.setCaretColor(color);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedRadioButtonMenuItem
    extends JRadioButtonMenuItem
    implements ISkinnedComponent<JRadioButtonMenuItem> {
        private static final long serialVersionUID = -3609854793671399210L;
        private AbstractButtonSkin<JRadioButtonMenuItem> skin;

        @Override
        public AbstractButtonSkin<JRadioButtonMenuItem> getSkin() {
            if (this.skin == null) {
                this.skin = new AbstractButtonSkin();
            }
            return this.skin;
        }

        public SkinnedRadioButtonMenuItem() {
        }

        public SkinnedRadioButtonMenuItem(String text) {
            super(text);
        }

        public SkinnedRadioButtonMenuItem(Action a) {
            super(a);
        }

        public void setIcon(SkinImage skinImage) {
            ((AbstractButtonSkin)this.getSkin()).setIcon(this, skinImage);
        }

        @Override
        public void setIcon(Icon icon) {
            ((AbstractButtonSkin)this.getSkin()).resetIcon();
            super.setIcon(icon);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedCheckBoxMenuItem
    extends JCheckBoxMenuItem
    implements ISkinnedComponent<JCheckBoxMenuItem> {
        private static final long serialVersionUID = 7972531296466954594L;
        private AbstractButtonSkin<JCheckBoxMenuItem> skin;

        @Override
        public AbstractButtonSkin<JCheckBoxMenuItem> getSkin() {
            if (this.skin == null) {
                this.skin = new AbstractButtonSkin();
            }
            return this.skin;
        }

        public SkinnedCheckBoxMenuItem() {
        }

        public SkinnedCheckBoxMenuItem(String text) {
            super(text);
        }

        public SkinnedCheckBoxMenuItem(Action a) {
            super(a);
        }

        public void setIcon(SkinImage skinImage) {
            ((AbstractButtonSkin)this.getSkin()).setIcon(this, skinImage);
        }

        @Override
        public void setIcon(Icon icon) {
            ((AbstractButtonSkin)this.getSkin()).resetIcon();
            super.setIcon(icon);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedMenuItem
    extends JMenuItem
    implements ISkinnedComponent<JMenuItem> {
        private static final long serialVersionUID = 3738616219203986847L;
        private AbstractButtonSkin<JMenuItem> skin;

        @Override
        public AbstractButtonSkin<JMenuItem> getSkin() {
            if (this.skin == null) {
                this.skin = new AbstractButtonSkin();
            }
            return this.skin;
        }

        public SkinnedMenuItem() {
        }

        public SkinnedMenuItem(String text) {
            super(text);
        }

        public SkinnedMenuItem(Action a) {
            super(a);
        }

        public void setIcon(SkinImage skinImage) {
            ((AbstractButtonSkin)this.getSkin()).setIcon(this, skinImage);
        }

        @Override
        public void setIcon(Icon icon) {
            ((AbstractButtonSkin)this.getSkin()).resetIcon();
            super.setIcon(icon);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedMenu
    extends JMenu
    implements ISkinnedComponent<JMenu> {
        private static final long serialVersionUID = -1067731457894672601L;
        private AbstractButtonSkin<JMenu> skin;

        @Override
        public AbstractButtonSkin<JMenu> getSkin() {
            if (this.skin == null) {
                this.skin = new AbstractButtonSkin();
            }
            return this.skin;
        }

        public SkinnedMenu() {
        }

        public SkinnedMenu(String text) {
            super(text);
        }

        public SkinnedMenu(Action a) {
            super(a);
        }

        public void setIcon(SkinImage skinImage) {
            ((AbstractButtonSkin)this.getSkin()).setIcon(this, skinImage);
        }

        @Override
        public void setIcon(Icon icon) {
            ((AbstractButtonSkin)this.getSkin()).resetIcon();
            super.setIcon(icon);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedRadioButton
    extends JRadioButton
    implements ISkinnedComponent<JRadioButton> {
        private static final long serialVersionUID = 2724598726704588129L;
        private AbstractButtonSkin<JRadioButton> skin;

        @Override
        public AbstractButtonSkin<JRadioButton> getSkin() {
            if (this.skin == null) {
                this.skin = new AbstractButtonSkin();
            }
            return this.skin;
        }

        public SkinnedRadioButton() {
        }

        public SkinnedRadioButton(String text) {
            super(text);
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            this.getSkin().resetForeground();
            super.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            this.getSkin().resetBackground();
            super.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this, skinFont);
        }

        @Override
        public void setFont(Font font) {
            this.getSkin().resetFont();
            super.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        public void setBorder(SkinBorder skinBorder) {
            ((JComponentSkin)this.getSkin()).setBorder(this, skinBorder);
        }

        @Override
        public void setBorder(Border border) {
            ((JComponentSkin)this.getSkin()).resetBorder();
            super.setBorder(border);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedCheckBox
    extends JCheckBox
    implements ISkinnedComponent<JCheckBox> {
        private static final long serialVersionUID = 6283239481504889377L;
        private AbstractButtonSkin<JCheckBox> skin;

        @Override
        public AbstractButtonSkin<JCheckBox> getSkin() {
            if (this.skin == null) {
                this.skin = new AbstractButtonSkin();
            }
            return this.skin;
        }

        public SkinnedCheckBox() {
        }

        public SkinnedCheckBox(String text) {
            super(text);
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            this.getSkin().resetForeground();
            super.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            this.getSkin().resetBackground();
            super.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this, skinFont);
        }

        @Override
        public void setFont(Font font) {
            this.getSkin().resetFont();
            super.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        public void setBorder(SkinBorder skinBorder) {
            ((JComponentSkin)this.getSkin()).setBorder(this, skinBorder);
        }

        @Override
        public void setBorder(Border border) {
            ((JComponentSkin)this.getSkin()).resetBorder();
            super.setBorder(border);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedButton
    extends JButton
    implements ISkinnedComponent<JButton> {
        private static final long serialVersionUID = -1868724405885582324L;
        private AbstractButtonSkin<JButton> skin;

        @Override
        public AbstractButtonSkin<JButton> getSkin() {
            if (this.skin == null) {
                this.skin = new AbstractButtonSkin();
            }
            return this.skin;
        }

        public SkinnedButton() {
        }

        public SkinnedButton(String text) {
            super(text);
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            this.getSkin().resetForeground();
            super.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            this.getSkin().resetBackground();
            super.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this, skinFont);
        }

        @Override
        public void setFont(Font font) {
            this.getSkin().resetFont();
            super.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        public void setBorder(SkinBorder skinBorder) {
            ((JComponentSkin)this.getSkin()).setBorder(this, skinBorder);
        }

        @Override
        public void setBorder(Border border) {
            ((JComponentSkin)this.getSkin()).resetBorder();
            super.setBorder(border);
        }

        public void setIcon(SkinImage skinImage) {
            ((AbstractButtonSkin)this.getSkin()).setIcon(this, skinImage);
        }

        @Override
        public void setIcon(Icon icon) {
            ((AbstractButtonSkin)this.getSkin()).resetIcon();
            super.setIcon(icon);
        }

        public void setPressedIcon(SkinImage skinImage) {
            ((AbstractButtonSkin)this.getSkin()).setPressedIcon(this, skinImage);
        }

        @Override
        public void setPressedIcon(Icon icon) {
            ((AbstractButtonSkin)this.getSkin()).resetPressedIcon();
            super.setPressedIcon(icon);
        }

        public void setRolloverIcon(SkinImage skinImage) {
            ((AbstractButtonSkin)this.getSkin()).setRolloverIcon(this, skinImage);
        }

        @Override
        public void setRolloverIcon(Icon icon) {
            ((AbstractButtonSkin)this.getSkin()).resetRolloverIcon();
            super.setRolloverIcon(icon);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedTabbedPane
    extends JTabbedPane
    implements ISkinnedComponent<JTabbedPane> {
        private static final long serialVersionUID = 6069807433509074270L;
        private JComponentSkin<JTabbedPane> skin;

        @Override
        public JComponentSkin<JTabbedPane> getSkin() {
            if (this.skin == null) {
                this.skin = new JComponentSkin();
            }
            return this.skin;
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            this.getSkin().resetForeground();
            super.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            this.getSkin().resetBackground();
            super.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this, skinFont);
        }

        @Override
        public void setFont(Font font) {
            this.getSkin().resetFont();
            super.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        public void setBorder(SkinBorder skinBorder) {
            ((JComponentSkin)this.getSkin()).setBorder(this, skinBorder);
        }

        @Override
        public void setBorder(Border border) {
            ((JComponentSkin)this.getSkin()).resetBorder();
            super.setBorder(border);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedScrollPane
    extends JScrollPane
    implements ISkinnedComponent<JScrollPane> {
        private static final long serialVersionUID = 8958616297664604107L;
        private JComponentSkin<JScrollPane> skin;

        @Override
        public JComponentSkin<JScrollPane> getSkin() {
            if (this.skin == null) {
                this.skin = new JComponentSkin();
            }
            return this.skin;
        }

        public SkinnedScrollPane() {
            this.init();
        }

        public SkinnedScrollPane(Component comp) {
            super(comp);
            this.init();
        }

        public SkinnedScrollPane(int vsbPolicy, int hsbPolicy) {
            super(vsbPolicy, hsbPolicy);
            this.init();
        }

        public SkinnedScrollPane(Component comp, int vsbPolicy, int hsbPolicy) {
            super(comp, vsbPolicy, hsbPolicy);
            this.init();
        }

        private void init() {
            new SkinScrollBarUI(this.getVerticalScrollBar(), true);
            new SkinScrollBarUI(this.getHorizontalScrollBar(), false);
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            this.getSkin().resetForeground();
            super.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            this.getSkin().resetBackground();
            super.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this, skinFont);
        }

        @Override
        public void setFont(Font font) {
            this.getSkin().resetFont();
            super.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        public void setBorder(SkinBorder skinBorder) {
            ((JComponentSkin)this.getSkin()).setBorder(this, skinBorder);
        }

        @Override
        public void setBorder(Border border) {
            ((JComponentSkin)this.getSkin()).resetBorder();
            super.setBorder(border);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }

        private static class SkinScrollBarUI
        extends BasicScrollBarUI
        implements ILocalRepaint {
            private static final SkinColor backColor = FSkin.getColor(Colors.CLR_THEME2);
            private static final SkinColor borderColor = FSkin.getColor(Colors.CLR_TEXT);
            private static final SkinColor grooveColor = borderColor.alphaColor(200);
            private static final AlphaComposite alphaDim = AlphaComposite.getInstance(3, 0.7f);
            private static final int grooveSpace = 3;
            private final boolean vertical;
            private boolean hovered;
            private MouseAdapter hoverListener;

            private SkinScrollBarUI(JScrollBar scrollbar, boolean vertical0) {
                this.vertical = vertical0;
                this.hoverListener = new SkinScrollBarListener(this);
                scrollbar.setOpaque(false);
                scrollbar.addMouseListener(this.hoverListener);
                scrollbar.setUI(this);
            }

            @Override
            protected void uninstallListeners() {
                super.uninstallListeners();
                this.scrollbar.removeMouseListener(this.hoverListener);
            }

            @Override
            public void repaintSelf() {
                Dimension d = this.scrollbar.getSize();
                this.scrollbar.repaint(0, 0, d.width, d.height);
            }

            @Override
            protected JButton createIncreaseButton(int orientation) {
                return new HiddenButton();
            }

            @Override
            protected JButton createDecreaseButton(int orientation) {
                return new HiddenButton();
            }

            @Override
            protected void paintTrack(Graphics g2, JComponent c, Rectangle trackBounds) {
            }

            @Override
            protected void paintThumb(Graphics g2, JComponent c, Rectangle thumbBounds) {
                int x2;
                int[] yPoints;
                int[] xPoints;
                int y2;
                int maxArrowThickness;
                int arrowThickness;
                int x = thumbBounds.x;
                int y = thumbBounds.y;
                int width = thumbBounds.width - 1;
                int height = thumbBounds.height - 1;
                if (this.vertical) {
                    int x22 = (x += 2) + (width -= 4) / 2;
                    int x3 = x + width;
                    arrowThickness = width / 2;
                    maxArrowThickness = height / 2 - 6;
                    if (maxArrowThickness < 0) {
                        maxArrowThickness = 0;
                    }
                    if (arrowThickness > maxArrowThickness) {
                        arrowThickness = maxArrowThickness;
                    }
                    y2 = y + arrowThickness;
                    int y3 = y + height - arrowThickness;
                    int y4 = y + height;
                    xPoints = new int[]{x, x22, x3, x3, x22, x};
                    yPoints = new int[]{y2, y, y2, y3, y4, y3};
                } else {
                    int y22 = (y += 2) + (height -= 4) / 2;
                    int y3 = y + height;
                    arrowThickness = height / 2;
                    maxArrowThickness = width / 2 - 6;
                    if (maxArrowThickness < 0) {
                        maxArrowThickness = 0;
                    }
                    if (arrowThickness > maxArrowThickness) {
                        arrowThickness = maxArrowThickness;
                    }
                    x2 = x + arrowThickness;
                    int x3 = x + width - arrowThickness;
                    int x4 = x + width;
                    yPoints = new int[]{y, y22, y3, y3, y22, y};
                    xPoints = new int[]{x2, x, x2, x3, x4, x3};
                }
                Graphics2D g2d = (Graphics2D)g2;
                if (!this.hovered) {
                    g2d.setComposite(alphaDim);
                }
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                FSkin.setGraphicsColor(g2d, backColor);
                g2d.fillPolygon(xPoints, yPoints, xPoints.length);
                FSkin.setGraphicsColor(g2d, borderColor);
                g2d.drawPolygon(xPoints, yPoints, xPoints.length);
                if (this.vertical) {
                    if (height > 12) {
                        FSkin.setGraphicsColor(g2d, grooveColor);
                        int x23 = x + 3;
                        int x3 = x + width - 3;
                        int y3 = y + height / 2;
                        y2 = y3 - 3;
                        int y4 = y3 + 3;
                        g2d.drawLine(x23, y2, x3, y2);
                        g2d.drawLine(x23, y3, x3, y3);
                        g2d.drawLine(x23, y4, x3, y4);
                    }
                } else if (width > 12) {
                    FSkin.setGraphicsColor(g2d, grooveColor);
                    int y23 = y + 3;
                    int y3 = y + height - 3;
                    int x3 = x + width / 2;
                    x2 = x3 - 3;
                    int x4 = x3 + 3;
                    g2d.drawLine(x2, y23, x2, y3);
                    g2d.drawLine(x3, y23, x3, y3);
                    g2d.drawLine(x4, y23, x4, y3);
                }
            }

            private static class SkinScrollBarListener
            extends MouseAdapter {
                private SkinScrollBarUI barUI;

                private SkinScrollBarListener(SkinScrollBarUI barUI) {
                    this.barUI = barUI;
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    this.barUI.hovered = true;
                    this.barUI.repaintSelf();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    this.barUI.hovered = false;
                    this.barUI.repaintSelf();
                }
            }

            private static class HiddenButton
            extends JButton {
                private HiddenButton() {
                }

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(0, 0);
                }
            }
        }
    }

    public static abstract class FPanelBase
    extends SkinnedPanel {
        private static final long serialVersionUID = -7223626737375474132L;
        private SkinImage foregroundImage;
        private SkinImage backgroundTexture;
        private SkinColor backgroundTextureOverlay;

        protected FPanelBase() {
        }

        public FPanelBase(LayoutManager layoutManager) {
            super(layoutManager);
        }

        protected abstract void onSetForegroundImage(Image var1, boolean var2);

        public final void setForegroundImage(SkinImage skinImage, boolean stretch) {
            this.onSetForegroundImage(skinImage.image, stretch);
            this.foregroundImage = skinImage;
        }

        public final void setForegroundImage(SkinImage skinImage) {
            this.onSetForegroundImage(skinImage.image, false);
            this.foregroundImage = skinImage;
        }

        public final void setForegroundImage(Image image) {
            this.onSetForegroundImage(image, false);
            this.foregroundImage = null;
        }

        public final void setForegroundImage(ImageIcon imageIcon) {
            this.onSetForegroundImage(imageIcon.getImage(), false);
            this.foregroundImage = null;
        }

        protected abstract void onSetBackgroundTexture(Image var1);

        public final void setBackgroundTexture(SkinImage skinImage) {
            this.onSetBackgroundTexture(skinImage.image);
            this.backgroundTexture = skinImage;
        }

        public final void setBackgroundTexture(Image image) {
            this.onSetBackgroundTexture(image);
            this.backgroundTexture = null;
        }

        public final void setBackgroundTexture(ImageIcon imageIcon) {
            this.onSetBackgroundTexture(imageIcon.getImage());
            this.backgroundTexture = null;
        }

        protected abstract void onSetBackgroundTextureOverlay(Color var1);

        public final void setBackgroundTextureOverlay(SkinColor skinColor) {
            this.onSetBackgroundTextureOverlay(skinColor.color);
            this.backgroundTextureOverlay = skinColor;
        }

        public final void setBackgroundTextureOverlay(Color color) {
            this.onSetBackgroundTextureOverlay(color);
            this.backgroundTextureOverlay = null;
        }

        @Override
        protected void paintComponent(Graphics g2) {
            if (this.getSkin().update(this)) {
                if (this.foregroundImage != null) {
                    this.setForegroundImage(this.foregroundImage);
                }
                if (this.backgroundTexture != null) {
                    this.setBackgroundTexture(this.backgroundTexture);
                }
                if (this.backgroundTextureOverlay != null) {
                    this.setBackgroundTextureOverlay(this.backgroundTextureOverlay);
                }
            }
            super.paintComponent(g2);
        }
    }

    public static class SkinnedPanel
    extends JPanel
    implements ISkinnedComponent<JPanel> {
        private static final long serialVersionUID = -1842620489613307379L;
        private JComponentSkin<JPanel> skin;

        @Override
        public JComponentSkin<JPanel> getSkin() {
            if (this.skin == null) {
                this.skin = new JComponentSkin();
            }
            return this.skin;
        }

        public SkinnedPanel() {
        }

        public SkinnedPanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            this.getSkin().resetForeground();
            super.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            this.getSkin().resetBackground();
            super.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this, skinFont);
        }

        @Override
        public void setFont(Font font) {
            this.getSkin().resetFont();
            super.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        public void setBorder(SkinBorder skinBorder) {
            ((JComponentSkin)this.getSkin()).setBorder(this, skinBorder);
        }

        @Override
        public void setBorder(Border border) {
            ((JComponentSkin)this.getSkin()).resetBorder();
            super.setBorder(border);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedList<E>
    extends JList<E>
    implements ISkinnedComponent<JList<E>> {
        private static final long serialVersionUID = -2449981390420167627L;
        private JSkinSkin<JList<E>> skin;

        @Override
        public JSkinSkin<JList<E>> getSkin() {
            if (this.skin == null) {
                this.skin = new JSkinSkin();
            }
            return this.skin;
        }

        public SkinnedList() {
        }

        public SkinnedList(ListModel<E> model0) {
            super(model0);
        }

        public SkinnedList(E[] items) {
            super(items);
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            this.getSkin().resetForeground();
            super.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            this.getSkin().resetBackground();
            super.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this, skinFont);
        }

        @Override
        public void setFont(Font font) {
            this.getSkin().resetFont();
            super.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        public void setBorder(SkinBorder skinBorder) {
            ((JComponentSkin)this.getSkin()).setBorder(this, skinBorder);
        }

        @Override
        public void setBorder(Border border) {
            ((JComponentSkin)this.getSkin()).resetBorder();
            super.setBorder(border);
        }

        public void setSelectionForeground(SkinColor skinColor) {
            ((JSkinSkin)this.getSkin()).setSelectionForeground(this, skinColor);
        }

        @Override
        public void setSelectionForeground(Color color) {
            ((JSkinSkin)this.getSkin()).resetSelectionForeground();
            super.setSelectionForeground(color);
        }

        public void setSelectionBackground(SkinColor skinColor) {
            ((JSkinSkin)this.getSkin()).setSelectionBackground(this, skinColor);
        }

        @Override
        public void setSelectionBackground(Color color) {
            ((JSkinSkin)this.getSkin()).resetSelectionBackground();
            super.setSelectionBackground(color);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedComboBox<E>
    extends JComboBox<E>
    implements ISkinnedComponent<JComboBox<E>> {
        private static final long serialVersionUID = 9032839876990765149L;
        private JComponentSkin<JComboBox<E>> skin;

        @Override
        public JComponentSkin<JComboBox<E>> getSkin() {
            if (this.skin == null) {
                this.skin = new JComponentSkin();
            }
            return this.skin;
        }

        public SkinnedComboBox() {
        }

        public SkinnedComboBox(ComboBoxModel<E> model0) {
            super(model0);
        }

        public SkinnedComboBox(E[] items) {
            super(items);
        }

        public SkinnedComboBox(Vector<E> items) {
            super(items);
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            this.getSkin().resetForeground();
            super.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            this.getSkin().resetBackground();
            super.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this, skinFont);
        }

        @Override
        public void setFont(Font font) {
            this.getSkin().resetFont();
            super.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        public void setBorder(SkinBorder skinBorder) {
            ((JComponentSkin)this.getSkin()).setBorder(this, skinBorder);
        }

        @Override
        public void setBorder(Border border) {
            ((JComponentSkin)this.getSkin()).resetBorder();
            super.setBorder(border);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedLabel
    extends JLabel
    implements ISkinnedComponent<JLabel> {
        private static final long serialVersionUID = 7046941724535782054L;
        private JLabelSkin<JLabel> skin;

        @Override
        public JLabelSkin<JLabel> getSkin() {
            if (this.skin == null) {
                this.skin = new JLabelSkin();
            }
            return this.skin;
        }

        public SkinnedLabel() {
        }

        public SkinnedLabel(String text) {
            super(text);
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            this.getSkin().resetForeground();
            super.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            this.getSkin().resetBackground();
            super.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this, skinFont);
        }

        @Override
        public void setFont(Font font) {
            this.getSkin().resetFont();
            super.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        public void setBorder(SkinBorder skinBorder) {
            ((JComponentSkin)this.getSkin()).setBorder(this, skinBorder);
        }

        @Override
        public void setBorder(Border border) {
            ((JComponentSkin)this.getSkin()).resetBorder();
            super.setBorder(border);
        }

        public void setIcon(SkinImage skinImage) {
            ((JLabelSkin)this.getSkin()).setIcon(this, skinImage);
        }

        @Override
        public void setIcon(Icon icon) {
            ((JLabelSkin)this.getSkin()).resetIcon();
            super.setIcon(icon);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedMenuBar
    extends JMenuBar
    implements ISkinnedComponent<JMenuBar> {
        private static final long serialVersionUID = -183434586261989294L;
        private JComponentSkin<JMenuBar> skin;

        @Override
        public JComponentSkin<JMenuBar> getSkin() {
            if (this.skin == null) {
                this.skin = new JComponentSkin();
            }
            return this.skin;
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            this.getSkin().resetForeground();
            super.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            this.getSkin().resetBackground();
            super.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this, skinFont);
        }

        @Override
        public void setFont(Font font) {
            this.getSkin().resetFont();
            super.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        public void setBorder(SkinBorder skinBorder) {
            ((JComponentSkin)this.getSkin()).setBorder(this, skinBorder);
        }

        @Override
        public void setBorder(Border border) {
            ((JComponentSkin)this.getSkin()).resetBorder();
            super.setBorder(border);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedLayeredPane
    extends JLayeredPane
    implements ISkinnedComponent<JLayeredPane> {
        private static final long serialVersionUID = -8325505112790327931L;
        private JComponentSkin<JLayeredPane> skin;

        @Override
        public JComponentSkin<JLayeredPane> getSkin() {
            if (this.skin == null) {
                this.skin = new JComponentSkin();
            }
            return this.skin;
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            this.getSkin().update(this);
            super.paintComponent(g2);
        }
    }

    public static class SkinnedDialog
    extends JDialog
    implements ISkinnedComponent<JDialog> {
        private static final long serialVersionUID = -1086360770925335844L;
        private SkinBorder border;
        private WindowSkin<JDialog> skin;

        @Override
        public WindowSkin<JDialog> getSkin() {
            if (this.skin == null) {
                this.skin = new WindowSkin();
            }
            return this.skin;
        }

        public SkinnedDialog() {
        }

        public SkinnedDialog(Frame owner, boolean modal) {
            super(owner, modal);
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            this.getSkin().resetForeground();
            super.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            this.getSkin().resetBackground();
            super.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this, skinFont);
        }

        @Override
        public void setFont(Font font) {
            this.getSkin().resetFont();
            super.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        public void setIconImage(SkinImage skinImage) {
            ((WindowSkin)this.getSkin()).setIconImage(this, skinImage);
        }

        @Override
        public void setIconImage(Image image) {
            ((WindowSkin)this.getSkin()).resetIconImage();
            super.setIconImage(image);
        }

        public void setBorder(SkinBorder skinBorder) {
            this.getRootPane().setBorder(skinBorder != null ? skinBorder.createBorder() : null);
            this.border = skinBorder;
        }

        public void setBorder(Border border) {
            this.getRootPane().setBorder(border);
            this.border = null;
        }

        @Override
        public void paint(Graphics g2) {
            if (this.getSkin().update(this) && this.border != null) {
                this.setBorder(this.border);
            }
            super.paint(g2);
        }
    }

    public static class SkinnedFrame
    extends JFrame
    implements ISkinnedComponent<JFrame> {
        private static final long serialVersionUID = -7737786252990479019L;
        private SkinBorder border;
        private WindowSkin<JFrame> skin;

        @Override
        public WindowSkin<JFrame> getSkin() {
            if (this.skin == null) {
                this.skin = new WindowSkin();
            }
            return this.skin;
        }

        public void setForeground(SkinColor skinColor) {
            this.getSkin().setForeground(this, skinColor);
        }

        @Override
        public void setForeground(Color color) {
            this.getSkin().resetForeground();
            super.setForeground(color);
        }

        public void setBackground(SkinColor skinColor) {
            this.getSkin().setBackground(this, skinColor);
        }

        @Override
        public void setBackground(Color color) {
            this.getSkin().resetBackground();
            super.setBackground(color);
        }

        public void setFont(SkinFont skinFont) {
            this.getSkin().setFont(this, skinFont);
        }

        @Override
        public void setFont(Font font) {
            this.getSkin().resetFont();
            super.setFont(font);
        }

        public void setCursor(SkinCursor skinCursor) {
            this.getSkin().setCursor(this, skinCursor);
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.getSkin().resetCursor();
            super.setCursor(cursor);
        }

        public void setIconImage(SkinImage skinImage) {
            ((WindowSkin)this.getSkin()).setIconImage(this, skinImage);
        }

        @Override
        public void setIconImage(Image image) {
            ((WindowSkin)this.getSkin()).resetIconImage();
            super.setIconImage(image);
        }

        public void setBorder(SkinBorder skinBorder) {
            this.getRootPane().setBorder(skinBorder != null ? skinBorder.createBorder() : null);
            this.border = skinBorder;
        }

        public void setBorder(Border border) {
            this.getRootPane().setBorder(border);
            this.border = null;
        }

        @Override
        public void paint(Graphics g2) {
            if (this.getSkin().update(this) && this.border != null) {
                this.setBorder(this.border);
            }
            super.paint(g2);
        }
    }

    public static interface ISkinnedComponent<T extends Component> {
        public ComponentSkin<T> getSkin();
    }

    public static class JSkinSkin<T extends JList<?>>
    extends JComponentSkin<T> {
        private SkinColor selectionForeground;
        private SkinColor selectionBackground;

        protected JSkinSkin() {
        }

        protected void setSelectionForeground(T comp, SkinColor skinColor) {
            ((JList)comp).setSelectionForeground(skinColor != null ? skinColor.color : null);
            this.selectionForeground = skinColor;
        }

        protected void resetSelectionForeground() {
            this.selectionForeground = null;
        }

        protected void setSelectionBackground(T comp, SkinColor skinColor) {
            ((JList)comp).setSelectionBackground(skinColor != null ? skinColor.color : null);
            this.selectionBackground = skinColor;
        }

        protected void resetSelectionBackground() {
            this.selectionBackground = null;
        }

        @Override
        protected void reapply(T comp) {
            if (this.selectionForeground != null) {
                this.setSelectionForeground(comp, this.selectionForeground);
            }
            if (this.selectionBackground != null) {
                this.setSelectionBackground(comp, this.selectionBackground);
            }
            super.reapply(comp);
        }
    }

    public static class JTableSkin<T extends JTable>
    extends JComponentSkin<T> {
        private SkinColor selectionForeground;
        private SkinColor selectionBackground;
        private SkinColor gridColor;

        protected JTableSkin() {
        }

        protected void setSelectionForeground(T comp, SkinColor skinColor) {
            ((JTable)comp).setSelectionForeground(skinColor != null ? skinColor.color : null);
            this.selectionForeground = skinColor;
        }

        protected void resetSelectionForeground() {
            this.selectionForeground = null;
        }

        protected void setSelectionBackground(T comp, SkinColor skinColor) {
            ((JTable)comp).setSelectionBackground(skinColor != null ? skinColor.color : null);
            this.selectionBackground = skinColor;
        }

        protected void resetSelectionBackground() {
            this.selectionBackground = null;
        }

        protected void setGridColor(T comp, SkinColor skinColor) {
            ((JTable)comp).setGridColor(skinColor != null ? skinColor.color : null);
            this.gridColor = skinColor;
        }

        protected void resetGridColor() {
            this.gridColor = null;
        }

        @Override
        protected void reapply(T comp) {
            if (this.selectionForeground != null) {
                this.setSelectionForeground(comp, this.selectionForeground);
            }
            if (this.selectionBackground != null) {
                this.setSelectionBackground(comp, this.selectionBackground);
            }
            if (this.gridColor != null) {
                this.setGridColor(comp, this.gridColor);
            }
            super.reapply(comp);
        }
    }

    public static class JTextComponentSkin<T extends JTextComponent>
    extends JComponentSkin<T> {
        private SkinColor caretColor;

        protected JTextComponentSkin() {
        }

        protected void setCaretColor(T comp, SkinColor skinColor) {
            ((JTextComponent)comp).setCaretColor(skinColor != null ? skinColor.color : null);
            this.caretColor = skinColor;
        }

        protected void resetCaretColor() {
            this.caretColor = null;
        }

        @Override
        protected void reapply(T comp) {
            if (this.caretColor != null) {
                this.setCaretColor(comp, this.caretColor);
            }
            super.reapply(comp);
        }
    }

    public static class AbstractButtonSkin<T extends AbstractButton>
    extends JComponentSkin<T> {
        private SkinImage icon;
        private SkinImage pressedIcon;
        private SkinImage rolloverIcon;

        protected AbstractButtonSkin() {
        }

        protected void setIcon(T comp, SkinImage skinImage) {
            ((AbstractButton)comp).setIcon(skinImage != null ? skinImage.getIcon() : null);
            this.icon = skinImage;
        }

        protected void resetIcon() {
            this.icon = null;
        }

        protected void setPressedIcon(T comp, SkinImage skinImage) {
            ((AbstractButton)comp).setPressedIcon(skinImage != null ? skinImage.getIcon() : null);
            this.pressedIcon = skinImage;
        }

        protected void resetPressedIcon() {
            this.pressedIcon = null;
        }

        protected void setRolloverIcon(T comp, SkinImage skinImage) {
            ((AbstractButton)comp).setRolloverIcon(skinImage != null ? skinImage.getIcon() : null);
            this.rolloverIcon = skinImage;
        }

        protected void resetRolloverIcon() {
            this.rolloverIcon = null;
        }

        @Override
        protected void reapply(T comp) {
            if (this.icon != null) {
                this.setIcon(comp, this.icon);
            }
            if (this.pressedIcon != null) {
                this.setPressedIcon(comp, this.pressedIcon);
            }
            if (this.rolloverIcon != null) {
                this.setRolloverIcon(comp, this.rolloverIcon);
            }
            super.reapply(comp);
        }
    }

    public static class JLabelSkin<T extends JLabel>
    extends JComponentSkin<T> {
        private SkinImage icon;

        protected JLabelSkin() {
        }

        protected void setIcon(T comp, SkinImage skinImage) {
            ((JLabel)comp).setIcon(skinImage != null ? skinImage.getIcon() : null);
            this.icon = skinImage;
        }

        protected void resetIcon() {
            this.icon = null;
        }

        @Override
        protected void reapply(T comp) {
            if (this.icon != null) {
                this.setIcon(comp, this.icon);
            }
            super.reapply(comp);
        }
    }

    public static class JComponentSkin<T extends JComponent>
    extends ComponentSkin<T> {
        private SkinBorder border;

        protected JComponentSkin() {
        }

        protected void setBorder(T comp, SkinBorder skinBorder) {
            ((JComponent)comp).setBorder(skinBorder != null ? skinBorder.createBorder() : null);
            this.border = skinBorder;
        }

        protected void resetBorder() {
            this.border = null;
        }

        @Override
        protected void reapply(T comp) {
            if (this.border != null) {
                this.setBorder(comp, this.border);
            }
            super.reapply(comp);
        }
    }

    public static class WindowSkin<T extends Window>
    extends ComponentSkin<T> {
        private SkinImage iconImage;

        protected WindowSkin() {
        }

        protected void setIconImage(T comp, SkinImage skinImage) {
            ((Window)comp).setIconImage(skinImage != null ? skinImage.image : null);
            this.iconImage = skinImage;
        }

        protected void resetIconImage() {
            this.iconImage = null;
        }

        @Override
        protected void reapply(T comp) {
            if (this.iconImage != null) {
                this.setIconImage(comp, this.iconImage);
            }
            super.reapply(comp);
        }
    }

    public static class ComponentSkin<T extends Component> {
        private SkinColor foreground;
        private SkinColor background;
        private SkinFont font;
        private SkinCursor cursor;
        private int appliedSkinIndex = FSkin.access$2900();

        protected ComponentSkin() {
        }

        protected boolean update(T comp) {
            if (this.appliedSkinIndex == currentSkinIndex) {
                return false;
            }
            this.appliedSkinIndex = currentSkinIndex;
            this.reapply(comp);
            return true;
        }

        public SkinColor getForeground() {
            return this.foreground;
        }

        protected void setForeground(T comp, SkinColor skinColor) {
            ((Component)comp).setForeground(skinColor != null ? skinColor.color : null);
            this.foreground = skinColor;
        }

        protected void resetForeground() {
            this.foreground = null;
        }

        public SkinColor getBackground() {
            return this.background;
        }

        protected void setBackground(T comp, SkinColor skinColor) {
            ((Component)comp).setBackground(skinColor != null ? skinColor.color : null);
            this.background = skinColor;
        }

        protected void resetBackground() {
            this.background = null;
        }

        public SkinFont getFont() {
            return this.font;
        }

        protected void setFont(T comp, SkinFont skinFont) {
            ((Component)comp).setFont(skinFont != null ? skinFont.font : null);
            this.font = skinFont;
        }

        protected void resetFont() {
            this.font = null;
        }

        protected void setCursor(T comp, SkinCursor skinCursor) {
            ((Component)comp).setCursor(skinCursor != null ? skinCursor.cursor : null);
            this.cursor = skinCursor;
        }

        protected void resetCursor() {
            this.cursor = null;
        }

        protected void reapply(T comp) {
            if (this.foreground != null) {
                this.setForeground(comp, this.foreground);
            }
            if (this.background != null) {
                this.setBackground(comp, this.background);
            }
            if (this.font != null) {
                this.setFont(comp, this.font);
            }
            if (this.cursor != null) {
                this.setCursor(comp, this.cursor);
            }
        }
    }

    private static class ForgeLookAndFeel {
        private static boolean onInit = true;
        private static boolean isMetalLafSet = false;
        private final Color FORE_COLOR;
        private final Color BACK_COLOR;
        private final Color HIGHLIGHT_COLOR;
        private final Border LINE_BORDER;
        private final Border EMPTY_BORDER;

        private ForgeLookAndFeel() {
            this.FORE_COLOR = FSkin.getColor((Colors)Colors.CLR_TEXT).color;
            this.BACK_COLOR = FSkin.getColor((Colors)Colors.CLR_THEME2).color;
            this.HIGHLIGHT_COLOR = this.BACK_COLOR.brighter();
            this.LINE_BORDER = BorderFactory.createLineBorder(this.FORE_COLOR.darker(), 1);
            this.EMPTY_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        }

        private void setForgeLookAndFeel(JFrame appFrame) {
            if (this.setMetalLookAndFeel(appFrame)) {
                this.setMenusLookAndFeel();
                this.setComboBoxLookAndFeel();
                this.setTabbedPaneLookAndFeel();
                this.setButtonLookAndFeel();
                this.setToolTipLookAndFeel();
                this.setTextEditLookAndFeel();
            }
            onInit = false;
        }

        private boolean setMetalLookAndFeel(JFrame appFrame) {
            if (onInit) {
                try {
                    UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(appFrame);
                    isMetalLafSet = true;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                    e.printStackTrace();
                }
            }
            return isMetalLafSet;
        }

        private void setMenusLookAndFeel() {
            Color clrTheme = FSkin.getColor((Colors)Colors.CLR_THEME).color;
            Color backgroundColor = FSkin.stepColor(clrTheme, 0);
            Color menuBarEdgeColor = FSkin.stepColor(clrTheme, -80);
            UIManager.put("MenuBar.foreground", this.FORE_COLOR);
            UIManager.put("MenuBar.gradient", ForgeLookAndFeel.getColorGradients(backgroundColor.darker(), backgroundColor));
            UIManager.put("MenuBar.border", BorderFactory.createMatteBorder(0, 0, 1, 0, menuBarEdgeColor));
            UIManager.put("Menu.foreground", this.FORE_COLOR);
            UIManager.put("Menu.background", this.BACK_COLOR);
            UIManager.put("Menu.borderPainted", false);
            UIManager.put("Menu.selectionBackground", this.HIGHLIGHT_COLOR);
            UIManager.put("Menu.selectionForeground", this.FORE_COLOR);
            UIManager.put("Menu.border", this.EMPTY_BORDER);
            UIManager.put("Menu.opaque", false);
            UIManager.put("PopupMenu.border", this.LINE_BORDER);
            UIManager.put("PopupMenu.background", this.BACK_COLOR);
            UIManager.put("PopupMenu.foreground", this.FORE_COLOR);
            UIManager.put("MenuItem.foreground", this.FORE_COLOR);
            UIManager.put("MenuItem.background", this.BACK_COLOR);
            UIManager.put("MenuItem.border", this.EMPTY_BORDER);
            UIManager.put("MenuItem.selectionBackground", this.HIGHLIGHT_COLOR);
            UIManager.put("MenuItem.selectionForeground", this.FORE_COLOR);
            UIManager.put("MenuItem.acceleratorForeground", this.FORE_COLOR.darker());
            UIManager.put("MenuItem.opaque", true);
            UIManager.put("Separator.foreground", this.FORE_COLOR.darker());
            UIManager.put("Separator.background", this.BACK_COLOR);
            UIManager.put("RadioButtonMenuItem.foreground", this.FORE_COLOR);
            UIManager.put("RadioButtonMenuItem.background", this.BACK_COLOR);
            UIManager.put("RadioButtonMenuItem.selectionBackground", this.HIGHLIGHT_COLOR);
            UIManager.put("RadioButtonMenuItem.selectionForeground", this.FORE_COLOR);
            UIManager.put("RadioButtonMenuItem.border", this.EMPTY_BORDER);
            UIManager.put("RadioButtonMenuItem.acceleratorForeground", this.FORE_COLOR.darker());
            UIManager.put("CheckBoxMenuItem.foreground", this.FORE_COLOR);
            UIManager.put("CheckBoxMenuItem.background", this.BACK_COLOR);
            UIManager.put("CheckBoxMenuItem.selectionBackground", this.HIGHLIGHT_COLOR);
            UIManager.put("CheckBoxMenuItem.selectionForeground", this.FORE_COLOR);
            UIManager.put("CheckBoxMenuItem.border", this.EMPTY_BORDER);
            UIManager.put("CheckBoxMenuItem.acceleratorForeground", this.FORE_COLOR.darker());
        }

        private void setTabbedPaneLookAndFeel() {
            UIManager.put("TabbedPane.selected", this.HIGHLIGHT_COLOR);
            UIManager.put("TabbedPane.contentOpaque", FSkin.getColor(Colors.CLR_THEME));
            UIManager.put("TabbedPane.unselectedBackground", this.BACK_COLOR);
        }

        private void setComboBoxLookAndFeel() {
            UIManager.put("ComboBox.background", this.BACK_COLOR);
            UIManager.put("ComboBox.foreground", this.FORE_COLOR);
            UIManager.put("ComboBox.selectionBackground", this.HIGHLIGHT_COLOR);
            UIManager.put("ComboBox.selectionForeground", this.FORE_COLOR);
            UIManager.put("ComboBox.disabledBackground", this.BACK_COLOR);
            UIManager.put("ComboBox.disabledForeground", this.BACK_COLOR.darker());
            UIManager.put("ComboBox.font", ForgeLookAndFeel.getDefaultFont("ComboBox.font"));
            boolean isBright = FSkin.isColorBright(this.FORE_COLOR);
            UIManager.put("ComboBox.border", BorderFactory.createLineBorder(isBright ? this.FORE_COLOR.darker() : this.FORE_COLOR.brighter(), 1));
        }

        private void setButtonLookAndFeel() {
            UIManager.put("Button.foreground", this.FORE_COLOR);
            UIManager.put("Button.background", this.BACK_COLOR);
            UIManager.put("Button.select", this.HIGHLIGHT_COLOR);
            UIManager.put("Button.focus", this.FORE_COLOR.darker());
            UIManager.put("Button.rollover", false);
        }

        private void setToolTipLookAndFeel() {
            UIManager.put("ToolTip.background", this.BACK_COLOR);
            UIManager.put("ToolTip.foreground", this.FORE_COLOR);
            UIManager.put("ToolTip.border", this.LINE_BORDER);
        }

        private void setTextEditLookAndFeel() {
            if (OperatingSystem.isMac()) {
                for (String key : new String[]{"TextField.focusInputMap", "TextArea.focusInputMap"}) {
                    InputMap im = (InputMap)UIManager.get(key);
                    im.put(KeyStroke.getKeyStroke(67, 256), "copy-to-clipboard");
                    im.put(KeyStroke.getKeyStroke(86, 256), "paste-from-clipboard");
                    im.put(KeyStroke.getKeyStroke(88, 256), "cut-to-clipboard");
                    im.put(KeyStroke.getKeyStroke(65, 256), "select-all");
                }
            }
        }

        private static Font getDefaultFont(String component) {
            return FSkin.getFont(UIManager.getFont(component).getSize()).font;
        }

        private static List<Object> getColorGradients(Color bottom, Color top) {
            ArrayList<Object> gradients = new ArrayList<Object>();
            gradients.add(0.0);
            gradients.add(0.0);
            gradients.add(top);
            gradients.add(bottom);
            gradients.add(bottom);
            return gradients;
        }
    }

    public static class SkinFont {
        private static Font baseFont;
        private static Map<String, SkinFont> fonts;
        private final int style;
        private final int size;
        private Font font;

        private static SkinFont get(int style0, int size0) {
            String key = style0 + "|" + size0;
            SkinFont skinFont = fonts.get(key);
            if (skinFont == null) {
                skinFont = new SkinFont(style0, size0);
                fonts.put(key, skinFont);
            }
            return skinFont;
        }

        private static void setBaseFont(Font baseFont0) {
            baseFont = baseFont0;
            for (SkinFont skinFont : fonts.values()) {
                skinFont.updateFont();
            }
        }

        private SkinFont(int style0, int size0) {
            this.style = style0;
            this.size = size0;
            this.updateFont();
        }

        public Font getBaseFont() {
            return this.font;
        }

        public int getSize() {
            return this.font.getSize();
        }

        public int measureTextWidth(Graphics g2, String text) {
            return g2.getFontMetrics(this.font).stringWidth(text);
        }

        public FontMetrics getFontMetrics() {
            return Singletons.getView().getFrame().getGraphics().getFontMetrics(this.font);
        }

        private void updateFont() {
            try {
                this.font = baseFont.deriveFont(this.style, this.size);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        static {
            fonts = new HashMap<String, SkinFont>();
        }
    }

    public static class UnskinnedIcon
    extends SkinIcon {
        private final float opacity;

        public UnskinnedIcon(String path0) {
            super(new ImageIcon(path0));
            this.opacity = 1.0f;
        }

        public UnskinnedIcon(BufferedImage i0) {
            this(i0, 1.0f);
        }

        public UnskinnedIcon(BufferedImage i0, float opacity0) {
            super(new ImageIcon(i0));
            this.opacity = opacity0;
        }

        @Override
        public ImageIcon getIcon() {
            return super.getIcon();
        }

        @Override
        protected void draw(Graphics g2, int x, int y) {
            if (this.opacity == 1.0f) {
                super.draw(g2, x, y);
                return;
            }
            Graphics2D g2d = (Graphics2D)g2;
            Composite oldComp = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, this.opacity));
            super.draw(g2d, x, y);
            g2d.setComposite(oldComp);
        }

        @Override
        protected void draw(Graphics g2, int x, int y, int w, int h2) {
            if (this.opacity == 1.0f) {
                super.draw(g2, x, y, w, h2);
                return;
            }
            Graphics2D g2d = (Graphics2D)g2;
            Composite oldComp = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, this.opacity));
            super.draw(g2, x, y, w, h2);
            g2d.setComposite(oldComp);
        }

        @Override
        protected void draw(Graphics g2, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
            if (this.opacity == 1.0f) {
                super.draw(g2, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2);
                return;
            }
            Graphics2D g2d = (Graphics2D)g2;
            Composite oldComp = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, this.opacity));
            super.draw(g2, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2);
            g2d.setComposite(oldComp);
        }
    }

    public static class SkinIcon
    extends SkinImage {
        private static final Map<FSkinProp, SkinIcon> icons = new HashMap<FSkinProp, SkinIcon>();

        private static void setIcon(FSkinProp s0, ImageIcon imageIcon0) {
            SkinIcon skinIcon = icons.get((Object)s0);
            if (skinIcon == null) {
                skinIcon = new SkinIcon(imageIcon0);
                icons.put(s0, skinIcon);
            } else {
                skinIcon.changeImage(imageIcon0.getImage(), imageIcon0);
            }
        }

        private static void setIcon(FSkinProp s0) {
            int[] tempCoords = s0.getCoords();
            FSkin.x0 = tempCoords[0];
            y0 = tempCoords[1];
            w0 = tempCoords[2];
            h0 = tempCoords[3];
            BufferedImage img = FSkin.testPreferredSprite(s0);
            if (img == null) {
                return;
            }
            try {
                SkinIcon.setIcon(s0, new ImageIcon(img.getSubimage(x0, y0, w0, h0)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private static void setIcon(FSkinProp s0, String s1) {
            try {
                File file = new File(s1);
                ImageIO.read(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            SkinIcon.setIcon(s0, new ImageIcon(s1));
        }

        private static void setIcon(FSkinProp s0, BufferedImage bi0) {
            SkinIcon.setIcon(s0, new ImageIcon(bi0));
        }

        private SkinIcon(ImageIcon imageIcon0) {
            super(imageIcon0.getImage());
            this.imageIcon = imageIcon0;
        }

        @Override
        protected SkinIcon clone() {
            return new SkinIcon(this.imageIcon);
        }

        @Override
        public SkinIcon resize(int w, int h2) {
            return (SkinIcon)super.resize(w, h2);
        }

        @Override
        public SkinIcon scale(double scale) {
            return this.scale(scale, scale);
        }

        @Override
        public SkinIcon scale(double scaleX, double scaleY) {
            return (SkinIcon)super.scale(scaleX, scaleY);
        }

        @Override
        protected void createResizedImage(SkinImage baseImage, int w, int h2) {
            Image image0 = baseImage.image.getScaledInstance(w, h2, 4);
            this.changeImage(image0, new ImageIcon(image0));
        }

        @Override
        protected int getWidth() {
            return this.imageIcon.getIconWidth();
        }

        @Override
        protected int getHeight() {
            return this.imageIcon.getIconHeight();
        }

        @Override
        protected ImageIcon getIcon() {
            return this.imageIcon;
        }
    }

    public static class SkinCursor {
        private static final Toolkit TOOLS = Toolkit.getDefaultToolkit();
        private final Point hotSpot;
        private final String name;
        private Cursor cursor;

        private SkinCursor(Point hotSpot0, String name0) {
            this.hotSpot = hotSpot0;
            this.name = name0;
        }

        private void updateCursor(Image image) {
            this.cursor = TOOLS.createCustomCursor(image, this.hotSpot, this.name);
        }
    }

    public static class SkinImage
    implements ISkinImage {
        private static final Map<FSkinProp, SkinImage> images = new HashMap<FSkinProp, SkinImage>();
        protected Image image;
        protected ImageIcon imageIcon;
        protected HashMap<String, SkinImage> scaledImages = new HashMap();
        private HashMap<String, SkinCursor> cursors = new HashMap();

        private static void setImage(FSkinProp s0, Image image0) {
            SkinImage skinImage = images.get((Object)s0);
            if (skinImage == null) {
                skinImage = new SkinImage(image0);
                images.put(s0, skinImage);
            } else {
                skinImage.changeImage(image0, null);
            }
        }

        private static void setImage(FSkinProp s0) {
            SkinImage.setImage(s0, true);
        }

        private static void setImage(FSkinProp s0, boolean scale) {
            int[] tempCoords = s0.getCoords();
            FSkin.x0 = tempCoords[0];
            y0 = tempCoords[1];
            w0 = tempCoords[2];
            h0 = tempCoords[3];
            newW = tempCoords.length == 6 ? tempCoords[4] : 0;
            newH = tempCoords.length == 6 ? tempCoords[5] : 0;
            BufferedImage img = FSkin.testPreferredSprite(s0);
            if (img == null) {
                return;
            }
            try {
                BufferedImage bi0 = img.getSubimage(x0, y0, w0, h0);
                if (scale && newW != 0) {
                    SkinImage.setImage(s0, bi0.getScaledInstance(newW, newH, 4));
                } else {
                    SkinImage.setImage(s0, bi0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private SkinImage(Image image0) {
            this.image = image0;
        }

        protected void changeImage(Image image0, ImageIcon imageIcon0) {
            this.image = image0;
            this.imageIcon = imageIcon0;
            this.updateScaledImages();
            this.updateCursors();
        }

        protected SkinImage clone() {
            return new SkinImage(this.image);
        }

        public SkinImage resize(int w, int h2) {
            String key = w + "x" + h2;
            SkinImage scaledImage = this.scaledImages.get(key);
            if (scaledImage == null) {
                scaledImage = this.clone();
                scaledImage.createResizedImage(this, w, h2);
                this.scaledImages.put(key, scaledImage);
            }
            return scaledImage;
        }

        public boolean save(String path, int w, int h2) {
            Image scaledImage = this.image.getScaledInstance(w, h2, 4);
            BufferedImage resizedImage = new BufferedImage(w, h2, 2);
            Graphics2D g2d = resizedImage.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.drawImage(scaledImage, 0, 0, null);
            g2d.dispose();
            File outputfile = new File(path);
            try {
                ImageIO.write((RenderedImage)resizedImage, "png", outputfile);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }

        public SkinImage scale(double scale) {
            return this.scale(scale, scale);
        }

        public SkinImage scale(double scaleX, double scaleY) {
            String key = scaleX + "|" + scaleY;
            SkinImage scaledImage = this.scaledImages.get(key);
            if (scaledImage == null) {
                scaledImage = this.clone();
                scaledImage.createScaledImage(this, scaleX, scaleY);
                this.scaledImages.put(key, scaledImage);
            }
            return scaledImage;
        }

        protected void updateScaledImages() {
            for (Map.Entry<String, SkinImage> i : this.scaledImages.entrySet()) {
                String[] dims = i.getKey().split("x");
                if (dims.length == 2) {
                    i.getValue().createResizedImage(this, Integer.parseInt(dims[0]), Integer.parseInt(dims[1]));
                    continue;
                }
                dims = i.getKey().split("\\|");
                i.getValue().createScaledImage(this, Double.parseDouble(dims[0]), Double.parseDouble(dims[1]));
            }
        }

        protected void createResizedImage(SkinImage baseImage, int w, int h2) {
            this.changeImage(baseImage.image.getScaledInstance(w, h2, 4), null);
        }

        private void createScaledImage(SkinImage baseImage, double scaleX, double scaleY) {
            this.createResizedImage(baseImage, (int)((double)baseImage.getWidth() * scaleX), (int)((double)baseImage.getHeight() * scaleY));
        }

        private SkinCursor toCursor(int hotSpotX, int hotSpotY, String name) {
            String key = hotSpotX + "|" + hotSpotY + "|" + name;
            SkinCursor cursor = this.cursors.get(key);
            if (cursor == null) {
                cursor = new SkinCursor(new Point(hotSpotX, hotSpotY), name);
                cursor.updateCursor(this.image);
                this.cursors.put(key, cursor);
            }
            return cursor;
        }

        private void updateCursors() {
            for (SkinCursor cursor : this.cursors.values()) {
                cursor.updateCursor(this.image);
            }
        }

        public Dimension getSizeForPaint(Graphics g2) {
            if (g2 == null) {
                throw new NullPointerException("Must pass Graphics to get size for paint");
            }
            return new Dimension(this.getWidth(), this.getHeight());
        }

        protected int getWidth() {
            return this.image.getWidth(null);
        }

        protected int getHeight() {
            return this.image.getHeight(null);
        }

        protected ImageIcon getIcon() {
            if (this.imageIcon == null) {
                this.imageIcon = new ImageIcon(this.image);
            }
            return this.imageIcon;
        }

        protected void draw(Graphics g2, int x, int y) {
            g2.drawImage(this.image, x, y, null);
        }

        protected void draw(Graphics g2, int x, int y, int w, int h2) {
            g2.drawImage(this.image, x, y, w, h2, null);
        }

        protected void draw(Graphics g2, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
            g2.drawImage(this.image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
        }
    }

    public static enum Colors {
        CLR_THEME(FSkinProp.CLR_THEME),
        CLR_BORDERS(FSkinProp.CLR_BORDERS),
        CLR_ZEBRA(FSkinProp.CLR_ZEBRA),
        CLR_HOVER(FSkinProp.CLR_HOVER),
        CLR_ACTIVE(FSkinProp.CLR_ACTIVE),
        CLR_INACTIVE(FSkinProp.CLR_INACTIVE),
        CLR_TEXT(FSkinProp.CLR_TEXT),
        CLR_PHASE_INACTIVE_ENABLED(FSkinProp.CLR_PHASE_INACTIVE_ENABLED),
        CLR_PHASE_INACTIVE_DISABLED(FSkinProp.CLR_PHASE_INACTIVE_DISABLED),
        CLR_PHASE_ACTIVE_ENABLED(FSkinProp.CLR_PHASE_ACTIVE_ENABLED),
        CLR_PHASE_ACTIVE_DISABLED(FSkinProp.CLR_PHASE_ACTIVE_DISABLED),
        CLR_THEME2(FSkinProp.CLR_THEME2),
        CLR_OVERLAY(FSkinProp.CLR_OVERLAY),
        CLR_COMBAT_TARGETING_ARROW(FSkinProp.CLR_COMBAT_TARGETING_ARROW),
        CLR_NORMAL_TARGETING_ARROW(FSkinProp.CLR_NORMAL_TARGETING_ARROW),
        CLR_PWATTK_TARGETING_ARROW(FSkinProp.CLR_PWATTK_TARGETING_ARROW);

        private Color color;
        private final FSkinProp skinProp;

        private Colors(FSkinProp skinProp0) {
            this.skinProp = skinProp0;
        }

        public static Colors fromSkinProp(FSkinProp skinProp) {
            for (Colors c : Colors.values()) {
                if (c.skinProp != skinProp) continue;
                return c;
            }
            return null;
        }

        public static void updateAll() {
            for (Object c : Colors.values()) {
                c.updateColor();
            }
            if (SkinColor.baseColors.isEmpty()) {
                for (Object c : Colors.values()) {
                    SkinColor.baseColors.put(c, new SkinColor((Colors)((Object)c)));
                }
            } else {
                for (SkinColor c : SkinColor.baseColors.values()) {
                    c.updateColor();
                }
                for (SkinColor c : SkinColor.derivedColors.values()) {
                    c.updateColor();
                }
            }
        }

        private void updateColor() {
            int[] tempCoords = this.skinProp.getCoords();
            FSkin.x0 = tempCoords[0];
            y0 = tempCoords[1];
            try {
                this.color = bimPreferredSprite.getData().getBounds().contains(x0, y0) ? FSkin.getColorFromPixel(bimPreferredSprite.getRGB(x0, y0)) : new Color(0, 0, 0, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class TitledSkinBorder
    extends SkinBorder {
        private final SkinColor foreColor;
        private final String title;
        private Border insideBorder;
        private SkinBorder insideSkinBorder;

        public TitledSkinBorder(Border insideBorder0, String title0, SkinColor foreColor0) {
            this.insideBorder = insideBorder0;
            this.title = title0;
            this.foreColor = foreColor0;
        }

        public TitledSkinBorder(SkinBorder insideSkinBorder0, String title0, SkinColor foreColor0) {
            this.insideSkinBorder = insideSkinBorder0;
            this.title = title0;
            this.foreColor = foreColor0;
        }

        @Override
        protected Border createBorder() {
            Border inBorder = this.insideBorder;
            if (this.insideSkinBorder != null) {
                inBorder = this.insideSkinBorder.createBorder();
            }
            TitledBorder border = new TitledBorder(inBorder, this.title);
            border.setTitleColor(this.foreColor.color);
            return border;
        }
    }

    public static class CompoundSkinBorder
    extends SkinBorder {
        private Border outsideBorder;
        private Border insideBorder;
        private SkinBorder outsideSkinBorder;
        private SkinBorder insideSkinBorder;

        public CompoundSkinBorder(SkinBorder outsideSkinBorder0, SkinBorder insideSkinBorder0) {
            this.outsideSkinBorder = outsideSkinBorder0;
            this.insideSkinBorder = insideSkinBorder0;
        }

        public CompoundSkinBorder(SkinBorder outsideSkinBorder0, Border insideBorder0) {
            this.outsideSkinBorder = outsideSkinBorder0;
            this.insideBorder = insideBorder0;
        }

        public CompoundSkinBorder(Border outsideBorder0, SkinBorder insideSkinBorder0) {
            this.outsideBorder = outsideBorder0;
            this.insideSkinBorder = insideSkinBorder0;
        }

        @Override
        protected Border createBorder() {
            Border outBorder = this.outsideBorder;
            if (this.outsideSkinBorder != null) {
                outBorder = this.outsideSkinBorder.createBorder();
            }
            Border inBorder = this.insideBorder;
            if (this.insideSkinBorder != null) {
                inBorder = this.insideSkinBorder.createBorder();
            }
            return BorderFactory.createCompoundBorder(outBorder, inBorder);
        }
    }

    public static class MatteSkinBorder
    extends SkinBorder {
        private final int top;
        private final int left;
        private final int bottom;
        private final int right;
        private final SkinColor skinColor;

        public MatteSkinBorder(int top0, int left0, int bottom0, int right0, SkinColor skinColor0) {
            this.top = top0;
            this.left = left0;
            this.bottom = bottom0;
            this.right = right0;
            this.skinColor = skinColor0;
        }

        @Override
        protected Border createBorder() {
            return BorderFactory.createMatteBorder(this.top, this.left, this.bottom, this.right, this.skinColor.color);
        }
    }

    public static class LineSkinBorder
    extends SkinBorder {
        private final SkinColor skinColor;
        private final int thickness;

        public LineSkinBorder(SkinColor skinColor0) {
            this(skinColor0, 1);
        }

        public LineSkinBorder(SkinColor skinColor0, int thickness0) {
            this.skinColor = skinColor0;
            this.thickness = thickness0;
        }

        @Override
        protected Border createBorder() {
            return BorderFactory.createLineBorder(this.skinColor.color, this.thickness);
        }
    }

    public static abstract class SkinBorder {
        protected abstract Border createBorder();
    }

    public static class SkinColor {
        private static final HashMap<Colors, SkinColor> baseColors = new HashMap();
        private static final HashMap<String, SkinColor> derivedColors = new HashMap();
        private static final int NO_BRIGHTNESS_DELTA = 0;
        private static final int NO_STEP = -999;
        private static final int NO_ALPHA = -1;
        private final Colors baseColor;
        private final int brightnessDelta;
        private final int step;
        private final int contrastStep;
        private final int alpha;
        protected Color color;

        public Color getColor() {
            return this.color;
        }

        private SkinColor(Colors baseColor0) {
            this(baseColor0, 0, -999, -999, -1);
        }

        private SkinColor(Colors baseColor0, int brightnessDelta0, int step0, int contrastStep0, int alpha0) {
            this.baseColor = baseColor0;
            this.brightnessDelta = brightnessDelta0;
            this.step = step0;
            this.contrastStep = contrastStep0;
            this.alpha = alpha0;
            this.updateColor();
        }

        private SkinColor getDerivedColor(int brightnessDelta0, int step0, int contrastStep0, int alpha0) {
            String key = this.baseColor.name() + "|" + brightnessDelta0 + "|" + step0 + "|" + contrastStep0 + "|" + alpha0;
            SkinColor derivedColor = derivedColors.get(key);
            if (derivedColor == null) {
                derivedColor = new SkinColor(this.baseColor, brightnessDelta0, step0, contrastStep0, alpha0);
                derivedColors.put(key, derivedColor);
            }
            return derivedColor;
        }

        public SkinColor brighter() {
            return this.getDerivedColor(this.brightnessDelta + 1, this.step, this.contrastStep, this.alpha);
        }

        public SkinColor darker() {
            return this.getDerivedColor(this.brightnessDelta - 1, this.step, this.contrastStep, this.alpha);
        }

        public SkinColor stepColor(int step0) {
            if (this.step != -999) {
                step0 += this.step;
            }
            return this.getDerivedColor(this.brightnessDelta, step0, this.contrastStep, this.alpha);
        }

        public SkinColor getContrastColor(int contrastStep0) {
            if (this.contrastStep != -999) {
                contrastStep0 += this.contrastStep;
            }
            return this.getDerivedColor(this.brightnessDelta, this.step, contrastStep0, this.alpha);
        }

        public SkinColor getHighContrastColor() {
            return this.getContrastColor(255);
        }

        public SkinColor alphaColor(int alpha0) {
            return this.getDerivedColor(this.brightnessDelta, this.step, this.contrastStep, alpha0);
        }

        protected void updateColor() {
            this.color = this.baseColor.color;
            if (this.brightnessDelta != 0) {
                if (this.brightnessDelta < 0) {
                    for (int i = 0; i > this.brightnessDelta; --i) {
                        this.color = this.color.darker();
                    }
                } else {
                    for (int i = 0; i < this.brightnessDelta; ++i) {
                        this.color = this.color.brighter();
                    }
                }
            }
            if (this.step != -999) {
                this.color = FSkin.stepColor(this.color, this.step);
            }
            if (this.contrastStep != -999) {
                this.color = FSkin.stepColor(this.color, FSkin.isColorBright(this.color) ? -this.contrastStep : this.contrastStep);
            }
            if (this.alpha != -1) {
                this.color = FSkin.alphaColor(this.color, this.alpha);
            }
        }
    }
}

