/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.toolbox.FAbsolutePositioner;
import forge.toolbox.FLabel;
import forge.toolbox.FSkin;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollBar;
import javax.swing.Timer;
import javax.swing.border.Border;

public class FScrollPane
extends FSkin.SkinnedScrollPane {
    private static final FSkin.SkinColor arrowColor = FSkin.getColor(FSkin.Colors.CLR_TEXT);
    private final ArrowButton[] arrowButtons;

    public FScrollPane(boolean showBorder0) {
        this(null, showBorder0);
    }

    public FScrollPane(boolean showBorder0, int vertical0, int horizontal0) {
        this(null, showBorder0, false, vertical0, horizontal0);
    }

    public FScrollPane(Component c0, boolean showBorder0) {
        this(c0, showBorder0, false, 20, 30);
    }

    public FScrollPane(Component c0, boolean showBorder0, boolean useArrowButtons0) {
        this(c0, showBorder0, useArrowButtons0, 20, 30);
    }

    public FScrollPane(Component c0, boolean showBorder0, int vertical0, int horizontal0) {
        this(c0, showBorder0, false, vertical0, horizontal0);
    }

    public FScrollPane(Component c0, boolean showBorder0, boolean useArrowButtons0, int vertical0, int horizontal0) {
        super(c0, vertical0, horizontal0);
        this.getVerticalScrollBar().setUnitIncrement(16);
        this.getHorizontalScrollBar().setUnitIncrement(16);
        this.getViewport().setOpaque(false);
        this.setOpaque(false);
        if (showBorder0) {
            this.setBorder(new FSkin.LineSkinBorder(FSkin.getColor(FSkin.Colors.CLR_BORDERS)));
        } else {
            this.setBorder((Border)null);
        }
        if (useArrowButtons0) {
            this.getHorizontalScrollBar().setPreferredSize(new Dimension(0, 0));
            this.getVerticalScrollBar().setPreferredSize(new Dimension(0, 0));
            this.arrowButtons = new ArrowButton[4];
        } else {
            this.arrowButtons = null;
        }
    }

    @Override
    public void setVisible(boolean visible0) {
        super.setVisible(visible0);
        if (!visible0) {
            this.hideArrowButtons();
        }
    }

    public void hideArrowButtons() {
        if (this.arrowButtons == null) {
            return;
        }
        for (ArrowButton arrowButton : this.arrowButtons) {
            if (arrowButton == null) continue;
            FAbsolutePositioner.SINGLETON_INSTANCE.hide(arrowButton);
        }
    }

    public void scrollToTop() {
        this.getVerticalScrollBar().setValue(0);
    }

    public void scrollToBottom() {
        this.getVerticalScrollBar().setValue(this.getVerticalScrollBar().getMaximum());
    }

    @Override
    public void paint(Graphics g2) {
        JScrollBar vertScrollBar;
        super.paint(g2);
        if (this.arrowButtons == null) {
            return;
        }
        boolean[] visible = new boolean[]{false, false, false, false};
        JScrollBar horzScrollBar = this.getHorizontalScrollBar();
        if (horzScrollBar.isVisible()) {
            visible[0] = horzScrollBar.getValue() > 0;
            boolean bl = visible[1] = horzScrollBar.getValue() < horzScrollBar.getMaximum() - horzScrollBar.getModel().getExtent();
        }
        if ((vertScrollBar = this.getVerticalScrollBar()).isVisible()) {
            visible[2] = vertScrollBar.getValue() > 0;
            visible[3] = vertScrollBar.getValue() < vertScrollBar.getMaximum() - vertScrollBar.getModel().getExtent();
        }
        for (int dir = 0; dir < 4; ++dir) {
            this.updateArrowButton(dir, visible);
        }
    }

    private void updateArrowButton(int dir, boolean[] visible) {
        int w;
        int x;
        int h2;
        int y;
        ArrowButton arrowButton = this.arrowButtons[dir];
        if (!visible[dir]) {
            if (arrowButton != null) {
                arrowButton.setVisible(false);
            }
            return;
        }
        Insets insets = this.getInsets();
        int panelWidth = this.getWidth();
        int panelHeight = this.getHeight();
        int arrowButtonSize = 18;
        int cornerSize = 17;
        if (dir < 2) {
            y = insets.top;
            h2 = panelHeight - y - insets.bottom;
            if (visible[2]) {
                y += 17;
                h2 -= 17;
            }
            if (visible[3]) {
                h2 -= 17;
            }
            x = dir == 0 ? insets.left : panelWidth - 18 - insets.right;
            w = 18;
        } else {
            x = insets.left;
            w = panelWidth - x - insets.right;
            if (visible[0]) {
                x += 17;
                w -= 17;
            }
            if (visible[1]) {
                w -= 17;
            }
            y = dir == 2 ? insets.top : panelHeight - 18 - insets.bottom;
            h2 = 18;
        }
        if (arrowButton == null) {
            switch (dir) {
                case 0: {
                    arrowButton = new LeftArrowButton(this.getHorizontalScrollBar());
                    break;
                }
                case 1: {
                    arrowButton = new RightArrowButton(this.getHorizontalScrollBar());
                    break;
                }
                case 2: {
                    arrowButton = new TopArrowButton(this.getVerticalScrollBar());
                    break;
                }
                default: {
                    arrowButton = new BottomArrowButton(this.getVerticalScrollBar());
                }
            }
            this.arrowButtons[dir] = arrowButton;
        }
        arrowButton.setSize(w, h2);
        FAbsolutePositioner.SINGLETON_INSTANCE.show(arrowButton, this, x, y);
    }

    private class BottomArrowButton
    extends ArrowButton {
        public BottomArrowButton(JScrollBar vertScrollbar) {
            super(vertScrollbar, 1);
        }

        @Override
        protected void drawArrow(Graphics g2) {
            int x2 = this.getWidth() / 2;
            int x1 = x2 - 1;
            int y = (this.getHeight() + 6) / 2;
            for (int i = 0; i < 6; ++i) {
                g2.drawLine(x1, y, x2, y);
                --x1;
                ++x2;
                --y;
            }
        }
    }

    private class TopArrowButton
    extends ArrowButton {
        public TopArrowButton(JScrollBar vertScrollbar) {
            super(vertScrollbar, -1);
        }

        @Override
        protected void drawArrow(Graphics g2) {
            int x2 = this.getWidth() / 2;
            int x1 = x2 - 1;
            int y = (this.getHeight() - 6) / 2;
            for (int i = 0; i < 6; ++i) {
                g2.drawLine(x1, y, x2, y);
                --x1;
                ++x2;
                ++y;
            }
        }
    }

    private class RightArrowButton
    extends ArrowButton {
        public RightArrowButton(JScrollBar horzScrollbar) {
            super(horzScrollbar, 1);
        }

        @Override
        protected void drawArrow(Graphics g2) {
            int x = (this.getWidth() + 6) / 2;
            int y2 = this.getHeight() / 2;
            int y1 = y2 - 1;
            for (int i = 0; i < 6; ++i) {
                g2.drawLine(x, y1, x, y2);
                --x;
                --y1;
                ++y2;
            }
        }
    }

    private class LeftArrowButton
    extends ArrowButton {
        public LeftArrowButton(JScrollBar horzScrollbar) {
            super(horzScrollbar, -1);
        }

        @Override
        protected void drawArrow(Graphics g2) {
            int x = (this.getWidth() - 6) / 2;
            int y2 = this.getHeight() / 2;
            int y1 = y2 - 1;
            for (int i = 0; i < 6; ++i) {
                g2.drawLine(x, y1, x, y2);
                ++x;
                --y1;
                ++y2;
            }
        }
    }

    private abstract class ArrowButton
    extends FLabel {
        protected final int arrowSize = 6;
        private final JScrollBar scrollBar;
        private final int incrementDirection;
        final Timer timer;

        protected ArrowButton(JScrollBar scrollBar0, int incrementDirection0) {
            super(new FLabel.ButtonBuilder());
            this.arrowSize = 6;
            this.timer = new Timer(50, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!ArrowButton.this.isVisible()) {
                        ((Timer)e.getSource()).stop();
                        return;
                    }
                    ArrowButton.this.scrollBar.setValue(ArrowButton.this.scrollBar.getValue() + ArrowButton.this.scrollBar.getUnitIncrement() * ArrowButton.this.incrementDirection);
                }
            });
            this.scrollBar = scrollBar0;
            this.incrementDirection = incrementDirection0;
            this.timer.setInitialDelay(500);
            this.setFocusable(false);
        }

        @Override
        protected void setPressed(boolean pressed0) {
            super.setPressed(pressed0);
            if (pressed0) {
                this.scrollBar.setValue(this.scrollBar.getValue() + this.scrollBar.getUnitIncrement() * this.incrementDirection);
                this.timer.start();
            } else {
                this.timer.stop();
            }
        }

        @Override
        protected void paintContent(Graphics2D g2, int w, int h2, boolean paintPressedState) {
            FSkin.setGraphicsColor(g2, arrowColor);
            this.drawArrow(g2);
        }

        protected abstract void drawArrow(Graphics var1);
    }
}

