/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.gui.interfaces.IProgressBar;
import java.util.Date;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class FProgressBar
extends JProgressBar
implements IProgressBar {
    private long startMillis = 0L;
    private int tempVal = 0;
    private int etaSecs = 0;
    private String desc = "";
    private boolean showETA = true;
    private boolean showCount = true;
    private boolean percentMode = false;
    private final Runnable barIncrementor = () -> {
        this.setValue(this.tempVal);
        this.tempVal = 0;
    };

    public FProgressBar() {
        this.reset();
        this.setStringPainted(true);
    }

    @Override
    public void setDescription(String s0) {
        this.desc = s0;
        this.setString(s0);
    }

    public void setValueThreadSafe(int value) {
        this.tempVal = value;
        SwingUtilities.invokeLater(this.barIncrementor);
    }

    @Override
    public void setValue(int progress) {
        super.setValue(progress);
        StringBuilder sb = new StringBuilder(this.desc);
        if (this.showCount) {
            sb.append(" ");
            int maximum = this.getMaximum();
            if (this.percentMode) {
                sb.append(100 * progress / maximum).append("%");
            } else {
                sb.append(progress).append(" of ").append(maximum);
            }
        }
        if (this.showETA) {
            this.calculateETA(progress);
            sb.append(", ETA").append(String.format("%02d:%02d:%02d", this.etaSecs / 3600, this.etaSecs % 3600 / 60, this.etaSecs % 60 + 1));
        }
        this.setString(sb.toString());
    }

    @Override
    public void reset() {
        this.setIndeterminate(true);
        this.setValue(0);
        this.tempVal = 0;
        this.startMillis = new Date().getTime();
        this.setIndeterminate(false);
        this.setShowETA(true);
        this.setShowCount(true);
    }

    @Override
    public void setShowETA(boolean b0) {
        this.showETA = b0;
    }

    @Override
    public void setShowCount(boolean b0) {
        this.showCount = b0;
    }

    private void calculateETA(int v0) {
        float tempMillis = new Date().getTime();
        float timePerUnit = (tempMillis - (float)this.startMillis) / (float)v0;
        this.etaSecs = (int)((float)(this.getMaximum() - v0) * timePerUnit) / 1000;
    }

    public boolean isPercentMode() {
        return this.percentMode;
    }

    @Override
    public void setPercentMode(boolean value) {
        this.percentMode = value;
    }
}

