/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.gui.UiCommand;
import forge.gui.framework.ILocalRepaint;
import forge.toolbox.FSkin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class FPanel
extends FSkin.FPanelBase
implements ILocalRepaint {
    private static final FSkin.SkinColor selectedColor = FSkin.getColor(FSkin.Colors.CLR_ACTIVE);
    private static final FSkin.SkinColor hoveredColor = FSkin.getColor(FSkin.Colors.CLR_HOVER);
    private static final FSkin.SkinColor unselectedColor = FSkin.getColor(FSkin.Colors.CLR_INACTIVE);
    private boolean selectable = false;
    private boolean hoverable = false;
    private boolean foregroundStretch = false;
    private Image foregroundImage = null;
    private Image backgroundTexture = null;
    private Color backgroundTextureOverlay = null;
    private FSkin.SkinColor borderColor = FSkin.getColor(FSkin.Colors.CLR_BORDERS);
    private boolean borderToggle = true;
    private int cornerDiameter = 20;
    private int foregroundAlign = 0;
    private boolean selected;
    private boolean hovered;
    private UiCommand cmdClick;
    private int pnlW;
    private int pnlH;
    private int imgW;
    private int imgH;
    private int scaledW;
    private int scaledH;
    private int textureW;
    private int textureH;
    private int tempX;
    private int tempY;
    private double iar;
    private final MouseAdapter madEvents = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent evt) {
            FPanel.this.hovered = true;
            FPanel.this.repaintSelf();
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            FPanel.this.hovered = false;
            FPanel.this.repaintSelf();
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (FPanel.this.cmdClick != null) {
                FPanel.this.cmdClick.run();
            }
            if (!FPanel.this.selectable) {
                return;
            }
            if (FPanel.this.selected) {
                FPanel.this.setSelected(false);
            } else {
                FPanel.this.setSelected(true);
            }
        }
    };

    public FPanel() {
        this(new FlowLayout());
    }

    public FPanel(LayoutManager lm0) {
        super(lm0);
        this.setOpaque(false);
        this.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME));
    }

    public void setCornerDiameter(int int0) {
        this.cornerDiameter = int0 <= 0 ? 0 : int0;
    }

    public void setCommand(UiCommand cmd0) {
        this.cmdClick = cmd0;
    }

    public UiCommand getCommand() {
        return this.cmdClick;
    }

    public void setHoverable(boolean bool0) {
        this.hoverable = bool0;
        this.confirmDrawEfficiency();
        if (bool0) {
            this.addMouseListener(this.madEvents);
        } else {
            this.removeMouseListener(this.madEvents);
        }
    }

    public void setSelectable(boolean bool0) {
        this.selectable = bool0;
        this.confirmDrawEfficiency();
    }

    public void setSelected(boolean bool0) {
        this.selected = bool0;
        if (bool0) {
            this.setBackground(selectedColor);
        } else {
            this.setBackground(unselectedColor);
        }
        this.repaintSelf();
    }

    @Override
    protected void onSetForegroundImage(Image img0, boolean stretch) {
        if (img0 == null) {
            this.foregroundImage = null;
            return;
        }
        this.foregroundImage = img0;
        this.imgW = img0.getWidth(null);
        this.imgH = img0.getHeight(null);
        this.iar = (double)this.imgW / (double)this.imgH;
        this.foregroundStretch = stretch;
    }

    public void setForegroundAlign(int i0) {
        ArrayList<Integer> implemented = new ArrayList<Integer>();
        implemented.add(3);
        implemented.add(0);
        if (!implemented.contains(i0)) {
            throw new IllegalArgumentException();
        }
        this.foregroundAlign = i0;
        implemented.clear();
    }

    public void setForegroundStretch(boolean bool0) {
        this.foregroundStretch = bool0;
    }

    @Override
    protected void onSetBackgroundTexture(Image img0) {
        if (img0 == null) {
            return;
        }
        this.backgroundTexture = img0;
        this.textureW = img0.getWidth(null);
        this.textureH = img0.getHeight(null);
    }

    @Override
    public void onSetBackgroundTextureOverlay(Color color) {
        this.backgroundTextureOverlay = color;
    }

    public void setBorderToggle(boolean bool0) {
        this.borderToggle = bool0;
    }

    public void setBorderColor(FSkin.SkinColor clr0) {
        this.borderColor = clr0;
    }

    public void setHovered(boolean b0) {
        this.hovered = b0;
    }

    @Override
    public void repaintSelf() {
        Dimension d = this.getSize();
        this.repaint(0, 0, d.width, d.height);
    }

    @Override
    public void paintComponent(Graphics graphics0) {
        super.paintComponent(graphics0);
        this.pnlW = this.getWidth();
        this.pnlH = this.getHeight();
        Graphics2D g2d = (Graphics2D)graphics0.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.foregroundStretch && this.foregroundImage != null) {
            this.drawForegroundStretched(g2d);
        } else if (this.backgroundTexture == null) {
            this.drawBackgroundColor(g2d);
        } else {
            this.drawBackgroundTexture(g2d);
        }
        if (!this.foregroundStretch && this.foregroundImage != null) {
            this.drawForegroundScaled(g2d);
        }
        if (this.borderToggle) {
            this.drawBorder(g2d);
        }
        g2d.dispose();
    }

    private void drawBackgroundColor(Graphics2D g2d0) {
        if (this.selected) {
            FSkin.setGraphicsColor(g2d0, selectedColor);
        } else if (this.hovered) {
            FSkin.setGraphicsColor(g2d0, hoveredColor);
        } else if (this.selectable) {
            FSkin.setGraphicsColor(g2d0, unselectedColor);
        } else if (this.getSkin().getBackground() != null) {
            FSkin.setGraphicsColor(g2d0, this.getSkin().getBackground());
        } else {
            g2d0.setColor(this.getBackground());
        }
        g2d0.fillRoundRect(0, 0, this.pnlW, this.pnlH, this.cornerDiameter, this.cornerDiameter);
    }

    private void drawBackgroundTexture(Graphics2D g2d0) {
        this.tempX = 0;
        this.tempY = 0;
        while (this.tempX < this.pnlW) {
            while (this.tempY < this.pnlH) {
                g2d0.drawImage(this.backgroundTexture, this.tempX, this.tempY, null);
                this.tempY += this.textureH;
            }
            this.tempX += this.textureW;
            this.tempY = 0;
        }
        this.tempX = 0;
        if (this.backgroundTextureOverlay != null) {
            g2d0.setColor(this.backgroundTextureOverlay);
            g2d0.fillRect(0, 0, this.pnlW, this.pnlH);
        }
    }

    private void drawForegroundScaled(Graphics2D g2d0) {
        if (this.imgW >= this.pnlW) {
            this.scaledW = this.pnlW;
            this.scaledH = (int)((double)this.scaledW / this.iar);
        } else if (this.imgH >= this.pnlH) {
            this.scaledH = this.pnlH;
            this.scaledW = (int)((double)this.scaledH * this.iar);
        } else {
            this.scaledW = this.imgW;
            this.scaledH = this.imgH;
        }
        if (this.scaledH > this.pnlH) {
            this.scaledH = this.pnlH;
            this.scaledW = (int)((double)this.scaledH * this.iar);
        } else if (this.scaledW > this.pnlW) {
            this.scaledW = this.pnlW;
            this.scaledH = (int)((double)this.scaledW / this.iar);
        }
        switch (this.foregroundAlign) {
            case 3: {
                this.tempX = (this.pnlW - this.scaledW) / 2;
                this.tempY = this.pnlH - this.scaledH;
                break;
            }
            default: {
                this.tempX = (this.pnlW - this.scaledW) / 2;
                this.tempY = (this.pnlH - this.scaledH) / 2;
            }
        }
        g2d0.drawImage(this.foregroundImage, this.tempX, this.tempY, this.scaledW + this.tempX, this.scaledH + this.tempY, 0, 0, this.imgW, this.imgH, null);
    }

    private void drawForegroundStretched(Graphics2D g2d0) {
        g2d0.drawImage(this.foregroundImage, 0, 0, this.pnlW, this.pnlH, 0, 0, this.imgW, this.imgH, null);
    }

    private void drawBorder(Graphics2D g2d0) {
        FSkin.setGraphicsColor(g2d0, this.borderColor);
        g2d0.drawRoundRect(0, 0, this.pnlW - 1, this.pnlH - 1, this.cornerDiameter, this.cornerDiameter);
    }

    private void confirmDrawEfficiency() {
        String str = "\nAn FPanel may not be simultaneously %s and have a %s.\nPlease adjust the panel's declaration to use one or the other.";
        if (this.hoverable && this.foregroundStretch) {
            throw new IllegalArgumentException(String.format("\nAn FPanel may not be simultaneously %s and have a %s.\nPlease adjust the panel's declaration to use one or the other.", "hoverable", "stretched foreground image"));
        }
        if (this.hoverable && this.backgroundTexture != null) {
            throw new IllegalArgumentException(String.format("\nAn FPanel may not be simultaneously %s and have a %s.\nPlease adjust the panel's declaration to use one or the other.", "hoverable", "background texture"));
        }
        if (this.selectable && this.foregroundStretch) {
            throw new IllegalArgumentException(String.format("\nAn FPanel may not be simultaneously %s and have a %s.\nPlease adjust the panel's declaration to use one or the other.", "selectable", "stretched foreground image"));
        }
        if (this.selectable && this.backgroundTexture != null) {
            throw new IllegalArgumentException(String.format("\nAn FPanel may not be simultaneously %s and have a %s.\nPlease adjust the panel's declaration to use one or the other.", "selectable", "background texture"));
        }
    }
}

