/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import com.google.common.collect.ImmutableList;
import forge.gui.FThreads;
import forge.localinstance.skin.FSkinProp;
import forge.toolbox.FButton;
import forge.toolbox.FComboBox;
import forge.toolbox.FLabel;
import forge.toolbox.FSkin;
import forge.toolbox.FTextField;
import forge.toolbox.FTextPane;
import forge.util.Localizer;
import forge.view.FDialog;
import forge.view.FView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class FOptionPane
extends FDialog {
    public static final FSkin.SkinImage QUESTION_ICON = FSkin.getIcon(FSkinProp.ICO_QUESTION);
    public static final FSkin.SkinImage INFORMATION_ICON = FSkin.getIcon(FSkinProp.ICO_INFORMATION);
    public static final FSkin.SkinImage WARNING_ICON = FSkin.getIcon(FSkinProp.ICO_WARNING);
    public static final FSkin.SkinImage ERROR_ICON = FSkin.getIcon(FSkinProp.ICO_ERROR);
    private int result = -1;
    private final FButton[] buttons;

    public static void showMessageDialog(String message) {
        FOptionPane.showMessageDialog(message, "Forge", INFORMATION_ICON);
    }

    public static void showMessageDialog(String message, String title) {
        FOptionPane.showMessageDialog(message, title, INFORMATION_ICON);
    }

    public static void showErrorDialog(String message) {
        FOptionPane.showMessageDialog(message, "Forge", ERROR_ICON);
    }

    public static void showErrorDialog(String message, String title) {
        FOptionPane.showMessageDialog(message, title, ERROR_ICON);
    }

    public static void showMessageDialog(String message, String title, FSkin.SkinImage icon) {
        FOptionPane.showOptionDialog(message, title, icon, ImmutableList.of(Localizer.getInstance().getMessage("lblOK", new Object[0])), 0);
    }

    public static boolean showConfirmDialog(String message) {
        return FOptionPane.showConfirmDialog(message, "Forge");
    }

    public static boolean showConfirmDialog(String message, String title) {
        return FOptionPane.showConfirmDialog(message, title, Localizer.getInstance().getMessage("lblYes", new Object[0]), Localizer.getInstance().getMessage("lblNo", new Object[0]), true);
    }

    public static boolean showConfirmDialog(String message, String title, boolean defaultYes) {
        return FOptionPane.showConfirmDialog(message, title, Localizer.getInstance().getMessage("lblYes", new Object[0]), Localizer.getInstance().getMessage("lblNo", new Object[0]), defaultYes);
    }

    public static boolean showConfirmDialog(String message, String title, String yesButtonText, String noButtonText) {
        return FOptionPane.showConfirmDialog(message, title, yesButtonText, noButtonText, true);
    }

    public static boolean showConfirmDialog(String message, String title, String yesButtonText, String noButtonText, boolean defaultYes) {
        ImmutableList<String> options = ImmutableList.of(yesButtonText, noButtonText);
        int reply = FOptionPane.showOptionDialog(message, title, QUESTION_ICON, options, defaultYes ? 0 : 1);
        return reply == 0;
    }

    public static int showOptionDialog(String message, String title, FSkin.SkinImage icon, List<String> options) {
        return FOptionPane.showOptionDialog(message, title, icon, options, 0);
    }

    public static int showOptionDialog(String message, String title, FSkin.SkinImage icon, Component comp, List<String> options) {
        return FOptionPane.showOptionDialog(message, title, icon, comp, options, 0);
    }

    public static int showOptionDialog(String message, String title, FSkin.SkinImage icon, List<String> options, int defaultOption) {
        if (FView.SINGLETON_INSTANCE.getSplash() != null) {
            return 0;
        }
        return FOptionPane.showOptionDialog(message, title, icon, null, options, defaultOption);
    }

    public static int showOptionDialog(String message, String title, FSkin.SkinImage icon, Component comp, List<String> options, int defaultOption) {
        Callable<Integer> showChoice = () -> {
            FOptionPane optionPane = new FOptionPane(message, title, icon, comp, options, defaultOption);
            optionPane.setVisible(true);
            int dialogResult = optionPane.result;
            optionPane.dispose();
            return dialogResult;
        };
        FutureTask<Integer> future = new FutureTask<Integer>(showChoice);
        FThreads.invokeInEdtAndWait(future);
        try {
            return future.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String showInputDialog(String message, String title) {
        return (String)FOptionPane.showInputDialog(message, title, null, "", null);
    }

    public static String showInputDialog(String message, String title, FSkin.SkinImage icon) {
        return (String)FOptionPane.showInputDialog(message, title, icon, "", null);
    }

    public static String showInputDialog(String message, String title, FSkin.SkinImage icon, String initialInput) {
        return (String)FOptionPane.showInputDialog(message, title, icon, initialInput, null);
    }

    public static <T> T showInputDialog(String message, String title, FSkin.SkinImage icon, String initialInput, List<T> inputOptions) {
        Callable<Object> showChoice = () -> {
            JComponent inputField;
            FTextField txtInput = null;
            FComboBox cbInput = null;
            if (inputOptions == null) {
                txtInput = new FTextField.Builder().text(initialInput).build();
                inputField = txtInput;
            } else {
                cbInput = new FComboBox(inputOptions);
                cbInput.setSelectedItem(initialInput);
                inputField = cbInput;
            }
            final FOptionPane optionPane = new FOptionPane(message, title, icon, inputField, ImmutableList.of(Localizer.getInstance().getMessage("lblOK", new Object[0]), Localizer.getInstance().getMessage("lblCancel", new Object[0])), -1);
            optionPane.setDefaultFocus(inputField);
            inputField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        optionPane.setResult(0);
                    }
                }
            });
            optionPane.setVisible(true);
            int dialogResult = optionPane.result;
            optionPane.dispose();
            if (dialogResult == 0) {
                if (inputOptions == null) {
                    return txtInput.getText();
                }
                return cbInput.getSelectedItem();
            }
            return null;
        };
        FutureTask<Object> future = new FutureTask<Object>(showChoice);
        FThreads.invokeInEdtAndWait(future);
        try {
            return (T)future.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public FOptionPane(String message, String title, FSkin.SkinImage icon, Component comp, List<String> options, int defaultOption) {
        FThreads.assertExecutedByEdt(true);
        this.setTitle(title);
        int padding = 10;
        int x = 10;
        int gapAboveButtons = 15;
        int gapBottom = comp == null ? 15 : 10;
        FLabel centeredLabel = null;
        FTextPane prompt = null;
        if (icon != null) {
            FLabel lblIcon;
            if (icon.getWidth() < 100) {
                lblIcon = new FLabel.Builder().icon(icon).build();
                this.add((Component)lblIcon, "x " + (x - 3) + ", ay top, w " + icon.getWidth() + ", h " + icon.getHeight() + ", gapbottom " + gapBottom);
                x += icon.getWidth();
            } else {
                lblIcon = new FLabel.Builder().icon(icon).iconInBackground(true).iconScaleFactor(1.0).iconAlignX(0).build();
                lblIcon.setMinimumSize(new Dimension(icon.getWidth() * 2, icon.getHeight()));
                this.add((Component)lblIcon, "x " + x + ", ay top, wrap, gapbottom " + gapBottom);
                centeredLabel = lblIcon;
            }
        }
        if (message != null) {
            prompt = new FTextPane();
            prompt.setContentType("text/html");
            prompt.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            prompt.setText(FSkin.encodeSymbols(message, false));
            prompt.setFont(FSkin.getFont(14));
            if (centeredLabel != null) {
                prompt.setTextAlignment(1);
            }
            Dimension parentSize = JOptionPane.getRootFrame().getSize();
            prompt.setMaximumSize(new Dimension(parentSize.width / 2, parentSize.height - 100));
            this.add((Component)prompt, "x " + x + ", ay top, wrap, gaptop " + (icon == null ? 0 : 7) + ", gapbottom " + gapBottom);
            x = 10;
        }
        if (comp != null) {
            this.add(comp, "x " + x + ", w 100%-" + (x + 10) + ", wrap, gapbottom " + 15);
        }
        int optionCount = options.size();
        FButton btnMeasure = new FButton();
        FontMetrics metrics = JOptionPane.getRootFrame().getGraphics().getFontMetrics(btnMeasure.getFont());
        int maxTextWidth = 0;
        this.buttons = new FButton[optionCount];
        for (int i = 0; i < optionCount; ++i) {
            String option = options.get(i);
            int textWidth = metrics.stringWidth(option);
            if (textWidth > maxTextWidth) {
                maxTextWidth = textWidth;
            }
            this.buttons[i] = new FButton(option);
        }
        this.pack();
        int width = this.getWidth();
        int gapBetween = 3;
        int buttonHeight = 26;
        int buttonWidth = Math.max(maxTextWidth + btnMeasure.getMargin().left + btnMeasure.getMargin().right, 120);
        int dx = buttonWidth + 3;
        int totalButtonWidth = dx * optionCount - 3;
        final int lastOption = optionCount - 1;
        x = (width - totalButtonWidth) / 2;
        if (x < 10) {
            width = totalButtonWidth + 20;
            x = 10;
        }
        for (int i = 0; i < optionCount; ++i) {
            final int option = i;
            FButton btn = this.buttons[i];
            btn.addActionListener(arg0 -> {
                this.result = option;
                this.setVisible(false);
            });
            btn.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 37: {
                            if (option <= 0) break;
                            FOptionPane.this.buttons[option - 1].requestFocusInWindow();
                            break;
                        }
                        case 39: {
                            if (option >= lastOption) break;
                            FOptionPane.this.buttons[option + 1].requestFocusInWindow();
                            break;
                        }
                        case 36: {
                            if (option <= 0) break;
                            FOptionPane.this.buttons[0].requestFocusInWindow();
                            break;
                        }
                        case 35: {
                            if (option >= lastOption) break;
                            FOptionPane.this.buttons[lastOption].requestFocusInWindow();
                        }
                    }
                }
            });
            if (option == defaultOption) {
                this.setDefaultFocus(btn);
            }
            this.add((Component)btn, "x " + x + ", w " + buttonWidth + ", h " + 26);
            x += dx;
        }
        if (centeredLabel != null) {
            centeredLabel.setPreferredSize(new Dimension(width - 20, centeredLabel.getMinimumSize().height));
            if (prompt != null) {
                prompt.setPreferredSize(new Dimension(width - 20, prompt.getPreferredSize().height));
            }
        }
        this.setSize(width, this.getHeight() + 26);
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.isVisible() == visible) {
            return;
        }
        if (visible) {
            this.result = -1;
        }
        super.setVisible(visible);
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result0) {
        this.result = result0;
        SwingUtilities.invokeLater(() -> this.setVisible(false));
    }

    public boolean isButtonEnabled(int index) {
        return this.buttons[index].isEnabled();
    }

    public void setButtonEnabled(int index, boolean enabled) {
        this.buttons[index].setEnabled(enabled);
    }
}

