/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public abstract class FMouseAdapter
extends MouseAdapter {
    private static FMouseAdapter mouseDownAdapter;
    private static MouseEvent mouseDownEvent;
    private final boolean isCompDraggable;
    private boolean hovered;
    private Point mouseDownLoc;
    private Point firstClickLoc;
    private int downButton;
    private int buttonsDown;
    private int firstClickButton;
    private Component tempMotionListenerComp;

    public void onLeftMouseDown(MouseEvent e) {
    }

    public void onLeftMouseUp(MouseEvent e) {
    }

    public void onLeftClick(MouseEvent e) {
    }

    public void onLeftDoubleClick(MouseEvent e) {
    }

    public void onLeftMouseDragging(MouseEvent e) {
    }

    public void onLeftMouseDragDrop(MouseEvent e) {
    }

    public void onMiddleMouseDown(MouseEvent e) {
    }

    public void onMiddleMouseUp(MouseEvent e) {
    }

    public void onMiddleClick(MouseEvent e) {
    }

    public void onMiddleDoubleClick(MouseEvent e) {
    }

    public void onMiddleMouseDragging(MouseEvent e) {
    }

    public void onMiddleMouseDragDrop(MouseEvent e) {
    }

    public void onRightMouseDown(MouseEvent e) {
    }

    public void onRightMouseUp(MouseEvent e) {
    }

    public void onRightClick(MouseEvent e) {
    }

    public void onRightDoubleClick(MouseEvent e) {
    }

    public void onRightMouseDragging(MouseEvent e) {
    }

    public void onRightMouseDragDrop(MouseEvent e) {
    }

    public void onMouseEnter(MouseEvent e) {
    }

    public void onMouseExit(MouseEvent e) {
    }

    public FMouseAdapter() {
        this(false);
    }

    public FMouseAdapter(boolean isCompDraggable0) {
        this.isCompDraggable = isCompDraggable0;
    }

    public static void forceMouseUp() {
        FMouseAdapter.setMouseDownAdapter(null);
    }

    private static void setMouseDownAdapter(FMouseAdapter mouseDownAdapter0) {
        if (mouseDownAdapter == mouseDownAdapter0) {
            return;
        }
        if (mouseDownAdapter != null) {
            switch (FMouseAdapter.mouseDownAdapter.downButton) {
                case 1: {
                    mouseDownAdapter.onLeftMouseUp(mouseDownEvent);
                    break;
                }
                case 2: {
                    mouseDownAdapter.onMiddleMouseUp(mouseDownEvent);
                    break;
                }
                case 3: {
                    mouseDownAdapter.onRightMouseUp(mouseDownEvent);
                }
            }
            mouseDownAdapter.resetMouseDownLoc();
            FMouseAdapter.mouseDownAdapter.firstClickLoc = null;
            FMouseAdapter.mouseDownAdapter.downButton = 0;
            FMouseAdapter.mouseDownAdapter.buttonsDown = 0;
            FMouseAdapter.mouseDownAdapter.firstClickButton = 0;
            FMouseAdapter.mouseDownAdapter.hovered = false;
            mouseDownEvent = null;
        }
        mouseDownAdapter = mouseDownAdapter0;
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        FMouseAdapter.setMouseDownAdapter(this);
        mouseDownEvent = e;
        int button = e.getButton();
        if (button < 1 || button > 3) {
            return;
        }
        if (this.downButton == 0) {
            this.downButton = button;
            switch (button) {
                case 1: {
                    this.onLeftMouseDown(e);
                    break;
                }
                case 2: {
                    this.onMiddleMouseDown(e);
                    break;
                }
                case 3: {
                    this.onRightMouseDown(e);
                }
            }
        }
        this.buttonsDown += button;
        if (this.buttonsDown == 4 && this.downButton != 2) {
            this.downButton = 2;
            this.onMiddleMouseDown(e);
        }
        this.mouseDownLoc = e.getLocationOnScreen();
        if (this.isCompDraggable) {
            this.tempMotionListenerComp = e.getComponent();
            if (this.tempMotionListenerComp != null) {
                for (MouseMotionListener motionListener : this.tempMotionListenerComp.getMouseMotionListeners()) {
                    if (motionListener != this) continue;
                    this.tempMotionListenerComp = null;
                    break;
                }
                if (this.tempMotionListenerComp != null) {
                    this.tempMotionListenerComp.addMouseMotionListener(this);
                }
            }
        }
        if (this.firstClickLoc != null) {
            if (e.getClickCount() % 2 == 0 && this.downButton == this.firstClickButton && e.getLocationOnScreen().distance(this.firstClickLoc) <= 3.0) {
                switch (this.firstClickButton) {
                    case 1: {
                        this.onLeftDoubleClick(e);
                        break;
                    }
                    case 2: {
                        this.onMiddleDoubleClick(e);
                        break;
                    }
                    case 3: {
                        this.onRightDoubleClick(e);
                    }
                }
            }
            this.firstClickLoc = null;
            this.firstClickButton = 0;
        }
    }

    @Override
    public final void mouseDragged(MouseEvent e) {
        if (this.mouseDownLoc != null && this.isCompDraggable && e.getLocationOnScreen().distance(this.mouseDownLoc) > 3.0) {
            this.resetMouseDownLoc();
        }
        if (this.tempMotionListenerComp == null) {
            switch (this.downButton) {
                case 1: {
                    this.onLeftMouseDragging(e);
                    break;
                }
                case 2: {
                    this.onMiddleMouseDragging(e);
                    break;
                }
                case 3: {
                    this.onRightMouseDragging(e);
                }
            }
        }
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
        this.hovered = true;
        this.onMouseEnter(e);
    }

    @Override
    public final void mouseExited(MouseEvent e) {
        this.hovered = false;
        this.onMouseExit(e);
    }

    private void resetMouseDownLoc() {
        this.mouseDownLoc = null;
        if (this.tempMotionListenerComp != null) {
            this.tempMotionListenerComp.removeMouseMotionListener(this);
            this.tempMotionListenerComp = null;
        }
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
        int button = e.getButton();
        if (button < 1 || button > 3 || this.downButton == 0 || mouseDownAdapter != this) {
            return;
        }
        this.buttonsDown -= button;
        if (this.buttonsDown > 0) {
            return;
        }
        button = this.downButton;
        this.downButton = 0;
        mouseDownAdapter = null;
        mouseDownEvent = null;
        switch (button) {
            case 1: {
                this.onLeftMouseUp(e);
                break;
            }
            case 2: {
                this.onMiddleMouseUp(e);
                break;
            }
            case 3: {
                this.onRightMouseUp(e);
            }
        }
        if (!this.hovered) {
            this.resetMouseDownLoc();
        }
        if (this.mouseDownLoc != null) {
            if (e.getClickCount() % 2 == 1) {
                this.firstClickButton = button;
                this.firstClickLoc = this.mouseDownLoc;
            }
            this.resetMouseDownLoc();
            switch (button) {
                case 1: {
                    this.onLeftClick(e);
                    break;
                }
                case 2: {
                    this.onMiddleClick(e);
                    break;
                }
                case 3: {
                    this.onRightClick(e);
                }
            }
        } else if (this.isCompDraggable) {
            switch (button) {
                case 1: {
                    this.onLeftMouseDragDrop(e);
                    break;
                }
                case 2: {
                    this.onMiddleMouseDragDrop(e);
                    break;
                }
                case 3: {
                    this.onRightMouseDragDrop(e);
                }
            }
        }
    }

    @Override
    public final void mouseClicked(MouseEvent e) {
    }
}

