/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.Singletons;
import forge.toolbox.FSkin;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;

public class FList<E>
extends FSkin.SkinnedList<E> {
    private static final EmptyBorder itemBorder = new EmptyBorder(4, 3, 4, 3);

    public FList() {
        this.initialize();
    }

    public FList(ListModel<E> model0) {
        super(model0);
        this.initialize();
    }

    private void initialize() {
        this.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        this.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        this.setSelectionForeground(this.getSkin().getForeground());
        this.setFont(FSkin.getFont(12));
        this.setCellRenderer(new ComplexCellRenderer());
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                FList.this.updateSelectionBackground();
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                FList.this.updateSelectionBackground();
            }
        });
        this.updateSelectionBackground();
    }

    private void updateSelectionBackground() {
        this.setSelectionBackground(FSkin.getColor(this.hasFocus() ? FSkin.Colors.CLR_ACTIVE : FSkin.Colors.CLR_INACTIVE));
    }

    public int getAutoSizeWidth() {
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int width = 0;
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            int itemWidth = metrics.stringWidth(this.getModel().getElementAt(i).toString());
            if (itemWidth <= width) continue;
            width = itemWidth;
        }
        int minWidth = 150;
        if ((width += FList.itemBorder.getBorderInsets().left + FList.itemBorder.getBorderInsets().right) < 150) {
            width = 150;
        } else {
            int maxWidth = Singletons.getView().getFrame().getWidth() - 50;
            if (width > maxWidth) {
                width = maxWidth;
            }
        }
        return width;
    }

    public int getCount() {
        return this.getModel().getSize();
    }

    private class ComplexCellRenderer<E1>
    implements ListCellRenderer<E1> {
        private final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        private ComplexCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends E1> lst0, E1 val0, int i0, boolean isSelected, boolean cellHasFocus) {
            JLabel lblItem = (JLabel)this.defaultRenderer.getListCellRendererComponent(lst0, val0, i0, isSelected, cellHasFocus);
            lblItem.setBorder(itemBorder);
            return lblItem;
        }
    }
}

