/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.gui.UiCommand;
import forge.gui.framework.ILocalRepaint;
import forge.gui.interfaces.IButton;
import forge.localinstance.skin.FSkinProp;
import forge.toolbox.FMouseAdapter;
import forge.toolbox.FSkin;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class FLabel
extends FSkin.SkinnedLabel
implements ILocalRepaint,
IButton {
    private static final FSkin.SkinColor clrHover = FSkin.getColor(FSkin.Colors.CLR_HOVER);
    private static final FSkin.SkinColor clrText = FSkin.getColor(FSkin.Colors.CLR_TEXT);
    private static final FSkin.SkinColor clrMain = FSkin.getColor(FSkin.Colors.CLR_INACTIVE);
    private static final FSkin.SkinColor d50 = clrMain.stepColor(-50);
    private static final FSkin.SkinColor d30 = clrMain.stepColor(-30);
    private static final FSkin.SkinColor d10 = clrMain.stepColor(-10);
    private static final FSkin.SkinColor l10 = clrMain.stepColor(10);
    private static final FSkin.SkinColor l20 = clrMain.stepColor(20);
    private static final FSkin.SkinColor l30 = clrMain.stepColor(30);
    private final double iconScaleFactor;
    private int fontStyle;
    private final int iconAlignX;
    private int iw;
    private int ih;
    private final boolean selectable;
    private boolean selected;
    private boolean hoverable;
    private boolean hovered;
    private boolean pressed;
    private boolean opaque;
    private final boolean iconInBackground;
    private final boolean iconScaleAuto;
    private boolean reactOnMouseDown;
    private final Point iconInsets;
    private Image img;
    private Runnable cmdClick;
    private Runnable cmdRightClick;
    private double iar;
    private AlphaComposite alphaDim;
    private AlphaComposite alphaStrong;
    private final ActionListener fireResize = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            FLabel.this.resetIcon();
            FLabel.this.resizeTimer.stop();
        }
    };
    private final Timer resizeTimer = new Timer(10, this.fireResize);
    private final ComponentAdapter cadResize = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            FLabel.this.resizeTimer.restart();
        }
    };
    private final AncestorListener showFirstTime = new AncestorListener(){

        @Override
        public void ancestorAdded(AncestorEvent e) {
            FLabel.this.resetIcon();
        }

        @Override
        public void ancestorMoved(AncestorEvent arg0) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent arg0) {
        }
    };
    private final FMouseAdapter madEvents = new FMouseAdapter(){

        @Override
        public void onMouseEnter(MouseEvent e) {
            FLabel.this.setHovered(true);
        }

        @Override
        public void onMouseExit(MouseEvent e) {
            FLabel.this.setHovered(false);
        }

        @Override
        public void onLeftMouseDown(MouseEvent e) {
            if (FLabel.this.reactOnMouseDown) {
                FLabel.this._doMouseAction();
            }
            FLabel.this.setPressed(true);
        }

        @Override
        public void onLeftMouseUp(MouseEvent e) {
            FLabel.this.setPressed(false);
        }

        @Override
        public void onLeftClick(MouseEvent e) {
            if (!FLabel.this.reactOnMouseDown) {
                FLabel.this._doMouseAction();
            }
        }

        @Override
        public void onRightClick(MouseEvent e) {
            FLabel.this._doRightClickAction();
        }
    };

    protected FLabel(Builder b0) {
        super(b0.bldText);
        this.iconScaleFactor = b0.bldIconScaleFactor;
        this.opaque = b0.bldOpaque;
        this.iconInBackground = b0.bldIconInBackground;
        this.iconScaleAuto = b0.bldIconScaleAuto;
        this.selectable = b0.bldSelectable;
        this.selected = b0.bldSelected;
        this.iconAlignX = b0.bldIconAlignX;
        this.iconInsets = b0.bldIconInsets;
        this.setEnabled(b0.bldEnabled);
        this.setFontStyle(b0.bldFontStyle);
        this.setFontSize(b0.bldFontSize);
        this.setUnhoveredAlpha(b0.bldUnhoveredAlpha);
        this.setCommand(b0.bldCmd);
        this.setReactOnMouseDown(b0.bldReactOnMouseDown);
        this.setFontAlign(b0.bldFontAlign);
        this.setToolTipText(b0.bldToolTip);
        this.setHoverable(b0.bldHoverable);
        this.setIcon(b0.bldIcon);
        if (b0.bldSelectable || b0.bldHoverable) {
            this.setFocusable(true);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyChar() == ' ' || e.getKeyCode() == 10 || e.getKeyCode() == 10) {
                        FLabel.this._doMouseAction();
                    }
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent arg0) {
                    FLabel.this.repaintSelf();
                }

                @Override
                public void focusGained(FocusEvent arg0) {
                    FLabel.this.repaintSelf();
                }
            });
        }
        if (b0.bldUseSkinColors) {
            this.setForeground(clrText);
            this.setBackground(clrMain);
        }
        this.removeComponentListener(this.cadResize);
        this.addComponentListener(this.cadResize);
        this.addAncestorListener(this.showFirstTime);
    }

    private void _doMouseAction() {
        if (this.selectable) {
            this.setSelected(!this.selected);
        }
        if (this.cmdClick != null && this.isEnabled()) {
            this.cmdClick.run();
        }
    }

    private void _doRightClickAction() {
        if (this.cmdRightClick != null && this.isEnabled()) {
            this.cmdRightClick.run();
        }
    }

    @Override
    public void setEnabled(boolean b0) {
        if (this.isEnabled() == b0) {
            return;
        }
        super.setEnabled(b0);
        if (!this.hoverable) {
            return;
        }
        if (!b0) {
            this.removeMouseListener(this.madEvents);
        } else {
            this.addMouseListener(this.madEvents);
        }
    }

    public void setHoverable(boolean b0) {
        if (this.hoverable == b0) {
            return;
        }
        this.hoverable = b0;
        if (!this.isEnabled()) {
            return;
        }
        if (!b0) {
            this.removeMouseListener(this.madEvents);
        } else {
            this.addMouseListener(this.madEvents);
        }
    }

    protected void setHovered(boolean hovered0) {
        this.hovered = hovered0;
        this.repaintSelf();
    }

    protected void setPressed(boolean pressed0) {
        this.pressed = pressed0;
        this.repaintSelf();
    }

    @Override
    public void setSelected(boolean b0) {
        this.selected = b0;
        this.repaintSelf();
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    private void setUnhoveredAlpha(float f0) {
        this.alphaDim = AlphaComposite.getInstance(3, f0);
        this.alphaStrong = AlphaComposite.getInstance(3, 1.0f);
    }

    public void setFontSize(int i0) {
        switch (this.fontStyle) {
            case 1: {
                this.setFont(FSkin.getBoldFont(i0));
                break;
            }
            case 2: {
                this.setFont(FSkin.getItalicFont(i0));
                break;
            }
            default: {
                this.setFont(FSkin.getFont(i0));
            }
        }
    }

    public void setFontStyle(int i0) {
        if (i0 != 0 && i0 != 1 && i0 != 2) {
            throw new IllegalArgumentException("FLabel$setFontStyle must be passed either Font.PLAIN, Font.BOLD, or Font.ITALIC.");
        }
        this.fontStyle = i0;
    }

    public void setFontAlign(int i0) {
        if (i0 != 0 && i0 != 2 && i0 != 4) {
            throw new IllegalArgumentException("FLabel$setFontStyle must be passed either SwingConstants.CENTER, SwingConstants.LEFT, or SwingConstants.RIGHT");
        }
        this.setHorizontalAlignment(i0);
    }

    public int getAutoSizeWidth() {
        int width = 0;
        if (this.getText() != null && !this.getText().isEmpty()) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            width = metrics.stringWidth(this.getText());
        }
        if (this.getIcon() != null) {
            width += this.getIcon().getIconWidth() + this.getIconTextGap();
        }
        if (this.opaque || this.selectable) {
            width += 6;
        }
        return width;
    }

    public Timer getResizeTimer() {
        return this.resizeTimer;
    }

    public Runnable getCommand() {
        return this.cmdClick;
    }

    public Runnable getRightClickCommand() {
        return this.cmdRightClick;
    }

    protected int getMaxTextWidth() {
        int w = this.getWidth();
        int h2 = this.getHeight();
        int sh = (int)((double)h2 * this.iconScaleFactor);
        int sw = (int)((double)sh * this.iar);
        return w - sw;
    }

    @Override
    public void setIcon(Icon i0) {
        if (this.iconInBackground || this.iconScaleAuto) {
            if (i0 != null) {
                this.img = ((ImageIcon)i0).getImage();
                this.iw = this.img.getWidth(null);
                this.ih = this.img.getHeight(null);
                this.iar = (double)this.iw / (double)this.ih;
            } else {
                this.img = null;
                this.iw = 0;
                this.ih = 0;
                this.iar = 0.0;
            }
        } else {
            super.setIcon(i0);
        }
    }

    public void setCommand(Runnable c0) {
        this.cmdClick = c0;
    }

    public void setRightClickCommand(Runnable c0) {
        this.cmdRightClick = c0;
    }

    public void setReactOnMouseDown(boolean b0) {
        this.reactOnMouseDown = b0;
    }

    @Override
    public void setOpaque(boolean b0) {
        this.opaque = b0;
        super.setOpaque(false);
    }

    @Override
    public void repaintSelf() {
        Dimension d = this.getSize();
        this.repaint(0, 0, d.width, d.height);
    }

    @Override
    public void paintComponent(Graphics g2) {
        boolean paintPressedState;
        Graphics2D g2d = (Graphics2D)g2;
        int w = this.getWidth();
        int h2 = this.getHeight();
        boolean paintWithHover = this.hoverable && this.hovered && this.isEnabled();
        Composite oldComp = g2d.getComposite();
        if (this.hoverable) {
            g2d.setComposite(paintWithHover ? this.alphaStrong : this.alphaDim);
        }
        boolean bl = paintPressedState = this.pressed && this.hovered && this.isEnabled() && (this.opaque || this.selectable);
        if (paintPressedState) {
            FLabel.paintPressed(g2d, w, h2);
        } else if (this.opaque) {
            if (this.selected) {
                FLabel.paintDown(g2d, w, h2);
            } else {
                FLabel.paintUp(g2d, w, h2);
            }
        } else if (this.selectable) {
            if (this.selected) {
                FLabel.paintDown(g2d, w, h2);
            } else {
                FLabel.paintBorder(g2d, w, h2);
            }
        }
        this.paintContent(g2d, w, h2, paintPressedState);
        if (this.hoverable) {
            g2d.setComposite(oldComp);
        }
        if (this.hasFocus() && this.isEnabled()) {
            FLabel.paintFocus(g2d, w, h2);
        }
    }

    protected void paintContent(Graphics2D g2, int w, int h2, boolean paintPressedState) {
        if (paintPressedState) {
            g2.translate(1, 1);
        }
        if (this.iconInBackground) {
            int sh = (int)((double)h2 * this.iconScaleFactor);
            int sw = (int)((double)sh * this.iar);
            int x = this.iconAlignX == 0 ? (int)((double)((w - sw) / 2) + this.iconInsets.getX()) : (int)this.iconInsets.getX();
            int y = (int)((double)((h2 - sh) / 2) + this.iconInsets.getY());
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.drawImage(this.img, x, y, sw + x, sh + y, 0, 0, this.iw, this.ih, null);
        }
        super.paintComponent(g2);
        if (paintPressedState) {
            g2.translate(-1, -1);
        }
    }

    private static void paintFocus(Graphics2D g2, int w, int h2) {
        FSkin.setGraphicsColor(g2, clrHover);
        g2.drawRect(0, 0, w - 2, h2 - 2);
        FSkin.setGraphicsColor(g2, l30);
        g2.drawRect(1, 1, w - 4, h2 - 4);
    }

    private static void paintPressed(Graphics2D g2, int w, int h2) {
        FSkin.setGraphicsGradientPaint(g2, 0.0f, (float)h2, d50, 0.0f, 0.0f, d10);
        g2.fillRect(0, 0, w - 1, h2 - 1);
        FSkin.setGraphicsColor(g2, d50);
        g2.drawRect(0, 0, w - 2, h2 - 2);
        FSkin.setGraphicsColor(g2, d10);
        g2.drawRect(1, 1, w - 4, h2 - 4);
    }

    private static void paintUp(Graphics2D g2, int w, int h2) {
        FSkin.setGraphicsGradientPaint(g2, 0.0f, (float)h2, d10, 0.0f, 0.0f, l20);
        g2.fillRect(0, 0, w, h2);
        FSkin.setGraphicsColor(g2, d50);
        g2.drawRect(0, 0, w - 2, h2 - 2);
        FSkin.setGraphicsColor(g2, l10);
        g2.drawRect(1, 1, w - 4, h2 - 4);
    }

    private static void paintBorder(Graphics2D g2, int w, int h2) {
        FSkin.setGraphicsColor(g2, l10);
        g2.drawRect(0, 0, w - 2, h2 - 2);
        FSkin.setGraphicsColor(g2, l30);
        g2.drawRect(1, 1, w - 4, h2 - 4);
    }

    private static void paintDown(Graphics2D g2, int w, int h2) {
        FSkin.setGraphicsGradientPaint(g2, 0.0f, (float)h2, d30, 0.0f, 0.0f, l10);
        g2.fillRect(0, 0, w - 1, h2 - 1);
        FSkin.setGraphicsColor(g2, d30);
        g2.drawRect(0, 0, w - 2, h2 - 2);
        FSkin.setGraphicsColor(g2, l10);
        g2.drawRect(1, 1, w - 4, h2 - 4);
    }

    protected void resetIcon() {
        if (this.img != null && this.iconScaleAuto && !this.iconInBackground) {
            int h2 = (int)((double)this.getHeight() * this.iconScaleFactor);
            int w = (int)((double)h2 * this.iar);
            if (w == 0 || h2 == 0) {
                return;
            }
            super.setIcon(new ImageIcon(this.img.getScaledInstance(w, h2, 4)));
        }
    }

    @Override
    public void setCommand(UiCommand command0) {
        this.cmdClick = command0;
    }

    @Override
    public void setImage(FSkinProp color) {
        this.setForeground(FSkin.getColor(FSkin.Colors.fromSkinProp(color)));
    }

    @Override
    public void setTextColor(int r, int g2, int b) {
        this.setForeground(new Color(r, g2, b));
    }

    public static class ButtonBuilder
    extends Builder {
        public ButtonBuilder() {
            this.bldHoverable = true;
            this.bldOpaque = true;
        }
    }

    public static class Builder {
        private double bldIconScaleFactor = 0.8;
        private int bldFontStyle = 0;
        private int bldFontSize = 14;
        private float bldUnhoveredAlpha = 0.7f;
        private int bldIconAlignX = 2;
        private final Point bldIconInsets = new Point(0, 0);
        private boolean bldSelectable = false;
        private boolean bldSelected = false;
        protected boolean bldHoverable = false;
        protected boolean bldOpaque = false;
        private boolean bldIconInBackground = false;
        private boolean bldIconScaleAuto = true;
        protected boolean bldReactOnMouseDown = false;
        private boolean bldUseSkinColors = true;
        private boolean bldEnabled = true;
        protected String bldText;
        protected String bldToolTip;
        private FSkin.SkinImage bldIcon;
        private int bldFontAlign;
        protected UiCommand bldCmd;

        public FLabel build() {
            return new FLabel(this);
        }

        public Builder text(String s0) {
            this.bldText = s0;
            return this;
        }

        public Builder tooltip(String s0) {
            this.bldToolTip = s0;
            return this;
        }

        public Builder icon(FSkin.SkinImage i0) {
            this.bldIcon = i0;
            return this;
        }

        public Builder fontAlign(int i0) {
            this.bldFontAlign = i0;
            return this;
        }

        public Builder opaque(boolean b0) {
            this.bldOpaque = b0;
            return this;
        }

        public Builder opaque() {
            this.opaque(true);
            return this;
        }

        public Builder hoverable(boolean b0) {
            this.bldHoverable = b0;
            return this;
        }

        public Builder hoverable() {
            this.hoverable(true);
            return this;
        }

        public Builder selectable(boolean b0) {
            this.bldSelectable = b0;
            return this;
        }

        public Builder selectable() {
            this.selectable(true);
            return this;
        }

        public Builder selected(boolean b0) {
            this.bldSelected = b0;
            return this;
        }

        public Builder selected() {
            this.selected(true);
            return this;
        }

        public Builder reactOnMouseDown(boolean b0) {
            this.bldReactOnMouseDown = b0;
            return this;
        }

        public Builder reactOnMouseDown() {
            this.reactOnMouseDown(true);
            return this;
        }

        public Builder useSkinColors(boolean b0) {
            this.bldUseSkinColors = b0;
            return this;
        }

        public Builder cmdClick(UiCommand c0) {
            this.bldCmd = c0;
            return this;
        }

        public Builder fontSize(int i0) {
            this.bldFontSize = i0;
            return this;
        }

        public Builder fontStyle(int i0) {
            this.bldFontStyle = i0;
            return this;
        }

        public Builder enabled(boolean b0) {
            this.bldEnabled = b0;
            return this;
        }

        public Builder iconScaleAuto(boolean b0) {
            this.bldIconScaleAuto = b0;
            return this;
        }

        public Builder iconScaleFactor(double d0) {
            this.bldIconScaleFactor = d0;
            return this;
        }

        public Builder iconInBackground(boolean b0) {
            this.bldIconInBackground = b0;
            return this;
        }

        public Builder iconInBackground() {
            this.iconInBackground(true);
            return this;
        }

        public Builder unhoveredAlpha(float f0) {
            this.bldUnhoveredAlpha = f0;
            return this;
        }

        public Builder iconAlignX(int i0) {
            this.bldIconAlignX = i0;
            return this;
        }
    }
}

