/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.toolbox.FLabel;
import forge.toolbox.FOptionPane;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.SwingWorker;

public class FHyperlink
extends FLabel {
    private FHyperlink(Builder b) {
        super(b);
        this.setCursor(new Cursor(12));
    }

    private static class _LinkRunner
    extends SwingWorker<Void, Void> {
        private final URI uri;

        private _LinkRunner(URI u) {
            if (u == null) {
                throw new NullPointerException();
            }
            this.uri = u;
        }

        @Override
        protected Void doInBackground() throws Exception {
            Desktop.getDesktop().browse(this.uri);
            return null;
        }
    }

    public static class Builder
    extends FLabel.Builder {
        private String bldUrl;

        public Builder() {
            this.bldHoverable = true;
            this.bldReactOnMouseDown = true;
            this.bldCmd = null;
        }

        @Override
        public FHyperlink build() {
            URI uri;
            StringBuilder sb = new StringBuilder();
            sb.append("<html><a href='").append(this.bldUrl).append("'>");
            sb.append(null == this.bldText || this.bldText.isEmpty() ? this.bldUrl : this.bldText);
            sb.append("</a></html>");
            boolean browsingSupported = Builder._isBrowsingSupported();
            if (browsingSupported) {
                this.tooltip(this.bldUrl);
            } else {
                this.tooltip(this.bldUrl + " (click to copy to clipboard)");
            }
            try {
                uri = new URI(this.bldUrl);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            this.cmdClick(() -> {
                if (browsingSupported) {
                    new _LinkRunner(uri).execute();
                } else {
                    StringSelection ss = new StringSelection(this.bldUrl);
                    try {
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
                    }
                    catch (IllegalStateException ex) {
                        FOptionPane.showErrorDialog("Sorry, a problem occurred while copying this link to your system clipboard.", "A problem occurred");
                    }
                }
            });
            return new FHyperlink(this);
        }

        public Builder url(String url) {
            this.bldUrl = url;
            return this;
        }

        private static boolean _isBrowsingSupported() {
            if (!Desktop.isDesktopSupported()) {
                return false;
            }
            return Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
        }
    }
}

