/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import com.google.common.collect.ObjectArrays;
import forge.gui.interfaces.IComboBox;
import forge.toolbox.FComboBox;
import forge.toolbox.FSkin;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;

public class FComboBoxWrapper<E>
implements IComboBox<E> {
    private static final List<FComboBoxWrapper<?>> allWrappers = new ArrayList();
    private FComboBox<E> comboBox = new FComboBox();
    private ActionListener[] suppressedActionListeners = null;
    private Object constraints;

    public static void refreshAllSkins() {
        for (FComboBoxWrapper<?> wrapper : allWrappers) {
            super.refreshSkin();
        }
    }

    public FComboBoxWrapper() {
        allWrappers.add(this);
    }

    @Override
    public void addItem(E item) {
        this.comboBox.addItem(item);
    }

    public void removeItem(E item) {
        this.comboBox.removeItem(item);
    }

    @Override
    public void removeAllItems() {
        this.comboBox.removeAllItems();
    }

    @Override
    public E getSelectedItem() {
        E res = this.comboBox.getSelectedItem();
        return res == null ? null : (E)res;
    }

    @Override
    public void setSelectedItem(Object item) {
        this.comboBox.setSelectedItem(item);
    }

    @Override
    public int getSelectedIndex() {
        return this.comboBox.getSelectedIndex();
    }

    @Override
    public void setSelectedIndex(int index) {
        this.comboBox.setSelectedIndex(index);
    }

    public String getText() {
        return this.comboBox.getText();
    }

    public void setText(String text0) {
        this.comboBox.setText(text0);
    }

    @Override
    public String getToolTipText() {
        return this.comboBox.getToolTipText();
    }

    @Override
    public void setToolTipText(String s0) {
        this.comboBox.setToolTipText(s0);
    }

    public void setMaximumRowCount(int count) {
        this.comboBox.setMaximumRowCount(count);
    }

    public int getItemCount() {
        return this.comboBox.getItemCount();
    }

    public E getItemAt(int index) {
        return this.comboBox.getItemAt(index);
    }

    public void addActionListener(ActionListener l) {
        this.comboBox.addActionListener(l);
    }

    public void addItemListener(ItemListener l) {
        this.comboBox.addItemListener(l);
    }

    public void suppressActionListeners() {
        ActionListener[] listeners;
        for (ActionListener al : listeners = this.comboBox.getActionListeners()) {
            this.comboBox.removeActionListener(al);
        }
        this.suppressedActionListeners = this.suppressedActionListeners == null ? listeners : ObjectArrays.concat(this.suppressedActionListeners, listeners, ActionListener.class);
    }

    public void unsuppressActionListeners() {
        if (this.suppressedActionListeners != null) {
            for (ActionListener al : this.suppressedActionListeners) {
                this.comboBox.addActionListener(al);
            }
            this.suppressedActionListeners = null;
        }
    }

    public void addKeyListener(KeyListener l) {
        this.comboBox.addKeyListener(l);
    }

    public void setRenderer(ListCellRenderer<? super E> aRenderer) {
        this.comboBox.setRenderer(aRenderer);
    }

    public void setModel(ComboBoxModel<E> aModel) {
        this.comboBox.setModel(aModel);
    }

    public void setTextAlignment(FComboBox.TextAlignment align) {
        this.comboBox.setTextAlignment(align);
    }

    public void setSkinFont(FSkin.SkinFont skinFont) {
        this.comboBox.setSkinFont(skinFont);
    }

    @Override
    public boolean isVisible() {
        return this.comboBox.isVisible();
    }

    @Override
    public void setVisible(boolean aFlag) {
        this.comboBox.setVisible(aFlag);
    }

    @Override
    public boolean isEnabled() {
        return this.comboBox.isEnabled();
    }

    @Override
    public void setEnabled(boolean aFlag) {
        this.comboBox.setEnabled(aFlag);
    }

    public int getAutoSizeWidth() {
        return this.comboBox.getAutoSizeWidth();
    }

    public void addTo(Container container) {
        this.addTo(container, null);
    }

    public void addTo(Container container, Object constraints0) {
        container.add(this.comboBox, constraints0);
        this.constraints = constraints0;
    }

    public JComponent getComponent() {
        return this.comboBox;
    }

    private void refreshSkin() {
        this.comboBox = FComboBoxWrapper.refreshComboBoxSkin(this.comboBox, this.constraints);
    }

    public static <E> FComboBox<E> refreshComboBoxSkin(FComboBox<E> comboBox) {
        return FComboBoxWrapper.refreshComboBoxSkin(comboBox, null);
    }

    public static <E> FComboBox<E> refreshComboBoxSkin(FComboBox<E> comboBox, Object constraints) {
        KeyListener[] keyListeners;
        ItemListener[] itemListeners;
        ActionListener[] actionListeners;
        int index;
        Container parent = comboBox.getParent();
        if (parent == null) {
            return comboBox;
        }
        for (index = 0; index < parent.getComponentCount() && parent.getComponent(index) != comboBox; ++index) {
        }
        FComboBox newComboBox = new FComboBox();
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            newComboBox.addItem(comboBox.getItemAt(i));
        }
        newComboBox.setSelectedIndex(comboBox.getSelectedIndex());
        for (ActionListener l : actionListeners = newComboBox.getActionListeners()) {
            newComboBox.removeActionListener(l);
        }
        for (ActionListener l : actionListeners = comboBox.getActionListeners()) {
            newComboBox.addActionListener(l);
        }
        for (ItemListener l : itemListeners = newComboBox.getItemListeners()) {
            newComboBox.removeItemListener(l);
        }
        for (ItemListener l : itemListeners = comboBox.getItemListeners()) {
            newComboBox.addItemListener(l);
        }
        for (KeyListener l : keyListeners = newComboBox.getKeyListeners()) {
            newComboBox.removeKeyListener(l);
        }
        for (KeyListener l : keyListeners = comboBox.getKeyListeners()) {
            newComboBox.addKeyListener(l);
        }
        newComboBox.setEnabled(comboBox.isEnabled());
        newComboBox.setRenderer(comboBox.getRenderer());
        newComboBox.setTextAlignment(comboBox.getTextAlignment());
        if (comboBox.getSkinFont() != null) {
            newComboBox.setSkinFont(comboBox.getSkinFont());
        }
        parent.remove(index);
        parent.add(newComboBox, constraints, index);
        return newComboBox;
    }
}

