/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import com.google.common.collect.ImmutableList;
import forge.toolbox.FComboBox;
import forge.toolbox.FComboBoxWrapper;
import forge.toolbox.FSkin;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class FComboBoxPanel<E>
extends JPanel {
    private static final List<FComboBoxPanel<?>> allPanels = new ArrayList();
    private String comboBoxCaption = "";
    private FComboBox<E> comboBox = null;
    private int flowLayout;

    public static void refreshAllSkins() {
        for (FComboBoxPanel<?> panel : allPanels) {
            super.refreshSkin();
        }
    }

    public FComboBoxPanel(String comboBoxCaption0) {
        this(comboBoxCaption0, 0);
    }

    public FComboBoxPanel(String comboBoxCaption0, int flowLayout0) {
        this.comboBoxCaption = comboBoxCaption0;
        this.flowLayout = flowLayout0;
        this.applyLayoutAndSkin();
        allPanels.add(this);
    }

    public FComboBoxPanel(String comboBoxCaption0, Iterable<E> items) {
        this(comboBoxCaption0, 0, items);
    }

    public FComboBoxPanel(String comboBoxCaption0, int flowLayout0, Iterable<E> items) {
        this(comboBoxCaption0, flowLayout0);
        ImmutableList<E> list = ImmutableList.copyOf(items);
        this.setComboBox(new FComboBox<E>(list), list.get(0));
    }

    public void setComboBox(FComboBox<E> comboBox0, E selectedItem) {
        this.removeExistingComboBox();
        this.comboBox = comboBox0;
        this.comboBox.setSelectedItem((Object)selectedItem);
        this.setComboBoxLayout();
    }

    private void removeExistingComboBox() {
        if (this.comboBox != null) {
            this.remove(this.comboBox);
            this.comboBox = null;
        }
    }

    private void applyLayoutAndSkin() {
        this.setPanelLayout();
        this.setLabelLayout();
        this.setComboBoxLayout();
    }

    private void setPanelLayout() {
        FlowLayout panelLayout = new FlowLayout(this.flowLayout);
        panelLayout.setVgap(0);
        this.setLayout(panelLayout);
        this.setOpaque(false);
    }

    private void setLabelLayout() {
        if (this.comboBoxCaption != null && !this.comboBoxCaption.isEmpty()) {
            FSkin.SkinnedLabel comboLabel = new FSkin.SkinnedLabel(this.comboBoxCaption);
            comboLabel.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
            comboLabel.setFont(FSkin.getBoldFont());
            this.add(comboLabel);
        }
    }

    private void setComboBoxLayout() {
        if (this.comboBox != null) {
            this.comboBox.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
            this.comboBox.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
            this.comboBox.setFont(FSkin.getFont());
            this.comboBox.setEditable(false);
            this.comboBox.setFocusable(true);
            this.comboBox.setOpaque(true);
            this.add(this.comboBox);
        }
    }

    public void addActionListener(ActionListener l) {
        this.comboBox.addActionListener(l);
    }

    public void setSelectedItem(Object item) {
        this.comboBox.setSelectedItem(item);
    }

    public E getSelectedItem() {
        return this.comboBox.getSelectedItem();
    }

    private void refreshSkin() {
        this.comboBox = FComboBoxWrapper.refreshComboBoxSkin(this.comboBox);
    }
}

