/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.gui.interfaces.IComboBox;
import forge.toolbox.FSkin;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class FComboBox<E>
extends FSkin.SkinnedComboBox<E>
implements IComboBox<E> {
    private TextAlignment textAlignment = TextAlignment.LEFT;
    private FSkin.SkinFont skinFont;

    public FComboBox() {
        this.initialize();
    }

    public FComboBox(ComboBoxModel<E> model) {
        super(model);
        this.initialize();
    }

    public FComboBox(E[] items) {
        super(items);
        this.initialize();
    }

    public FComboBox(List<E> items) {
        this(new Vector<E>(items));
    }

    public FComboBox(Vector<E> items) {
        super(items);
        this.initialize();
    }

    private void initialize() {
        this.setUI(new FComboBoxUI());
        this.setBorder(FComboBox.getDefaultBorder());
    }

    private static Border getDefaultBorder() {
        return UIManager.getBorder("ComboBox.border");
    }

    public String getText() {
        E selectedItem = this.getSelectedItem();
        if (selectedItem == null) {
            return "";
        }
        return selectedItem.toString();
    }

    public void setText(String text0) {
        this.setSelectedItem((Object)null);
        this.dataModel.setSelectedItem(text0);
    }

    public TextAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(TextAlignment align) {
        this.textAlignment = align;
    }

    public FSkin.SkinFont getSkinFont() {
        return this.skinFont;
    }

    public void setSkinFont(FSkin.SkinFont skinFont0) {
        this.skinFont = skinFont0;
        this.setFont(skinFont0);
    }

    public int getAutoSizeWidth() {
        int maxWidth = 0;
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        for (int i = 0; i < this.getItemCount(); ++i) {
            int width = metrics.stringWidth(this.getItemAt(i).toString());
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth + 28;
    }

    @Override
    public E getSelectedItem() {
        return (E)super.getSelectedItem();
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Graphics2D g2d = (Graphics2D)g2;
        g2d.setPaint(this.getForeground());
        int shapeWidth = 8;
        int shapeHeight = 8;
        int x = this.getWidth() - shapeWidth - 6;
        int y = this.getHeight() / 2 - 1;
        if (this.getHeight() > 26) {
            shapeWidth += 2;
            shapeHeight += 2;
            x -= 4;
        }
        int[] xPoints = new int[]{x, x + shapeWidth, x + shapeWidth / 2};
        int[] yPoints = new int[]{--y, y, y + shapeHeight / 2};
        g2d.fillPolygon(xPoints, yPoints, 3);
    }

    private class FComboBoxUI
    extends BasicComboBoxUI {
        private FComboBoxUI() {
        }

        @Override
        protected LayoutManager createLayoutManager() {
            return super.createLayoutManager();
        }

        @Override
        protected ComboPopup createPopup() {
            ComboPopup p = super.createPopup();
            JComponent c = (JComponent)((Object)p);
            c.setBorder(FComboBox.getDefaultBorder());
            return p;
        }

        @Override
        protected JButton createArrowButton() {
            return new JButton(){

                @Override
                public int getWidth() {
                    return 0;
                }
            };
        }

        protected ListCellRenderer createRenderer() {
            return new CustomCellRenderer();
        }

        private class CustomCellRenderer<E>
        implements ListCellRenderer<E> {
            private final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

            private CustomCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends E> list, E value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel lblItem = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, (Object)value, index, isSelected, cellHasFocus);
                lblItem.setBorder(new EmptyBorder(4, 3, 4, 3));
                lblItem.setHorizontalAlignment(FComboBox.this.textAlignment.getInt());
                return lblItem;
            }
        }
    }

    public static enum TextAlignment {
        LEFT(2),
        RIGHT(4),
        CENTER(0);

        private int value;

        private TextAlignment(int value) {
            this.value = value;
        }

        public int getInt() {
            return this.value;
        }
    }
}

