/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.toolbox.FCheckBox;
import forge.toolbox.FSkin;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;

public class FCheckBoxTree
extends JTree {
    FCheckBoxTree selfPointer = this;
    private static final String ROOTNODE_LABEL = "/";
    private Map<Object, FTreeNode> nodesSet = new HashMap<Object, FTreeNode>();
    private HashMap<TreePath, TreeNodeState> treeNodesStates;
    private HashSet<TreePath> checkedPaths = new HashSet();
    private TreePath lastSelectedPath;
    private TreePath lastCheckedPath;
    protected EventListenerList listenerList = new EventListenerList();

    public FCheckBoxTree() {
        super(new FTreeNode(new FTreeNodeData((Comparable)((Object)ROOTNODE_LABEL))));
        this.setToggleClickCount(0);
        this.setUI(new FCheckBoxTreeUI());
        FCheckBoxTreeCellRenderer cellRenderer = new FCheckBoxTreeCellRenderer();
        this.setCellRenderer(cellRenderer);
        DefaultTreeSelectionModel dtsm = new DefaultTreeSelectionModel(){

            @Override
            public void setSelectionPath(TreePath path) {
            }

            @Override
            public void addSelectionPath(TreePath path) {
            }

            @Override
            public void removeSelectionPath(TreePath path) {
            }

            @Override
            public void setSelectionPaths(TreePath[] pPaths) {
            }
        };
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath tp = FCheckBoxTree.this.selfPointer.getPathForLocation(e.getX(), e.getY());
                if (tp == null) {
                    return;
                }
                boolean enabledStatus = ((TreeNodeState)((FCheckBoxTree)FCheckBoxTree.this).treeNodesStates.get((Object)tp)).isEnabled;
                if (!enabledStatus) {
                    return;
                }
                boolean checkStatus = !((TreeNodeState)((FCheckBoxTree)FCheckBoxTree.this).treeNodesStates.get((Object)tp)).isSelected;
                FCheckBoxTree.this.setPathCheckStatus(tp, checkStatus);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.setSelectionModel(dtsm);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    public TreePath getLastSelectedPath() {
        return this.lastSelectedPath;
    }

    public TreePath getLastCheckedBox() {
        return this.lastCheckedPath;
    }

    @Override
    public void setModel(TreeModel newModel) {
        super.setModel(newModel);
        this.initModelCheckState();
    }

    public TreePath[] getCheckedPaths() {
        return this.checkedPaths.toArray(new TreePath[0]);
    }

    public Object[] getCheckedValues(boolean leafNodesOnly) {
        ArrayList<Comparable> checkedValues = new ArrayList<Comparable>();
        for (TreePath tp : this.getCheckedPaths()) {
            boolean getValueFromNode;
            FTreeNode node = (FTreeNode)tp.getLastPathComponent();
            boolean bl = getValueFromNode = !leafNodesOnly || node.isLeaf();
            if (!getValueFromNode) continue;
            FTreeNodeData data = node.getUserObject();
            checkedValues.add(data.item);
        }
        return checkedValues.toArray(new Object[0]);
    }

    public boolean isSelectedPartially(TreePath path) {
        TreeNodeState cn = this.treeNodesStates.get(path);
        return cn.isEnabled && cn.isSelected && cn.hasChildren() && !cn.allChildrenSelected();
    }

    public void resetCheckingState() {
        this.treeNodesStates = new HashMap();
        this.checkedPaths = new HashSet();
        this.nodesSet = new HashMap<Object, FTreeNode>();
        FTreeNode node = (FTreeNode)this.getModel().getRoot();
        if (node == null) {
            return;
        }
        this.addSubtreeToCheckingStateTracking(node, true);
    }

    public FTreeNode getNodeByKey(Object key) {
        FTreeNode node = this.nodesSet.getOrDefault(key, null);
        if (node != null) {
            return node;
        }
        return this.nodesSet.getOrDefault(key.hashCode(), null);
    }

    public int getNumberOfActiveChildNodes(FTreeNode node) {
        TreeNodeState cn = this.getTreeNodeState(node);
        if (cn != null) {
            return cn.enabledChildrenCount;
        }
        return -1;
    }

    public List<FTreeNode> getActiveChildNodes(FTreeNode parent) {
        ArrayList<FTreeNode> activeChildren = new ArrayList<FTreeNode>();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            FTreeNode childNode = (FTreeNode)parent.getChildAt(i);
            TreeNodeState cn = this.getTreeNodeState(childNode);
            if (cn == null || !cn.isEnabled) continue;
            activeChildren.add(childNode);
        }
        return activeChildren;
    }

    public int getNumberOfSelectedChildNodes(FTreeNode node) {
        TreeNodeState cn = this.getTreeNodeState(node);
        if (cn != null) {
            return cn.selectedChildrenCount;
        }
        return -1;
    }

    public void setNodeCheckStatus(FTreeNode node, boolean isChecked) {
        Object[] path = node.getPath();
        TreePath treePath = new TreePath(path);
        this.setPathCheckStatus(treePath, isChecked);
    }

    public void setNodeEnabledStatus(FTreeNode node, boolean isEnabled) {
        Object[] path = node.getPath();
        TreePath treePath = new TreePath(path);
        this.setPathEnableStatus(treePath, isEnabled);
    }

    public void setTreeData(TreeMap<FTreeNodeData, List<FTreeNodeData>> nodesMap) {
        FTreeNode rootNode = new FTreeNode(new FTreeNodeData((Comparable)((Object)ROOTNODE_LABEL)));
        for (FTreeNodeData keyNodeInfo : nodesMap.keySet()) {
            FTreeNode keyNode = new FTreeNode(keyNodeInfo);
            rootNode.add(keyNode);
            for (FTreeNodeData childNodeInfo : nodesMap.get(keyNodeInfo)) {
                keyNode.add(childNodeInfo);
            }
        }
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(rootNode);
        this.setModel(defaultTreeModel);
    }

    public void showNodesCount() {
        this.setCellRenderer(new FCheckBoxTreeCellRenderer(true));
    }

    public void hideNodesCount() {
        this.setCellRenderer(new FCheckBoxTreeCellRenderer(false));
    }

    private void initModelCheckState() {
        this.treeNodesStates = new HashMap();
        this.checkedPaths = new HashSet();
        this.nodesSet = new HashMap<Object, FTreeNode>();
        FTreeNode node = (FTreeNode)this.getModel().getRoot();
        if (node == null || node.getChildCount() == 0) {
            return;
        }
        this.addSubtreeToCheckingStateTracking(node, false);
    }

    private void addSubtreeToCheckingStateTracking(FTreeNode node, boolean resetSelectState) {
        FTreeNode prevNode = this.nodesSet.put(node.getKey(), node);
        if (prevNode != null) {
            throw new RuntimeException("Node " + node + "already present in Nodes Set (key:" + node.getKey() + ")");
        }
        Object[] path = node.getPath();
        FTreeNodeData nodeData = node.getUserObject();
        boolean selectStatus = !resetSelectState && nodeData.isSelected;
        TreePath treePath = new TreePath(path);
        TreeNodeState nodeState = new TreeNodeState(selectStatus, nodeData.isEnabled, node.getChildCount(), 0, node.getChildCount());
        this.treeNodesStates.put(treePath, nodeState);
        TreePath lastChildNodePath = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            lastChildNodePath = treePath.pathByAddingChild(node.getChildAt(i));
            this.addSubtreeToCheckingStateTracking((FTreeNode)lastChildNodePath.getLastPathComponent(), resetSelectState);
        }
        if (lastChildNodePath != null) {
            this.updatePredecessors(lastChildNodePath);
        } else if (selectStatus) {
            this.checkedPaths.add(treePath);
        } else {
            this.checkedPaths.remove(treePath);
        }
    }

    private void setPathCheckStatus(TreePath tp, boolean checkStatus) {
        this.setCheckedStatusOnTree(tp, checkStatus);
        this.updatePredecessors(tp);
        this.fireCheckChangeEvent(new TreeCheckChangeEvent(new Object()));
        this.selfPointer.repaint();
    }

    private void setPathEnableStatus(TreePath tp, boolean enableStatus) {
        this.percolateEnabledStatusOnSubtree(tp, enableStatus);
        this.updatePredecessors(tp);
        this.fireEnabledChangeEvent(new TreeEnabledChangeEvent(new Object()));
        this.selfPointer.repaint();
    }

    private TreeNodeState getTreeNodeState(FTreeNode node) {
        Object[] path = node.getPath();
        TreePath treePath = new TreePath(path);
        return this.treeNodesStates.get(treePath);
    }

    protected boolean isRoot(TreePath tp) {
        return tp.getParentPath() == null;
    }

    protected void updatePredecessors(TreePath tp) {
        if (this.isRoot(tp)) {
            return;
        }
        TreePath parentPath = tp.getParentPath();
        TreeNodeState parentTreeNodeState = this.treeNodesStates.get(parentPath);
        FTreeNode parentTreeNode = (FTreeNode)parentPath.getLastPathComponent();
        parentTreeNodeState.selectedChildrenCount = 0;
        parentTreeNodeState.enabledChildrenCount = 0;
        parentTreeNodeState.isSelected = false;
        parentTreeNodeState.isEnabled = true;
        for (int i = 0; i < parentTreeNode.getChildCount(); ++i) {
            TreePath childPath = parentPath.pathByAddingChild(parentTreeNode.getChildAt(i));
            TreeNodeState childTreeNodeState = this.treeNodesStates.get(childPath);
            if (childTreeNodeState == null || !childTreeNodeState.isEnabled) continue;
            ++parentTreeNodeState.enabledChildrenCount;
            if (!childTreeNodeState.isSelected) continue;
            ++parentTreeNodeState.selectedChildrenCount;
            parentTreeNodeState.isSelected = true;
        }
        if (parentTreeNodeState.enabledChildrenCount == 0) {
            parentTreeNodeState.isEnabled = false;
        }
        if (parentTreeNodeState.isSelected) {
            this.checkedPaths.add(parentPath);
        } else {
            this.checkedPaths.remove(parentPath);
        }
        this.updatePredecessors(parentPath);
    }

    protected void setCheckedStatusOnTree(TreePath tp, boolean isChecked) {
        this.lastSelectedPath = tp;
        if (isChecked) {
            this.lastCheckedPath = tp;
        }
        this.percolateCheckedStatusOnSubTree(tp, isChecked);
    }

    private void percolateCheckedStatusOnSubTree(TreePath tp, boolean isChecked) {
        TreeNodeState cn = this.treeNodesStates.get(tp);
        cn.isSelected = cn.isEnabled && isChecked;
        FTreeNode node = (FTreeNode)tp.getLastPathComponent();
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.percolateCheckedStatusOnSubTree(tp.pathByAddingChild(node.getChildAt(i)), isChecked);
        }
        int n = cn.selectedChildrenCount = isChecked ? cn.enabledChildrenCount : 0;
        if (cn.isEnabled) {
            if (isChecked) {
                this.checkedPaths.add(tp);
            } else {
                this.checkedPaths.remove(tp);
            }
        }
    }

    private void percolateEnabledStatusOnSubtree(TreePath tp, boolean isEnabled) {
        TreeNodeState cn = this.treeNodesStates.get(tp);
        cn.isEnabled = isEnabled;
        boolean bl = cn.isSelected = isEnabled && cn.isSelected;
        if (!cn.isSelected) {
            cn.selectedChildrenCount = 0;
            this.checkedPaths.remove(tp);
        }
        FTreeNode node = (FTreeNode)tp.getLastPathComponent();
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.percolateEnabledStatusOnSubtree(tp.pathByAddingChild(node.getChildAt(i)), isEnabled);
        }
    }

    public void addCheckChangeEventListener(CheckChangeEventListener listener) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.add(CheckChangeEventListener.class, listener);
    }

    public void removeCheckChangeEventListener(CheckChangeEventListener listener) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(CheckChangeEventListener.class, listener);
    }

    void fireCheckChangeEvent(TreeCheckChangeEvent evt) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != CheckChangeEventListener.class) continue;
            ((CheckChangeEventListener)listeners[i + 1]).checkStateChanged(evt);
        }
    }

    public void addEnableChangeEventListener(EnableChangeEventListener listener) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.add(EnableChangeEventListener.class, listener);
    }

    public void removeEnableChangeEventListener(EnableChangeEventListener listener) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(EnableChangeEventListener.class, listener);
    }

    void fireEnabledChangeEvent(TreeEnabledChangeEvent evt) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != CheckChangeEventListener.class) continue;
            ((EnableChangeEventListener)listeners[i + 1]).enabledStateChanged(evt);
        }
    }

    static interface EnableChangeEventListener
    extends EventListener {
        public void enabledStateChanged(TreeEnabledChangeEvent var1);
    }

    public static class TreeEnabledChangeEvent
    extends EventObject {
        public TreeEnabledChangeEvent(Object source) {
            super(source);
        }
    }

    static interface CheckChangeEventListener
    extends EventListener {
        public void checkStateChanged(TreeCheckChangeEvent var1);
    }

    public static class TreeCheckChangeEvent
    extends EventObject {
        public TreeCheckChangeEvent(Object source) {
            super(source);
        }
    }

    private static class FCheckBoxTreeUI
    extends BasicTreeUI {
        private final IconUIResource nodeCollapsedIcon = new IconUIResource(new NodeIcon(true));
        private final IconUIResource nodeExpandedIcon = new IconUIResource(new NodeIcon(false));

        @Override
        protected void paintHorizontalLine(Graphics g2, JComponent c, int y, int left, int right) {
        }

        @Override
        protected void paintVerticalLine(Graphics g2, JComponent c, int x, int top, int bottom) {
        }

        @Override
        public Icon getCollapsedIcon() {
            return this.nodeCollapsedIcon;
        }

        @Override
        public Icon getExpandedIcon() {
            return this.nodeExpandedIcon;
        }

        static class NodeIcon
        implements Icon {
            private static final int SIZE = 9;
            private static final int HEADER_HEIGHT = 6;
            private static final int HEADER_GLYPH_WIDTH = 8;
            private final boolean isCollapsed;

            public NodeIcon(boolean isCollapsed) {
                this.isCollapsed = isCollapsed;
            }

            @Override
            public void paintIcon(Component c, Graphics g2, int x, int y) {
                Graphics2D g2d = (Graphics2D)g2;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                FSkin.setGraphicsFont(g2d, FSkin.getFont());
                Polygon glyph = new Polygon();
                int offset = 5;
                x += 4;
                y += 3;
                if (!this.isCollapsed) {
                    glyph.addPoint(x - offset + 2, y + offset - 1);
                    glyph.addPoint(x + offset, y + offset - 1);
                    glyph.addPoint(x + offset, y - offset + 1);
                } else {
                    glyph.addPoint(x, ++y - offset);
                    glyph.addPoint(x + offset, y);
                    glyph.addPoint(x, y + offset);
                }
                g2d.fill(glyph);
            }

            @Override
            public int getIconWidth() {
                return 9;
            }

            @Override
            public int getIconHeight() {
                return 9;
            }
        }
    }

    private class FCheckBoxTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        FCheckBox checkBox;
        private final FSkin.SkinFont CHECKBOX_LABEL_FONT = FSkin.getFont(14);
        private final FSkin.SkinColor CHECKBOX_LABEL_COLOUR = FSkin.getColor(FSkin.Colors.CLR_TEXT);
        private final Color CHECKBOX_SELECTED_LABEL_COLOUR = new Color(252, 226, 137);
        private final boolean displayNodesCount;

        public FCheckBoxTreeCellRenderer(boolean displayNodesCount) {
            this.setLayout(new MigLayout("insets 0, gap 0"));
            this.setBorder(null);
            this.setOpaque(false);
            this.checkBox = new FCheckBox();
            this.displayNodesCount = displayNodesCount;
            this.add((Component)this.checkBox, "left, gaptop 2, w 250::450, h 20!");
        }

        public FCheckBoxTreeCellRenderer() {
            this(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            FTreeNode node = (FTreeNode)value;
            FTreeNodeData nodeInfo = node.getUserObject();
            TreePath tp = new TreePath(node.getPath());
            TreeNodeState cn = (TreeNodeState)FCheckBoxTree.this.treeNodesStates.get(tp);
            if (cn == null) {
                return this;
            }
            this.checkBox.setEnabled(cn.isEnabled);
            this.checkBox.setSelected(cn.isSelected);
            String chkBoxTxt = nodeInfo.label;
            int disabledNodes = cn.numberOfChildren - cn.enabledChildrenCount;
            int totalActiveNodes = cn.numberOfChildren - disabledNodes;
            if (this.displayNodesCount && !node.isLeaf() && cn.numberOfChildren > 0 && totalActiveNodes > 0) {
                chkBoxTxt = chkBoxTxt + String.format(" (%d/%d)", cn.selectedChildrenCount, totalActiveNodes);
            }
            this.checkBox.setText(chkBoxTxt);
            this.checkBox.setName(nodeInfo.item.toString());
            if (cn.isSelected) {
                this.checkBox.setForeground(this.CHECKBOX_SELECTED_LABEL_COLOUR);
            } else {
                this.checkBox.setForeground(this.CHECKBOX_LABEL_COLOUR);
            }
            this.checkBox.setFont(this.CHECKBOX_LABEL_FONT);
            return this;
        }
    }

    private static class TreeNodeState {
        boolean isSelected;
        boolean isEnabled;
        int numberOfChildren;
        int selectedChildrenCount;
        int enabledChildrenCount;

        public TreeNodeState(boolean isSelected, boolean isEnabled, int numberOfChildren, int selectedChildrenCount, int enabledChildrenCount) {
            this.isSelected = isSelected && isEnabled;
            this.isEnabled = isEnabled;
            this.numberOfChildren = numberOfChildren;
            this.selectedChildrenCount = selectedChildrenCount;
            this.enabledChildrenCount = enabledChildrenCount;
        }

        public boolean hasChildren() {
            return this.numberOfChildren > 0;
        }

        public boolean allChildrenSelected() {
            return this.numberOfChildren == this.selectedChildrenCount;
        }

        public boolean allChildrenEnabled() {
            return this.enabledChildrenCount == this.numberOfChildren;
        }
    }

    public static class FTreeNode
    extends DefaultMutableTreeNode {
        public FTreeNode(FTreeNodeData object) {
            super(object, true);
        }

        public void add(List<FTreeNodeData> nodesData) {
            for (FTreeNodeData dataObject : nodesData) {
                this.add(new FTreeNode(dataObject));
            }
        }

        public void add(FTreeNodeData dataObject) {
            this.add(new FTreeNode(dataObject));
        }

        @Override
        public FTreeNodeData getUserObject() {
            return (FTreeNodeData)super.getUserObject();
        }

        @Override
        public String toString() {
            return "FTreeNode[" + this.getUserObject().toString() + "]";
        }

        public Object getKey() {
            return this.getUserObject().getKey();
        }
    }

    public static class FTreeNodeData
    implements Comparable<FTreeNodeData> {
        public Object key;
        public String label;
        public Comparable item;
        public boolean isEnabled = true;
        public boolean isSelected = false;

        public FTreeNodeData(Comparable value) {
            this(value, value.toString(), value.hashCode());
        }

        public FTreeNodeData(Comparable value, String label) {
            this(value, label, value.hashCode());
        }

        public FTreeNodeData(Comparable value, String name, Object key) {
            this.item = value;
            this.label = name;
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public int hashCode() {
            return this.item.hashCode();
        }

        public String toString() {
            return "FTreeNodeInfo[" + this.label + ", " + this.item.toString() + "]";
        }

        @Override
        public int compareTo(FTreeNodeData o) {
            return this.item.compareTo(o.item);
        }
    }
}

