/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.toolbox.FCheckBox;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class FCheckBoxList<E>
extends JList<E> {
    private static final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private int lastClickedIndex = 0;
    private int currentShiftSelectionMinIndex = Integer.MAX_VALUE;
    private int currentShiftSelectionMaxIndex = -1;
    private int currentHighlightMinIndex = Integer.MAX_VALUE;
    private int currentHighlightMaxIndex = -1;
    private boolean shiftSelectShouldCheckBox = true;

    public FCheckBoxList(boolean keepSelectionWhenFocusLost) {
        this.setCellRenderer(new CellRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = FCheckBoxList.this.locationToIndex(e.getPoint());
                if (index != -1) {
                    if (e.isShiftDown()) {
                        FCheckBox checkbox;
                        int i;
                        int min2 = Math.min(FCheckBoxList.this.lastClickedIndex, index);
                        int max = Math.max(FCheckBoxList.this.lastClickedIndex, index);
                        if (index == FCheckBoxList.this.lastClickedIndex) {
                            FCheckBoxList.this.currentHighlightMinIndex = FCheckBoxList.this.lastClickedIndex;
                            FCheckBoxList.this.currentHighlightMaxIndex = FCheckBoxList.this.lastClickedIndex;
                        } else if (index > FCheckBoxList.this.lastClickedIndex) {
                            FCheckBoxList.this.currentHighlightMinIndex = FCheckBoxList.this.lastClickedIndex;
                            FCheckBoxList.this.currentHighlightMaxIndex = index;
                        } else if (index < FCheckBoxList.this.lastClickedIndex) {
                            FCheckBoxList.this.currentHighlightMinIndex = index;
                            FCheckBoxList.this.currentHighlightMaxIndex = FCheckBoxList.this.lastClickedIndex;
                        }
                        FCheckBoxList.this.currentShiftSelectionMinIndex = Math.min(min2, FCheckBoxList.this.currentShiftSelectionMinIndex);
                        FCheckBoxList.this.currentShiftSelectionMaxIndex = Math.max(max, FCheckBoxList.this.currentShiftSelectionMaxIndex);
                        for (i = FCheckBoxList.this.currentShiftSelectionMinIndex; i <= FCheckBoxList.this.currentShiftSelectionMaxIndex; ++i) {
                            checkbox = (FCheckBox)FCheckBoxList.this.getModel().getElementAt(i);
                            if (!FCheckBoxList.this.shiftSelectShouldCheckBox) continue;
                            checkbox.setSelected(!FCheckBoxList.this.shiftSelectShouldCheckBox);
                        }
                        for (i = min2; i <= max; ++i) {
                            checkbox = (FCheckBox)FCheckBoxList.this.getModel().getElementAt(i);
                            checkbox.setSelected(FCheckBoxList.this.shiftSelectShouldCheckBox);
                        }
                    } else {
                        FCheckBox checkbox = (FCheckBox)FCheckBoxList.this.getModel().getElementAt(index);
                        if (checkbox.isEnabled()) {
                            checkbox.setSelected(!checkbox.isSelected());
                            FCheckBoxList.this.shiftSelectShouldCheckBox = checkbox.isSelected();
                            FCheckBoxList.this.lastClickedIndex = index;
                            FCheckBoxList.this.currentShiftSelectionMinIndex = (FCheckBoxList.this.currentHighlightMinIndex = Integer.MAX_VALUE);
                            FCheckBoxList.this.currentShiftSelectionMaxIndex = (FCheckBoxList.this.currentHighlightMaxIndex = -1);
                        }
                    }
                    FCheckBoxList.this.repaint();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == ' ') {
                    FCheckBox item = (FCheckBox)FCheckBoxList.this.getSelectedValue();
                    if (null == item || !item.isEnabled()) {
                        return;
                    }
                    item.setSelected(!item.isSelected());
                    FCheckBoxList.this.repaint();
                }
            }
        });
        if (!keepSelectionWhenFocusLost) {
            this.addFocusListener(new FocusListener(){
                int lastSelectedIdx;

                @Override
                public void focusLost(FocusEvent arg0) {
                    this.lastSelectedIdx = Math.max(0, FCheckBoxList.this.getSelectedIndex());
                    FCheckBoxList.this.clearSelection();
                }

                @Override
                public void focusGained(FocusEvent arg0) {
                    if (FCheckBoxList.this.getSelectedIndex() == -1) {
                        FCheckBoxList.this.setSelectedIndex(this.lastSelectedIdx);
                    }
                }
            });
        }
        this.setSelectionMode(0);
    }

    protected class CellRenderer<E1>
    implements ListCellRenderer<E1> {
        protected CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends E1> list, E1 value, int index, boolean isSelected, boolean cellHasFocus) {
            FCheckBox checkbox = (FCheckBox)value;
            if (index >= FCheckBoxList.this.currentHighlightMinIndex && index <= FCheckBoxList.this.currentHighlightMaxIndex) {
                checkbox.setOpaque(true);
            } else {
                checkbox.setOpaque(false);
            }
            checkbox.setForeground(isSelected ? FCheckBoxList.this.getSelectionForeground() : FCheckBoxList.this.getForeground());
            checkbox.setBackground(FCheckBoxList.this.getSelectionBackground());
            checkbox.setFont(FCheckBoxList.this.getFont());
            checkbox.setFocusPainted(false);
            checkbox.setBorderPainted(true);
            checkbox.setBorder(isSelected ? UIManager.getBorder("List.focusCellHighlightBorder") : NO_FOCUS_BORDER);
            return checkbox;
        }
    }
}

