/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.gui.UiCommand;
import forge.gui.framework.ILocalRepaint;
import forge.gui.interfaces.IButton;
import forge.localinstance.skin.FSkinProp;
import forge.toolbox.FSkin;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;

public class FButton
extends FSkin.SkinnedButton
implements ILocalRepaint,
IButton {
    private FSkin.SkinImage imgL;
    private FSkin.SkinImage imgM;
    private FSkin.SkinImage imgR;
    private int w;
    private int h = 0;
    private boolean allImagesPresent = false;
    private boolean toggle = false;
    private boolean hovered = false;
    private final AlphaComposite disabledComposite = AlphaComposite.getInstance(3, 0.25f);
    private KeyAdapter klEnter;

    public FButton() {
        this("");
    }

    public FButton(String label) {
        super(label);
        this.setOpaque(false);
        this.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        this.setBackground(Color.red);
        this.setFocusPainted(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setContentAreaFilled(false);
        this.setMargin(new Insets(0, 25, 0, 25));
        this.setFont(FSkin.getBoldFont(14));
        this.imgL = FSkin.getIcon(FSkinProp.IMG_BTN_UP_LEFT);
        this.imgM = FSkin.getIcon(FSkinProp.IMG_BTN_UP_CENTER);
        this.imgR = FSkin.getIcon(FSkinProp.IMG_BTN_UP_RIGHT);
        if (this.imgL != null && this.imgM != null && this.imgR != null) {
            this.allImagesPresent = true;
        }
        this.klEnter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    FButton.this.doClick();
                }
            }
        };
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                FButton.this.hovered = true;
                if (FButton.this.isToggled() || !FButton.this.isEnabled()) {
                    return;
                }
                FButton.this.resetImg();
                FButton.this.repaintSelf();
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                FButton.this.hovered = false;
                if (FButton.this.isToggled() || !FButton.this.isEnabled()) {
                    return;
                }
                FButton.this.resetImg();
                FButton.this.repaintSelf();
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (FButton.this.isToggled() || !FButton.this.isEnabled()) {
                    return;
                }
                FButton.this.imgL = FSkin.getIcon(FSkinProp.IMG_BTN_DOWN_LEFT);
                FButton.this.imgM = FSkin.getIcon(FSkinProp.IMG_BTN_DOWN_CENTER);
                FButton.this.imgR = FSkin.getIcon(FSkinProp.IMG_BTN_DOWN_RIGHT);
                FButton.this.repaintSelf();
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (FButton.this.isToggled() || !FButton.this.isEnabled()) {
                    return;
                }
                FButton.this.resetImg();
                FButton.this.repaintSelf();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (FButton.this.isToggled()) {
                    return;
                }
                FButton.this.resetImg();
                FButton.this.addKeyListener(FButton.this.klEnter);
                FButton.this.repaintSelf();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (FButton.this.isToggled()) {
                    return;
                }
                FButton.this.resetImg();
                FButton.this.removeKeyListener(FButton.this.klEnter);
                FButton.this.repaintSelf();
            }
        });
    }

    private void resetImg() {
        if (this.hovered) {
            this.imgL = FSkin.getIcon(FSkinProp.IMG_BTN_OVER_LEFT);
            this.imgM = FSkin.getIcon(FSkinProp.IMG_BTN_OVER_CENTER);
            this.imgR = FSkin.getIcon(FSkinProp.IMG_BTN_OVER_RIGHT);
        } else if (this.isFocusOwner()) {
            this.imgL = FSkin.getIcon(FSkinProp.IMG_BTN_FOCUS_LEFT);
            this.imgM = FSkin.getIcon(FSkinProp.IMG_BTN_FOCUS_CENTER);
            this.imgR = FSkin.getIcon(FSkinProp.IMG_BTN_FOCUS_RIGHT);
        } else {
            this.imgL = FSkin.getIcon(FSkinProp.IMG_BTN_UP_LEFT);
            this.imgM = FSkin.getIcon(FSkinProp.IMG_BTN_UP_CENTER);
            this.imgR = FSkin.getIcon(FSkinProp.IMG_BTN_UP_RIGHT);
        }
    }

    @Override
    public void setEnabled(boolean b0) {
        if (!b0) {
            this.imgL = FSkin.getIcon(FSkinProp.IMG_BTN_DISABLED_LEFT);
            this.imgM = FSkin.getIcon(FSkinProp.IMG_BTN_DISABLED_CENTER);
            this.imgR = FSkin.getIcon(FSkinProp.IMG_BTN_DISABLED_RIGHT);
        } else {
            this.resetImg();
        }
        super.setEnabled(b0);
        this.repaintSelf();
    }

    public boolean isToggled() {
        return this.toggle;
    }

    public void setToggled(boolean b0) {
        if (b0) {
            this.imgL = FSkin.getIcon(FSkinProp.IMG_BTN_TOGGLE_LEFT);
            this.imgM = FSkin.getIcon(FSkinProp.IMG_BTN_TOGGLE_CENTER);
            this.imgR = FSkin.getIcon(FSkinProp.IMG_BTN_TOGGLE_RIGHT);
        } else if (this.isEnabled()) {
            this.resetImg();
        } else {
            this.imgL = FSkin.getIcon(FSkinProp.IMG_BTN_DISABLED_LEFT);
            this.imgM = FSkin.getIcon(FSkinProp.IMG_BTN_DISABLED_CENTER);
            this.imgR = FSkin.getIcon(FSkinProp.IMG_BTN_DISABLED_RIGHT);
        }
        this.toggle = b0;
        this.repaintSelf();
    }

    public int getAutoSizeWidth() {
        int width = 0;
        if (this.getText() != null && !this.getText().isEmpty()) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            width = metrics.stringWidth(this.getText());
        }
        return width;
    }

    @Override
    public void repaintSelf() {
        Dimension d = this.getSize();
        this.repaint(0, 0, d.width, d.height);
    }

    @Override
    protected void paintComponent(Graphics g2) {
        if (!this.allImagesPresent) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g2;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        if (!this.isEnabled()) {
            g2d.setComposite(this.disabledComposite);
        }
        this.w = this.getWidth();
        this.h = this.getHeight();
        FSkin.drawImage(g2d, this.imgL, 0, 0, this.h, this.h);
        FSkin.drawImage(g2d, this.imgM, this.h, 0, this.w - 2 * this.h, this.h);
        FSkin.drawImage(g2d, this.imgR, this.w - this.h, 0, this.h, this.h);
        super.paintComponent(g2);
    }

    @Override
    public void setCommand(UiCommand command) {
        this.addActionListener(e -> command.run());
    }

    @Override
    public void setImage(FSkinProp color) {
        this.setForeground(FSkin.getColor(FSkin.Colors.fromSkinProp(color)));
    }

    @Override
    public void setTextColor(int r, int g2, int b) {
        this.setForeground(new Color(r, g2, b));
    }
}

