/*
 * Decompiled with CFR 0.152.
 */
package forge.sound;

import com.google.common.eventbus.Subscribe;
import forge.game.event.GameEvent;
import forge.gui.GuiBase;
import forge.gui.events.UiEvent;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.sound.EventVisualizer;
import forge.sound.IAudioClip;
import forge.sound.IAudioMusic;
import forge.sound.MusicPlaylist;
import forge.sound.NoSoundClip;
import forge.sound.SoundEffectType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class SoundSystem {
    public static final SoundSystem instance = new SoundSystem();
    public static final int DELAY = 30;
    private static final IAudioClip emptySound = new NoSoundClip();
    private static final Map<SoundEffectType, IAudioClip> loadedClips = new EnumMap<SoundEffectType, IAudioClip>(SoundEffectType.class);
    private static final Map<String, IAudioClip> loadedScriptClips = new HashMap<String, IAudioClip>();
    private final EventVisualizer visualizer = new EventVisualizer(GamePlayerUtil.getGuiPlayer());
    private IAudioMusic currentTrack;
    private MusicPlaylist currentPlaylist;

    private SoundSystem() {
    }

    private static boolean isUsingAltSystem() {
        return !GuiBase.getInterface().isLibgdxPort() && FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ALT_SOUND_SYSTEM);
    }

    protected IAudioClip fetchResource(SoundEffectType type) {
        if (GuiBase.getInterface().isLibgdxPort() ? FModel.getPreferences().getPrefInt(ForgePreferences.FPref.UI_VOL_SOUNDS) < 1 : !FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ENABLE_SOUNDS)) {
            return emptySound;
        }
        IAudioClip clip = loadedClips.get((Object)type);
        if (clip == null) {
            String resource = type.getResourceFileName();
            clip = GuiBase.getInterface().createAudioClip(resource);
            if (clip == null) {
                return emptySound;
            }
            loadedClips.put(type, clip);
        }
        return clip;
    }

    protected IAudioClip fetchResource(String fileName) {
        if (GuiBase.getInterface().isLibgdxPort() ? FModel.getPreferences().getPrefInt(ForgePreferences.FPref.UI_VOL_SOUNDS) < 1 : !FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ENABLE_SOUNDS)) {
            return emptySound;
        }
        IAudioClip clip = loadedScriptClips.get(fileName);
        if (null == clip) {
            clip = GuiBase.getInterface().createAudioClip(fileName);
            if (clip == null) {
                return emptySound;
            }
            loadedScriptClips.put(fileName, clip);
        }
        return clip;
    }

    public boolean hasResource(SoundEffectType type) {
        boolean result = true;
        IAudioClip clip = this.fetchResource(type);
        if (clip.equals(emptySound)) {
            result = false;
        }
        return result;
    }

    public void play(String resourceFileName, boolean isSynchronized) {
        if (SoundSystem.isUsingAltSystem()) {
            GuiBase.getInterface().startAltSoundSystem(this.getSoundDirectory() + resourceFileName, isSynchronized);
        } else {
            IAudioClip snd = this.fetchResource(resourceFileName);
            if (!isSynchronized || snd.isDone()) {
                snd.play((float)FModel.getPreferences().getPrefInt(ForgePreferences.FPref.UI_VOL_SOUNDS) / 100.0f);
            }
        }
    }

    public void play(SoundEffectType type, boolean isSynchronized) {
        if (SoundSystem.isUsingAltSystem()) {
            GuiBase.getInterface().startAltSoundSystem(this.getSoundDirectory() + type.getResourceFileName(), isSynchronized);
        } else {
            IAudioClip snd = this.fetchResource(type);
            if (!isSynchronized || snd.isDone()) {
                snd.play((float)FModel.getPreferences().getPrefInt(ForgePreferences.FPref.UI_VOL_SOUNDS) / 100.0f);
            }
        }
    }

    public void loop(String resourceFileName) {
        this.fetchResource(resourceFileName).loop();
    }

    public void loop(SoundEffectType type) {
        this.fetchResource(type).loop();
    }

    public void stop(String resourceFileName) {
        this.fetchResource(resourceFileName).stop();
    }

    public void stop(SoundEffectType type) {
        this.fetchResource(type).stop();
    }

    @Subscribe
    public void receiveEvent(GameEvent evt) {
        SoundEffectType effect = evt.visit(this.visualizer);
        if (null == effect) {
            return;
        }
        if (effect == SoundEffectType.ScriptedEffect) {
            String resourceName = this.visualizer.getScriptedSoundEffectName(evt);
            if (!resourceName.isEmpty()) {
                this.play(resourceName, false);
            }
        } else {
            this.play(effect, effect.isSynced());
        }
    }

    @Subscribe
    public void receiveEvent(UiEvent evt) {
        SoundEffectType effect = evt.visit(this.visualizer);
        if (null != effect) {
            this.play(effect, effect.isSynced());
        }
    }

    public void setBackgroundMusic(MusicPlaylist playlist) {
        this.currentPlaylist = playlist;
        this.changeBackgroundTrack();
    }

    public MusicPlaylist getCurrentPlaylist() {
        return this.currentPlaylist;
    }

    public void changeBackgroundTrack() {
        if (this.currentTrack != null) {
            this.currentTrack.dispose();
            this.currentTrack = null;
        }
        if (this.currentPlaylist == null || GuiBase.getInterface().isLibgdxPort() ? FModel.getPreferences().getPrefInt(ForgePreferences.FPref.UI_VOL_MUSIC) < 1 : !FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ENABLE_MUSIC)) {
            return;
        }
        String filename = this.currentPlaylist.getRandomFilename();
        if (filename == null) {
            return;
        }
        try {
            this.currentTrack = GuiBase.getInterface().createAudioMusic(filename);
            this.currentTrack.play(() -> {
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                this.changeBackgroundTrack();
            });
            this.refreshVolume();
        }
        catch (Exception ex) {
            System.err.println("Unable to load music file: " + filename);
        }
    }

    public void refreshVolume() {
        if (this.currentTrack != null) {
            this.currentTrack.setVolume((float)FModel.getPreferences().getPrefInt(ForgePreferences.FPref.UI_VOL_MUSIC) / 100.0f);
        }
    }

    public void pause() {
        if (this.currentTrack != null) {
            this.currentTrack.pause();
        }
    }

    public void resume() {
        if (this.currentTrack != null) {
            this.currentTrack.resume();
        }
    }

    public void dispose() {
        if (this.currentTrack != null) {
            this.currentTrack.dispose();
            this.currentTrack = null;
        }
        this.invalidateSoundCache();
    }

    public void fadeModifier(float value) {
        if (this.currentTrack != null) {
            this.currentTrack.setVolume((float)FModel.getPreferences().getPrefInt(ForgePreferences.FPref.UI_VOL_MUSIC) * value / 100.0f);
        }
    }

    public String[] getAvailableSoundSets() {
        ArrayList<String> availableSets = new ArrayList<String>();
        File dir = new File(ForgeConstants.CACHE_SOUND_DIR);
        if (dir != null && dir.exists()) {
            String[] files;
            for (String fileName : files = dir.list()) {
                String fullPath = ForgeConstants.CACHE_SOUND_DIR + fileName;
                if (fileName.equals("Default") || !new File(fullPath).isDirectory()) continue;
                availableSets.add(fileName);
            }
        }
        Collections.sort(availableSets);
        availableSets.add(0, "Default");
        if (availableSets.size() == 1 || !availableSets.contains(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_CURRENT_SOUND_SET))) {
            FModel.getPreferences().setPref(ForgePreferences.FPref.UI_CURRENT_SOUND_SET, "Default");
            this.invalidateSoundCache();
        }
        return availableSets.toArray(new String[0]);
    }

    public String getSoundDirectory() {
        String profileName = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_CURRENT_SOUND_SET);
        if (profileName.equals("Default")) {
            return ForgeConstants.SOUND_DIR;
        }
        return ForgeConstants.CACHE_SOUND_DIR + profileName + ForgeConstants.PATH_SEPARATOR;
    }

    public void invalidateSoundCache() {
        for (IAudioClip c : loadedClips.values()) {
            c.dispose();
        }
        loadedClips.clear();
        for (IAudioClip c : loadedScriptClips.values()) {
            c.dispose();
        }
        loadedScriptClips.clear();
    }

    public String getMusicDirectory() {
        if (GuiBase.isAdventureMode()) {
            return ForgeConstants.ADVENTURE_MUSIC_DIR;
        }
        String profileName = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_CURRENT_MUSIC_SET);
        if (profileName.equals("Default")) {
            return ForgeConstants.MUSIC_DIR;
        }
        return ForgeConstants.CACHE_MUSIC_DIR + profileName + ForgeConstants.PATH_SEPARATOR;
    }

    public static String[] getAvailableMusicSets() {
        ArrayList<String> availableSets = new ArrayList<String>();
        File dir = new File(ForgeConstants.CACHE_MUSIC_DIR);
        if (dir != null && dir.exists()) {
            String[] files;
            for (String fileName : files = dir.list()) {
                String fullPath = ForgeConstants.CACHE_MUSIC_DIR + fileName;
                if (fileName.equals("Default") || !new File(fullPath).isDirectory()) continue;
                availableSets.add(fileName);
            }
        }
        Collections.sort(availableSets);
        availableSets.add(0, "Default");
        if (availableSets.size() == 1 || !availableSets.contains(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_CURRENT_MUSIC_SET))) {
            FModel.getPreferences().setPref(ForgePreferences.FPref.UI_CURRENT_MUSIC_SET, "Default");
            MusicPlaylist.invalidateMusicPlaylist();
        }
        return availableSets.toArray(new String[0]);
    }
}

