/*
 * Decompiled with CFR 0.152.
 */
package forge.sound;

import forge.LobbyPlayer;
import forge.game.card.Card;
import forge.game.event.EventValueChangeType;
import forge.game.event.GameEvent;
import forge.game.event.GameEventBlockersDeclared;
import forge.game.event.GameEventCardAttachment;
import forge.game.event.GameEventCardChangeZone;
import forge.game.event.GameEventCardCounters;
import forge.game.event.GameEventCardDamaged;
import forge.game.event.GameEventCardDestroyed;
import forge.game.event.GameEventCardPhased;
import forge.game.event.GameEventCardRegenerated;
import forge.game.event.GameEventCardSacrificed;
import forge.game.event.GameEventCardStatsChanged;
import forge.game.event.GameEventCardTapped;
import forge.game.event.GameEventDayTimeChanged;
import forge.game.event.GameEventFlipCoin;
import forge.game.event.GameEventGameOutcome;
import forge.game.event.GameEventGameStarted;
import forge.game.event.GameEventLandPlayed;
import forge.game.event.GameEventManaBurn;
import forge.game.event.GameEventPlayerLivesChanged;
import forge.game.event.GameEventPlayerPoisoned;
import forge.game.event.GameEventPlayerShardsChanged;
import forge.game.event.GameEventRollDie;
import forge.game.event.GameEventShuffle;
import forge.game.event.GameEventSpellResolved;
import forge.game.event.GameEventTokenCreated;
import forge.game.event.GameEventTurnEnded;
import forge.game.event.GameEventZone;
import forge.game.event.IGameEventVisitor;
import forge.game.spellability.AbilityManaPart;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.gui.events.IUiEventVisitor;
import forge.gui.events.UiEventAttackerDeclared;
import forge.gui.events.UiEventBlockerAssigned;
import forge.gui.events.UiEventNextGameDecision;
import forge.sound.SoundEffectType;
import forge.sound.SoundSystem;
import forge.util.TextUtil;
import forge.util.maps.MapOfLists;
import java.io.File;
import java.util.Collection;

public class EventVisualizer
extends IGameEventVisitor.Base<SoundEffectType>
implements IUiEventVisitor<SoundEffectType> {
    final LobbyPlayer player;

    public EventVisualizer(LobbyPlayer lobbyPlayer) {
        this.player = lobbyPlayer;
    }

    @Override
    public SoundEffectType visit(GameEventGameStarted event) {
        return SoundEffectType.StartDuel;
    }

    @Override
    public SoundEffectType visit(GameEventCardDamaged event) {
        return SoundEffectType.Damage;
    }

    @Override
    public SoundEffectType visit(GameEventCardDestroyed event) {
        return SoundEffectType.Destroy;
    }

    @Override
    public SoundEffectType visit(GameEventCardAttachment event) {
        return SoundEffectType.Equip;
    }

    @Override
    public SoundEffectType visit(GameEventCardChangeZone event) {
        ZoneType from = event.from == null ? null : event.from.getZoneType();
        ZoneType to = event.to.getZoneType();
        if (from == ZoneType.Library && to == ZoneType.Hand) {
            return SoundEffectType.Draw;
        }
        if (from == ZoneType.Hand && (to == ZoneType.Graveyard || to == ZoneType.Library)) {
            return SoundEffectType.Discard;
        }
        return to == ZoneType.Exile ? SoundEffectType.Exile : null;
    }

    @Override
    public SoundEffectType visit(GameEventCardStatsChanged event) {
        return event.transform ? SoundEffectType.FlipCard : null;
    }

    @Override
    public SoundEffectType visit(GameEventCardRegenerated event) {
        return SoundEffectType.Regen;
    }

    @Override
    public SoundEffectType visit(GameEventCardSacrificed event) {
        return SoundEffectType.Sacrifice;
    }

    @Override
    public SoundEffectType visit(GameEventCardCounters event) {
        return event.newValue > event.oldValue ? SoundEffectType.AddCounter : (event.newValue < event.oldValue ? SoundEffectType.RemoveCounter : null);
    }

    @Override
    public SoundEffectType visit(GameEventTurnEnded event) {
        return SoundEffectType.EndOfTurn;
    }

    @Override
    public SoundEffectType visit(GameEventFlipCoin event) {
        return SoundEffectType.FlipCoin;
    }

    @Override
    public SoundEffectType visit(GameEventRollDie event) {
        return SoundEffectType.RollDie;
    }

    @Override
    public SoundEffectType visit(GameEventPlayerLivesChanged event) {
        return event.newLives < event.oldLives ? SoundEffectType.LifeLoss : SoundEffectType.LifeGain;
    }

    @Override
    public SoundEffectType visit(GameEventPlayerShardsChanged event) {
        return SoundEffectType.TakeShard;
    }

    @Override
    public SoundEffectType visit(GameEventManaBurn event) {
        return SoundEffectType.ManaBurn;
    }

    @Override
    public SoundEffectType visit(GameEventPlayerPoisoned event) {
        return SoundEffectType.Poison;
    }

    @Override
    public SoundEffectType visit(GameEventShuffle event) {
        return SoundEffectType.Shuffle;
    }

    @Override
    public SoundEffectType visit(GameEventTokenCreated event) {
        return SoundEffectType.Token;
    }

    @Override
    public SoundEffectType visit(GameEventDayTimeChanged event) {
        return event.daytime ? SoundEffectType.Daytime : SoundEffectType.Nighttime;
    }

    @Override
    public SoundEffectType visit(GameEventBlockersDeclared event) {
        boolean isLocalHuman;
        boolean bl = isLocalHuman = event.defendingPlayer.getLobbyPlayer() == this.player;
        if (isLocalHuman) {
            return null;
        }
        for (MapOfLists<Card, Card> ab : event.blockers.values()) {
            for (Collection bb : ab.values()) {
                if (bb.isEmpty()) continue;
                return SoundEffectType.Block;
            }
        }
        return null;
    }

    @Override
    public SoundEffectType visit(GameEventGameOutcome event) {
        boolean humanWonTheDuel = event.result.getWinningLobbyPlayer() == this.player;
        return humanWonTheDuel ? SoundEffectType.WinDuel : SoundEffectType.LoseDuel;
    }

    @Override
    public SoundEffectType visit(GameEventSpellResolved evt) {
        if (evt.spell == null) {
            return null;
        }
        Card source = evt.spell.getHostCard();
        if (evt.spell.isSpell()) {
            if (EventVisualizer.hasSpecificCardEffect(source)) {
                return SoundEffectType.ScriptedEffect;
            }
            if (source.isCreature() && source.isArtifact()) {
                return SoundEffectType.ArtifactCreature;
            }
            if (source.isCreature()) {
                return SoundEffectType.Creature;
            }
            if (source.isArtifact()) {
                return SoundEffectType.Artifact;
            }
            if (source.isInstant()) {
                return SoundEffectType.Instant;
            }
            if (source.isPlaneswalker()) {
                return SoundEffectType.Planeswalker;
            }
            if (source.isSorcery()) {
                return SoundEffectType.Sorcery;
            }
            if (source.isEnchantment()) {
                return SoundEffectType.Enchantment;
            }
        }
        return null;
    }

    @Override
    public SoundEffectType visit(GameEventCardTapped event) {
        return event.tapped ? SoundEffectType.Tap : SoundEffectType.Untap;
    }

    @Override
    public SoundEffectType visit(GameEventLandPlayed event) {
        SoundEffectType resultSound = null;
        return resultSound;
    }

    @Override
    public SoundEffectType visit(GameEventZone event) {
        Card card = event.card;
        ZoneType zoneTo = event.zoneType;
        EventValueChangeType zoneEventMode = event.mode;
        SoundEffectType resultSound = null;
        if (zoneEventMode == EventValueChangeType.Added && zoneTo == ZoneType.Battlefield && card.isLand()) {
            resultSound = this.getLandSound(card);
        }
        return resultSound;
    }

    private SoundEffectType getLandSound(Card land) {
        SoundEffectType resultSound = null;
        if (EventVisualizer.hasSpecificCardEffect(land)) {
            resultSound = SoundEffectType.ScriptedEffect;
        } else {
            StringBuilder fullManaColors = new StringBuilder();
            for (SpellAbility sa : land.getManaAbilities()) {
                for (AbilityManaPart mp : sa.getAllManaParts()) {
                    String currManaColor = mp.getOrigProduced();
                    if ("C".equals(currManaColor)) continue;
                    fullManaColors.append(currManaColor);
                }
            }
            int fullManaColorsLength = (fullManaColors = new StringBuilder(TextUtil.fastReplace(fullManaColors.toString(), " ", ""))).length();
            if (fullManaColorsLength >= 3) {
                if ((fullManaColors = new StringBuilder(fullManaColors.substring(0, 3))).toString().contains("W") && fullManaColors.toString().contains("U") && fullManaColors.toString().contains("B") && SoundSystem.instance.hasResource(SoundEffectType.WhiteBlueBlackLand)) {
                    resultSound = SoundEffectType.WhiteBlueBlackLand;
                } else if (fullManaColors.toString().contains("W") && fullManaColors.toString().contains("G") && fullManaColors.toString().contains("U") && SoundSystem.instance.hasResource(SoundEffectType.WhiteGreenBlueLand)) {
                    resultSound = SoundEffectType.WhiteGreenBlueLand;
                } else if (fullManaColors.toString().contains("W") && fullManaColors.toString().contains("R") && fullManaColors.toString().contains("B") && SoundSystem.instance.hasResource(SoundEffectType.WhiteRedBlackLand)) {
                    resultSound = SoundEffectType.WhiteRedBlackLand;
                } else if (fullManaColors.toString().contains("B") && fullManaColors.toString().contains("W") && fullManaColors.toString().contains("G") && SoundSystem.instance.hasResource(SoundEffectType.BlackWhiteGreenLand)) {
                    resultSound = SoundEffectType.BlackWhiteGreenLand;
                } else if (fullManaColors.toString().contains("B") && fullManaColors.toString().contains("R") && fullManaColors.toString().contains("G") && SoundSystem.instance.hasResource(SoundEffectType.BlackRedGreenLand)) {
                    resultSound = SoundEffectType.BlackRedGreenLand;
                } else if (fullManaColors.toString().contains("U") && fullManaColors.toString().contains("B") && fullManaColors.toString().contains("R") && SoundSystem.instance.hasResource(SoundEffectType.BlueBlackRedLand)) {
                    resultSound = SoundEffectType.BlueBlackRedLand;
                } else if (fullManaColors.toString().contains("G") && fullManaColors.toString().contains("U") && fullManaColors.toString().contains("R") && SoundSystem.instance.hasResource(SoundEffectType.GreenBlueRedLand)) {
                    resultSound = SoundEffectType.GreenBlueRedLand;
                } else if (fullManaColors.toString().contains("G") && fullManaColors.toString().contains("B") && fullManaColors.toString().contains("U") && SoundSystem.instance.hasResource(SoundEffectType.GreenBlackBlueLand)) {
                    resultSound = SoundEffectType.GreenBlackBlueLand;
                } else if (fullManaColors.toString().contains("G") && fullManaColors.toString().contains("R") && fullManaColors.toString().contains("W") && SoundSystem.instance.hasResource(SoundEffectType.GreenRedWhiteLand)) {
                    resultSound = SoundEffectType.GreenRedWhiteLand;
                } else if (fullManaColors.toString().contains("R") && fullManaColors.toString().contains("U") && fullManaColors.toString().contains("W") && SoundSystem.instance.hasResource(SoundEffectType.RedBlueWhiteLand)) {
                    resultSound = SoundEffectType.RedBlueWhiteLand;
                }
            }
            if (resultSound == null && fullManaColorsLength >= 2) {
                if ((fullManaColors = new StringBuilder(fullManaColors.substring(0, 2))).toString().contains("W") && fullManaColors.toString().contains("U") && SoundSystem.instance.hasResource(SoundEffectType.WhiteBlueLand)) {
                    resultSound = SoundEffectType.WhiteBlueLand;
                } else if (fullManaColors.toString().contains("W") && fullManaColors.toString().contains("G") && SoundSystem.instance.hasResource(SoundEffectType.WhiteGreenLand)) {
                    resultSound = SoundEffectType.WhiteGreenLand;
                } else if (fullManaColors.toString().contains("W") && fullManaColors.toString().contains("R") && SoundSystem.instance.hasResource(SoundEffectType.WhiteRedLand)) {
                    resultSound = SoundEffectType.WhiteRedLand;
                } else if (fullManaColors.toString().contains("B") && fullManaColors.toString().contains("W") && SoundSystem.instance.hasResource(SoundEffectType.BlackWhiteLand)) {
                    resultSound = SoundEffectType.BlackWhiteLand;
                } else if (fullManaColors.toString().contains("B") && fullManaColors.toString().contains("R") && SoundSystem.instance.hasResource(SoundEffectType.BlackRedLand)) {
                    resultSound = SoundEffectType.BlackRedLand;
                } else if (fullManaColors.toString().contains("U") && fullManaColors.toString().contains("B") && SoundSystem.instance.hasResource(SoundEffectType.BlueBlackLand)) {
                    resultSound = SoundEffectType.BlueBlackLand;
                } else if (fullManaColors.toString().contains("G") && fullManaColors.toString().contains("U") && SoundSystem.instance.hasResource(SoundEffectType.GreenBlueLand)) {
                    resultSound = SoundEffectType.GreenBlueLand;
                } else if (fullManaColors.toString().contains("G") && fullManaColors.toString().contains("B") && SoundSystem.instance.hasResource(SoundEffectType.GreenBlackLand)) {
                    resultSound = SoundEffectType.GreenBlackLand;
                } else if (fullManaColors.toString().contains("G") && fullManaColors.toString().contains("R") && SoundSystem.instance.hasResource(SoundEffectType.GreenRedLand)) {
                    resultSound = SoundEffectType.GreenRedLand;
                } else if (fullManaColors.toString().contains("R") && fullManaColors.toString().contains("U") && SoundSystem.instance.hasResource(SoundEffectType.RedBlueLand)) {
                    resultSound = SoundEffectType.RedBlueLand;
                }
            }
            if (resultSound == null) {
                if (fullManaColorsLength >= 2) {
                    fullManaColors = new StringBuilder(fullManaColors.substring(0, 1));
                }
                resultSound = fullManaColors.toString().contains("B") ? SoundEffectType.BlackLand : (fullManaColors.toString().contains("U") ? SoundEffectType.BlueLand : (fullManaColors.toString().contains("G") ? SoundEffectType.GreenLand : (fullManaColors.toString().contains("R") ? SoundEffectType.RedLand : (fullManaColors.toString().contains("W") ? SoundEffectType.WhiteLand : SoundEffectType.OtherLand))));
            }
        }
        return resultSound;
    }

    private static boolean hasSpecificCardEffect(Card c) {
        String effect = "";
        if (null != c) {
            effect = c.hasSVar("SoundEffect") ? c.getSVar("SoundEffect") : TextUtil.fastReplace(TextUtil.fastReplace(TextUtil.fastReplace(c.getName(), ",", ""), " ", "_"), "'", "").toLowerCase() + ".mp3";
        }
        return new File(SoundSystem.instance.getSoundDirectory(), effect).exists();
    }

    public String getScriptedSoundEffectName(GameEvent evt) {
        Card c = null;
        if (evt instanceof GameEventSpellResolved) {
            c = ((GameEventSpellResolved)evt).spell.getHostCard();
        } else if (evt instanceof GameEventZone) {
            GameEventZone evZone = (GameEventZone)evt;
            if (evZone.zoneType == ZoneType.Battlefield && evZone.mode == EventValueChangeType.Added && evZone.card.isLand()) {
                c = evZone.card;
            }
        }
        if (c == null) {
            return "";
        }
        if (c.hasSVar("SoundEffect")) {
            return c.getSVar("SoundEffect");
        }
        return TextUtil.fastReplace(TextUtil.fastReplace(TextUtil.fastReplace(c.getName(), ",", ""), " ", "_"), "'", "").toLowerCase() + ".mp3";
    }

    @Override
    public SoundEffectType visit(UiEventBlockerAssigned event) {
        return event.attackerBeingBlocked == null ? null : SoundEffectType.Block;
    }

    @Override
    public SoundEffectType visit(UiEventAttackerDeclared event) {
        return null;
    }

    @Override
    public SoundEffectType visit(UiEventNextGameDecision event) {
        return null;
    }

    @Override
    public SoundEffectType visit(GameEventCardPhased event) {
        return SoundEffectType.Phasing;
    }
}

