/*
 * Decompiled with CFR 0.152.
 */
package forge.sound;

import forge.sound.IAudioMusic;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import javazoom.jl.player.advanced.AdvancedPlayer;
import javazoom.jl.player.advanced.PlaybackEvent;
import javazoom.jl.player.advanced.PlaybackListener;

public class AudioMusic
implements IAudioMusic {
    private AdvancedPlayer musicPlayer;
    private FileInputStream fileStream;
    private BufferedInputStream bufferedStream;
    private boolean canResume;
    private String filename;
    private int total;
    private int stopped;
    private boolean valid;
    private Runnable onComplete;

    public AudioMusic(String filename0) {
        this.filename = filename0;
    }

    @Override
    public void play(Runnable onComplete0) {
        this.onComplete = onComplete0;
        this.play(-1);
    }

    private boolean play(int pos) {
        this.valid = true;
        this.canResume = false;
        try {
            this.fileStream = new FileInputStream(this.filename);
            this.total = this.fileStream.available();
            if (pos > -1) {
                this.fileStream.skip(pos);
            }
            this.bufferedStream = new BufferedInputStream(this.fileStream);
            this.musicPlayer = new AdvancedPlayer(this.bufferedStream);
            this.musicPlayer.setPlayBackListener(new PlaybackListener(){

                @Override
                public void playbackFinished(PlaybackEvent evt) {
                    if (AudioMusic.this.onComplete != null) {
                        AudioMusic.this.onComplete.run();
                    }
                }
            });
            new Thread(() -> {
                try {
                    this.musicPlayer.play();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.valid = false;
                }
            }, "Audio Music").start();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.valid = false;
        }
        return this.valid;
    }

    @Override
    public void pause() {
        if (this.musicPlayer == null) {
            return;
        }
        try {
            this.stopped = this.fileStream.available();
            this.close();
            if (this.valid) {
                this.canResume = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void close() {
        this.musicPlayer.setPlayBackListener(null);
        this.musicPlayer.close();
        this.fileStream = null;
        this.bufferedStream = null;
        this.musicPlayer = null;
    }

    @Override
    public void resume() {
        if (!this.canResume) {
            return;
        }
        if (this.play(this.total - this.stopped)) {
            this.canResume = false;
        }
    }

    @Override
    public void stop() {
        if (this.musicPlayer == null) {
            return;
        }
        this.musicPlayer.setPlayBackListener(null);
        this.musicPlayer.stop();
    }

    @Override
    public void dispose() {
        if (this.musicPlayer == null) {
            return;
        }
        this.close();
        this.canResume = false;
    }

    @Override
    public void setVolume(float value) {
    }
}

