/*
 * Decompiled with CFR 0.152.
 */
package forge.sound;

import com.google.common.io.Files;
import com.sipgate.mp3wav.Converter;
import forge.sound.IAudioClip;
import forge.sound.SoundSystem;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.function.Supplier;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioClip
implements IAudioClip {
    private final int maxSize = 16;
    private String filename;
    private List<ClipWrapper> clips;
    private boolean failed;
    private static Map<String, byte[]> audioClips = new HashMap<String, byte[]>(30);

    public static byte[] getAudioClips(File file) throws IOException {
        if (!audioClips.containsKey(file.toString())) {
            audioClips.put(file.toString(), Converter.convertFrom(Files.asByteSource(file).openStream()).toByteArray());
        }
        return audioClips.get(file.toString());
    }

    public static boolean fileExists(String fileName) {
        File fSound = new File(SoundSystem.instance.getSoundDirectory(), fileName);
        return fSound.exists();
    }

    public AudioClip(String filename) {
        this.filename = filename;
        this.clips = new ArrayList<ClipWrapper>(16);
        this.addClip();
    }

    @Override
    public final void play(float value) {
        if (this.clips.stream().anyMatch(ClipWrapper::isRunning)) {
            AudioClip.waitSoundSystemDelay();
        }
        this.getIdleClip().start();
    }

    @Override
    public final void loop() {
        this.getIdleClip().loop();
    }

    @Override
    public void dispose() {
        for (byte[] b : audioClips.values()) {
            Object var2_2 = null;
        }
        audioClips.clear();
    }

    @Override
    public final void stop() {
        for (ClipWrapper clip : this.clips) {
            clip.stop();
        }
    }

    @Override
    public final boolean isDone() {
        return this.clips.stream().noneMatch(ClipWrapper::isRunning);
    }

    private ClipWrapper getIdleClip() {
        return this.clips.stream().filter(clip -> !clip.isRunning()).findFirst().orElseGet(this::addClip);
    }

    private ClipWrapper addClip() {
        if (this.clips.size() < 16 && !this.failed) {
            ClipWrapper clip = new ClipWrapper(this.filename);
            if (clip.isFailed()) {
                this.failed = true;
            } else {
                this.clips.add(clip);
            }
            return clip;
        }
        return ClipWrapper.Dummy;
    }

    private static boolean waitSoundSystemDelay() {
        try {
            Thread.sleep(30L);
            return true;
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    static class ClipWrapper {
        private final Clip clip;
        private boolean started;
        static final ClipWrapper Dummy = new ClipWrapper();

        private ClipWrapper() {
            this.clip = null;
        }

        ClipWrapper(String filename) {
            this.clip = this.createClip(filename);
            if (this.clip != null) {
                this.clip.addLineListener(this::clipStateChanged);
            }
        }

        boolean isFailed() {
            return null == this.clip;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start() {
            if (null == this.clip) {
                return;
            }
            ClipWrapper clipWrapper = this;
            synchronized (clipWrapper) {
                this.clip.setMicrosecondPosition(0L);
                this.started = false;
                this.clip.start();
                this.wait(() -> this.started);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void loop() {
            if (null == this.clip) {
                return;
            }
            ClipWrapper clipWrapper = this;
            synchronized (clipWrapper) {
                this.clip.setMicrosecondPosition(0L);
                this.started = false;
                this.clip.loop(-1);
                this.wait(() -> this.started);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            if (null == this.clip) {
                return;
            }
            ClipWrapper clipWrapper = this;
            synchronized (clipWrapper) {
                this.clip.stop();
            }
        }

        boolean isRunning() {
            return this.clip != null && (this.clip.isRunning() || this.clip.isActive());
        }

        private Clip createClip(String filename) {
            File fSound = new File(SoundSystem.instance.getSoundDirectory(), filename);
            if (!fSound.exists()) {
                throw new IllegalArgumentException("Sound file " + fSound.toString() + " does not exist, cannot make a clip of it");
            }
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(AudioClip.getAudioClips(fSound));
                AudioInputStream stream = AudioSystem.getAudioInputStream(bis);
                AudioFormat format = stream.getFormat();
                DataLine.Info info = new DataLine.Info(Clip.class, stream.getFormat(), (int)stream.getFrameLength() * format.getFrameSize());
                Clip clip = (Clip)AudioSystem.getLine(info);
                clip.open(stream);
                return clip;
            }
            catch (IOException ex) {
                System.err.println("Unable to load sound file: " + filename);
            }
            catch (LineUnavailableException ex) {
                System.err.println("Error initializing sound system: " + ex);
            }
            catch (UnsupportedAudioFileException ex) {
                System.err.println("Unsupported file type of the sound file: " + fSound.toString() + " - " + ex.getMessage());
                return null;
            }
            throw new MissingResourceException("Sound clip failed to load", this.getClass().getName(), filename);
        }

        private void clipStateChanged(LineEvent lineEvent) {
            this.started |= lineEvent.getType() == LineEvent.Type.START;
        }

        private void wait(Supplier<Boolean> completed) {
            int attempts = 5;
            for (int i = 0; i < 5 && !completed.get().booleanValue() && AudioClip.waitSoundSystemDelay(); ++i) {
            }
        }
    }
}

