/*
 * Decompiled with CFR 0.152.
 */
package forge.sound;

import java.util.HashMap;
import java.util.Map;

class AsyncSoundRegistry {
    static Map<String, Integer> soundsPlayed = new HashMap<String, Integer>();

    AsyncSoundRegistry() {
    }

    public static synchronized void registerSound(String soundName) {
        if (soundsPlayed.containsKey(soundName)) {
            soundsPlayed.put(soundName, soundsPlayed.get(soundName) + 1);
        } else {
            soundsPlayed.put(soundName, 1);
        }
    }

    public static synchronized void unregisterSound(String soundName) {
        if (soundsPlayed.containsKey(soundName) && soundsPlayed.get(soundName) > 1) {
            soundsPlayed.put(soundName, soundsPlayed.get(soundName) - 1);
        } else {
            soundsPlayed.remove(soundName);
        }
    }

    public static synchronized boolean isRegistered(String soundName) {
        return soundsPlayed.containsKey(soundName);
    }

    public static synchronized int getNumIterations(String soundName) {
        return soundsPlayed.getOrDefault(soundName, 0);
    }
}

