/*
 * Decompiled with CFR 0.152.
 */
package forge.sound;

import forge.sound.AsyncSoundRegistry;
import forge.sound.AudioClip;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AltSoundSystem
extends Thread {
    private String filename;
    private boolean isSync;
    private final int EXTERNAL_BUFFER_SIZE = 524288;
    private final int MAX_SOUND_ITERATIONS = 5;

    public AltSoundSystem(String wavfile, boolean synced) {
        this.filename = wavfile;
        this.isSync = synced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isSync && AsyncSoundRegistry.getNumIterations(this.filename) >= 1) {
            return;
        }
        if (AsyncSoundRegistry.getNumIterations(this.filename) >= 5) {
            return;
        }
        File soundFile = new File(this.filename);
        if (!soundFile.exists()) {
            return;
        }
        AudioInputStream audioInputStream = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(AudioClip.getAudioClips(soundFile));
            audioInputStream = AudioSystem.getAudioInputStream(bis);
        }
        catch (IOException | UnsupportedAudioFileException e) {
            e.printStackTrace();
            return;
        }
        AudioFormat format = audioInputStream.getFormat();
        SourceDataLine audioLine = null;
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        Mixer.Info selectedMixer = null;
        try {
            for (Mixer.Info mixerInfo : AudioSystem.getMixerInfo()) {
                Mixer mixer = AudioSystem.getMixer(mixerInfo);
                if (!mixer.isLineSupported(info)) continue;
                selectedMixer = mixerInfo;
                break;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return;
        }
        if (selectedMixer == null) {
            return;
        }
        try {
            audioLine = AudioSystem.getSourceDataLine((AudioFormat)format, selectedMixer);
            audioLine.open(format);
        }
        catch (Exception e) {
            return;
        }
        audioLine.start();
        AsyncSoundRegistry.registerSound(this.filename);
        int nBytesRead = 0;
        byte[] audioBufData = new byte[524288];
        try {
            while (nBytesRead != -1) {
                nBytesRead = audioInputStream.read(audioBufData, 0, audioBufData.length);
                if (nBytesRead < 0) continue;
                audioLine.write(audioBufData, 0, nBytesRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        finally {
            audioLine.drain();
            audioLine.close();
            try {
                audioInputStream.close();
            }
            catch (IOException iOException) {}
            AsyncSoundRegistry.unregisterSound(this.filename);
        }
    }
}

