/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.workshop.views;

import com.google.common.collect.Iterables;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.gui.framework.IVDoc;
import forge.item.PaperCard;
import forge.itemmanager.CardManager;
import forge.itemmanager.ItemManagerContainer;
import forge.model.FModel;
import forge.screens.match.controllers.CDetailPicture;
import forge.screens.workshop.controllers.CCardScript;
import forge.screens.workshop.controllers.CWorkshopCatalog;
import forge.util.ItemPool;
import forge.util.Localizer;
import java.awt.Component;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public enum VWorkshopCatalog implements IVDoc<CWorkshopCatalog>
{
    SINGLETON_INSTANCE;

    final Localizer localizer = Localizer.getInstance();
    private DragCell parentCell;
    private final DragTab tab = new DragTab(this.localizer.getMessage("lblCardCatalog", new Object[0]));
    private final ItemManagerContainer cardManagerContainer = new ItemManagerContainer();
    private final CardManager cardManager;
    private final CDetailPicture cDetailPicture = new CDetailPicture();

    private VWorkshopCatalog() {
        this.cardManager = new CardManager(this.cDetailPicture, true, false, false);
        this.cardManager.setCaption(this.localizer.getMessage("lblCatalog", new Object[0]));
        Iterable<PaperCard> allCards = Iterables.concat(FModel.getMagicDb().getCommonCards().getAllCardsNoAlt(), FModel.getMagicDb().getVariantCards().getAllCards());
        this.cardManager.setPool(ItemPool.createFrom(allCards, PaperCard.class), true);
        this.cardManagerContainer.setItemManager(this.cardManager);
        this.cardManager.addSelectionListener(e -> {
            PaperCard card = (PaperCard)this.cardManager.getSelectedItem();
            this.cDetailPicture.showItem(card);
            CCardScript.SINGLETON_INSTANCE.showCard(card);
        });
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.WORKSHOP_CATALOG;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CWorkshopCatalog getLayoutControl() {
        return CWorkshopCatalog.SINGLETON_INSTANCE;
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    @Override
    public void populate() {
        JPanel parentBody = this.parentCell.getBody();
        parentBody.setLayout(new MigLayout("insets 5, gap 0, wrap, hidemode 3"));
        parentBody.add((Component)this.cardManagerContainer, "push, grow");
    }

    public CardManager getCardManager() {
        return this.cardManager;
    }

    public CDetailPicture getCDetailPicture() {
        return this.cDetailPicture;
    }
}

