/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.workshop.views;

import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.gui.framework.IVDoc;
import forge.screens.workshop.controllers.CCardScript;
import forge.toolbox.FScrollPane;
import forge.toolbox.FTextPane;
import forge.util.Localizer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.miginfocom.swing.MigLayout;

public enum VCardScript implements IVDoc<CCardScript>
{
    SINGLETON_INSTANCE;

    private DragCell parentCell;
    private final DragTab tab = new DragTab(Localizer.getInstance().getMessage("lblCardScript", new Object[0]));
    private final FTextPane txtScript = new FTextPane();
    private final FScrollPane scrollScript;
    private final StyledDocument doc;
    private final Style error;
    private final Style empty;

    private VCardScript() {
        this.txtScript.setEditable(true);
        this.txtScript.setFocusable(true);
        this.doc = new DefaultStyledDocument();
        this.txtScript.setDocument(this.doc);
        this.scrollScript = new FScrollPane(this.txtScript, true);
        this.error = this.doc.addStyle("error", null);
        this.error.addAttribute(StyleConstants.Background, Color.red);
        this.error.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.empty = this.doc.addStyle("empty", null);
    }

    public JTextPane getTxtScript() {
        return this.txtScript;
    }

    public StyledDocument getDoc() {
        return this.doc;
    }

    public Style getErrorStyle() {
        return this.error;
    }

    public Style getEmptyStyle() {
        return this.empty;
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.WORKSHOP_CARDSCRIPT;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CCardScript getLayoutControl() {
        return CCardScript.SINGLETON_INSTANCE;
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    @Override
    public void populate() {
        JPanel body = this.parentCell.getBody();
        body.setLayout(new MigLayout("insets 1, gap 0, wrap"));
        body.add((Component)this.scrollScript, "w 100%, h 100%");
    }
}

