/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.workshop.controllers;

import com.google.common.collect.ImmutableList;
import forge.Singletons;
import forge.card.CardDb;
import forge.card.CardRules;
import forge.game.card.Card;
import forge.gui.card.CardScriptInfo;
import forge.gui.card.CardScriptParser;
import forge.gui.framework.FScreen;
import forge.gui.framework.ICDoc;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.workshop.menus.WorkshopFileMenu;
import forge.screens.workshop.views.VCardDesigner;
import forge.screens.workshop.views.VCardScript;
import forge.screens.workshop.views.VWorkshopCatalog;
import forge.toolbox.FOptionPane;
import forge.util.Localizer;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.Map;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;

public enum CCardScript implements ICDoc
{
    SINGLETON_INSTANCE;

    private PaperCard currentCard;
    private CardScriptInfo currentScriptInfo;
    private boolean isTextDirty;
    private boolean switchInProgress;
    private boolean refreshing;
    private static final ImmutableList<String> switchAwayOptions;

    private CCardScript() {
        VCardScript.SINGLETON_INSTANCE.getTxtScript().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                CCardScript.this.updateDirtyFlag();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                CCardScript.this.updateDirtyFlag();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }
        });
        VCardScript.SINGLETON_INSTANCE.getTxtScript().addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                CCardScript.this.refresh();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    private void updateDirtyFlag() {
        boolean isTextNowDirty;
        boolean bl = isTextNowDirty = !this.refreshing && this.currentScriptInfo != null && !VCardScript.SINGLETON_INSTANCE.getTxtScript().getText().equals(this.currentScriptInfo.getText());
        if (this.isTextDirty == isTextNowDirty) {
            return;
        }
        this.isTextDirty = isTextNowDirty;
        VCardDesigner.SINGLETON_INSTANCE.getBtnSaveCard().setEnabled(isTextNowDirty);
        VCardScript.SINGLETON_INSTANCE.getTabLabel().setText((isTextNowDirty ? "*" : "") + "Card Script");
        WorkshopFileMenu.updateSaveEnabled();
    }

    public PaperCard getCurrentCard() {
        return this.currentCard;
    }

    public void showCard(PaperCard card) {
        if (this.currentCard == card || this.switchInProgress) {
            return;
        }
        if (!this.canSwitchAway(true)) {
            VWorkshopCatalog.SINGLETON_INSTANCE.getCardManager().setSelectedItem(this.currentCard);
            return;
        }
        this.currentCard = card;
        this.currentScriptInfo = card != null ? CardScriptInfo.getScriptFor(this.currentCard.getRules().getNormalizedName()) : null;
        this.refresh();
    }

    public void refresh() {
        if (this.refreshing) {
            return;
        }
        this.refreshing = true;
        JTextPane txtScript = VCardScript.SINGLETON_INSTANCE.getTxtScript();
        txtScript.setText(this.currentScriptInfo != null ? this.currentScriptInfo.getText() : "");
        txtScript.setEditable(this.currentScriptInfo != null && this.currentScriptInfo.canEdit());
        txtScript.setCaretPosition(0);
        StyledDocument doc = VCardScript.SINGLETON_INSTANCE.getDoc();
        Style error = VCardScript.SINGLETON_INSTANCE.getErrorStyle();
        Style empty = VCardScript.SINGLETON_INSTANCE.getEmptyStyle();
        doc.setCharacterAttributes(0, 9999, empty, true);
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.DEV_WORKSHOP_SYNTAX) && this.currentScriptInfo != null) {
            for (Map.Entry<Integer, Integer> region : new CardScriptParser(this.currentScriptInfo.getText()).getErrorRegions().entrySet()) {
                doc.setCharacterAttributes(region.getKey(), region.getValue(), error, true);
            }
        }
        this.refreshing = false;
    }

    public boolean hasChanges() {
        return this.currentScriptInfo != null && this.isTextDirty;
    }

    public boolean canSwitchAway(boolean isCardChanging) {
        if (this.switchInProgress) {
            return false;
        }
        if (!this.hasChanges()) {
            return true;
        }
        this.switchInProgress = true;
        Singletons.getControl().ensureScreenActive(FScreen.WORKSHOP_SCREEN);
        int choice = FOptionPane.showOptionDialog(Localizer.getInstance().getMessage("lblSaveChangesToDestConfirm", this.currentCard.toString()), Localizer.getInstance().getMessage("lblSaveChangesConfirm", new Object[0]), FOptionPane.QUESTION_ICON, switchAwayOptions);
        this.switchInProgress = false;
        if (choice == -1 || choice == 2) {
            return false;
        }
        if (choice == 0 && !this.saveChanges()) {
            return false;
        }
        if (!isCardChanging) {
            this.refresh();
        }
        return true;
    }

    public boolean saveChanges() {
        if (!this.hasChanges()) {
            return true;
        }
        String text = VCardScript.SINGLETON_INSTANCE.getTxtScript().getText();
        if (!this.currentScriptInfo.trySetText(text)) {
            return false;
        }
        this.updateDirtyFlag();
        String oldName = this.currentCard.getName();
        CardRules newRules = CardRules.fromScript(Arrays.asList(text.split("\n")));
        CardDb cardDb = newRules.isVariant() ? FModel.getMagicDb().getVariantCards() : FModel.getMagicDb().getCommonCards();
        cardDb.getEditor().putCard(newRules);
        if (newRules.getName().equals(oldName)) {
            Card.updateCard(this.currentCard);
        } else {
            this.currentCard = cardDb.getCard(newRules.getName());
        }
        VWorkshopCatalog.SINGLETON_INSTANCE.getCardManager().repaint();
        VWorkshopCatalog.SINGLETON_INSTANCE.getCDetailPicture().showItem(this.currentCard);
        this.refresh();
        return true;
    }

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
    }

    @Override
    public void update() {
    }

    static {
        switchAwayOptions = ImmutableList.of(Localizer.getInstance().getMessage("lblSave", new Object[0]), Localizer.getInstance().getMessage("lblDontSave", new Object[0]), Localizer.getInstance().getMessage("lblCancel", new Object[0]));
    }
}

