/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import forge.CachedCardImage;
import forge.game.GameView;
import forge.game.card.CardView;
import forge.game.spellability.StackItemView;
import forge.gui.card.CardDetailUtil;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.gui.framework.IVDoc;
import forge.screens.match.controllers.CDock;
import forge.screens.match.controllers.CStack;
import forge.toolbox.FMouseAdapter;
import forge.toolbox.FScrollPanel;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import forge.util.collect.FCollectionView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;

public class VStack
implements IVDoc<CStack> {
    private DragCell parentCell;
    private final DragTab tab = new DragTab(Localizer.getInstance().getMessage("lblStack", new Object[0]));
    private final FScrollPanel scroller = new FScrollPanel(new MigLayout("insets 0, gap 0, wrap"), true, 20, 31);
    private final AbilityMenu abilityMenu = new AbilityMenu();
    private StackInstanceTextArea hoveredItem;
    private final CStack controller;

    public StackInstanceTextArea getHoveredItem() {
        return this.hoveredItem;
    }

    public VStack(CStack controller) {
        this.controller = controller;
    }

    @Override
    public void populate() {
        this.parentCell.getBody().setLayout(new MigLayout("insets 3px, gap 0"));
        this.parentCell.getBody().add((Component)this.scroller, "grow, push");
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.REPORT_STACK;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CStack getLayoutControl() {
        return this.controller;
    }

    public void updateStack() {
        GameView model = this.controller.getMatchUI().getGameView();
        if (model == null) {
            return;
        }
        FCollectionView<StackItemView> items = model.getStack();
        this.tab.setText(Localizer.getInstance().getMessage("lblStack", new Object[0]) + " : " + items.size());
        if (!this.parentCell.getSelected().equals(this)) {
            return;
        }
        this.hoveredItem = null;
        this.scroller.removeAll();
        boolean isFirst = true;
        for (StackItemView item : items) {
            StackInstanceTextArea tar = new StackInstanceTextArea(item);
            this.scroller.add((Component)tar, "pushx, growx" + (isFirst ? "" : ", gaptop 2px"));
            if (!isFirst) continue;
            isFirst = false;
            this.controller.getMatchUI().setCard(item.getSourceCard());
        }
        this.scroller.revalidate();
        this.scroller.repaint();
        SwingUtilities.invokeLater(this.scroller::scrollToTop);
    }

    private final class AbilityMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1548494191627807962L;
        private final JCheckBoxMenuItem jmiAutoYield = new JCheckBoxMenuItem(Localizer.getInstance().getMessage("cbpAutoYieldMode", new Object[0]));
        private final JCheckBoxMenuItem jmiAlwaysYes;
        private final JCheckBoxMenuItem jmiAlwaysNo;
        private StackItemView item;
        private Integer triggerID = 0;

        public AbilityMenu() {
            this.jmiAutoYield.addActionListener(arg0 -> {
                String key = this.item.getKey();
                boolean autoYield = VStack.this.controller.getMatchUI().shouldAutoYield(key);
                VStack.this.controller.getMatchUI().setShouldAutoYield(key, !autoYield);
                if (!autoYield && VStack.this.controller.getMatchUI().getGameView().peekStack() == this.item) {
                    VStack.this.controller.getMatchUI().getGameController().passPriority();
                }
            });
            this.add(this.jmiAutoYield);
            this.jmiAlwaysYes = new JCheckBoxMenuItem(Localizer.getInstance().getMessage("lblAlwaysYes", new Object[0]));
            this.jmiAlwaysYes.addActionListener(arg0 -> {
                if (VStack.this.controller.getMatchUI().shouldAlwaysAcceptTrigger(this.triggerID)) {
                    VStack.this.controller.getMatchUI().setShouldAlwaysAskTrigger(this.triggerID);
                } else {
                    VStack.this.controller.getMatchUI().setShouldAlwaysAcceptTrigger(this.triggerID);
                }
            });
            this.add(this.jmiAlwaysYes);
            this.jmiAlwaysNo = new JCheckBoxMenuItem(Localizer.getInstance().getMessage("lblAlwaysNo", new Object[0]));
            this.jmiAlwaysNo.addActionListener(arg0 -> {
                if (VStack.this.controller.getMatchUI().shouldAlwaysDeclineTrigger(this.triggerID)) {
                    VStack.this.controller.getMatchUI().setShouldAlwaysAskTrigger(this.triggerID);
                } else {
                    VStack.this.controller.getMatchUI().setShouldAlwaysDeclineTrigger(this.triggerID);
                }
            });
            this.add(this.jmiAlwaysNo);
        }

        public void setStackInstance(StackItemView item0) {
            this.item = item0;
            this.triggerID = this.item.getSourceTrigger();
            this.jmiAutoYield.setSelected(VStack.this.controller.getMatchUI().shouldAutoYield(this.item.getKey()));
            if (this.item.isOptionalTrigger() && VStack.this.controller.getMatchUI().isLocalPlayer(this.item.getActivatingPlayer())) {
                this.jmiAlwaysYes.setSelected(VStack.this.controller.getMatchUI().shouldAlwaysAcceptTrigger(this.triggerID));
                this.jmiAlwaysNo.setSelected(VStack.this.controller.getMatchUI().shouldAlwaysDeclineTrigger(this.triggerID));
                this.jmiAlwaysYes.setVisible(true);
                this.jmiAlwaysNo.setVisible(true);
            } else {
                this.jmiAlwaysYes.setVisible(false);
                this.jmiAlwaysNo.setVisible(false);
            }
        }
    }

    public class StackInstanceTextArea
    extends FSkin.SkinnedTextArea {
        public static final int PADDING = 3;
        public static final int CARD_WIDTH = 50;
        public static final int CARD_HEIGHT = 70;
        private final StackItemView item;
        private final CachedCardImage cachedImage;

        public StackItemView getItem() {
            return this.item;
        }

        @Override
        public Point getLocationOnScreen() {
            try {
                return super.getLocationOnScreen();
            }
            catch (Exception e) {
                if (VStack.this.hoveredItem == this) {
                    VStack.this.hoveredItem = null;
                }
                return null;
            }
        }

        public StackInstanceTextArea(StackItemView item0) {
            this.item = item0;
            String txt = (this.item.isOptionalTrigger() && VStack.this.controller.getMatchUI().isLocalPlayer(this.item.getActivatingPlayer()) ? "(OPTIONAL) " : "") + this.item.getText();
            this.setText(txt);
            this.setOpaque(true);
            this.setBorder(new EmptyBorder(3, 56, 3, 3));
            this.setFocusable(false);
            this.setEditable(false);
            this.setLineWrap(true);
            this.setFont(FSkin.getFont());
            this.setWrapStyleWord(true);
            this.setMinimumSize(new Dimension(56, 76));
            if (VStack.this.hoveredItem == null) {
                VStack.this.hoveredItem = this;
                VStack.this.controller.getMatchUI().setCard(this.item.getSourceCard());
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (VStack.this.controller.getMatchUI().getCDock().getArcState() == CDock.ArcState.MOUSEOVER) {
                        VStack.this.hoveredItem = StackInstanceTextArea.this;
                    }
                    VStack.this.controller.getMatchUI().setCard(StackInstanceTextArea.this.item.getSourceCard());
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (VStack.this.controller.getMatchUI().getCDock().getArcState() == CDock.ArcState.MOUSEOVER && VStack.this.hoveredItem == StackInstanceTextArea.this) {
                        VStack.this.hoveredItem = null;
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (VStack.this.controller.getMatchUI().getCDock().getArcState() == CDock.ArcState.ON) {
                        if (VStack.this.hoveredItem == StackInstanceTextArea.this) {
                            VStack.this.hoveredItem = null;
                        } else {
                            VStack.this.hoveredItem = StackInstanceTextArea.this;
                            VStack.this.controller.getMatchUI().setCard(StackInstanceTextArea.this.item.getSourceCard());
                        }
                    }
                }
            });
            if (this.item.isAbility()) {
                this.addMouseListener(new FMouseAdapter(){

                    @Override
                    public void onLeftClick(MouseEvent e) {
                        this.onClick(e);
                    }

                    @Override
                    public void onRightClick(MouseEvent e) {
                        this.onClick(e);
                    }

                    private void onClick(MouseEvent e) {
                        VStack.this.abilityMenu.setStackInstance(StackInstanceTextArea.this.item);
                        VStack.this.abilityMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                });
            }
            CardView.CardStateView curState = this.item.getSourceCard().getCurrentState();
            boolean isFaceDown = this.item.getSourceCard().isFaceDown();
            CardDetailUtil.DetailColors color = isFaceDown ? CardDetailUtil.DetailColors.FACE_DOWN : CardDetailUtil.getBorderColor(curState, true);
            this.setBackground(new Color(color.r, color.g, color.b));
            this.setForeground(FSkin.getHighContrastColor(this.getBackground()));
            this.cachedImage = new CachedCardImage(this.item.getSourceCard(), VStack.this.controller.getMatchUI().getLocalPlayers(), 50, 70){

                @Override
                public void onImageFetched() {
                    StackInstanceTextArea.this.repaint();
                }
            };
        }

        @Override
        public void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            Graphics2D g2d = (Graphics2D)g2;
            BufferedImage img = this.cachedImage.getImage();
            if (img != null) {
                g2d.drawImage(img, null, 3, 3);
            }
        }
    }
}

