/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import forge.game.card.CardView;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.gui.framework.IVDoc;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.match.controllers.CPrompt;
import forge.toolbox.FButton;
import forge.toolbox.FHtmlViewer;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class VPrompt
implements IVDoc<CPrompt> {
    private DragCell parentCell;
    final Localizer localizer = Localizer.getInstance();
    private final DragTab tab = new DragTab(this.localizer.getMessage("lblPrompt", new Object[0]));
    private final FButton btnOK = new FButton(this.localizer.getMessage("lblOK", new Object[0]));
    private final FButton btnCancel = new FButton(this.localizer.getMessage("lblCancel", new Object[0]));
    private final FHtmlViewer tarMessage = new FHtmlViewer();
    private final FScrollPane messageScroller = new FScrollPane(this.tarMessage, false, 20, 31);
    private final JLabel lblGames;
    private CardView card = null;
    private KeyAdapter buttonKeyAdapter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27 && VPrompt.this.btnCancel.isEnabled() && (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ALLOW_ESC_TO_END_TURN) || !VPrompt.this.btnCancel.getText().equals("End Turn"))) {
                VPrompt.this.btnCancel.doClick();
            }
        }
    };
    private final CPrompt controller;

    public void setCardView(CardView card) {
        this.card = card;
    }

    public VPrompt(final CPrompt controller) {
        this.controller = controller;
        this.lblGames = new FLabel.Builder().fontSize(12).fontStyle(0).fontAlign(0).opaque().build();
        this.btnOK.addKeyListener(this.buttonKeyAdapter);
        this.btnCancel.addKeyListener(this.buttonKeyAdapter);
        this.tarMessage.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        this.tarMessage.setMargin(new Insets(3, 3, 3, 3));
        this.tarMessage.getAccessibleContext().setAccessibleName("Prompt");
        this.tarMessage.setFocusable(true);
        this.messageScroller.getViewport().getView().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (VPrompt.this.card != null) {
                    controller.getMatchUI().setCard(VPrompt.this.card);
                }
            }
        });
    }

    @Override
    public void populate() {
        ForgePreferences prefs = FModel.getPreferences();
        JPanel container = this.parentCell.getBody();
        container.setLayout(new MigLayout("wrap 2, gap 0px!, insets 1px 1px 3px 1px"));
        if (prefs.getPrefBoolean(ForgePreferences.FPref.UI_COMPACT_PROMPT)) {
            this.tarMessage.setFont(FSkin.getFont());
        } else {
            container.add((Component)this.lblGames, "span 2, w 10:100%, h 22px!");
            this.tarMessage.setFont(FSkin.getRelativeFont(14));
        }
        this.lblGames.setText(this.localizer.getMessage("lblGameSetup", new Object[0]));
        container.add((Component)this.messageScroller, "span 2, w 10:100%, h 0:100%");
        boolean largerButtons = prefs.getPrefBoolean(ForgePreferences.FPref.UI_FOR_TOUCHSCREN);
        String constraints = largerButtons ? "w 10:50%, h 40%:40%:60px" : "w 10:50%, hmin 24px";
        constraints = constraints + ", gaptop 2px!";
        container.add((Component)this.btnOK, constraints);
        container.add((Component)this.btnCancel, constraints);
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.REPORT_MESSAGE;
    }

    @Override
    public CPrompt getLayoutControl() {
        return this.controller;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    public FButton getBtnOK() {
        return this.btnOK;
    }

    public FButton getBtnCancel() {
        return this.btnCancel;
    }

    public FHtmlViewer getTarMessage() {
        return this.tarMessage;
    }

    public JLabel getLblGames() {
        return this.lblGames;
    }
}

