/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import com.google.common.collect.Lists;
import forge.game.GameLogEntry;
import forge.game.GameLogEntryType;
import forge.game.GameView;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.gui.framework.IVDoc;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.match.GameLogPanel;
import forge.screens.match.controllers.CLog;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class VLog
implements IVDoc<CLog> {
    private final List<GameLogEntry> displayedLogEntries = Lists.newArrayList();
    private GameView gameLogModel = null;
    private DragCell parentCell;
    private final DragTab tab = new DragTab(Localizer.getInstance().getMessage("lblLog", new Object[0]));
    private final GameLogPanel gameLog;
    private JPanel p = null;
    private final CLog controller;

    public VLog(CLog controller) {
        this.controller = controller;
        this.gameLog = new GameLogPanel();
    }

    @Override
    public void populate() {
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.REPORT_LOG;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CLog getLayoutControl() {
        return this.controller;
    }

    public void updateConsole() {
        GameView model = this.controller.getMatchUI().getGameView();
        if (this.isGameLogConsoleVisible() && model != null) {
            this.resetDisplayIfNewGame(model);
            this.displayNewGameLogEntries(model);
            this.refreshLayout();
        }
    }

    private boolean isGameLogConsoleVisible() {
        return this.parentCell.getSelected().equals(this);
    }

    private void resetDisplayIfNewGame(GameView model) {
        if (this.gameLogModel != model) {
            this.gameLog.reset();
            this.displayedLogEntries.clear();
            this.gameLogModel = model;
        }
    }

    private void refreshLayout() {
        this.p = this.parentCell.getBody();
        this.p.remove(this.gameLog);
        this.p.setLayout(new MigLayout("insets 1"));
        this.p.add((Component)this.gameLog, "w 10:100%, h 100%");
    }

    private void displayNewGameLogEntries(GameView model) {
        List<GameLogEntry> newLogEntries = Lists.reverse(this.getNewGameLogEntries(model));
        if (newLogEntries.size() > 0) {
            this.addNewLogEntriesToJPanel(newLogEntries);
        }
    }

    private List<GameLogEntry> getNewGameLogEntries(GameView model) {
        String logEntryType = FModel.getPreferences().getPref(ForgePreferences.FPref.DEV_LOG_ENTRY_TYPE);
        GameLogEntryType logVerbosityFilter = GameLogEntryType.valueOf(logEntryType);
        if (model != null && model.getGameLog() != null) {
            List<GameLogEntry> logEntries = model.getGameLog().getLogEntries(logVerbosityFilter);
            logEntries.removeAll(this.displayedLogEntries);
            return logEntries;
        }
        return new ArrayList<GameLogEntry>();
    }

    private void addNewLogEntriesToJPanel(List<GameLogEntry> newLogEntries) {
        for (GameLogEntry logEntry : newLogEntries) {
            this.gameLog.setTextFont(VLog.getJTextAreaFont(logEntry.type));
            this.gameLog.addLogEntry(logEntry.message);
            this.displayedLogEntries.add(logEntry);
        }
    }

    private static FSkin.SkinFont getJTextAreaFont(GameLogEntryType logEntryType) {
        boolean isNewTurn = logEntryType == GameLogEntryType.TURN;
        return isNewTurn ? FSkin.getBoldFont() : FSkin.getFont();
    }
}

