/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import forge.game.player.PlayerView;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.gui.framework.IVDoc;
import forge.screens.match.CMatchUI;
import forge.screens.match.controllers.CHand;
import forge.toolbox.FScrollPane;
import forge.util.Localizer;
import forge.view.arcane.HandArea;
import java.awt.Component;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class VHand
implements IVDoc<CHand> {
    private final CHand control;
    private DragCell parentCell;
    private final EDocID docID;
    private final DragTab tab = new DragTab(Localizer.getInstance().getMessage("lblYourHand", new Object[0]));
    private final FScrollPane scroller = new FScrollPane(false);
    private final HandArea hand;

    public VHand(CMatchUI matchUI, EDocID id0, PlayerView p) {
        this.hand = new HandArea(matchUI, this.scroller);
        this.docID = id0;
        id0.setDoc(this);
        if (p == null) {
            this.tab.setText("lblNoPlayerHand");
        } else {
            this.tab.setText(Localizer.getInstance().getMessage("lblPlayerHand", p.getName()));
        }
        this.scroller.setViewportView(this.hand);
        this.hand.setOpaque(false);
        this.control = new CHand(matchUI, p, this);
    }

    @Override
    public void populate() {
        JPanel pnl = this.parentCell.getBody();
        pnl.setLayout(new MigLayout("insets 0, gap 0"));
        pnl.add((Component)this.scroller, "w 100%, h 100%!");
    }

    @Override
    public EDocID getDocumentID() {
        return this.docID;
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CHand getLayoutControl() {
        return this.control;
    }

    public HandArea getHandArea() {
        return this.hand;
    }
}

