/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import forge.game.card.CounterEnumType;
import forge.game.player.PlayerView;
import forge.game.zone.ZoneType;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.gui.framework.IVDoc;
import forge.localinstance.skin.FSkinProp;
import forge.screens.match.CMatchUI;
import forge.screens.match.controllers.CField;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.toolbox.special.PhaseIndicator;
import forge.toolbox.special.PlayerDetailsPanel;
import forge.util.Localizer;
import forge.view.arcane.PlayArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import net.miginfocom.swing.MigLayout;

public class VField
implements IVDoc<CField> {
    private static final int LIFE_CRITICAL = 5;
    private static final int POISON_CRITICAL = 8;
    private final CField control;
    private DragCell parentCell;
    private final EDocID docID;
    private final DragTab tab = new DragTab(Localizer.getInstance().getMessage("lblField", new Object[0]));
    private final PlayerView player;
    private final FScrollPane scroller = new FScrollPane(false);
    private final PlayArea tabletop;
    private final FSkin.SkinnedPanel avatarArea = new FSkin.SkinnedPanel();
    private final PlayerDetailsPanel detailsPanel;
    private final FLabel lblAvatar = new FLabel.Builder().fontAlign(0).iconScaleFactor(1.0).build();
    private final FLabel lblLife = new FLabel.Builder().fontAlign(0).fontStyle(1).build();
    private final FLabel lblPoison = new FLabel.Builder().fontAlign(0).fontStyle(1).icon(FSkin.getImage(FSkinProp.IMG_ZONE_POISON)).iconInBackground().build();
    private final FLabel lblEnergy = new FLabel.Builder().fontAlign(0).fontStyle(1).icon(FSkin.getImage(FSkinProp.IMG_ENERGY)).iconInBackground().build();
    private final FLabel lblExperience = new FLabel.Builder().fontAlign(0).fontStyle(1).icon(FSkin.getImage(FSkinProp.IMG_EXPERIENCE)).iconInBackground().build();
    private final FLabel lblTicket = new FLabel.Builder().fontAlign(0).fontStyle(1).icon(FSkin.getImage(FSkinProp.IMG_TICKET)).iconInBackground().build();
    private final FLabel lblRad = new FLabel.Builder().fontAlign(0).fontStyle(1).icon(FSkin.getImage(FSkinProp.IMG_RAD)).iconInBackground().build();
    private final PhaseIndicator phaseIndicator = new PhaseIndicator();
    private final Border borderAvatarSimple = new LineBorder(new Color(0, 0, 0, 0), 1);
    private final Border borderAvatarHighlighted = new LineBorder(Color.red, 2);

    public VField(CMatchUI matchUI, EDocID id0, PlayerView p, boolean mirror) {
        this.docID = id0;
        this.player = p;
        if (p != null) {
            this.tab.setText(Localizer.getInstance().getMessage("lblPlayField", p.getName()));
        } else {
            this.tab.setText(Localizer.getInstance().getMessage("lblNoPlayerForEDocID", this.docID.toString()));
        }
        this.detailsPanel = new PlayerDetailsPanel(this.player);
        this.tabletop = new PlayArea(matchUI, this.scroller, mirror, this.player, ZoneType.Battlefield);
        this.control = new CField(matchUI, this.player, this);
        this.lblAvatar.setFocusable(false);
        this.lblLife.setFocusable(false);
        this.lblPoison.setFocusable(false);
        this.lblEnergy.setFocusable(false);
        this.lblExperience.setFocusable(false);
        this.lblTicket.setFocusable(false);
        this.lblRad.setFocusable(false);
        this.avatarArea.setOpaque(false);
        this.avatarArea.setBackground(FSkin.getColor(FSkin.Colors.CLR_HOVER));
        this.avatarArea.setLayout(new MigLayout("insets 0, gap 0"));
        this.avatarArea.add((Component)this.lblAvatar, "w 100%-6px!, h 100%-23px!, wrap, gap 3 3 3 0");
        this.avatarArea.add((Component)this.lblLife, "w 100%!, h 20px!, wrap");
        this.avatarArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                VField.this.avatarArea.setOpaque(true);
                if (!VField.this.isHighlighted()) {
                    VField.this.avatarArea.setBorder(new FSkin.LineSkinBorder(FSkin.getColor(FSkin.Colors.CLR_BORDERS)));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                VField.this.avatarArea.setOpaque(false);
                if (!VField.this.isHighlighted()) {
                    VField.this.avatarArea.setBorder(VField.this.borderAvatarSimple);
                }
            }
        });
        this.tabletop.setBorder(new FSkin.MatteSkinBorder(0, 1, 0, 0, FSkin.getColor(FSkin.Colors.CLR_BORDERS)));
        this.tabletop.setOpaque(false);
        this.scroller.setViewportView(this.tabletop);
        this.updateDetails();
    }

    @Override
    public void populate() {
        JPanel pnl = this.parentCell.getBody();
        pnl.setLayout(new MigLayout("insets 0, gap 0"));
        pnl.add((Component)this.avatarArea, "w 10%!, h 35%!");
        pnl.add((Component)this.phaseIndicator, "w 5%!, h 100%!, span 1 2");
        pnl.add((Component)this.scroller, "w 85%!, h 100%!, span 1 2, wrap");
        pnl.add((Component)this.detailsPanel, "w 10%!, h 64%!, gapleft 1px");
    }

    @Override
    public EDocID getDocumentID() {
        return this.docID;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CField getLayoutControl() {
        return this.control;
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    public PlayArea getTabletop() {
        return this.tabletop;
    }

    public JPanel getAvatarArea() {
        return this.avatarArea;
    }

    public PhaseIndicator getPhaseIndicator() {
        return this.phaseIndicator;
    }

    public PlayerDetailsPanel getDetailsPanel() {
        return this.detailsPanel;
    }

    private boolean isHighlighted() {
        return this.control.getMatchUI().isHighlighted(this.player);
    }

    public void setAvatar(FSkin.SkinImage avatar) {
        this.lblAvatar.setIcon(avatar);
        this.lblAvatar.getResizeTimer().start();
    }

    public void updateManaPool() {
        this.detailsPanel.updateManaPool();
    }

    public void updateZones() {
        this.detailsPanel.updateZones();
    }

    private void addLblTicket() {
        if (this.lblTicket.isShowing() || this.lblExperience.isShowing() || this.lblEnergy.isShowing() || this.lblPoison.isShowing()) {
            return;
        }
        this.avatarArea.remove(this.lblLife);
        this.lblLife.setIcon(FSkin.getImage(FSkinProp.ICO_QUEST_LIFE));
        this.avatarArea.add((Component)this.lblLife, "w 50%!, h 20px!, split 2");
        this.avatarArea.add((Component)this.lblTicket, "w 50%!, h 20px!, wrap");
    }

    private void removeLblTicket() {
        if (!this.lblTicket.isShowing()) {
            return;
        }
        this.avatarArea.remove(this.lblTicket);
        this.avatarArea.remove(this.lblLife);
        this.avatarArea.add((Component)this.lblLife, "w 100%!, h 20px!, wrap");
    }

    private void addLblRad() {
        if (this.lblRad.isShowing() || this.lblExperience.isShowing() || this.lblEnergy.isShowing() || this.lblPoison.isShowing()) {
            return;
        }
        this.avatarArea.remove(this.lblLife);
        this.lblLife.setIcon(FSkin.getImage(FSkinProp.ICO_QUEST_LIFE));
        this.avatarArea.add((Component)this.lblLife, "w 50%!, h 20px!, split 2");
        this.avatarArea.add((Component)this.lblRad, "w 50%!, h 20px!, wrap");
    }

    private void removeLblRad() {
        if (!this.lblRad.isShowing()) {
            return;
        }
        this.avatarArea.remove(this.lblRad);
        this.avatarArea.remove(this.lblLife);
        this.avatarArea.add((Component)this.lblLife, "w 100%!, h 20px!, wrap");
    }

    private void addLblExperience() {
        if (this.lblExperience.isShowing() || this.lblEnergy.isShowing() || this.lblPoison.isShowing()) {
            return;
        }
        this.avatarArea.remove(this.lblLife);
        this.lblLife.setIcon(FSkin.getImage(FSkinProp.ICO_QUEST_LIFE));
        this.avatarArea.add((Component)this.lblLife, "w 50%!, h 20px!, split 2");
        this.avatarArea.add((Component)this.lblExperience, "w 50%!, h 20px!, wrap");
    }

    private void removeLblExperience() {
        if (!this.lblExperience.isShowing()) {
            return;
        }
        this.avatarArea.remove(this.lblExperience);
        this.avatarArea.remove(this.lblLife);
        this.avatarArea.add((Component)this.lblLife, "w 100%!, h 20px!, wrap");
    }

    private void addLblEnergy() {
        if (this.lblEnergy.isShowing() || this.lblPoison.isShowing()) {
            return;
        }
        this.avatarArea.remove(this.lblLife);
        this.lblLife.setIcon(FSkin.getImage(FSkinProp.ICO_QUEST_LIFE));
        this.avatarArea.add((Component)this.lblLife, "w 50%!, h 20px!, split 2");
        this.avatarArea.add((Component)this.lblEnergy, "w 50%!, h 20px!, wrap");
    }

    private void removeLblEnergy() {
        if (!this.lblEnergy.isShowing()) {
            return;
        }
        this.avatarArea.remove(this.lblEnergy);
        this.avatarArea.remove(this.lblLife);
        this.avatarArea.add((Component)this.lblLife, "w 100%!, h 20px!, wrap");
    }

    private void addLblPoison() {
        if (this.lblPoison.isShowing()) {
            return;
        }
        this.avatarArea.remove(this.lblLife);
        this.lblLife.setIcon(FSkin.getImage(FSkinProp.ICO_QUEST_LIFE));
        this.avatarArea.add((Component)this.lblLife, "w 50%!, h 20px!, split 2");
        this.avatarArea.add((Component)this.lblPoison, "w 50%!, h 20px!, wrap");
    }

    private void removeLblPoison() {
        if (!this.lblPoison.isShowing()) {
            return;
        }
        this.avatarArea.remove(this.lblPoison);
        this.avatarArea.remove(this.lblLife);
        this.avatarArea.add((Component)this.lblLife, "w 100%!, h 20px!, wrap");
    }

    public void updateDetails() {
        boolean highlighted;
        int life = this.player.getLife();
        this.lblLife.setText(String.valueOf(life));
        if (life > 5) {
            this.lblLife.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        } else {
            this.lblLife.setForeground(Color.RED);
        }
        int poison = this.player.getCounters(CounterEnumType.POISON);
        int energy = this.player.getCounters(CounterEnumType.ENERGY);
        int experience = this.player.getCounters(CounterEnumType.EXPERIENCE);
        int rad = this.player.getCounters(CounterEnumType.RAD);
        int ticket = this.player.getCounters(CounterEnumType.TICKET);
        if (poison > 0) {
            this.removeLblEnergy();
            this.removeLblExperience();
            this.removeLblRad();
            this.removeLblTicket();
            this.addLblPoison();
            this.lblPoison.setText(String.valueOf(poison));
            if (poison < 8) {
                this.lblPoison.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
            } else {
                this.lblPoison.setForeground(Color.RED);
            }
        } else {
            this.removeLblPoison();
        }
        if (energy > 0) {
            this.removeLblExperience();
            this.removeLblRad();
            this.removeLblTicket();
            if (poison == 0) {
                this.addLblEnergy();
                this.lblEnergy.setText(String.valueOf(energy));
            }
        } else {
            this.removeLblEnergy();
        }
        if (experience > 0) {
            this.removeLblRad();
            this.removeLblTicket();
            if (poison == 0 && energy == 0) {
                this.addLblExperience();
                this.lblExperience.setText(String.valueOf(experience));
            }
        } else {
            this.removeLblExperience();
        }
        if (rad > 0) {
            this.removeLblTicket();
            if (poison == 0 && energy == 0 && experience == 0) {
                this.addLblRad();
                this.lblRad.setText(String.valueOf(rad));
            }
        } else {
            this.removeLblRad();
        }
        if (ticket > 0) {
            if (poison == 0 && energy == 0 && experience == 0 && rad == 0) {
                this.addLblTicket();
                this.lblTicket.setText(String.valueOf(ticket));
            }
        } else {
            this.removeLblTicket();
        }
        this.avatarArea.setBorder((highlighted = this.isHighlighted()) ? this.borderAvatarHighlighted : this.borderAvatarSimple);
        this.avatarArea.setOpaque(highlighted);
        this.avatarArea.setToolTipText(this.player.getDetailsHtml());
    }
}

