/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import forge.gui.UiCommand;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.gui.framework.ILocalRepaint;
import forge.gui.framework.IVDoc;
import forge.localinstance.skin.FSkinProp;
import forge.screens.match.controllers.CDock;
import forge.toolbox.FLabel;
import forge.toolbox.FMouseAdapter;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public class VDock
implements IVDoc<CDock> {
    final Localizer localizer = Localizer.getInstance();
    private DragCell parentCell;
    private final DragTab tab = new DragTab(this.localizer.getMessage("lblDock", new Object[0]));
    private final DockButton btnConcede = new DockButton(FSkin.getIcon(FSkinProp.ICO_CONCEDE), this.localizer.getMessage("lblConcedeGame", new Object[0]));
    private final DockButton btnSettings = new DockButton(FSkin.getIcon(FSkinProp.ICO_SETTINGS), this.localizer.getMessage("lblGameSettings", new Object[0]));
    private final DockButton btnEndTurn = new DockButton(FSkin.getIcon(FSkinProp.ICO_ENDTURN), this.localizer.getMessage("lblEndTurn", new Object[0]));
    private final DockButton btnViewDeckList = new DockButton(FSkin.getIcon(FSkinProp.ICO_DECKLIST), this.localizer.getMessage("lblViewDeckList", new Object[0]));
    private final DockButton btnRevertLayout = new DockButton(FSkin.getIcon(FSkinProp.ICO_REVERTLAYOUT), this.localizer.getMessage("lblRevertLayout", new Object[0]));
    private final DockButton btnOpenLayout = new DockButton(FSkin.getIcon(FSkinProp.ICO_OPENLAYOUT), this.localizer.getMessage("lblOpenLayout", new Object[0]));
    private final DockButton btnSaveLayout = new DockButton(FSkin.getIcon(FSkinProp.ICO_SAVELAYOUT), this.localizer.getMessage("lblSaveLayout", new Object[0]));
    private final DockButton btnAlphaStrike = new DockButton(FSkin.getIcon(FSkinProp.ICO_ALPHASTRIKE), this.localizer.getMessage("lblAlphaStrike", new Object[0]));
    private final FLabel btnTargeting = new FLabel.Builder().icon(FSkin.getIcon(FSkinProp.ICO_ARCSOFF)).hoverable(true).iconInBackground(true).iconScaleFactor(1.0).build();
    private final CDock controller;

    public VDock(CDock controller) {
        this.controller = controller;
        this.btnTargeting.setPreferredSize(new Dimension(30, 30));
        this.btnTargeting.setMinimumSize(new Dimension(30, 30));
        this.btnTargeting.setMaximumSize(new Dimension(30, 30));
    }

    @Override
    public void populate() {
        this.btnTargeting.setFocusable(false);
        JPanel pnl = this.parentCell.getBody();
        pnl.setLayout(new FlowLayout(1, 10, 10));
        pnl.add(this.btnConcede);
        pnl.add(this.btnEndTurn);
        pnl.add(this.btnViewDeckList);
        pnl.add(this.btnRevertLayout);
        pnl.add(this.btnOpenLayout);
        pnl.add(this.btnSaveLayout);
        pnl.add(this.btnAlphaStrike);
        pnl.add(this.btnTargeting);
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.BUTTON_DOCK;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CDock getLayoutControl() {
        return this.controller;
    }

    public DockButton getBtnConcede() {
        return this.btnConcede;
    }

    public DockButton getBtnSettings() {
        return this.btnSettings;
    }

    public DockButton getBtnEndTurn() {
        return this.btnEndTurn;
    }

    public DockButton getBtnViewDeckList() {
        return this.btnViewDeckList;
    }

    public DockButton getBtnRevertLayout() {
        return this.btnRevertLayout;
    }

    public DockButton getBtnOpenLayout() {
        return this.btnOpenLayout;
    }

    public DockButton getBtnSaveLayout() {
        return this.btnSaveLayout;
    }

    public DockButton getBtnAlphaStrike() {
        return this.btnAlphaStrike;
    }

    public FLabel getBtnTargeting() {
        return this.btnTargeting;
    }

    public class DockButton
    extends FSkin.SkinnedLabel
    implements ILocalRepaint {
        private final FSkin.SkinImage img;
        private final FSkin.SkinColor hoverBG = FSkin.getColor(FSkin.Colors.CLR_HOVER);
        private final Color defaultBG = new Color(0, 0, 0, 0);
        private final Color defaultBorderColor = new Color(0, 0, 0, 0);
        private UiCommand command;
        private int w;
        private int h;

        public DockButton(FSkin.SkinImage i0, String s0) {
            this.setToolTipText(s0);
            this.setOpaque(false);
            this.setBackground(this.defaultBG);
            this.img = i0;
            Dimension size = new Dimension(30, 30);
            this.setMinimumSize(size);
            this.setMaximumSize(size);
            this.setPreferredSize(size);
            this.addMouseListener(new FMouseAdapter(){

                @Override
                public void onLeftClick(MouseEvent e) {
                    if (DockButton.this.command != null) {
                        DockButton.this.command.run();
                    }
                }

                @Override
                public void onMouseEnter(MouseEvent e) {
                    DockButton.this.setBackground(DockButton.this.hoverBG);
                }

                @Override
                public void onMouseExit(MouseEvent e) {
                    DockButton.this.setBackground(DockButton.this.defaultBG);
                }
            });
        }

        public void setCommand(UiCommand command0) {
            this.command = command0;
        }

        @Override
        public void repaintSelf() {
            Dimension d = this.getSize();
            this.repaint(0, 0, d.width, d.height);
        }

        @Override
        public void paintComponent(Graphics g2) {
            this.w = this.getWidth();
            this.h = this.getHeight();
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.w, this.h);
            if (this.getSkin().getBackground() == this.hoverBG) {
                FSkin.setGraphicsColor(g2, FSkin.getColor(FSkin.Colors.CLR_BORDERS));
            } else {
                g2.setColor(this.defaultBorderColor);
            }
            g2.drawRect(0, 0, this.w - 1, this.h - 1);
            FSkin.drawImage(g2, this.img, 0, 0, this.w, this.h);
            super.paintComponent(g2);
        }
    }
}

