/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.gui.framework.IVDoc;
import forge.screens.match.controllers.CCombat;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.Component;
import net.miginfocom.swing.MigLayout;

public class VCombat
implements IVDoc<CCombat> {
    private DragCell parentCell;
    private final DragTab tab = new DragTab(Localizer.getInstance().getMessage("lblCombatTab", new Object[0]));
    private final FSkin.SkinnedTextArea tar = new FSkin.SkinnedTextArea();
    private final CCombat controller;

    public VCombat(CCombat controller) {
        this.controller = controller;
        this.tar.setOpaque(false);
        this.tar.setBorder(new FSkin.MatteSkinBorder(0, 0, 0, 0, FSkin.getColor(FSkin.Colors.CLR_BORDERS)));
        this.tar.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        this.tar.setFocusable(false);
        this.tar.setLineWrap(true);
    }

    @Override
    public void populate() {
        this.parentCell.getBody().removeAll();
        this.parentCell.getBody().setLayout(new MigLayout("insets 0, gap 0, wrap"));
        this.parentCell.getBody().add((Component)this.tar, "w 95%!, gapleft 3%, gaptop 1%, h 95%");
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.REPORT_COMBAT;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CCombat getLayoutControl() {
        return this.controller;
    }

    public void updateCombat(int cntAttackers, String desc) {
        if (!this.equals(this.parentCell.getSelected())) {
            return;
        }
        this.tab.setText(cntAttackers > 0 ? Localizer.getInstance().getMessage("lblCombatTab", new Object[0]) + " : " + cntAttackers : Localizer.getInstance().getMessage("lblCombatTab", new Object[0]));
        this.tar.setText(desc);
    }
}

