/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import forge.game.GameView;
import forge.game.card.CardView;
import forge.game.player.PlayerView;
import forge.gui.CardPicturePanel;
import forge.gui.WrapLayout;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.gui.framework.IVDoc;
import forge.screens.match.controllers.CAntes;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.util.collect.FCollectionView;
import java.awt.Component;
import java.awt.Dimension;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class VAntes
implements IVDoc<CAntes> {
    private final CAntes controller;
    private DragCell parentCell;
    private final DragTab tab = new DragTab("Ante");
    private final JPanel pnl = new JPanel();
    private final FScrollPane scroller = new FScrollPane(this.pnl, false);
    private final SortedSet<AntePanel> allAntes = new TreeSet<AntePanel>();

    public VAntes(CAntes controller) {
        this.controller = controller;
        this.pnl.setLayout(new WrapLayout());
        this.pnl.setOpaque(false);
    }

    @Override
    public void populate() {
        this.parentCell.getBody().setLayout(new MigLayout("insets 0, gap 0"));
        this.parentCell.getBody().add((Component)this.scroller, "w 100%!, h 100%!");
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.CARD_ANTES;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CAntes getLayoutControl() {
        return this.controller;
    }

    public void update() {
        this.allAntes.clear();
        this.pnl.removeAll();
        GameView gameView = this.controller.getMatchUI().getGameView();
        if (gameView == null) {
            return;
        }
        for (PlayerView p : gameView.getPlayers()) {
            FCollectionView<CardView> ante = p.getAnte();
            if (ante == null) continue;
            for (CardView c : ante) {
                AntePanel pnlTemp = new AntePanel(c);
                this.allAntes.add(pnlTemp);
                this.pnl.add(pnlTemp);
            }
        }
    }

    private class AntePanel
    extends JPanel
    implements Comparable<AntePanel> {
        private final CardView card;

        public AntePanel(CardView c) {
            this.card = c;
            Dimension d = new Dimension(160, 250);
            this.setPreferredSize(d);
            this.setMaximumSize(d);
            this.setMinimumSize(d);
            this.setOpaque(false);
            this.setLayout(new MigLayout("gap 0, insets 0, wrap"));
            this.add((Component)new FLabel.Builder().fontSize(14).text(this.card.getOwner().getName()).fontAlign(0).build(), "w 160px, h 20px");
            CardPicturePanel picPanel = new CardPicturePanel();
            this.add((Component)picPanel, "w 160px, h 230px");
            picPanel.setCard(c.getCurrentState());
        }

        @Override
        public int compareTo(AntePanel o) {
            return o.card.getId() - this.card.getId();
        }
    }
}

