/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.menus;

import com.google.common.primitives.Ints;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.menus.MenuUtil;
import forge.model.FModel;
import forge.screens.match.CMatchUI;
import forge.screens.match.VAutoYields;
import forge.screens.match.controllers.CDock;
import forge.screens.match.menus.CardOverlaysMenu;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public final class GameMenu {
    private final CMatchUI matchUI;
    private static ForgePreferences prefs = FModel.getPreferences();
    private static boolean showIcons;

    public GameMenu(CMatchUI matchUI) {
        this.matchUI = matchUI;
    }

    public JMenu getMenu() {
        Localizer localizer = Localizer.getInstance();
        JMenu menu = new JMenu(localizer.getMessage("lblGame", new Object[0]));
        menu.setMnemonic(71);
        menu.add(this.getMenuItem_Undo());
        menu.add(this.getMenuItem_Concede());
        menu.add(this.getMenuItem_EndTurn());
        menu.add(this.getMenuItem_AlphaStrike());
        menu.addSeparator();
        menu.add(this.getMenuItem_TargetingArcs());
        menu.add(new CardOverlaysMenu(this.matchUI).getMenu());
        menu.add(this.getMenuItem_AutoYields());
        menu.addSeparator();
        menu.add(this.getMenuItem_ViewDeckList());
        menu.addSeparator();
        menu.add(GameMenu.getMenuItem_GameSoundEffects());
        return menu;
    }

    private static FSkin.SkinnedCheckBoxMenuItem getMenuItem_GameSoundEffects() {
        Localizer localizer = Localizer.getInstance();
        FSkin.SkinnedCheckBoxMenuItem menuItem = new FSkin.SkinnedCheckBoxMenuItem(localizer.getMessage("lblSoundEffects", new Object[0]));
        menuItem.setState(prefs.getPrefBoolean(ForgePreferences.FPref.UI_ENABLE_SOUNDS));
        menuItem.addActionListener(GameMenu.getSoundEffectsAction());
        return menuItem;
    }

    private static ActionListener getSoundEffectsAction() {
        return e -> GameMenu.toggleGameSoundEffects();
    }

    private static void toggleGameSoundEffects() {
        boolean isSoundEffectsEnabled = !prefs.getPrefBoolean(ForgePreferences.FPref.UI_ENABLE_SOUNDS);
        prefs.setPref(ForgePreferences.FPref.UI_ENABLE_SOUNDS, isSoundEffectsEnabled);
        prefs.save();
    }

    private FSkin.SkinnedMenuItem getMenuItem_Undo() {
        Localizer localizer = Localizer.getInstance();
        FSkin.SkinnedMenuItem menuItem = new FSkin.SkinnedMenuItem(localizer.getMessage("lblUndo", new Object[0]));
        menuItem.setAccelerator(MenuUtil.getAcceleratorKey(90));
        menuItem.addActionListener(this.getUndoAction());
        return menuItem;
    }

    private ActionListener getUndoAction() {
        return e -> this.matchUI.getGameController().undoLastAction();
    }

    private FSkin.SkinnedMenuItem getMenuItem_Concede() {
        FSkin.SkinnedMenuItem menuItem = new FSkin.SkinnedMenuItem(this.matchUI.getConcedeCaption());
        menuItem.setIcon(showIcons ? MenuUtil.getMenuIcon(FSkinProp.ICO_CONCEDE) : null);
        menuItem.setAccelerator(MenuUtil.getAcceleratorKey(81));
        menuItem.addActionListener(this.getConcedeAction());
        return menuItem;
    }

    private ActionListener getConcedeAction() {
        return e -> this.matchUI.concede();
    }

    private FSkin.SkinnedMenuItem getMenuItem_AlphaStrike() {
        Localizer localizer = Localizer.getInstance();
        FSkin.SkinnedMenuItem menuItem = new FSkin.SkinnedMenuItem(localizer.getMessage("lblAlphaStrike", new Object[0]));
        menuItem.setIcon(showIcons ? MenuUtil.getMenuIcon(FSkinProp.ICO_ALPHASTRIKE) : null);
        menuItem.setAccelerator(MenuUtil.getAcceleratorKey(65));
        menuItem.addActionListener(this.getAlphaStrikeAction());
        return menuItem;
    }

    private ActionListener getAlphaStrikeAction() {
        return e -> this.matchUI.getGameController().alphaStrike();
    }

    private FSkin.SkinnedMenuItem getMenuItem_EndTurn() {
        Localizer localizer = Localizer.getInstance();
        FSkin.SkinnedMenuItem menuItem = new FSkin.SkinnedMenuItem(localizer.getMessage("lblEndTurn", new Object[0]));
        menuItem.setIcon(showIcons ? MenuUtil.getMenuIcon(FSkinProp.ICO_ENDTURN) : null);
        menuItem.setAccelerator(MenuUtil.getAcceleratorKey(69));
        menuItem.addActionListener(this.getEndTurnAction());
        return menuItem;
    }

    private ActionListener getEndTurnAction() {
        return e -> this.matchUI.getGameController().passPriorityUntilEndOfTurn();
    }

    private FSkin.SkinnedMenu getMenuItem_TargetingArcs() {
        FSkin.SkinnedRadioButtonMenuItem menuItem;
        Localizer localizer = Localizer.getInstance();
        FSkin.SkinnedMenu menu = new FSkin.SkinnedMenu(localizer.getMessage("lblTargetingArcs", new Object[0]));
        ButtonGroup group = new ButtonGroup();
        FSkin.SkinIcon menuIcon = MenuUtil.getMenuIcon(FSkinProp.ICO_ARCSOFF);
        if (this.matchUI.getCDock().getArcState() == null) {
            String arcStateStr = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_TARGETING_OVERLAY);
            Integer arcState = Ints.tryParse(arcStateStr);
            this.matchUI.getCDock().setArcState(CDock.ArcState.values()[arcState == null ? 0 : arcState]);
        }
        if ((menuItem = this.getTargetingArcRadioButton(localizer.getMessage("lblOff", new Object[0]), FSkinProp.ICO_ARCSOFF, CDock.ArcState.OFF)).isSelected()) {
            menuIcon = MenuUtil.getMenuIcon(FSkinProp.ICO_ARCSOFF);
        }
        group.add(menuItem);
        menu.add(menuItem);
        menuItem = this.getTargetingArcRadioButton(localizer.getMessage("lblCardMouseOver", new Object[0]), FSkinProp.ICO_ARCSHOVER, CDock.ArcState.MOUSEOVER);
        if (menuItem.isSelected()) {
            menuIcon = MenuUtil.getMenuIcon(FSkinProp.ICO_ARCSHOVER);
        }
        group.add(menuItem);
        menu.add(menuItem);
        menuItem = this.getTargetingArcRadioButton(localizer.getMessage("lblAlwaysOn", new Object[0]), FSkinProp.ICO_ARCSON, CDock.ArcState.ON);
        if (menuItem.isSelected()) {
            menuIcon = MenuUtil.getMenuIcon(FSkinProp.ICO_ARCSON);
        }
        group.add(menuItem);
        menu.setIcon(showIcons ? menuIcon : null);
        menu.add(menuItem);
        return menu;
    }

    private FSkin.SkinnedRadioButtonMenuItem getTargetingArcRadioButton(String caption, FSkinProp icon, CDock.ArcState arcState) {
        FSkin.SkinnedRadioButtonMenuItem menuItem = new FSkin.SkinnedRadioButtonMenuItem(caption);
        menuItem.setIcon(showIcons ? MenuUtil.getMenuIcon(icon) : null);
        menuItem.setSelected(arcState == this.matchUI.getCDock().getArcState());
        menuItem.addActionListener(this.getTargetingRadioButtonAction(arcState));
        return menuItem;
    }

    private ActionListener getTargetingRadioButtonAction(CDock.ArcState arcState) {
        return e -> {
            prefs.setPref(ForgePreferences.FPref.UI_TARGETING_OVERLAY, String.valueOf(arcState.ordinal()));
            prefs.save();
            this.matchUI.getCDock().setArcState(arcState);
            GameMenu.setTargetingArcMenuIcon((FSkin.SkinnedRadioButtonMenuItem)e.getSource());
        };
    }

    private static void setTargetingArcMenuIcon(FSkin.SkinnedRadioButtonMenuItem item) {
        JPopupMenu pop = (JPopupMenu)item.getParent();
        JMenu menu = (JMenu)pop.getInvoker();
        menu.setIcon(item.getIcon());
    }

    private FSkin.SkinnedMenuItem getMenuItem_AutoYields() {
        Localizer localizer = Localizer.getInstance();
        FSkin.SkinnedMenuItem menuItem = new FSkin.SkinnedMenuItem(localizer.getMessage("lblAutoYields", new Object[0]));
        menuItem.setIcon(showIcons ? MenuUtil.getMenuIcon(FSkinProp.ICO_WARNING) : null);
        menuItem.addActionListener(this.getAutoYieldsAction());
        return menuItem;
    }

    private ActionListener getAutoYieldsAction() {
        return e -> {
            VAutoYields autoYields = new VAutoYields(this.matchUI);
            autoYields.showAutoYields();
        };
    }

    private FSkin.SkinnedMenuItem getMenuItem_ViewDeckList() {
        Localizer localizer = Localizer.getInstance();
        FSkin.SkinnedMenuItem menuItem = new FSkin.SkinnedMenuItem(localizer.getMessage("lblDeckList", new Object[0]));
        menuItem.setIcon(showIcons ? MenuUtil.getMenuIcon(FSkinProp.ICO_DECKLIST) : null);
        menuItem.addActionListener(this.getViewDeckListAction());
        return menuItem;
    }

    private ActionListener getViewDeckListAction() {
        return e -> this.matchUI.viewDeckList();
    }
}

