/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.menus;

import forge.menus.MenuUtil;
import forge.screens.match.controllers.CDev;
import forge.screens.match.views.IDevListener;
import forge.util.Localizer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class DevModeMenu
implements ActionListener,
IDevListener {
    private CDev controller;
    private JCheckBoxMenuItem playUnlimitedLands = null;
    private JCheckBoxMenuItem viewAll = null;

    public DevModeMenu(CDev controller) {
        this.controller = controller;
        controller.addListener(this);
    }

    @Override
    public void update(boolean playUnlimitedLands, boolean mayViewAllCards) {
        if (this.playUnlimitedLands != null && this.viewAll != null) {
            this.playUnlimitedLands.setSelected(playUnlimitedLands);
            this.viewAll.setSelected(mayViewAllCards);
        }
    }

    public JMenu getMenu() {
        JMenu menu = new JMenu(Localizer.getInstance().getMessage("lblDev", new Object[0]));
        menu.setMnemonic(68);
        menu.add(this.getMenuItem(DevMenuItem.GENERATE_MANA));
        menu.add(this.getMenuItem(DevMenuItem.TUTOR_FOR_CARD));
        menu.addSeparator();
        menu.add(this.getMenuItem(DevMenuItem.ADD_CARD_TO_HAND));
        menu.add(this.getMenuItem(DevMenuItem.ADD_CARD_TO_PLAY));
        menu.add(this.getMenuItem(DevMenuItem.EXILE_FROM_HAND));
        menu.add(this.getMenuItem(DevMenuItem.EXILE_FROM_PLAY));
        menu.addSeparator();
        menu.add(this.getMenuItem(DevMenuItem.SET_PLAYER_LIFE));
        menu.add(this.getMenuItem(DevMenuItem.WIN_GAME));
        menu.addSeparator();
        menu.add(this.getMenuItem(DevMenuItem.SETUP_GAME_STATE));
        menu.add(this.getMenuItem(DevMenuItem.DUMP_GAME_STATE));
        menu.addSeparator();
        this.playUnlimitedLands = this.getCheckboxMenuItem(DevMenuItem.PLAY_UNLIMITED_LANDS);
        menu.add(this.playUnlimitedLands);
        this.viewAll = this.getCheckboxMenuItem(DevMenuItem.VIEW_ALL);
        menu.add(this.viewAll);
        menu.add(this.getMenuItem(DevMenuItem.ADD_COUNTER));
        menu.addSeparator();
        menu.add(this.getMenuItem(DevMenuItem.TAP_PERMANENT));
        menu.add(this.getMenuItem(DevMenuItem.UNTAP_PERMANENT));
        menu.addSeparator();
        menu.add(this.getMenuItem(DevMenuItem.RIGGED_PLANAR_ROLL));
        menu.add(this.getMenuItem(DevMenuItem.PLANESWALK_TO));
        menu.addSeparator();
        menu.add(this.getMenuItem(DevMenuItem.DEV_CORNER));
        return menu;
    }

    private JMenuItem getMenuItem(DevMenuItem m4) {
        JMenuItem menuItem = new JMenuItem(m4.caption);
        menuItem.addActionListener(this);
        return menuItem;
    }

    private JCheckBoxMenuItem getCheckboxMenuItem(DevMenuItem m4) {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(m4.caption);
        menuItem.addActionListener(this);
        return menuItem;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (DevMenuItem.getValue(e.getActionCommand())) {
            case GENERATE_MANA: {
                this.controller.generateMana();
                break;
            }
            case TUTOR_FOR_CARD: {
                this.controller.tutorForCard();
                break;
            }
            case ADD_CARD_TO_HAND: {
                this.controller.addCardToHand();
                break;
            }
            case ADD_CARD_TO_PLAY: {
                this.controller.addCardToBattlefield();
                break;
            }
            case EXILE_FROM_PLAY: {
                this.controller.exileCardsFromPlay();
                break;
            }
            case EXILE_FROM_HAND: {
                this.controller.exileCardsFromHand();
                break;
            }
            case SET_PLAYER_LIFE: {
                this.controller.setPlayerLife();
                break;
            }
            case WIN_GAME: {
                this.controller.winGame();
                break;
            }
            case SETUP_GAME_STATE: {
                this.controller.setupGameState();
                break;
            }
            case DUMP_GAME_STATE: {
                this.controller.dumpGameState();
                break;
            }
            case PLAY_UNLIMITED_LANDS: {
                this.controller.togglePlayManyLandsPerTurn();
                break;
            }
            case VIEW_ALL: {
                this.controller.toggleViewAllCards();
                break;
            }
            case ADD_COUNTER: {
                this.controller.addCounterToPermanent();
                break;
            }
            case TAP_PERMANENT: {
                this.controller.tapPermanent();
                break;
            }
            case UNTAP_PERMANENT: {
                this.controller.untapPermanent();
                break;
            }
            case RIGGED_PLANAR_ROLL: {
                this.controller.riggedPlanerRoll();
                break;
            }
            case PLANESWALK_TO: {
                this.controller.planeswalkTo();
                break;
            }
            case DEV_CORNER: {
                DevModeMenu.openDevForumInBrowser();
                break;
            }
        }
    }

    private static void openDevForumInBrowser() {
        MenuUtil.openUrlInBrowser("http://www.slightlymagic.net/forum/viewforum.php?f=52");
    }

    private static enum DevMenuItem {
        GENERATE_MANA("lblGenerateMana"),
        TUTOR_FOR_CARD("lblTutor"),
        ADD_CARD_TO_HAND("lblCardToHand"),
        ADD_CARD_TO_PLAY("lblCastSpellOrPlayLand"),
        EXILE_FROM_HAND("lblExileFromHand"),
        EXILE_FROM_PLAY("lblExileFromPlay"),
        SET_PLAYER_LIFE("lblSetLife"),
        WIN_GAME("lblWinGame"),
        SETUP_GAME_STATE("lblSetupGame"),
        DUMP_GAME_STATE("lblDumpGame"),
        PLAY_UNLIMITED_LANDS("lblUnlimitedLands"),
        VIEW_ALL("lblViewAll"),
        ADD_COUNTER("lblAddCounterPermanent"),
        TAP_PERMANENT("lblTapPermanent"),
        UNTAP_PERMANENT("lblUntapPermanent"),
        RIGGED_PLANAR_ROLL("lblRiggedRoll"),
        PLANESWALK_TO("lblWalkTo"),
        DEV_CORNER("lblDeveloperCorner");

        protected String caption;

        private DevMenuItem(String value) {
            this.caption = Localizer.getInstance().getMessage(value, new Object[0]);
        }

        protected static DevMenuItem getValue(String s2) {
            for (DevMenuItem t2 : DevMenuItem.values()) {
                if (t2.caption != s2) continue;
                return t2;
            }
            return null;
        }
    }
}

