/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.menus;

import forge.localinstance.properties.ForgePreferences;
import forge.menus.MenuUtil;
import forge.model.FModel;
import forge.screens.match.CMatchUI;
import forge.util.Localizer;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public final class CardOverlaysMenu {
    private final CMatchUI matchUI;
    private static ForgePreferences prefs = FModel.getPreferences();
    private static boolean showOverlays = prefs.getPrefBoolean(ForgePreferences.FPref.UI_SHOW_CARD_OVERLAYS);

    public CardOverlaysMenu(CMatchUI matchUI) {
        this.matchUI = matchUI;
    }

    public JMenu getMenu() {
        JMenu menu = new JMenu(Localizer.getInstance().getMessage("lblCardOverlays", new Object[0]));
        menu.add(this.getMenuItem_ShowOverlays());
        menu.addSeparator();
        menu.add(this.getMenuItem_CardOverlay(Localizer.getInstance().getMessage("lblCardName", new Object[0]), ForgePreferences.FPref.UI_OVERLAY_CARD_NAME));
        menu.add(this.getMenuItem_CardOverlay(Localizer.getInstance().getMessage("lblManaCost", new Object[0]), ForgePreferences.FPref.UI_OVERLAY_CARD_MANA_COST));
        menu.add(this.getMenuItem_CardOverlay(Localizer.getInstance().getMessage("lblPowerOrToughness", new Object[0]), ForgePreferences.FPref.UI_OVERLAY_CARD_POWER));
        menu.add(this.getMenuItem_CardOverlay(Localizer.getInstance().getMessage("lblCardID", new Object[0]), ForgePreferences.FPref.UI_OVERLAY_CARD_ID));
        menu.add(this.getMenuItem_CardOverlay(Localizer.getInstance().getMessage("lblAbilityIcon", new Object[0]), ForgePreferences.FPref.UI_OVERLAY_ABILITY_ICONS));
        return menu;
    }

    private JMenuItem getMenuItem_CardOverlay(String menuCaption, ForgePreferences.FPref pref) {
        JCheckBoxMenuItem menu = new JCheckBoxMenuItem(menuCaption);
        menu.setState(prefs.getPrefBoolean(pref));
        menu.setEnabled(showOverlays);
        menu.addActionListener(this.getCardOverlaysAction(pref));
        return menu;
    }

    private JMenuItem getMenuItem_ShowOverlays() {
        JCheckBoxMenuItem menu = new JCheckBoxMenuItem(Localizer.getInstance().getMessage("lblShow", new Object[0]));
        menu.setAccelerator(MenuUtil.getAcceleratorKey(79));
        menu.setState(prefs.getPrefBoolean(ForgePreferences.FPref.UI_SHOW_CARD_OVERLAYS));
        menu.addActionListener(this.getShowOverlaysAction());
        return menu;
    }

    private ActionListener getShowOverlaysAction() {
        return e -> this.toggleCardOverlayDisplay((JMenuItem)e.getSource());
    }

    private void toggleCardOverlayDisplay(JMenuItem showMenu) {
        CardOverlaysMenu.toggleShowOverlaySetting();
        this.repaintCardOverlays();
        for (Component c : showMenu.getParent().getComponents()) {
            JMenuItem m4;
            if (!(c instanceof JMenuItem) || (m4 = (JMenuItem)c) == showMenu) continue;
            m4.setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.UI_SHOW_CARD_OVERLAYS));
        }
    }

    private static void toggleShowOverlaySetting() {
        boolean isOverlayEnabled = !prefs.getPrefBoolean(ForgePreferences.FPref.UI_SHOW_CARD_OVERLAYS);
        prefs.setPref(ForgePreferences.FPref.UI_SHOW_CARD_OVERLAYS, isOverlayEnabled);
        prefs.save();
    }

    private ActionListener getCardOverlaysAction(ForgePreferences.FPref overlaySetting) {
        return e -> {
            CardOverlaysMenu.toggleOverlaySetting(overlaySetting);
            this.repaintCardOverlays();
        };
    }

    private static void toggleOverlaySetting(ForgePreferences.FPref overlaySetting) {
        boolean isOverlayEnabled = !prefs.getPrefBoolean(overlaySetting);
        prefs.setPref(overlaySetting, isOverlayEnabled);
        prefs.save();
    }

    private void repaintCardOverlays() {
        SwingUtilities.invokeLater(this.matchUI::repaintCardOverlays);
    }
}

