/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.controllers;

import forge.game.GameView;
import forge.game.card.CardView;
import forge.gui.FThreads;
import forge.gui.framework.ICDoc;
import forge.gui.framework.SDisplayUtil;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.match.CMatchUI;
import forge.screens.match.views.VPrompt;
import forge.toolbox.FSkin;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;

public class CPrompt
implements ICDoc {
    private final CMatchUI matchUI;
    private final VPrompt view;
    private Component lastFocusedButton = null;
    private final ActionListener actCancel = evt -> this.selectButtonCancel();
    private final ActionListener actOK = evt -> this.selectButtonOk();
    private final WindowAdapter focusOKButtonOnDialogClose = new WindowAdapter(){

        @Override
        public void windowClosed(WindowEvent evt) {
            CPrompt.this.view.getBtnOK().requestFocusInWindow();
        }
    };
    private final PropertyChangeListener focusOnEnable = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (CPrompt.this.lastFocusedButton == null || CPrompt.this.lastFocusedButton == CPrompt.this.view.getBtnOK()) {
                boolean isEnabled;
                Dialog activeDialog = CPrompt.getActiveDialog(true);
                if (activeDialog != null) {
                    activeDialog.removeWindowListener(CPrompt.this.focusOKButtonOnDialogClose);
                    activeDialog.addWindowListener(CPrompt.this.focusOKButtonOnDialogClose);
                }
                if (isEnabled = ((Boolean)evt.getNewValue()).booleanValue()) {
                    CPrompt.this.view.getBtnOK().requestFocusInWindow();
                }
            }
        }
    };
    private final FocusListener onFocus = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            if (null != CPrompt.this.view.getParentCell() && CPrompt.this.view == CPrompt.this.view.getParentCell().getSelected()) {
                CPrompt.this.lastFocusedButton = e.getComponent();
            }
        }
    };

    public CPrompt(CMatchUI matchUI) {
        this.matchUI = matchUI;
        this.view = new VPrompt(this);
    }

    public final CMatchUI getMatchUI() {
        return this.matchUI;
    }

    public final VPrompt getView() {
        return this.view;
    }

    private void _initButton(JButton button, ActionListener onClick) {
        button.removeActionListener(onClick);
        button.addActionListener(onClick);
        button.removeFocusListener(this.onFocus);
        button.addFocusListener(this.onFocus);
        if (button == this.view.getBtnOK()) {
            button.removePropertyChangeListener("enabled", this.focusOnEnable);
            button.addPropertyChangeListener("enabled", this.focusOnEnable);
        }
    }

    @Override
    public void initialize() {
        this._initButton(this.view.getBtnCancel(), this.actCancel);
        this._initButton(this.view.getBtnOK(), this.actOK);
    }

    private static Dialog getActiveDialog(boolean modalOnly) {
        Window[] windows = Window.getWindows();
        if (windows != null) {
            for (Window w : windows) {
                if (!w.isShowing() || !(w instanceof Dialog) || modalOnly && !((Dialog)w).isModal()) continue;
                return (Dialog)w;
            }
        }
        return null;
    }

    private void selectButtonOk() {
        this.matchUI.getGameController().selectButtonOk();
    }

    private void selectButtonCancel() {
        this.matchUI.getGameController().selectButtonCancel();
    }

    public void setMessage(String header) {
        this.view.getTarMessage().setText(FSkin.encodeSymbols(header, false));
        this.view.setCardView(null);
    }

    public void setMessage(String s0, CardView card) {
        this.view.getTarMessage().setText(FSkin.encodeSymbols(s0, false));
        this.view.setCardView(card);
    }

    public void remind() {
        SDisplayUtil.remind(this.view);
    }

    public void alert() {
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_REMIND_ON_PRIORITY)) {
            SDisplayUtil.remind(this.view, 15, 30);
        }
    }

    @Override
    public void register() {
    }

    @Override
    public void update() {
        if (null != this.lastFocusedButton) {
            this.lastFocusedButton.requestFocusInWindow();
        }
    }

    public void updateText() {
        FThreads.assertExecutedByEdt(true);
        GameView game = this.matchUI.getGameView();
        if (game == null) {
            return;
        }
        String text = String.format("T:%d G:%d/%d [%s]", new Object[]{game.getTurn(), game.getNumPlayedGamesInMatch() + 1, game.getNumGamesInMatch(), game.getGameType()});
        this.view.getLblGames().setText(text);
        this.view.getLblGames().setToolTipText(String.format("%s: Game #%d of %d, turn %d", new Object[]{game.getGameType(), game.getNumPlayedGamesInMatch() + 1, game.getNumGamesInMatch(), game.getTurn()}));
    }
}

