/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.controllers;

import forge.game.card.CardView;
import forge.gui.CardPicturePanel;
import forge.gui.framework.ICDoc;
import forge.item.InventoryItem;
import forge.screens.match.controllers.CDetailPicture;
import forge.screens.match.views.VPicture;
import forge.toolbox.FMouseAdapter;
import forge.toolbox.special.CardZoomer;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;

public class CPicture
implements ICDoc {
    private final CDetailPicture controller;
    private final VPicture view;
    private final CardPicturePanel picturePanel;
    private final JLabel flipIndicator;
    private final CardZoomer zoomer = CardZoomer.SINGLETON_INSTANCE;

    CPicture(CDetailPicture controller) {
        this.controller = controller;
        this.view = new VPicture(this);
        this.picturePanel = this.view.getPnlPicture();
        this.flipIndicator = this.view.getLblFlipcard();
        this.setMouseWheelListener();
        this.setMouseButtonListener();
    }

    public VPicture getView() {
        return this.view;
    }

    void showCard(CardView c, boolean isInAltState, boolean mayView, boolean mayFlip) {
        CardView.CardStateView toShow = c != null && mayView ? c.getState(isInAltState) : null;
        this.flipIndicator.setVisible(toShow != null && mayFlip);
        this.picturePanel.setCard(toShow, mayView);
        this.zoomer.setCard(toShow, mayFlip);
    }

    void showItem(InventoryItem item) {
        this.flipIndicator.setVisible(false);
        this.picturePanel.setItem(item);
    }

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
    }

    private void setMouseButtonListener() {
        this.picturePanel.addMouseListener(new FMouseAdapter(){

            @Override
            public void onLeftClick(MouseEvent e) {
                CPicture.this.controller.flip();
            }

            @Override
            public void onMiddleMouseDown(MouseEvent e) {
                if (CPicture.this.isCardDisplayed()) {
                    CPicture.this.zoomer.doMouseButtonZoom();
                }
            }

            @Override
            public void onMiddleMouseUp(MouseEvent e) {
                if (CPicture.this.isCardDisplayed()) {
                    CPicture.this.zoomer.closeZoomer();
                }
            }
        });
    }

    private void setMouseWheelListener() {
        this.picturePanel.addMouseWheelListener(arg0 -> {
            if (this.isCardDisplayed() && arg0.getWheelRotation() < 0) {
                this.zoomer.doMouseWheelZoom();
            }
        });
    }

    private boolean isCardDisplayed() {
        return this.controller.getCurrentCard() != null;
    }

    @Override
    public void update() {
    }
}

