/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.controllers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import forge.Singletons;
import forge.game.card.CardView;
import forge.game.player.PlayerView;
import forge.gui.FThreads;
import forge.gui.framework.ICDoc;
import forge.screens.match.CMatchUI;
import forge.screens.match.views.VField;
import forge.screens.match.views.VHand;
import forge.view.arcane.CardPanel;
import forge.view.arcane.HandArea;
import forge.view.arcane.util.Animation;
import forge.view.arcane.util.CardPanelMouseAdapter;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;

public class CHand
implements ICDoc {
    private final CMatchUI matchUI;
    private final PlayerView player;
    private final VHand view;
    private final List<CardView> ordering = Lists.newArrayList();

    public CHand(final CMatchUI matchUI, final PlayerView p0, VHand v0) {
        this.matchUI = matchUI;
        this.player = p0;
        this.view = v0;
        v0.getHandArea().addCardPanelMouseListener(new CardPanelMouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseDragEnd(CardPanel dragPanel, MouseEvent evt) {
                int index = CHand.this.view.getHandArea().getCardPanels().indexOf(dragPanel);
                List list = CHand.this.ordering;
                synchronized (list) {
                    CHand.this.ordering.remove(dragPanel.getCard());
                    CHand.this.ordering.add(index, dragPanel.getCard());
                    matchUI.getGameController(p0).reorderHand(dragPanel.getCard(), index);
                }
            }
        });
    }

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHand() {
        Object object;
        ImmutableList<Object> cards;
        FThreads.assertExecutedByEdt(true);
        HandArea p = this.view.getHandArea();
        VField vf = this.matchUI.getFieldViewFor(this.player);
        if (vf == null) {
            return;
        }
        Rectangle rctLibraryLabel = vf.getDetailsPanel().getLblLibrary().getBounds();
        if (rctLibraryLabel.isEmpty()) {
            return;
        }
        if (!this.matchUI.isCurrentScreen()) {
            return;
        }
        if (this.player.getHand() == null) {
            cards = ImmutableList.of();
        } else {
            object = this.player;
            synchronized (object) {
                cards = ImmutableList.copyOf(this.player.getHand());
            }
        }
        object = this.ordering;
        synchronized (object) {
            this.ordering.clear();
            this.ordering.addAll(cards);
        }
        ArrayList<CardPanel> placeholders = new ArrayList<CardPanel>();
        ArrayList<CardPanel> cardPanels = new ArrayList<CardPanel>();
        for (CardView card : this.ordering) {
            CardPanel cardPanel = p.getCardPanel(card.getId());
            if (cardPanel == null) {
                cardPanel = new CardPanel(this.matchUI, card);
                cardPanel.setDisplayEnabled(false);
                placeholders.add(cardPanel);
            } else {
                cardPanel.setCard(card);
            }
            cardPanels.add(cardPanel);
        }
        p.setCardPanels(cardPanels);
        JLayeredPane layeredPane = Singletons.getView().getFrame().getLayeredPane();
        int fromZoneX = 0;
        int fromZoneY = 0;
        Point zoneLocation = SwingUtilities.convertPoint(vf.getDetailsPanel().getLblLibrary(), Math.round((float)rctLibraryLabel.width / 2.0f), Math.round((float)rctLibraryLabel.height / 2.0f), layeredPane);
        fromZoneX = zoneLocation.x;
        fromZoneY = zoneLocation.y;
        int startWidth = 10;
        int startX = fromZoneX - Math.round((float)startWidth / 2.0f);
        int startY = fromZoneY - Math.round((float)Math.round((float)startWidth * 1.4f) / 2.0f);
        for (CardPanel placeholder : placeholders) {
            int endWidth = placeholder.getCardWidth();
            Point toPos = SwingUtilities.convertPoint(this.view.getHandArea(), placeholder.getCardLocation(), layeredPane);
            int endX = toPos.x;
            int endY = toPos.y;
            if (Singletons.getView().getFrame().isShowing()) {
                CardPanel animationPanel = new CardPanel(this.matchUI, placeholder.getCard());
                Animation.moveCard(startX, startY, startWidth, endX, endY, endWidth, animationPanel, placeholder, layeredPane, 500);
                continue;
            }
            Animation.moveCard(placeholder);
        }
    }

    @Override
    public void update() {
        this.updateHand();
    }
}

