/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.controllers;

import com.google.common.base.Function;
import forge.game.player.PlayerView;
import forge.game.zone.ZoneType;
import forge.gamemodes.match.input.Input;
import forge.gamemodes.match.input.InputPayMana;
import forge.gui.framework.ICDoc;
import forge.player.PlayerControllerHuman;
import forge.screens.match.CMatchUI;
import forge.screens.match.ZoneAction;
import forge.screens.match.views.VField;
import forge.toolbox.MouseTriggerEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class CField
implements ICDoc {
    private final CMatchUI matchUI;
    private final PlayerView player;
    private final VField view;
    private boolean initializedAlready = false;
    private final MouseListener madAvatar = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            CField.this.matchUI.getGameController().selectPlayer(CField.this.player, new MouseTriggerEvent(e));
        }
    };

    public CField(CMatchUI matchUI, PlayerView player0, VField v0) {
        this.matchUI = matchUI;
        this.player = player0;
        this.view = v0;
        ZoneAction handAction = new ZoneAction(matchUI, this.player, ZoneType.Hand);
        ZoneAction libraryAction = new ZoneAction(matchUI, this.player, ZoneType.Library);
        ZoneAction exileAction = new ZoneAction(matchUI, this.player, ZoneType.Exile);
        ZoneAction graveAction = new ZoneAction(matchUI, this.player, ZoneType.Graveyard);
        ZoneAction flashBackAction = new ZoneAction(matchUI, this.player, ZoneType.Flashback);
        ZoneAction commandAction = new ZoneAction(matchUI, this.player, ZoneType.Command);
        ZoneAction anteAction = new ZoneAction(matchUI, this.player, ZoneType.Ante);
        ZoneAction sideboardAction = new ZoneAction(matchUI, this.player, ZoneType.Sideboard);
        Function manaAction = colorCode -> {
            PlayerControllerHuman controller;
            Input ipm;
            if (matchUI.getGameController() instanceof PlayerControllerHuman && (ipm = (controller = (PlayerControllerHuman)matchUI.getGameController()).getInputQueue().getInput()) instanceof InputPayMana && ipm.getOwner().equals(this.player)) {
                int oldMana = this.player.getMana((byte)colorCode);
                controller.useMana((byte)colorCode);
                return oldMana != this.player.getMana((byte)colorCode);
            }
            return Boolean.FALSE;
        };
        this.view.getDetailsPanel().setupMouseActions(handAction, libraryAction, exileAction, graveAction, flashBackAction, commandAction, anteAction, sideboardAction, manaAction);
    }

    public final CMatchUI getMatchUI() {
        return this.matchUI;
    }

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        if (this.initializedAlready) {
            return;
        }
        this.initializedAlready = true;
        this.view.getAvatarArea().addMouseListener(this.madAvatar);
    }

    @Override
    public void update() {
    }
}

