/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.controllers;

import com.google.common.collect.Iterators;
import com.google.common.primitives.Ints;
import forge.Singletons;
import forge.gui.SOverlayUtils;
import forge.gui.framework.ICDoc;
import forge.gui.framework.SLayoutIO;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.screens.match.CMatchUI;
import forge.screens.match.views.VDock;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.util.Iterator;

public class CDock
implements ICDoc {
    private ArcState arcState;
    private final Iterator<ArcState> arcStateIterator = Iterators.cycle(ArcState.values());
    private final CMatchUI matchUI;
    private final VDock view;

    public CDock(CMatchUI matchUI) {
        this.matchUI = matchUI;
        this.view = new VDock(this);
    }

    public VDock getView() {
        return this.view;
    }

    public void endTurn() {
        this.matchUI.getGameController().passPriorityUntilEndOfTurn();
    }

    public ArcState getArcState() {
        return this.arcState;
    }

    private void refreshArcStateDisplay() {
        switch (this.arcState) {
            case OFF: {
                this.view.getBtnTargeting().setToolTipText(Localizer.getInstance().getMessage("lblTargetingArcsOff", new Object[0]));
                this.view.getBtnTargeting().setIcon(FSkin.getIcon(FSkinProp.ICO_ARCSOFF));
                this.view.getBtnTargeting().repaintSelf();
                break;
            }
            case MOUSEOVER: {
                this.view.getBtnTargeting().setToolTipText(Localizer.getInstance().getMessage("lblTargetingArcsCardMouseover", new Object[0]));
                this.view.getBtnTargeting().setIcon(FSkin.getIcon(FSkinProp.ICO_ARCSHOVER));
                this.view.getBtnTargeting().repaintSelf();
                break;
            }
            case ON: {
                this.view.getBtnTargeting().setToolTipText(Localizer.getInstance().getMessage("lblTargetingArcsAlwaysOn", new Object[0]));
                this.view.getBtnTargeting().setIcon(FSkin.getIcon(FSkinProp.ICO_ARCSON));
                this.view.getBtnTargeting().repaintSelf();
            }
        }
        FModel.getPreferences().setPref(ForgePreferences.FPref.UI_TARGETING_OVERLAY, String.valueOf(this.arcState.ordinal()));
        FModel.getPreferences().save();
    }

    public void toggleTargeting() {
        this.arcState = this.arcStateIterator.next();
        this.refreshArcStateDisplay();
        Singletons.getView().getFrame().repaint();
    }

    public void setArcState(ArcState state) {
        this.arcState = state;
        while (this.arcStateIterator.next() != this.arcState) {
        }
    }

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        String temp = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_TARGETING_OVERLAY);
        Integer arcState = Ints.tryParse(temp);
        this.setArcState(ArcState.values()[arcState == null ? 0 : arcState]);
        this.refreshArcStateDisplay();
        this.view.getBtnConcede().setCommand(this.matchUI::concede);
        this.view.getBtnSettings().setCommand(SOverlayUtils::showOverlay);
        this.view.getBtnEndTurn().setCommand(this::endTurn);
        this.view.getBtnViewDeckList().setCommand(this.matchUI::viewDeckList);
        this.view.getBtnRevertLayout().setCommand(SLayoutIO::revertLayout);
        this.view.getBtnOpenLayout().setCommand(SLayoutIO::openLayout);
        this.view.getBtnSaveLayout().setCommand(SLayoutIO::saveLayout);
        this.view.getBtnAlphaStrike().setCommand(() -> this.matchUI.getGameController().alphaStrike());
        this.view.getBtnTargeting().setCommand(this::toggleTargeting);
    }

    @Override
    public void update() {
    }

    public static enum ArcState {
        OFF,
        MOUSEOVER,
        ON;

    }
}

