/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.controllers;

import com.google.common.collect.Lists;
import forge.gui.framework.ICDoc;
import forge.interfaces.IGameController;
import forge.screens.match.CMatchUI;
import forge.screens.match.views.IDevListener;
import forge.screens.match.views.VDev;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;

public final class CDev
implements ICDoc {
    private final CMatchUI matchUI;
    private final VDev view;
    private final List<IDevListener> listeners = Lists.newArrayListWithCapacity(2);

    public CDev(CMatchUI matchUI) {
        this.matchUI = matchUI;
        this.view = new VDev(this);
        this.addListener(this.view);
        this.view.getLblUnlimitedLands().addMouseListener(this.onClick(this::togglePlayManyLandsPerTurn));
        this.view.getLblViewAll().addMouseListener(this.onClick(this::toggleViewAllCards));
        this.view.getLblGenerateMana().addMouseListener(this.onClick(this::generateMana));
        this.view.getLblSetupGame().addMouseListener(this.onClick(this::setupGameState));
        this.view.getLblDumpGame().addMouseListener(this.onClick(this::dumpGameState));
        this.view.getLblTutor().addMouseListener(this.onClick(this::tutorForCard));
        this.view.getLblCardToHand().addMouseListener(this.onClick(this::addCardToHand));
        this.view.getLblExileFromHand().addMouseListener(this.onClick(this::exileCardsFromHand));
        this.view.getLblCardToBattlefield().addMouseListener(this.onClick(this::addCardToBattlefield));
        this.view.getLblCardToLibrary().addMouseListener(this.onClick(this::addCardToLibrary));
        this.view.getLblCardToGraveyard().addMouseListener(this.onClick(this::addCardToGraveyard));
        this.view.getLblCardToExile().addMouseListener(this.onClick(this::addCardToExile));
        this.view.getLblCastSpell().addMouseListener(this.onClick(this::castASpell));
        this.view.getLblRepeatAddCard().addMouseListener(this.onClick(this::repeatAddCard));
        this.view.getLblAddCounterPermanent().addMouseListener(this.onClick(this::addCounterToPermanent));
        this.view.getLblSubCounterPermanent().addMouseListener(this.onClick(this::removeCountersFromPermanent));
        this.view.getLblTapPermanent().addMouseListener(this.onClick(this::tapPermanent));
        this.view.getLblUntapPermanent().addMouseListener(this.onClick(this::untapPermanent));
        this.view.getLblSetLife().addMouseListener(this.onClick(this::setPlayerLife));
        this.view.getLblWinGame().addMouseListener(this.onClick(this::winGame));
        this.view.getLblExileFromPlay().addMouseListener(this.onClick(this::exileCardsFromPlay));
        this.view.getLblRemoveFromGame().addMouseListener(this.onClick(this::removeCardsFromGame));
        this.view.getLblRiggedRoll().addMouseListener(this.onClick(this::riggedPlanerRoll));
        this.view.getLblWalkTo().addMouseListener(this.onClick(this::planeswalkTo));
        this.view.getLblAskAI().addMouseListener(this.onClick(this::askAI));
        this.view.getLblAskSimulationAI().addMouseListener(this.onClick(this::askSimulationAI));
    }

    public IGameController getController() {
        return this.matchUI.getGameController();
    }

    public VDev getView() {
        return this.view;
    }

    public void addListener(IDevListener listener) {
        this.listeners.add(listener);
    }

    private MouseListener onClick(final Runnable r) {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                r.run();
            }
        };
    }

    public void togglePlayManyLandsPerTurn() {
        boolean newValue = !this.view.getLblUnlimitedLands().getToggled();
        this.getController().cheat().setCanPlayUnlimitedLands(newValue);
        this.update();
    }

    public void toggleViewAllCards() {
        boolean newValue = !this.view.getLblViewAll().getToggled();
        this.getController().cheat().setViewAllCards(newValue);
        this.update();
    }

    public void generateMana() {
        this.getController().cheat().generateMana();
    }

    public void setupGameState() {
        this.getController().cheat().setupGameState();
    }

    public void dumpGameState() {
        this.getController().cheat().dumpGameState();
    }

    public void tutorForCard() {
        this.getController().cheat().tutorForCard();
    }

    public void addCardToHand() {
        this.getController().cheat().addCardToHand();
    }

    public void addCardToLibrary() {
        this.getController().cheat().addCardToLibrary();
    }

    public void addCardToGraveyard() {
        this.getController().cheat().addCardToGraveyard();
    }

    public void addCardToExile() {
        this.getController().cheat().addCardToExile();
    }

    public void castASpell() {
        this.getController().cheat().castASpell();
    }

    public void repeatAddCard() {
        this.getController().cheat().repeatLastAddition();
    }

    public void exileCardsFromHand() {
        this.getController().cheat().exileCardsFromHand();
    }

    public void addCounterToPermanent() {
        this.getController().cheat().addCountersToPermanent();
    }

    public void removeCountersFromPermanent() {
        this.getController().cheat().removeCountersFromPermanent();
    }

    public void tapPermanent() {
        this.getController().cheat().tapPermanents();
    }

    public void untapPermanent() {
        this.getController().cheat().untapPermanents();
    }

    public void setPlayerLife() {
        this.getController().cheat().setPlayerLife();
    }

    public void winGame() {
        this.getController().cheat().winGame();
    }

    public void addCardToBattlefield() {
        this.getController().cheat().addCardToBattlefield();
    }

    public void exileCardsFromPlay() {
        this.getController().cheat().exileCardsFromBattlefield();
    }

    public void removeCardsFromGame() {
        this.getController().cheat().removeCardsFromGame();
    }

    public void riggedPlanerRoll() {
        this.getController().cheat().riggedPlanarRoll();
    }

    public void planeswalkTo() {
        this.getController().cheat().planeswalkTo();
    }

    public void askAI() {
        this.getController().cheat().askAI(false);
    }

    public void askSimulationAI() {
        this.getController().cheat().askAI(true);
    }

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
    }

    @Override
    public void update() {
        IGameController controller = this.getController();
        if (controller != null) {
            boolean canPlayUnlimitedLands = controller.canPlayUnlimitedLands();
            boolean mayLookAtAllCards = controller.mayLookAtAllCards();
            for (IDevListener listener : this.listeners) {
                listener.update(canPlayUnlimitedLands, mayLookAtAllCards);
            }
        }
    }
}

