/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.controllers;

import forge.game.GameView;
import forge.game.card.Card;
import forge.game.card.CardView;
import forge.gui.interfaces.IMayViewCards;
import forge.item.IPaperCard;
import forge.item.InventoryItem;
import forge.screens.match.controllers.CDetail;
import forge.screens.match.controllers.CPicture;

public class CDetailPicture {
    private final CDetail cDetail;
    private final CPicture cPicture;
    private final IMayViewCards mayView;
    private CardView currentView = null;
    private boolean isDisplayAlt = false;
    private boolean alwaysDisplayAlt = false;

    public CDetailPicture() {
        this(IMayViewCards.ALL);
    }

    public CDetailPicture(IMayViewCards mayView) {
        this.mayView = mayView;
        this.cDetail = new CDetail(this);
        this.cPicture = new CPicture(this);
    }

    CardView getCurrentCard() {
        return this.currentView;
    }

    public CDetail getCDetail() {
        return this.cDetail;
    }

    public CPicture getCPicture() {
        return this.cPicture;
    }

    public void displayAlt(boolean showAlt) {
        this.isDisplayAlt = showAlt;
    }

    public void showCard(CardView c, boolean showAlt) {
        this.currentView = c;
        boolean mayFlip = this.mayView() && this.mayFlip();
        this.isDisplayAlt = mayFlip && showAlt;
        this.alwaysDisplayAlt = mayFlip && c.isFaceDown();
        this.update();
    }

    public void showItem(InventoryItem item) {
        if (item instanceof IPaperCard) {
            IPaperCard paperCard = (IPaperCard)item;
            CardView c = CardView.getCardForUi(paperCard);
            if (paperCard.isFoil() && c.getCurrentState().getFoilIndex() == 0) {
                if (item instanceof Card) {
                    c.getCurrentState().setFoilIndexOverride(-1);
                } else if (item instanceof IPaperCard) {
                    c.getCurrentState().setFoilIndexOverride(1);
                }
            }
            this.showCard(c, this.isDisplayAlt);
        } else {
            this.currentView = null;
            this.isDisplayAlt = false;
            this.alwaysDisplayAlt = false;
            this.cDetail.showItem(item);
            this.cPicture.showItem(item);
        }
    }

    public void setGameView(GameView gameView) {
        this.cDetail.getView().setGameView(gameView);
    }

    void flip() {
        if (this.mayFlip()) {
            this.isDisplayAlt = !this.isDisplayAlt;
            this.update();
        }
    }

    private void update() {
        boolean mayView = this.mayView();
        boolean mayFlip = this.mayFlip();
        this.cDetail.showCard(this.currentView, this.isDisplayAlt, mayView, mayFlip);
        this.cPicture.showCard(this.currentView, this.isDisplayAlt || this.alwaysDisplayAlt, mayView, mayFlip && !this.alwaysDisplayAlt);
    }

    private boolean mayView() {
        return this.currentView == null || this.mayView.mayView(this.currentView) || this.currentView.isForeTold();
    }

    private boolean mayFlip() {
        return this.currentView != null && this.mayView.mayFlip(this.currentView);
    }
}

