/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.controllers;

import com.google.common.collect.Iterables;
import forge.game.GameEntityView;
import forge.game.card.CardView;
import forge.game.combat.CombatView;
import forge.game.player.PlayerView;
import forge.gui.framework.ICDoc;
import forge.screens.match.views.VCombat;
import forge.util.Lang;
import forge.util.collect.FCollection;

public class CCombat
implements ICDoc {
    private CombatView combat;
    private final VCombat view = new VCombat(this);

    public VCombat getView() {
        return this.view;
    }

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
    }

    @Override
    public void update() {
        CombatView localCombat = this.combat;
        if (localCombat != null) {
            this.view.updateCombat(localCombat.getNumAttackers(), CCombat.getCombatDescription(localCombat));
        } else {
            this.view.updateCombat(0, "");
        }
    }

    public void setModel(CombatView combat) {
        this.combat = combat;
    }

    private static String getCombatDescription(CombatView localCombat) {
        StringBuilder display = new StringBuilder();
        for (GameEntityView defender : localCombat.getDefenders()) {
            display.append(CCombat.getCombatDescription(localCombat, defender));
        }
        return display.toString().trim();
    }

    private static String getCombatDescription(CombatView localCombat, GameEntityView defender) {
        StringBuilder display = new StringBuilder();
        Iterable<FCollection<CardView>> bands = localCombat.getAttackingBandsOf(defender);
        if (bands == null || Iterables.isEmpty(bands)) {
            return "";
        }
        display.append("\n");
        if (defender instanceof CardView) {
            PlayerView controller = ((CardView)defender).getController();
            display.append(Lang.getInstance().getPossesive(controller.getName())).append(" ");
        }
        display.append(defender).append(" is attacked by:\n");
        boolean previousBand = false;
        for (FCollection<CardView> band : bands) {
            boolean isBand;
            FCollection<CardView> blockers;
            int bandSize = band.size();
            if (bandSize == 0) continue;
            if (previousBand) {
                display.append("\n");
            }
            boolean blocked = (blockers = localCombat.getBlockers(band)) != null && !blockers.isEmpty();
            boolean bl = isBand = bandSize > 1;
            if (isBand) {
                display.append(" > BAND");
                display.append(blocked ? " (blocked)" : " >>>");
                display.append("\n");
            }
            for (CardView attacker : band) {
                display.append(" > ");
                display.append(CCombat.combatantToString(attacker)).append("\n");
            }
            if (!isBand) {
                if (blocked) {
                    display.append("     (blocked)\n");
                } else {
                    display.append("     >>>\n");
                }
            }
            if (blocked) {
                for (CardView blocker : blockers) {
                    display.append("     < ").append(CCombat.combatantToString(blocker)).append("\n");
                }
            }
            previousBand = isBand;
        }
        return display.toString();
    }

    private static String combatantToString(CardView c) {
        StringBuilder sb = new StringBuilder();
        CardView.CardStateView state = c.getCurrentState();
        String name = state.getName();
        sb.append("( ").append(state.getPower()).append(" / ").append(state.getToughness()).append(" ) ... ");
        if (c.isFaceDown()) {
            sb.append("Morph");
        } else {
            sb.append(name);
        }
        sb.append(" [").append(state.getDisplayId()).append("] ");
        return sb.toString();
    }
}

