/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match;

import forge.game.GameLogEntry;
import forge.game.GameLogEntryType;
import forge.game.GameView;
import forge.gui.SOverlayUtils;
import forge.gui.interfaces.IWinLoseView;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.screens.match.CMatchUI;
import forge.screens.match.ControlWinLose;
import forge.screens.match.GauntletWinLose;
import forge.screens.match.LimitedWinLose;
import forge.screens.match.QuestDraftWinLose;
import forge.screens.match.QuestWinLose;
import forge.screens.match.QuestWinLoseCardViewer;
import forge.toolbox.FButton;
import forge.toolbox.FLabel;
import forge.toolbox.FOverlay;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.toolbox.FTextArea;
import forge.util.Localizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class ViewWinLose
implements IWinLoseView<FButton> {
    private final ControlWinLose control;
    private final FScrollPane scrLog;
    private final FButton btnContinue;
    private final FButton btnRestart;
    private final FButton btnQuit;
    private final FSkin.SkinnedPanel pnlCustom;
    private final FSkin.SkinnedLabel lblTitle = new FSkin.SkinnedLabel("WinLoseFrame > lblTitle needs updating.");
    private final FSkin.SkinnedLabel lblStats = new FSkin.SkinnedLabel("WinLoseFrame > lblStats needs updating.");
    private final JPanel pnlOutcomes = new JPanel(new MigLayout("wrap, ax center, ay center"));
    private static final FSkin.SkinColor FORE_COLOR = FSkin.getColor(FSkin.Colors.CLR_TEXT);
    private static final String CONSTRAINTS_TITLE = "w 95%!, gap 0 0 20px 10px";
    private static final String CONSTRAINTS_TEXT = "w 95%!, h 220px!, gap 0 0 0 20px";
    private static final String CONSTRAINTS_CARDS = "w 95%!, h 330px!, gap 0 0 0 20px";
    private static final String CONSTRAINTS_CARDS_LARGE = "w 95%!, h 600px!, gap 0 0 0 20px";
    private final GameView game;

    public ViewWinLose(GameView game0, CMatchUI matchUI) {
        this.game = game0;
        FSkin.SkinnedPanel overlay = FOverlay.SINGLETON_INSTANCE.getPanel();
        JPanel pnlLeft = new JPanel();
        JPanel pnlRight = new JPanel();
        FScrollPane scrCustom = new FScrollPane(false);
        this.pnlCustom = new FSkin.SkinnedPanel();
        this.btnContinue = new FButton();
        this.btnRestart = new FButton();
        this.btnQuit = new FButton();
        ControlWinLose control = null;
        switch (game0.getGameType()) {
            case Quest: {
                control = new QuestWinLose(this, game0, matchUI);
                break;
            }
            case QuestDraft: {
                control = new QuestDraftWinLose(this, game0, matchUI);
                break;
            }
            case Draft: {
                if (!FModel.getGauntletMini().isGauntletDraft()) break;
            }
            case Sealed: {
                control = new LimitedWinLose(this, game0, matchUI);
                break;
            }
            case CommanderGauntlet: 
            case Gauntlet: {
                control = new GauntletWinLose(this, game0, matchUI);
                break;
            }
        }
        if (null == control) {
            control = new ControlWinLose(this, game0, matchUI);
        }
        this.control = control;
        pnlLeft.setOpaque(false);
        pnlRight.setOpaque(false);
        this.pnlCustom.setOpaque(false);
        scrCustom.getViewport().add(this.pnlCustom);
        this.lblTitle.setForeground(Color.white);
        this.lblTitle.setHorizontalAlignment(0);
        this.lblTitle.setFont(FSkin.getRelativeBoldFont(30));
        this.lblStats.setForeground(Color.white);
        this.lblStats.setHorizontalAlignment(0);
        this.lblStats.setFont(FSkin.getRelativeFont(26));
        Localizer localizer = Localizer.getInstance();
        this.btnContinue.setText(localizer.getMessage("btnNextGame", new Object[0]));
        this.btnContinue.setFont(FSkin.getRelativeFont(22));
        this.btnRestart.setText(localizer.getMessage("btnStartNewMatch", new Object[0]));
        this.btnRestart.setFont(FSkin.getRelativeFont(22));
        this.btnQuit.setText(localizer.getMessage("btnQuitMatch", new Object[0]));
        this.btnQuit.setFont(FSkin.getRelativeFont(22));
        this.btnContinue.setEnabled(!game0.isMatchOver());
        FTextArea txtLog = new FTextArea();
        txtLog.setText(StringUtils.join(this.game.getGameLog().getLogEntries(null), "\r\n").replace("[COMPUTER]", "[AI]"));
        txtLog.setFont(FSkin.getRelativeFont(14));
        txtLog.setFocusable(true);
        FLabel btnCopyLog = new FLabel.ButtonBuilder().text(localizer.getMessage("btnCopyToClipboard", new Object[0])).build();
        btnCopyLog.setCommand(() -> {
            StringSelection ss = new StringSelection(txtLog.getText());
            try {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
        overlay.setLayout(new MigLayout("insets 0, w 100%!, h 100%!"));
        pnlLeft.setLayout(new MigLayout("insets 0, wrap, ax center, ay center"));
        pnlRight.setLayout(new MigLayout("insets 0, wrap"));
        this.pnlCustom.setLayout(new MigLayout("insets 0, wrap, ax center, ay center"));
        boolean customIsPopulated = control.populateCustomPanel();
        if (customIsPopulated) {
            overlay.add((Component)pnlLeft, "w 40%!, h 100%!");
            overlay.add((Component)pnlRight, "w 60%!, h 100%!");
            pnlRight.add((Component)scrCustom, "w 100%!, h 100%!");
        } else {
            overlay.add((Component)pnlLeft, "w 100%!, h 100%!");
        }
        this.pnlOutcomes.setOpaque(false);
        pnlLeft.add((Component)this.lblTitle, "h 60px!, center");
        pnlLeft.add((Component)this.pnlOutcomes, "center");
        pnlLeft.add((Component)this.lblStats, "h 60px!, center");
        JPanel pnlButtons = new JPanel(new MigLayout("insets 0, wrap, ax center"));
        pnlButtons.setOpaque(false);
        String constraints = "w 300px!, h 50px!, gap 0 0 20px 0";
        pnlButtons.add((Component)this.btnContinue, "w 300px!, h 50px!, gap 0 0 20px 0");
        pnlButtons.add((Component)this.btnRestart, "w 300px!, h 50px!, gap 0 0 20px 0");
        pnlButtons.add((Component)this.btnQuit, "w 300px!, h 50px!, gap 0 0 20px 0");
        pnlLeft.add((Component)pnlButtons, "w 100%!");
        JPanel pnlLog = new JPanel(new MigLayout("insets 0, wrap, ax center"));
        this.scrLog = new FScrollPane(txtLog, false);
        pnlLog.setOpaque(false);
        pnlLog.add((Component)new FLabel.Builder().text(localizer.getMessage("lblGameLog", new Object[0])).fontAlign(0).fontSize(18).fontStyle(1).build(), "w 300px!, h 28px!, gaptop 20px");
        pnlLog.add((Component)this.scrLog, "w 300px!, h 100px!, gap 0 0 10 10");
        pnlLog.add((Component)btnCopyLog, "center, w pref+16, h pref+8");
        pnlLeft.add((Component)pnlLog, "w 100%!");
        this.lblTitle.setText(ViewWinLose.composeTitle(game0));
    }

    public final void show() {
        SwingUtilities.invokeLater(() -> {
            this.scrLog.getViewport().setViewPosition(new Point(0, 0));
            if (this.btnContinue.isEnabled()) {
                this.btnContinue.requestFocusInWindow();
            } else {
                this.btnQuit.requestFocusInWindow();
            }
        });
        this.showGameOutcomeSummary();
        this.showPlayerScores();
    }

    public final ControlWinLose getControl() {
        return this.control;
    }

    private static String composeTitle(GameView game) {
        String winner = game.getWinningPlayerName();
        int winningTeam = game.getWinningTeam();
        Localizer localizer = Localizer.getInstance();
        if (winner == null || winner.isEmpty()) {
            return localizer.getMessage("lblItsADraw", new Object[0]);
        }
        if (winningTeam != -1) {
            return localizer.getMessage("lblTeamWon", new Object[0]).replace("%s", String.valueOf(winningTeam));
        }
        return localizer.getMessage("lblWinnerWon", new Object[0]).replace("%s", winner);
    }

    @Override
    public FButton getBtnContinue() {
        return this.btnContinue;
    }

    @Override
    public FButton getBtnRestart() {
        return this.btnRestart;
    }

    @Override
    public FButton getBtnQuit() {
        return this.btnQuit;
    }

    public FSkin.SkinnedPanel getPnlCustom() {
        return this.pnlCustom;
    }

    private void showGameOutcomeSummary() {
        for (GameLogEntry o : this.game.getGameLog().getLogEntriesExact(GameLogEntryType.GAME_OUTCOME)) {
            this.pnlOutcomes.add((Component)new FLabel.Builder().text(o.message).fontSize(14).build(), "h 20!");
        }
    }

    private void showPlayerScores() {
        for (GameLogEntry o : this.game.getGameLog().getLogEntriesExact(GameLogEntryType.MATCH_RESULTS)) {
            this.lblStats.setText(ViewWinLose.removePlayerTypeFromLogMessage(o.message));
        }
    }

    private static String removePlayerTypeFromLogMessage(String message) {
        return message.replaceAll("\\[[^\\]]*\\]", "");
    }

    @Override
    public void hide() {
        SOverlayUtils.hideOverlay();
    }

    @Override
    public void showRewards(Runnable runnable) {
        runnable.run();
    }

    @Override
    public void showCards(String title, List<PaperCard> cards) {
        QuestWinLoseCardViewer cv = new QuestWinLoseCardViewer(cards);
        this.getPnlCustom().add((Component)new TitleLabel(title), CONSTRAINTS_TITLE);
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_LARGE_CARD_VIEWERS)) {
            this.getPnlCustom().add((Component)cv, CONSTRAINTS_CARDS_LARGE);
        } else {
            this.getPnlCustom().add((Component)cv, CONSTRAINTS_CARDS);
        }
    }

    @Override
    public void showMessage(String message, String title, FSkinProp icon) {
        FSkin.SkinIcon icoTemp = FSkin.getIcon(icon).scale(0.5);
        if (message.contains("\n")) {
            message = "<html>" + message.replace("\n", "<br>") + "</html>";
        }
        FSkin.SkinnedLabel lblMessage = new FSkin.SkinnedLabel(message);
        lblMessage.setFont(FSkin.getRelativeFont(14));
        lblMessage.setForeground(FORE_COLOR);
        lblMessage.setHorizontalAlignment(0);
        lblMessage.setIconTextGap(50);
        lblMessage.setIcon(icoTemp);
        this.getPnlCustom().add((Component)new TitleLabel(title), CONSTRAINTS_TITLE);
        this.getPnlCustom().add((Component)lblMessage, CONSTRAINTS_TEXT);
    }

    private class TitleLabel
    extends FSkin.SkinnedLabel {
        TitleLabel(String msg) {
            super(msg);
            this.setFont(FSkin.getRelativeFont(16));
            this.setPreferredSize(new Dimension(200, 40));
            this.setHorizontalAlignment(0);
            this.setForeground(FORE_COLOR);
            this.setBorder(new FSkin.MatteSkinBorder(1, 0, 1, 0, FORE_COLOR));
        }
    }
}

