/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match;

import forge.Singletons;
import forge.gui.framework.DragCell;
import forge.gui.framework.EDocID;
import forge.gui.framework.FScreen;
import forge.gui.framework.ICDoc;
import forge.gui.framework.IVDoc;
import forge.gui.framework.IVTopLevelUI;
import forge.gui.framework.SRearrangingUtil;
import forge.gui.framework.VEmptyDoc;
import forge.localinstance.properties.ForgePreferences;
import forge.screens.match.CMatchUI;
import forge.screens.match.views.VDev;
import forge.screens.match.views.VField;
import forge.screens.match.views.VHand;
import forge.sound.MusicPlaylist;
import forge.sound.SoundSystem;
import forge.toolbox.FButton;
import forge.view.FView;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class VMatchUI
implements IVTopLevelUI {
    private List<VField> lstFields = new ArrayList<VField>();
    private List<VHand> lstHands = new ArrayList<VHand>();
    private final CMatchUI control;

    VMatchUI(CMatchUI control) {
        this.control = control;
    }

    @Override
    public void instantiate() {
    }

    @Override
    public void populate() {
        Object handId;
        Object vField;
        VDev vDev = this.getControl().getCDev().getView();
        if (!ForgePreferences.DEV_MODE) {
            if (vDev.getParentCell() != null) {
                DragCell parent = vDev.getParentCell();
                parent.removeDoc(vDev);
                vDev.setParentCell(null);
                if (parent.getDocs().size() > 0) {
                    parent.setSelected(parent.getDocs().get(0));
                }
            }
        } else if (vDev.getParentCell() == null) {
            this.getControl().getCPrompt().getView().getParentCell().addDoc(vDev);
        }
        if (this.getBtnOK().isEnabled()) {
            this.getBtnOK().requestFocusInWindow();
        } else if (this.getBtnCancel().isEnabled()) {
            this.getBtnCancel().requestFocusInWindow();
        }
        for (int i = 2; i < this.lstFields.size(); ++i) {
            vField = this.lstFields.get(i);
            if (((VField)vField).getParentCell() != null) continue;
            this.lstFields.get(i % 2).getParentCell().addDoc((IVDoc<? extends ICDoc>)vField);
        }
        DragCell cellWithHands = null;
        vField = EDocID.Hands;
        int n = ((EDocID[])vField).length;
        for (int i = 0; i < n && (cellWithHands = ((EDocID)((Object)(handId = vField[i]))).getDoc().getParentCell()) == null; ++i) {
        }
        if (cellWithHands == null) {
            cellWithHands = EDocID.REPORT_LOG.getDoc().getParentCell();
        }
        for (int iHandId = 0; iHandId < EDocID.Hands.length; ++iHandId) {
            EDocID handId2 = EDocID.Hands[iHandId];
            DragCell parentCell = handId2.getDoc().getParentCell();
            VHand myVHand = null;
            for (VHand vHand : this.lstHands) {
                if (!handId2.equals((Object)vHand.getDocumentID())) continue;
                myVHand = vHand;
                break;
            }
            if (myVHand == null) {
                if (parentCell == null) continue;
                parentCell.removeDoc(handId2.getDoc());
                handId2.setDoc(new VEmptyDoc(handId2));
                continue;
            }
            if (parentCell != null) continue;
            EDocID fieldDoc = EDocID.Fields[iHandId];
            if (fieldDoc.getDoc().getParentCell() != null) {
                fieldDoc.getDoc().getParentCell().addDoc(myVHand);
                continue;
            }
            cellWithHands.addDoc(myVHand);
        }
        SwingUtilities.invokeLater(() -> {
            for (DragCell c : FView.SINGLETON_INSTANCE.getDragCells()) {
                if (!c.getDocs().isEmpty()) continue;
                SRearrangingUtil.fillGap(c);
                FView.SINGLETON_INSTANCE.removeDragCell(c);
            }
        });
    }

    public CMatchUI getControl() {
        return this.control;
    }

    public void setFieldViews(List<VField> lst0) {
        this.lstFields = lst0;
    }

    public List<VField> getFieldViews() {
        return this.lstFields;
    }

    public void setHandViews(List<VHand> lst0) {
        this.lstHands = lst0;
    }

    public FButton getBtnCancel() {
        return this.getControl().getCPrompt().getView().getBtnCancel();
    }

    public FButton getBtnOK() {
        return this.getControl().getCPrompt().getView().getBtnOK();
    }

    public List<VHand> getHands() {
        return this.lstHands;
    }

    @Override
    public boolean onSwitching(FScreen fromScreen, FScreen toScreen) {
        return true;
    }

    @Override
    public boolean onClosing(FScreen screen) {
        if (!Singletons.getControl().getCurrentScreen().equals(screen)) {
            Singletons.getControl().setCurrentScreen(screen);
        }
        if (this.control.concede()) {
            SoundSystem.instance.setBackgroundMusic(MusicPlaylist.MENUS);
            return true;
        }
        return false;
    }
}

