/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match;

import forge.Singletons;
import forge.screens.match.CMatchUI;
import forge.toolbox.FButton;
import forge.toolbox.FCheckBox;
import forge.toolbox.FList;
import forge.toolbox.FOptionPane;
import forge.toolbox.FScrollPane;
import forge.util.Localizer;
import forge.view.FDialog;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;

public class VAutoYields
extends FDialog {
    private static final int PADDING = 10;
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 26;
    private final FButton btnOk;
    private final FButton btnRemove;
    private final FList<String> lstAutoYields;
    private final FScrollPane listScroller;
    private final FCheckBox chkDisableAll;
    private final List<String> autoYields;

    public VAutoYields(CMatchUI matchUI) {
        this.setTitle(Localizer.getInstance().getMessage("lblAutoYields", new Object[0]));
        this.autoYields = new ArrayList<String>();
        for (String autoYield : matchUI.getAutoYields()) {
            this.autoYields.add(autoYield);
        }
        this.lstAutoYields = new FList<String>(new AutoYieldsListModel());
        int x = 10;
        int y = 10;
        int width = Singletons.getView().getFrame().getWidth() * 2 / 3;
        int w = width - 20;
        this.listScroller = new FScrollPane(this.lstAutoYields, true);
        this.chkDisableAll = new FCheckBox(Localizer.getInstance().getMessage("lblDisableAllAutoYields", new Object[0]), matchUI.getDisableAutoYields());
        this.chkDisableAll.addChangeListener(e -> matchUI.setDisableAutoYields(this.chkDisableAll.isSelected()));
        this.btnOk = new FButton(Localizer.getInstance().getMessage("lblOK", new Object[0]));
        this.btnOk.setCommand(() -> this.setVisible(false));
        this.btnRemove = new FButton(Localizer.getInstance().getMessage("lblRemoveYield", new Object[0]));
        this.btnRemove.setCommand(() -> {
            String selected = (String)this.lstAutoYields.getSelectedValue();
            if (selected != null) {
                this.autoYields.remove(selected);
                this.btnRemove.setEnabled(this.autoYields.size() > 0);
                matchUI.setShouldAutoYield(selected, false);
                this.revalidate();
                this.lstAutoYields.repaint();
            }
        });
        if (this.autoYields.size() > 0) {
            this.lstAutoYields.setSelectedIndex(0);
        } else {
            this.btnRemove.setEnabled(false);
        }
        Dimension checkBoxSize = this.chkDisableAll.getPreferredSize();
        int listHeight = this.lstAutoYields.getMinimumSize().height + 20;
        this.add(this.listScroller, x, y, w, listHeight);
        this.add(this.chkDisableAll, x, y += listHeight + 10, checkBoxSize.width, checkBoxSize.height);
        x = w - 300 - 10;
        this.add(this.btnOk, x, y, 150, 26);
        this.add(this.btnRemove, x += 160, y, 150, 26);
        this.pack();
        this.setSize(width, this.getHeight());
    }

    public void showAutoYields() {
        if (this.lstAutoYields.getCount() > 0) {
            this.setVisible(true);
            this.dispose();
        } else {
            FOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblNoActiveAutoYield", new Object[0]), Localizer.getInstance().getMessage("lblNoAutoYield", new Object[0]), FOptionPane.INFORMATION_ICON);
        }
    }

    private class AutoYieldsListModel
    extends AbstractListModel<String> {
        private AutoYieldsListModel() {
        }

        @Override
        public int getSize() {
            return VAutoYields.this.autoYields.size();
        }

        @Override
        public String getElementAt(int index) {
            return (String)VAutoYields.this.autoYields.get(index);
        }
    }
}

