/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match;

import forge.game.card.CardView;
import forge.game.player.PlayerView;
import forge.gui.SOverlayUtils;
import forge.localinstance.skin.FSkinProp;
import forge.screens.match.CMatchUI;
import forge.toolbox.FButton;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import forge.util.TextUtil;
import forge.view.FDialog;
import forge.view.arcane.CardPanel;
import forge.view.arcane.MiscCardPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;

public class VAssignGenericAmount {
    final Localizer localizer = Localizer.getInstance();
    private final CMatchUI matchUI;
    private final int wDlg = 700;
    private final int hDlg = 500;
    private final FDialog dlg = new FDialog();
    private final int totalAmountToAssign;
    private final String lblAmount;
    private final JLabel lblTotalAmount;
    private final boolean atLeastOne;
    private final FButton btnOK = new FButton(this.localizer.getMessage("lblOK", new Object[0]));
    private final FButton btnReset = new FButton(this.localizer.getMessage("lblReset", new Object[0]));
    private final List<AssignTarget> targetsList = new ArrayList<AssignTarget>();
    private final Map<FSkin.SkinnedPanel, AssignTarget> targetsMap = new HashMap<FSkin.SkinnedPanel, AssignTarget>();
    private final MouseAdapter mad = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent evt) {
            ((FSkin.SkinnedPanel)evt.getSource()).setBorder(new FSkin.LineSkinBorder(FSkin.getColor(FSkin.Colors.CLR_ACTIVE), 2));
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            ((FSkin.SkinnedPanel)evt.getSource()).setBorder((Border)null);
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            FSkin.SkinnedPanel panel = (FSkin.SkinnedPanel)evt.getSource();
            AssignTarget at = (AssignTarget)VAssignGenericAmount.this.targetsMap.get(panel);
            boolean meta = evt.isControlDown();
            boolean isLMB = SwingUtilities.isLeftMouseButton(evt);
            boolean isRMB = SwingUtilities.isRightMouseButton(evt);
            if (isLMB || isRMB) {
                VAssignGenericAmount.this.assignAmountTo(at, meta, isLMB);
            }
        }
    };

    public VAssignGenericAmount(CMatchUI matchUI, CardView effectSource, Map<Object, Integer> targets, int amount, boolean atLeastOne, String amountLabel) {
        this.matchUI = matchUI;
        this.dlg.setTitle(this.localizer.getMessage("lbLAssignAmountForEffect", amountLabel, effectSource.toString()));
        this.totalAmountToAssign = amount;
        this.atLeastOne = atLeastOne;
        this.lblAmount = amountLabel;
        this.lblTotalAmount = new FLabel.Builder().text(this.localizer.getMessage("lblTotalAmountText", this.lblAmount)).build();
        JPanel overlay = SOverlayUtils.genericOverlay();
        FSkin.SkinnedPanel pnlMain = new FSkin.SkinnedPanel();
        pnlMain.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        CardPanel pnlSource = new CardPanel(matchUI, effectSource);
        pnlSource.setOpaque(false);
        pnlSource.setCardBounds(0, 0, 105, 150);
        JPanel pnlInfo = new JPanel(new MigLayout("insets 0, gap 0, wrap"));
        pnlInfo.setOpaque(false);
        pnlInfo.add((Component)this.lblTotalAmount, "gap 0 0 20px 5px");
        pnlInfo.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblLClickAmountMessage", this.lblAmount)).build(), "gap 0 0 0 5px");
        pnlInfo.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblRClickAmountMessage", this.lblAmount)).build(), "gap 0 0 0 5px");
        JPanel pnlTargets = new JPanel();
        pnlTargets.setOpaque(false);
        int cols = targets.size();
        String wrap = "wrap " + cols;
        pnlTargets.setLayout(new MigLayout("insets 0, gap 0, ax center, " + wrap));
        FScrollPane scrTargets = new FScrollPane(pnlTargets, false);
        for (Map.Entry<Object, Integer> e : targets.entrySet()) {
            int maxAmount = e.getValue() != null ? e.getValue() : amount;
            AssignTarget at = new AssignTarget(e.getKey(), new FLabel.Builder().text("0").fontSize(18).fontAlign(0).build(), maxAmount);
            this.addPanelForTarget(pnlTargets, at);
        }
        for (AssignTarget l : this.targetsList) {
            if (l.entity instanceof Byte) {
                pnlTargets.add((Component)l.label, "w 100px!, h 30px!, gap 5px 5px 0 5px");
                continue;
            }
            pnlTargets.add((Component)l.label, "w 145px!, h 30px!, gap 5px 5px 0 5px");
        }
        this.btnOK.addActionListener(arg0 -> this.finish());
        this.btnReset.addActionListener(arg0 -> {
            this.resetAssignedAmount();
            this.initialAssignAmount();
        });
        pnlMain.setLayout(new MigLayout("insets 0, gap 0, wrap 2, ax center"));
        pnlMain.add((Component)pnlSource, "w 125px!, h 160px!, gap 50px 0 0 15px");
        pnlMain.add((Component)pnlInfo, "gap 20px 0 0 15px");
        pnlMain.add((Component)scrTargets, "w 96%!, gap 2% 0 0 0, pushy, growy, ax center, span 2");
        JPanel pnlButtons = new JPanel(new MigLayout("insets 0, gap 0, ax center"));
        pnlButtons.setOpaque(false);
        pnlButtons.add((Component)this.btnOK, "w 110px!, h 30px!, gap 0 10px 0 0");
        pnlButtons.add((Component)this.btnReset, "w 110px!, h 30px!");
        pnlMain.add((Component)pnlButtons, "ax center, w 350px!, gap 10px 10px 10px 10px, span 2");
        overlay.add(pnlMain);
        pnlMain.getRootPane().setDefaultButton(this.btnOK);
        this.initialAssignAmount();
        SOverlayUtils.showOverlay();
        this.dlg.setUndecorated(true);
        this.dlg.setContentPane(pnlMain);
        this.dlg.setSize(new Dimension(700, 500));
        this.dlg.setLocation((overlay.getWidth() - 700) / 2, (overlay.getHeight() - 500) / 2);
        this.dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.dlg.setVisible(true);
    }

    private void addPanelForTarget(JPanel pnlTargets, AssignTarget at) {
        if (at.entity instanceof CardView) {
            CardPanel cp = new CardPanel(this.matchUI, (CardView)at.entity);
            cp.setCardBounds(0, 0, 105, 150);
            cp.setOpaque(true);
            pnlTargets.add((Component)cp, "w 145px!, h 170px!, gap 5px 5px 3px 3px, ax center");
            cp.addMouseListener(this.mad);
            this.targetsMap.put(cp, at);
        } else if (at.entity instanceof PlayerView) {
            PlayerView p = (PlayerView)at.entity;
            FSkin.SkinImage playerAvatar = this.matchUI.getPlayerAvatar(p, 0);
            MiscCardPanel mp = new MiscCardPanel(this.matchUI, p.getName(), playerAvatar);
            mp.setCardBounds(0, 0, 105, 150);
            pnlTargets.add((Component)mp, "w 145px!, h 170px!, gap 5px 5px 3px 3px, ax center");
            mp.addMouseListener(this.mad);
            this.targetsMap.put(mp, at);
        } else if (at.entity instanceof Byte) {
            byte color = (Byte)at.entity;
            FSkin.SkinImage manaSymbol = color == 1 ? FSkin.getImage(FSkinProp.IMG_MANA_W) : (color == 2 ? FSkin.getImage(FSkinProp.IMG_MANA_U) : (color == 4 ? FSkin.getImage(FSkinProp.IMG_MANA_B) : (color == 8 ? FSkin.getImage(FSkinProp.IMG_MANA_R) : (color == 16 ? FSkin.getImage(FSkinProp.IMG_MANA_G) : FSkin.getImage(FSkinProp.IMG_MANA_COLORLESS)))));
            MiscCardPanel mp = new MiscCardPanel(this.matchUI, "", manaSymbol);
            mp.setCardBounds(0, 0, 70, 70);
            pnlTargets.add((Component)mp, "w 100px!, h 150px!, gap 5px 5px 3px 3px, ax center");
            mp.addMouseListener(this.mad);
            this.targetsMap.put(mp, at);
        }
        this.targetsList.add(at);
    }

    private void assignAmountTo(AssignTarget at, boolean meta, boolean isAdding) {
        int assigned = at.amount;
        int leftToAssign = Math.max(0, at.max - assigned);
        int amountToAdd = isAdding ? 1 : -1;
        int remainingAmount = Math.min(this.getRemainingAmount(), leftToAssign);
        if (meta) {
            amountToAdd = isAdding ? (leftToAssign > 0 ? leftToAssign : 0) : -assigned;
        }
        if (amountToAdd > remainingAmount) {
            amountToAdd = remainingAmount;
        }
        if (this.atLeastOne && assigned + amountToAdd < 1) {
            amountToAdd = 1 - assigned;
        }
        if (0 == amountToAdd || amountToAdd + assigned < 0) {
            return;
        }
        this.addAssignedAmount(at, amountToAdd);
        this.updateLabels();
    }

    private void initialAssignAmount() {
        if (!this.atLeastOne) {
            this.updateLabels();
            return;
        }
        for (AssignTarget at : this.targetsList) {
            this.addAssignedAmount(at, 1);
        }
        this.updateLabels();
    }

    private void resetAssignedAmount() {
        for (AssignTarget at : this.targetsList) {
            at.amount = 0;
        }
    }

    private void addAssignedAmount(AssignTarget at, int addedAmount) {
        int canAssign = this.getRemainingAmount();
        if (canAssign < addedAmount) {
            addedAmount = canAssign;
        }
        at.amount = Math.max(0, addedAmount + at.amount);
    }

    private int getRemainingAmount() {
        int spent = 0;
        for (AssignTarget at : this.targetsList) {
            spent += at.amount;
        }
        return this.totalAmountToAssign - spent;
    }

    private void updateLabels() {
        int amountLeft = this.totalAmountToAssign;
        for (AssignTarget at : this.targetsList) {
            amountLeft -= at.amount;
            StringBuilder sb = new StringBuilder();
            sb.append(at.amount);
            if (at.max - at.amount == 0) {
                sb.append(" (").append(this.localizer.getMessage("lblMax", new Object[0])).append(")");
            }
            at.label.setText(sb.toString());
        }
        this.lblTotalAmount.setText(TextUtil.concatNoSpace(this.localizer.getMessage("lblAvailableAmount", this.lblAmount), ": ", String.valueOf(amountLeft), " (of ", String.valueOf(this.totalAmountToAssign), ")"));
        this.btnOK.setEnabled(amountLeft == 0);
    }

    private void finish() {
        if (this.getRemainingAmount() > 0) {
            return;
        }
        this.dlg.dispose();
        SOverlayUtils.hideOverlay();
    }

    public Map<Object, Integer> getAssignedMap() {
        HashMap<Object, Integer> result = new HashMap<Object, Integer>(this.targetsList.size());
        for (AssignTarget at : this.targetsList) {
            result.put(at.entity, at.amount);
        }
        return result;
    }

    private static class AssignTarget {
        public final Object entity;
        public final JLabel label;
        public final int max;
        public int amount;

        public AssignTarget(Object e, JLabel lbl, int max0) {
            this.entity = e;
            this.label = lbl;
            this.max = max0;
            this.amount = 0;
        }
    }
}

