/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.game.GameEntityView;
import forge.game.card.CardView;
import forge.game.card.CounterEnumType;
import forge.game.player.PlayerView;
import forge.gui.SOverlayUtils;
import forge.screens.match.CMatchUI;
import forge.toolbox.FButton;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import forge.util.TextUtil;
import forge.view.FDialog;
import forge.view.arcane.CardPanel;
import forge.view.arcane.MiscCardPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;

public class VAssignCombatDamage {
    final Localizer localizer = Localizer.getInstance();
    private final CMatchUI matchUI;
    private final int wDlg = 700;
    private final int hDlg = 500;
    private final FDialog dlg = new FDialog();
    private final int totalDamageToAssign;
    private boolean attackerHasDeathtouch = false;
    private boolean attackerHasDivideDamage = false;
    private boolean attackerHasTrample = false;
    private boolean attackerHasInfect = false;
    private boolean overrideCombatantOrder = false;
    private boolean skip = false;
    private final GameEntityView defender;
    private final JLabel lblTotalDamage = new FLabel.Builder().text(this.localizer.getMessage("lblTotalDamageText", new Object[0])).build();
    private final JLabel lblAssignRemaining = new FLabel.Builder().text(this.localizer.getMessage("lblAssignRemainingText", new Object[0])).build();
    private final FButton btnOK = new FButton(this.localizer.getMessage("lblOK", new Object[0]));
    private final FButton btnReset = new FButton(this.localizer.getMessage("lblReset", new Object[0]));
    private final FButton btnAuto = new FButton(this.localizer.getMessage("lblAuto", new Object[0]));
    private final FButton btnSkip = new FButton(this.localizer.getMessage("lblSkip", new Object[0]));
    private final List<DamageTarget> defenders = Lists.newArrayList();
    private final Map<CardView, DamageTarget> damage = Maps.newHashMap();
    private final MouseAdapter mad = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent evt) {
            FSkin.SkinnedPanel panel = (FSkin.SkinnedPanel)evt.getSource();
            CardView source = null;
            if (panel instanceof CardPanel) {
                source = ((CardPanel)panel).getCard();
            }
            if (!VAssignCombatDamage.this.damage.containsKey(source)) {
                source = null;
            }
            FSkin.Colors brdrColor = VAssignCombatDamage.this.canAssignTo(source) ? FSkin.Colors.CLR_ACTIVE : FSkin.Colors.CLR_INACTIVE;
            panel.setBorder(new FSkin.LineSkinBorder(FSkin.getColor(brdrColor), 2));
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            ((FSkin.SkinnedPanel)evt.getSource()).setBorder((Border)null);
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            FSkin.SkinnedPanel panel = (FSkin.SkinnedPanel)evt.getSource();
            CardView source = null;
            if (panel instanceof CardPanel) {
                source = ((CardPanel)panel).getCard();
            }
            boolean meta = evt.isControlDown();
            boolean isLMB = SwingUtilities.isLeftMouseButton(evt);
            boolean isRMB = SwingUtilities.isRightMouseButton(evt);
            if (isLMB || isRMB) {
                VAssignCombatDamage.this.assignDamageTo(source, meta, isLMB);
            }
        }
    };

    private boolean canAssignTo(CardView card) {
        for (DamageTarget dt : this.defenders) {
            if (dt.card == card) {
                return true;
            }
            if (this.getDamageToKill(dt.card) <= dt.damage) continue;
            return false;
        }
        throw new RuntimeException("Asking to assign damage to object which is not present in defenders list");
    }

    public VAssignCombatDamage(CMatchUI matchUI, CardView attacker, List<CardView> blockers, int damage0, GameEntityView defender0, boolean overrideOrder, boolean maySkip) {
        this.matchUI = matchUI;
        String s2 = this.localizer.getMessage("lbLAssignDamageDealtBy", new Object[0]);
        this.dlg.setTitle(s2.replace("%s", attacker.toString()));
        this.totalDamageToAssign = damage0;
        this.defender = defender0;
        this.attackerHasDeathtouch = attacker.getCurrentState().hasDeathtouch();
        this.attackerHasInfect = attacker.getCurrentState().hasInfect();
        this.attackerHasTrample = this.defender != null && attacker.getCurrentState().hasTrample();
        this.attackerHasDivideDamage = attacker.getCurrentState().hasDivideDamage();
        this.overrideCombatantOrder = overrideOrder;
        JPanel overlay = SOverlayUtils.genericOverlay();
        FSkin.SkinnedPanel pnlMain = new FSkin.SkinnedPanel();
        pnlMain.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        CardPanel pnlAttacker = new CardPanel(matchUI, attacker);
        pnlAttacker.setOpaque(false);
        pnlAttacker.setCardBounds(0, 0, 105, 150);
        JPanel pnlInfo = new JPanel(new MigLayout("insets 0, gap 0, wrap"));
        pnlInfo.setOpaque(false);
        pnlInfo.add((Component)this.lblTotalDamage, "gap 0 0 20px 5px");
        pnlInfo.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblLClickDamageMessage", new Object[0])).build(), "gap 0 0 0 5px");
        pnlInfo.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblRClickDamageMessage", new Object[0])).build(), "gap 0 0 0 5px");
        JPanel pnlDefenders = new JPanel();
        pnlDefenders.setOpaque(false);
        int cols = this.attackerHasTrample || this.attackerHasDivideDamage && this.overrideCombatantOrder ? blockers.size() + 1 : blockers.size();
        String wrap = "wrap " + cols;
        pnlDefenders.setLayout(new MigLayout("insets 0, gap 0, ax center, " + wrap));
        FScrollPane scrDefenders = new FScrollPane(pnlDefenders, false);
        for (CardView c : blockers) {
            DamageTarget dt = new DamageTarget(c, new FLabel.Builder().text("0").fontSize(18).fontAlign(0).build());
            this.damage.put(c, dt);
            this.defenders.add(dt);
            this.addPanelForDefender(pnlDefenders, c);
        }
        if (this.attackerHasTrample || this.attackerHasDivideDamage && this.overrideCombatantOrder) {
            DamageTarget dt = new DamageTarget(null, new FLabel.Builder().text("0").fontSize(18).fontAlign(0).build());
            this.damage.put(null, dt);
            this.defenders.add(dt);
            this.addPanelForDefender(pnlDefenders, this.defender);
        }
        for (DamageTarget l : this.defenders) {
            pnlDefenders.add((Component)l.label, "w 145px!, h 30px!, gap 5px 5px 0 5px");
        }
        this.btnOK.addActionListener(arg0 -> this.finish());
        this.btnReset.addActionListener(arg0 -> {
            this.resetAssignedDamage();
            this.initialAssignDamage(false);
        });
        this.btnAuto.addActionListener(arg0 -> {
            this.resetAssignedDamage();
            this.initialAssignDamage(true);
            this.finish();
        });
        pnlMain.setLayout(new MigLayout("insets 0, gap 0, wrap 2, ax center"));
        pnlMain.add((Component)pnlAttacker, "w 125px!, h 160px!, gap 50px 0 0 15px");
        pnlMain.add((Component)pnlInfo, "gap 20px 0 0 15px");
        pnlMain.add((Component)scrDefenders, "w 96%!, gap 2% 0 0 0, pushy, growy, ax center, span 2");
        pnlMain.add((Component)this.lblAssignRemaining, "w 96%!, gap 2% 0 0 0, ax center, span 2");
        JPanel pnlButtons = new JPanel(new MigLayout("insets 0, gap 0, ax center"));
        pnlButtons.setOpaque(false);
        pnlButtons.add((Component)this.btnAuto, "w 110px!, h 30px!, gap 0 10px 0 0");
        pnlButtons.add((Component)this.btnOK, "w 110px!, h 30px!, gap 0 10px 0 0");
        pnlButtons.add((Component)this.btnReset, "w 110px!, h 30px!");
        if (maySkip) {
            pnlButtons.add((Component)this.btnSkip, "gap 0 10px 0 0, w 110px!, h 30px!");
            this.btnSkip.addActionListener(arg0 -> {
                this.skip = true;
                this.finish();
            });
        }
        pnlMain.add((Component)pnlButtons, "ax center, w 500px!, gap 10px 10px 10px 10px, span 2");
        overlay.add(pnlMain);
        pnlMain.getRootPane().setDefaultButton(this.btnOK);
        SwingUtilities.invokeLater(this.btnAuto::requestFocusInWindow);
        this.initialAssignDamage(false);
        SOverlayUtils.showOverlay();
        this.dlg.setUndecorated(true);
        this.dlg.setContentPane(pnlMain);
        this.dlg.setSize(new Dimension(700, 500));
        this.dlg.setLocation((overlay.getWidth() - 700) / 2, (overlay.getHeight() - 500) / 2);
        this.dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.dlg.setVisible(true);
    }

    private void addPanelForDefender(JPanel pnlDefenders, GameEntityView defender) {
        if (defender instanceof CardView) {
            CardPanel cp = new CardPanel(this.matchUI, (CardView)defender);
            cp.setCardBounds(0, 0, 105, 150);
            cp.setOpaque(true);
            pnlDefenders.add((Component)cp, "w 145px!, h 170px!, gap 5px 5px 3px 3px, ax center");
            cp.addMouseListener(this.mad);
        } else if (defender instanceof PlayerView) {
            PlayerView p = (PlayerView)defender;
            FSkin.SkinImage playerAvatar = this.matchUI.getPlayerAvatar(p, 0);
            MiscCardPanel mp = new MiscCardPanel(this.matchUI, p.getName(), playerAvatar);
            mp.setCardBounds(0, 0, 105, 150);
            pnlDefenders.add((Component)mp, "w 145px!, h 170px!, gap 5px 5px 3px 3px, ax center");
            mp.addMouseListener(this.mad);
        }
    }

    private void assignDamageTo(CardView source, boolean meta, boolean isAdding) {
        boolean isFirstBlocker;
        if (!this.damage.containsKey(source)) {
            source = null;
        }
        if (!(this.attackerHasDivideDamage || source != null && source != this.defender && this.overrideCombatantOrder || !isAdding || this.canAssignTo(source))) {
            return;
        }
        int lethalDamage = this.getDamageToKill(source);
        int damageItHad = this.damage.get((Object)source).damage;
        int leftToKill = Math.max(0, lethalDamage - damageItHad);
        int damageToAdd = isAdding ? 1 : -1;
        int leftToAssign = this.getRemainingDamage();
        if (meta) {
            if (isAdding) {
                damageToAdd = leftToKill > 0 ? leftToKill : leftToAssign;
            } else {
                int n = damageToAdd = damageItHad > lethalDamage ? lethalDamage - damageItHad : -damageItHad;
            }
        }
        if (damageToAdd > leftToAssign) {
            damageToAdd = leftToAssign;
        }
        boolean bl = isFirstBlocker = this.defenders.get((int)0).card == source;
        if (!this.overrideCombatantOrder && isFirstBlocker && damageToAdd + damageItHad < lethalDamage) {
            return;
        }
        if (0 == damageToAdd || damageToAdd + damageItHad < 0) {
            return;
        }
        this.addDamage(source, damageToAdd);
        this.checkDamageQueue();
        this.updateLabels();
    }

    private void checkDamageQueue() {
        if (this.overrideCombatantOrder && this.attackerHasDivideDamage) {
            return;
        }
        boolean hasAliveEnemy = false;
        for (DamageTarget dt : this.defenders) {
            int lethal = this.getDamageToKill(dt.card);
            int damage = dt.damage;
            if (hasAliveEnemy && (!this.overrideCombatantOrder || dt.card == null || dt.card == this.defender)) {
                dt.damage = 0;
                continue;
            }
            hasAliveEnemy |= damage < lethal;
        }
    }

    private void initialAssignDamage(boolean toAllBlockers) {
        if (!toAllBlockers && this.overrideCombatantOrder) {
            this.updateLabels();
            return;
        }
        int dmgLeft = this.totalDamageToAssign;
        DamageTarget dtLast = null;
        for (DamageTarget dt : this.defenders) {
            int lethal = this.getDamageToKill(dt.card);
            int damage = Math.min(lethal, dmgLeft);
            this.addDamage(dt.card, damage);
            dtLast = dt;
            if ((dmgLeft -= damage) > 0 && toAllBlockers) continue;
            break;
        }
        if (dmgLeft < 0) {
            throw new RuntimeException("initialAssignDamage managed to assign more damage than it could");
        }
        if (toAllBlockers && dmgLeft > 0) {
            this.addDamage(dtLast.card, dmgLeft);
        }
        this.updateLabels();
    }

    private void resetAssignedDamage() {
        for (DamageTarget dt : this.defenders) {
            dt.damage = 0;
        }
    }

    private void addDamage(CardView card, int addedDamage) {
        int canAssign = this.getRemainingDamage();
        if (canAssign < addedDamage) {
            addedDamage = canAssign;
        }
        DamageTarget dt = this.damage.get(card);
        dt.damage = Math.max(0, addedDamage + dt.damage);
    }

    private int getRemainingDamage() {
        int spent = 0;
        for (DamageTarget dt : this.defenders) {
            spent += dt.damage;
        }
        return this.totalDamageToAssign - spent;
    }

    private void updateLabels() {
        int damageLeft = this.totalDamageToAssign;
        boolean allHaveLethal = true;
        for (DamageTarget dt : this.defenders) {
            int dmg = dt.damage;
            damageLeft -= dmg;
            int lethal = this.getDamageToKill(dt.card);
            int overkill = dmg - lethal;
            StringBuilder sb = new StringBuilder();
            sb.append(dmg);
            if (overkill >= 0) {
                sb.append(" (").append(this.localizer.getMessage("lblLethal", new Object[0]));
                if (overkill > 0) {
                    sb.append(" +").append(overkill);
                }
                sb.append(")");
            }
            allHaveLethal &= dmg >= lethal;
            dt.label.setText(sb.toString());
        }
        this.lblTotalDamage.setText(TextUtil.concatNoSpace(this.localizer.getMessage("lblAvailableDamagePoints", new Object[0]), ": ", String.valueOf(damageLeft), " (of ", String.valueOf(this.totalDamageToAssign), ")"));
        this.btnOK.setEnabled(damageLeft == 0);
        this.lblAssignRemaining.setVisible(allHaveLethal && damageLeft > 0);
    }

    private void finish() {
        if (!this.skip && this.getRemainingDamage() > 0) {
            return;
        }
        this.dlg.dispose();
        SOverlayUtils.hideOverlay();
    }

    private int getDamageToKill(CardView card) {
        int lethalDamage = 0;
        if (card == null) {
            if (this.defender instanceof PlayerView) {
                PlayerView p = (PlayerView)this.defender;
                lethalDamage = this.attackerHasInfect ? this.matchUI.getGameView().getPoisonCountersToLose() - p.getCounters(CounterEnumType.POISON) : p.getLife();
            } else if (this.defender instanceof CardView) {
                CardView pw = (CardView)this.defender;
                lethalDamage = Integer.parseInt(pw.getCurrentState().getLoyalty());
            }
        } else {
            lethalDamage = Math.max(0, card.getLethalDamage());
            if (card.getCurrentState().isPlaneswalker()) {
                lethalDamage = Integer.parseInt(card.getCurrentState().getLoyalty());
            } else if (this.attackerHasDeathtouch) {
                lethalDamage = Math.min(lethalDamage, 1);
            }
        }
        return lethalDamage;
    }

    public Map<CardView, Integer> getDamageMap() {
        if (this.skip) {
            return null;
        }
        HashMap<CardView, Integer> result = Maps.newHashMapWithExpectedSize(this.defenders.size());
        for (DamageTarget dt : this.defenders) {
            result.put(dt.card, dt.damage);
        }
        return result;
    }

    private static class DamageTarget {
        public final CardView card;
        public final JLabel label;
        public int damage;

        public DamageTarget(CardView c, JLabel lbl) {
            this.card = c;
            this.label = lbl;
        }
    }
}

