/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match;

import forge.Singletons;
import forge.game.GameEntityView;
import forge.game.GameView;
import forge.game.card.CardView;
import forge.game.combat.CombatView;
import forge.game.player.PlayerView;
import forge.game.spellability.StackItemView;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.match.CMatchUI;
import forge.screens.match.controllers.CDock;
import forge.screens.match.views.VField;
import forge.screens.match.views.VStack;
import forge.toolbox.FSkin;
import forge.util.collect.FCollection;
import forge.view.FView;
import forge.view.arcane.CardPanel;
import forge.view.arcane.CardPanelContainer;
import forge.view.arcane.util.CardPanelMouseListener;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;

public class TargetingOverlay {
    private final CMatchUI matchUI;
    private final OverlayPanel pnl = new OverlayPanel();
    private final List<CardPanel> cardPanels = new ArrayList<CardPanel>();
    private final List<Arc> arcsFoeAtk = new ArrayList<Arc>();
    private final List<Arc> arcsFoeDef = new ArrayList<Arc>();
    private final List<Arc> arcsFriend = new ArrayList<Arc>();
    private final ArcAssembler assembler = new ArcAssembler();
    private final Set<Integer> stackItemIDs = new HashSet<Integer>();
    private final Set<CardView> cardsVisualized = new HashSet<CardView>();
    private CardPanel activePanel = null;
    private int allowedUpdates = 0;
    private final int MAX_CONSECUTIVE_UPDATES = 1;

    public TargetingOverlay(CMatchUI matchUI) {
        this.matchUI = matchUI;
        this.pnl.setOpaque(false);
        this.pnl.setVisible(true);
        this.pnl.setFocusTraversalKeysEnabled(false);
        this.pnl.setBackground(FSkin.getColor(FSkin.Colors.CLR_ZEBRA));
    }

    public JPanel getPanel() {
        return this.pnl;
    }

    private void assembleArcs(CombatView combat) {
        Point itemLocOnScreen;
        this.arcsFoeAtk.clear();
        this.arcsFoeDef.clear();
        this.arcsFriend.clear();
        this.cardPanels.clear();
        this.cardsVisualized.clear();
        VStack.StackInstanceTextArea activeStackItem = this.matchUI.getCStack().getView().getHoveredItem();
        switch (this.matchUI.getCDock().getArcState()) {
            case OFF: {
                return;
            }
            case MOUSEOVER: {
                this.activePanel = null;
                block5: for (VField f : this.matchUI.getFieldViews()) {
                    this.cardPanels.addAll(f.getTabletop().getCardPanels());
                    List<CardPanel> cPanels = f.getTabletop().getCardPanels();
                    for (CardPanel c : cPanels) {
                        if (!c.isSelected()) continue;
                        this.activePanel = c;
                        continue block5;
                    }
                }
                if (this.activePanel != null || activeStackItem != null) break;
                return;
            }
            case ON: {
                for (VField f : this.matchUI.getFieldViews()) {
                    this.cardPanels.addAll(f.getTabletop().getCardPanels());
                }
                break;
            }
        }
        HashMap<Integer, Point> endpoints = new HashMap<Integer, Point>();
        Point locOnScreen = this.getPanel().getLocationOnScreen();
        for (CardPanel c : this.cardPanels) {
            if (!c.isShowing()) continue;
            Point cardLocOnScreen = c.getCardLocationOnScreen();
            endpoints.put(c.getCard().getId(), new Point((int)(cardLocOnScreen.getX() - locOnScreen.getX() + (double)((float)c.getWidth() * 0.25f)), (int)(cardLocOnScreen.getY() - locOnScreen.getY() + (double)((float)c.getHeight() * 0.5f))));
        }
        if (this.matchUI.getCDock().getArcState() == CDock.ArcState.MOUSEOVER) {
            if (this.activePanel != null) {
                this.addArcsForCard(this.activePanel.getCard(), endpoints, combat);
            }
        } else {
            for (CardPanel c : this.cardPanels) {
                if (!c.isShowing()) continue;
                this.addArcsForCard(c.getCard(), endpoints, combat);
            }
        }
        if (activeStackItem != null && (itemLocOnScreen = activeStackItem.getLocationOnScreen()) != null) {
            StackItemView instance;
            itemLocOnScreen.x = (int)((double)itemLocOnScreen.x + (15.5 - locOnScreen.getX()));
            itemLocOnScreen.y = (int)((double)itemLocOnScreen.y + (38.0 - locOnScreen.getY()));
            PlayerView activator = instance.getActivatingPlayer();
            for (instance = activeStackItem.getItem(); instance != null; instance = instance.getSubInstance()) {
                for (CardView c : instance.getTargetCards()) {
                    this.addArc((Point)endpoints.get(c.getId()), itemLocOnScreen, activator.isOpponentOf(c.getController()) ? ArcConnection.FoesStackTargeting : ArcConnection.FriendsStackTargeting);
                }
                for (PlayerView p : instance.getTargetPlayers()) {
                    Point point = this.getPlayerTargetingArrowPoint(p, locOnScreen);
                    if (point == null) continue;
                    this.addArc(point, itemLocOnScreen, activator.isOpponentOf(p) ? ArcConnection.FoesStackTargeting : ArcConnection.FriendsStackTargeting);
                }
            }
        }
    }

    private boolean assembleArcs(CombatView combat, boolean forceAssemble) {
        if (!this.getPanel().isShowing()) {
            return false;
        }
        if (!forceAssemble) {
            if (this.allowedUpdates >= 1) {
                this.allowedUpdates = 0;
                return false;
            }
            ++this.allowedUpdates;
        }
        if (!this.assembler.isListening() && this.matchUI != null && this.matchUI.getFieldViews() != null) {
            this.assembler.setListening(true);
            for (VField f : this.matchUI.getFieldViews()) {
                f.getTabletop().addLayoutListener(this.assembler);
                f.getTabletop().addCardPanelMouseListener(this.assembler);
            }
        }
        this.arcsFoeAtk.clear();
        this.arcsFoeDef.clear();
        this.arcsFriend.clear();
        this.cardPanels.clear();
        this.cardsVisualized.clear();
        try {
            switch (this.matchUI.getCDock().getArcState()) {
                case OFF: {
                    return true;
                }
                case MOUSEOVER: {
                    this.activePanel = null;
                    block8: for (VField f : this.matchUI.getFieldViews()) {
                        this.cardPanels.addAll(f.getTabletop().getCardPanels());
                        List<CardPanel> cPanels = f.getTabletop().getCardPanels();
                        for (CardPanel c : cPanels) {
                            if (!c.isSelected()) continue;
                            this.activePanel = c;
                            continue block8;
                        }
                    }
                    if (this.activePanel != null) break;
                    return true;
                }
                case ON: {
                    for (VField f : this.matchUI.getFieldViews()) {
                        this.cardPanels.addAll(f.getTabletop().getCardPanels());
                    }
                    break;
                }
            }
            Map<Integer, Point> endpoints = this.getCardEndpoints();
            if (this.matchUI.getCDock().getArcState() == CDock.ArcState.MOUSEOVER) {
                if (this.activePanel != null) {
                    this.addArcsForCard(this.activePanel.getCard(), endpoints, combat);
                }
            } else {
                for (CardPanel c : this.cardPanels) {
                    if (!c.isShowing()) continue;
                    this.addArcsForCard(c.getCard(), endpoints, combat);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private Map<Integer, Point> getCardEndpoints() {
        HashMap<Integer, Point> endpoints = new HashMap<Integer, Point>();
        Point locOnScreen = this.getPanel().getLocationOnScreen();
        for (CardPanel c : this.cardPanels) {
            if (!c.isShowing()) continue;
            Point cardLocOnScreen = c.getCardLocationOnScreen();
            endpoints.put(c.getCard().getId(), new Point((int)(cardLocOnScreen.getX() - locOnScreen.getX() + (double)((float)c.getWidth() * 0.25f)), (int)(cardLocOnScreen.getY() - locOnScreen.getY() + (double)((float)c.getHeight() * 0.5f))));
        }
        return endpoints;
    }

    private void assembleStackArrows() {
        if (!this.getPanel().isShowing()) {
            return;
        }
        VStack.StackInstanceTextArea activeStackItem = this.matchUI.getCStack().getView().getHoveredItem();
        if (activeStackItem != null) {
            if (this.stackItemIDs.add(activeStackItem.hashCode())) {
                activeStackItem.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        if (TargetingOverlay.this.matchUI.getCDock().getArcState() == CDock.ArcState.MOUSEOVER) {
                            TargetingOverlay.this.assembleStackArrows();
                            FView.SINGLETON_INSTANCE.getFrame().repaint();
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        if (TargetingOverlay.this.matchUI.getCDock().getArcState() == CDock.ArcState.MOUSEOVER) {
                            TargetingOverlay.this.assembleStackArrows();
                            FView.SINGLETON_INSTANCE.getFrame().repaint();
                        }
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (TargetingOverlay.this.matchUI.getCDock().getArcState() == CDock.ArcState.ON) {
                            TargetingOverlay.this.assembleStackArrows();
                            FView.SINGLETON_INSTANCE.getFrame().repaint();
                        }
                    }
                });
            }
            Map<Integer, Point> endpoints = this.getCardEndpoints();
            Point locOnScreen = this.getPanel().getLocationOnScreen();
            Point itemLocOnScreen = activeStackItem.getLocationOnScreen();
            if (itemLocOnScreen != null) {
                StackItemView instance;
                itemLocOnScreen.x = (int)((double)itemLocOnScreen.x + (15.5 - locOnScreen.getX()));
                itemLocOnScreen.y = (int)((double)itemLocOnScreen.y + (38.0 - locOnScreen.getY()));
                PlayerView activator = instance.getActivatingPlayer();
                for (instance = activeStackItem.getItem(); instance != null; instance = instance.getSubInstance()) {
                    Iterator iterator = instance.getTargetCards().iterator();
                    while (iterator.hasNext()) {
                        CardView c;
                        this.addArc(endpoints.get(c.getId()), itemLocOnScreen, activator.isOpponentOf((c = (CardView)iterator.next()).getController()) ? ArcConnection.FoesStackTargeting : ArcConnection.FriendsStackTargeting);
                    }
                    for (PlayerView p : instance.getTargetPlayers()) {
                        Point point = this.getPlayerTargetingArrowPoint(p, locOnScreen);
                        if (point == null) continue;
                        this.addArc(point, itemLocOnScreen, activator.isOpponentOf(p) ? ArcConnection.FoesStackTargeting : ArcConnection.FriendsStackTargeting);
                    }
                }
            }
        }
    }

    private Point getPlayerTargetingArrowPoint(PlayerView p, Point locOnScreen) {
        JPanel avatarArea = this.matchUI.getFieldViewFor(p).getAvatarArea();
        if (!avatarArea.isShowing()) {
            return null;
        }
        Point point = avatarArea.getLocationOnScreen();
        point.x += avatarArea.getWidth() / 2 - locOnScreen.x;
        point.y += avatarArea.getHeight() / 2 - locOnScreen.y;
        return point;
    }

    private void addArc(Point end, Point start, ArcConnection connects) {
        if (start == null || end == null) {
            return;
        }
        Arc newArc = new Arc(end, start);
        switch (connects) {
            case Friends: 
            case FriendsStackTargeting: {
                if (this.arcsFriend.contains(newArc)) break;
                this.arcsFriend.add(newArc);
                break;
            }
            case FoesAttacking: {
                if (this.arcsFoeAtk.contains(newArc)) break;
                this.arcsFoeAtk.add(newArc);
                break;
            }
            case FoesBlocking: 
            case FoesStackTargeting: {
                if (this.arcsFoeDef.contains(newArc)) break;
                this.arcsFoeDef.add(newArc);
            }
        }
    }

    private void addArcsForCard(CardView c, Map<Integer, Point> endpoints, CombatView combat) {
        if (!this.cardsVisualized.add(c)) {
            return;
        }
        CardView attachedTo = c.getAttachedTo();
        Iterable<CardView> attachedCards = c.getAttachedCards();
        CardView paired = c.getPairedWith();
        if (null != attachedTo && attachedTo.getController() != null && !attachedTo.getController().equals(c.getController())) {
            this.addArc(endpoints.get(attachedTo.getId()), endpoints.get(c.getId()), ArcConnection.Friends);
            this.cardsVisualized.add(attachedTo);
        }
        if (null != attachedCards) {
            for (CardView enc : attachedCards) {
                if (enc.getController() == null || enc.getController().equals(c.getController())) continue;
                this.addArc(endpoints.get(c.getId()), endpoints.get(enc.getId()), ArcConnection.Friends);
                this.cardsVisualized.add(enc);
            }
        }
        if (null != paired) {
            this.addArc(endpoints.get(paired.getId()), endpoints.get(c.getId()), ArcConnection.Friends);
            this.cardsVisualized.add(paired);
        }
        if (null != combat) {
            JPanel avatarArea;
            GameEntityView defender = combat.getDefender(c);
            if (defender instanceof CardView) {
                this.addArc(endpoints.get(defender.getId()), endpoints.get(c.getId()), ArcConnection.FoesAttacking);
            }
            if (defender instanceof PlayerView && (avatarArea = this.matchUI.getFieldViewFor((PlayerView)defender).getAvatarArea()).isShowing()) {
                Point locOnScreen = this.getPanel().getLocationOnScreen();
                Point point = this.getPlayerTargetingArrowPoint((PlayerView)defender, locOnScreen);
                this.addArc(point, endpoints.get(c.getId()), ArcConnection.FoesAttacking);
            }
            for (CardView pwAttacker : combat.getAttackersOf(c)) {
                this.addArc(endpoints.get(c.getId()), endpoints.get(pwAttacker.getId()), ArcConnection.FoesAttacking);
            }
            for (CardView attackingCard : combat.getAttackers()) {
                FCollection<CardView> cards = combat.getPlannedBlockers(attackingCard);
                if (cards == null) continue;
                for (CardView blockingCard : cards) {
                    if (!attackingCard.equals(c) && !blockingCard.equals(c)) continue;
                    this.addArc(endpoints.get(attackingCard.getId()), endpoints.get(blockingCard.getId()), ArcConnection.FoesBlocking);
                    this.cardsVisualized.add(blockingCard);
                    this.cardsVisualized.add(attackingCard);
                }
            }
        }
    }

    class ArcAssembler
    implements CardPanelContainer.LayoutEventListener,
    CardPanelMouseListener {
        private boolean isListening = false;
        private boolean isDragged = false;

        ArcAssembler() {
        }

        public boolean isListening() {
            return this.isListening;
        }

        public void setListening(boolean listening) {
            this.isListening = listening;
        }

        private void assembleAndRepaint() {
            if (this.isDragged) {
                return;
            }
            GameView gameView = TargetingOverlay.this.matchUI.getGameView();
            if (gameView != null) {
                TargetingOverlay.this.assembleArcs(gameView.getCombat(), true);
                FView.SINGLETON_INSTANCE.getFrame().repaint();
            }
        }

        @Override
        public void doingLayout() {
            this.assembleAndRepaint();
        }

        @Override
        public void mouseOver(CardPanel panel, MouseEvent evt) {
            this.assembleAndRepaint();
        }

        @Override
        public void mouseOut(CardPanel panel, MouseEvent evt) {
            this.assembleAndRepaint();
        }

        @Override
        public void mouseDragStart(CardPanel dragPanel, MouseEvent evt) {
            this.isDragged = true;
        }

        @Override
        public void mouseDragEnd(CardPanel dragPanel, MouseEvent evt) {
            this.isDragged = false;
        }

        @Override
        public void mouseLeftClicked(CardPanel panel, MouseEvent evt) {
        }

        @Override
        public void mouseRightClicked(CardPanel panel, MouseEvent evt) {
        }

        @Override
        public void mouseDragged(CardPanel dragPanel, int dragOffsetX, int dragOffsetY, MouseEvent evt) {
        }
    }

    private class OverlayPanel
    extends FSkin.SkinnedPanel {
        private final boolean useThrottling = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_TIMED_TARGETING_OVERLAY_UPDATES);

        private OverlayPanel() {
        }

        private Area getArrow(float length, float bendPercent) {
            float p1x = 0.0f;
            float p1y = 0.0f;
            float p2x = length;
            float p2y = 0.0f;
            float cx = length / 2.0f;
            float cy = length / 8.0f * bendPercent;
            int bodyWidth = 15;
            float headSize = 20.0f;
            float adjSize = (float)((double)(bodyWidth / 2) / Math.sqrt(2.0));
            float ex = p2x - cx;
            float ey = p2y - cy;
            float abs_e = (float)Math.sqrt(ex * ex + ey * ey);
            GeneralPath bodyPath = new GeneralPath();
            bodyPath.moveTo(p2x + ((ey /= abs_e) - (ex /= abs_e)) * adjSize, p2y - (ex + ey) * adjSize);
            bodyPath.quadTo(cx, cy, p1x, p1y - (float)(bodyWidth / 2));
            bodyPath.lineTo(p1x, p1y + (float)(bodyWidth / 2));
            bodyPath.quadTo(cx, cy, p2x - (ey + ex) * adjSize, p2y + (ex - ey) * adjSize);
            bodyPath.closePath();
            adjSize = (float)((double)headSize / Math.sqrt(2.0));
            ex = p2x - cx;
            ey = p2y - cy;
            abs_e = (float)Math.sqrt(ex * ex + ey * ey);
            GeneralPath headPath = new GeneralPath();
            headPath.moveTo(p2x - ((ey /= abs_e) + (ex /= abs_e)) * adjSize, p2y + (ex - ey) * adjSize);
            headPath.lineTo(p2x + headSize / 2.0f, p2y);
            headPath.lineTo(p2x + (ey - ex) * adjSize, p2y - (ex + ey) * adjSize);
            headPath.closePath();
            Area area = new Area(headPath);
            area.add(new Area(bodyPath));
            return area;
        }

        private void drawArrow(Graphics2D g2d, int startX, int startY, int endX, int endY, Color color) {
            float ex = endX - startX;
            float ey = endY - startY;
            if (ex == 0.0f && ey == 0.0f) {
                return;
            }
            float length = (float)Math.sqrt(ex * ex + ey * ey);
            float bendPercent = (float)Math.asin(ey / length);
            if (endX > startX) {
                bendPercent = -bendPercent;
            }
            Area arrow = this.getArrow(length, bendPercent);
            AffineTransform af = g2d.getTransform();
            g2d.translate(startX, startY);
            g2d.rotate(Math.atan2(ey, ex));
            g2d.setColor(color);
            g2d.fill(arrow);
            g2d.setColor(Color.BLACK);
            g2d.draw(arrow);
            g2d.setTransform(af);
        }

        private void drawArcs(Graphics2D g2d, Color color, List<Arc> arcs) {
            for (Arc arc : arcs) {
                this.drawArrow(g2d, arc.x1, arc.y1, arc.x2, arc.y2, color);
            }
        }

        @Override
        public void paintComponent(Graphics g2) {
            Color colorCombatAtk;
            Color colorCombat;
            if (Singletons.getControl().getCurrentScreen() != TargetingOverlay.this.matchUI.getScreen()) {
                return;
            }
            super.paintComponent(g2);
            CDock.ArcState overlaystate = TargetingOverlay.this.matchUI.getCDock().getArcState();
            if (overlaystate == CDock.ArcState.OFF) {
                return;
            }
            boolean assembled = false;
            GameView gameView = TargetingOverlay.this.matchUI.getGameView();
            if (gameView != null) {
                if (this.useThrottling) {
                    assembled = TargetingOverlay.this.assembleArcs(gameView.getCombat(), false);
                    TargetingOverlay.this.assembleStackArrows();
                } else {
                    TargetingOverlay.this.assembleArcs(gameView.getCombat());
                }
            }
            if (TargetingOverlay.this.arcsFoeAtk.isEmpty() && TargetingOverlay.this.arcsFoeDef.isEmpty() && TargetingOverlay.this.arcsFriend.isEmpty()) {
                if (assembled) {
                    FView.SINGLETON_INSTANCE.getFrame().repaint();
                }
                return;
            }
            Graphics2D g2d = (Graphics2D)g2;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color colorOther = FSkin.getColor(FSkin.Colors.CLR_NORMAL_TARGETING_ARROW).getColor();
            if (colorOther.getAlpha() == 0) {
                colorOther = FSkin.getColor(FSkin.Colors.CLR_ACTIVE).alphaColor(153).getColor();
            }
            if ((colorCombat = FSkin.getColor(FSkin.Colors.CLR_COMBAT_TARGETING_ARROW).getColor()).getAlpha() == 0) {
                colorCombat = new Color(255, 0, 0, 153);
            }
            if ((colorCombatAtk = FSkin.getColor(FSkin.Colors.CLR_PWATTK_TARGETING_ARROW).getColor()).getAlpha() == 0) {
                colorCombatAtk = new Color(255, 138, 1, 153);
            }
            this.drawArcs(g2d, colorOther, TargetingOverlay.this.arcsFriend);
            this.drawArcs(g2d, colorCombatAtk, TargetingOverlay.this.arcsFoeAtk);
            this.drawArcs(g2d, colorCombat, TargetingOverlay.this.arcsFoeDef);
            if (assembled || !this.useThrottling) {
                FView.SINGLETON_INSTANCE.getFrame().repaint();
            }
        }
    }

    private static enum ArcConnection {
        Friends,
        FoesAttacking,
        FoesBlocking,
        FriendsStackTargeting,
        FoesStackTargeting;

    }

    private static class Arc {
        private final int x1;
        private final int y1;
        private final int x2;
        private final int y2;

        private Arc(Point end, Point start) {
            this.x1 = start.x;
            this.y1 = start.y;
            this.x2 = end.x;
            this.y2 = end.y;
        }

        public boolean equals(Object obj) {
            Arc arc = (Arc)obj;
            return arc.x1 == this.x1 && arc.x2 == this.x2 && arc.y1 == this.y1 && arc.y2 == this.y2;
        }
    }
}

