/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match;

import forge.game.card.CardView;
import forge.gui.CardDetailPanel;
import forge.gui.CardPicturePanel;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.toolbox.FList;
import forge.toolbox.FPanel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;

public class QuestWinLoseCardViewer
extends FPanel {
    private final List<PaperCard> list;
    private final JList<PaperCard> jList;
    private final CardDetailPanel detail;
    private final CardPicturePanel picture;
    private final FScrollPane scroller;

    public QuestWinLoseCardViewer(List<PaperCard> list) {
        this.list = Collections.unmodifiableList(list);
        this.jList = new FList<PaperCard>(new ChooserListModel());
        this.detail = new CardDetailPanel();
        this.picture = new CardPicturePanel();
        this.scroller = new FScrollPane(this.jList, false);
        this.setCornerDiameter(20);
        this.setBorderToggle(false);
        this.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        this.picture.setOpaque(false);
        this.setLayout(new MigLayout("insets 0, gap 0"));
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_LARGE_CARD_VIEWERS)) {
            this.add((Component)this.scroller, "w 23%!, h 98%!, gap 1% 1% 1% 1%");
            this.add((Component)this.picture, "w 48%!, h 98%!, gap 0 0 1% 1%");
            this.add((Component)this.detail, "w 23%!, h 98%!, gap 1% 1% 1% 1%");
        } else {
            this.add((Component)this.scroller, "w 32%!, h 98%!, gap 1% 1% 1% 1%");
            this.add((Component)this.picture, "w 32%!, h 98%!, gap 0 0 1% 1%");
            this.add((Component)this.detail, "w 32%!, h 98%!, gap 1% 1% 1% 1%");
        }
        this.jList.getSelectionModel().addListSelectionListener(new SelListener());
        this.jList.setSelectedIndex(0);
    }

    private class SelListener
    implements ListSelectionListener {
        private SelListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int row = QuestWinLoseCardViewer.this.jList.getSelectedIndex();
            if (row >= 0 && row < QuestWinLoseCardViewer.this.list.size()) {
                PaperCard cp = (PaperCard)QuestWinLoseCardViewer.this.list.get(row);
                QuestWinLoseCardViewer.this.detail.setCard(CardView.getCardForUi(cp));
                QuestWinLoseCardViewer.this.picture.setItem(cp);
            }
        }
    }

    private class ChooserListModel
    extends AbstractListModel<PaperCard> {
        private static final long serialVersionUID = 3871965346333840556L;

        private ChooserListModel() {
        }

        @Override
        public int getSize() {
            return QuestWinLoseCardViewer.this.list.size();
        }

        @Override
        public PaperCard getElementAt(int index) {
            return (PaperCard)QuestWinLoseCardViewer.this.list.get(index);
        }
    }
}

